/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.facet;

import com.intellij.facet.FacetType;
import com.intellij.facet.ui.FacetBasedFrameworkSupportProvider;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.ide.util.frameworkSupport.FrameworkVersion;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.struts.StrutsBundle;
import com.intellij.struts.facet.AddStrutsSupportUtil;
import com.intellij.struts.facet.StrutsFacet;
import com.intellij.struts.facet.StrutsFacetType;
import com.intellij.struts.facet.ui.StrutsVersion;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StrutsFrameworkSupportProvider
extends FacetBasedFrameworkSupportProvider<StrutsFacet> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.struts.facet.StrutsFrameworkSupportProvider");

    public StrutsFrameworkSupportProvider() {
        super((FacetType)StrutsFacetType.getInstance());
    }

    public String getTitle() {
        return StrutsBundle.message((String)"framework.title.struts", (Object[])new Object[0]);
    }

    @NotNull
    public List<FrameworkVersion> getVersions() {
        ArrayList<FrameworkVersion> result = new ArrayList<FrameworkVersion>();
        for (StrutsVersion version : StrutsVersion.values()) {
            Object[] jars = version.getJars();
            LibraryInfo strutsTaglib = version.getStrutsTaglib();
            if (version == StrutsVersion.Struts1_2_9 && strutsTaglib != null) {
                jars = (LibraryInfo[])ArrayUtil.append((Object[])jars, (Object)strutsTaglib, LibraryInfo.class);
            }
            result.add(new FrameworkVersion(version.toString(), "struts", (LibraryInfo[])jars));
        }
        ArrayList<FrameworkVersion> arrayList = result;
        if (arrayList == null) {
            StrutsFrameworkSupportProvider.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static StrutsVersion getVersion(String versionName) {
        for (StrutsVersion version : StrutsVersion.values()) {
            if (!versionName.equals(version.toString())) continue;
            return version;
        }
        LOG.error("invalid struts version: " + versionName);
        return null;
    }

    protected void setupConfiguration(StrutsFacet facet, ModifiableRootModel rootModel, FrameworkVersion version) {
    }

    protected void onFacetCreated(StrutsFacet facet, ModifiableRootModel rootModel, FrameworkVersion version) {
        StartupManager.getInstance((Project)facet.getModule().getProject()).runWhenProjectIsInitialized(() -> AddStrutsSupportUtil.addSupportInWriteCommandAction(facet.getWebFacet(), false, false, StrutsFrameworkSupportProvider.getVersion(version.getVersionName())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/facet/StrutsFrameworkSupportProvider", "getVersions"));
    }
}

