/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.inplace.reference.config;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts.StrutsManager;
import com.intellij.struts.TilesModel;
import com.intellij.struts.dom.tiles.Put;
import com.intellij.struts.inplace.reference.XmlAttributeReferenceProvider;
import com.intellij.struts.inplace.reference.XmlValueReference;
import com.intellij.struts.inplace.reference.XmlValueSelfReference;
import com.intellij.util.xml.DomElement;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TilesPutsReferenceProvider
extends XmlAttributeReferenceProvider {
    public TilesPutsReferenceProvider() {
        super(Put.class);
        this.setSoft(true);
    }

    @Override
    protected PsiReference[] create(XmlAttributeValue attribute) {
        XmlTag putTag = (XmlTag)attribute.getContext().getContext();
        String definition = this.getDefinitionName(putTag);
        XmlValueReference ref = definition == null ? new XmlValueSelfReference(attribute, this) : new TilesPutsReference(attribute, definition);
        return new PsiReference[]{ref};
    }

    @Nullable
    protected String getDefinitionName(XmlTag putTag) {
        XmlTag definitionTag = putTag.getParentTag();
        return definitionTag != null ? definitionTag.getAttributeValue("name") : null;
    }

    protected class TilesPutsReference
    extends XmlValueReference
    implements PsiPolyVariantReference {
        private final String definition;

        TilesPutsReference(XmlAttributeValue attribute, String definition) {
            super(attribute, TilesPutsReferenceProvider.this);
            this.definition = definition;
            this.mySoft = TilesPutsReferenceProvider.this.isSoft();
        }

        @Override
        public PsiElement doResolve() {
            XmlTag el;
            TilesModel model = StrutsManager.getInstance().getTiles((PsiElement)this.myValue);
            XmlTag xmlTag = el = model == null ? null : model.getPutTag(this.definition, this.getValue());
            if (el != null) {
                return el;
            }
            if (this.mySoft) {
                return this.myValue;
            }
            return null;
        }

        @Override
        @Nullable
        public Object[] doGetVariants() {
            TilesModel model = StrutsManager.getInstance().getTiles((PsiElement)this.myValue);
            return model == null ? null : TilesPutsReference.getItems(model.getPuts(this.definition, true));
        }

        @Override
        @Nullable
        protected DomElement getScope() {
            TilesModel model = StrutsManager.getInstance().getTiles((PsiElement)this.myValue);
            if (model == null) {
                return null;
            }
            return model.findDefinition(this.definition);
        }

        @NotNull
        public ResolveResult[] multiResolve(boolean b) {
            Collection tags;
            TilesModel model = StrutsManager.getInstance().getTiles((PsiElement)this.myValue);
            if (model != null && (tags = model.getAllPuts(this.definition)) != null) {
                ArrayList<PsiElementResolveResult> result = new ArrayList<PsiElementResolveResult>();
                String val = this.getValue();
                for (Put put : tags) {
                    if (!val.equals(put.getName().getValue())) continue;
                    result.add(new PsiElementResolveResult((PsiElement)put.getName().getXmlAttributeValue()));
                }
                ResolveResult[] resolveResultArray = result.toArray(new ResolveResult[result.size()]);
                if (resolveResultArray == null) {
                    TilesPutsReference.$$$reportNull$$$0(0);
                }
                return resolveResultArray;
            }
            if (ResolveResult.EMPTY_ARRAY == null) {
                TilesPutsReference.$$$reportNull$$$0(1);
            }
            return ResolveResult.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/config/TilesPutsReferenceProvider$TilesPutsReference", "multiResolve"));
        }
    }
}

