/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.repl;

import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.AbstractList;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.repl.ILineId;
import org.jetbrains.kotlin.cli.common.repl.IReplStageHistory;
import org.jetbrains.kotlin.cli.common.repl.ReplHistoryRecord;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00040\u00032\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00040\u00060\u0005B+\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ$\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006H\u0002J\b\u0010\u0016\u001a\u00020\u0013H\u0002J#\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00040\u00062\u0006\u0010\u0018\u001a\u00020\u000fH\u0096\u0002J\u001c\u0010\u0019\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004\u0018\u00010\u0006H\u0016J$\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001fH\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0\u001f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/cli/common/repl/AggregatedReplStateHistory;", "T1", "T2", "Lorg/jetbrains/kotlin/cli/common/repl/IReplStageHistory;", "Lkotlin/Pair;", "Lkotlin/collections/AbstractList;", "Lorg/jetbrains/kotlin/cli/common/repl/ReplHistoryRecord;", "history1", "history2", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "(Lorg/jetbrains/kotlin/cli/common/repl/IReplStageHistory;Lorg/jetbrains/kotlin/cli/common/repl/IReplStageHistory;Ljava/util/concurrent/locks/ReentrantReadWriteLock;)V", "getLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "size", "", "getSize", "()I", "assertSameId", "", "r1", "r2", "assertSameSize", "get", "index", "pop", "push", "id", "Lorg/jetbrains/kotlin/cli/common/repl/ILineId;", "item", "reset", "", "resetTo", "cli-common"})
public class AggregatedReplStateHistory<T1, T2>
extends AbstractList<ReplHistoryRecord<? extends Pair<? extends T1, ? extends T2>>>
implements IReplStageHistory<Pair<? extends T1, ? extends T2>> {
    private final IReplStageHistory<T1> history1;
    private final IReplStageHistory<T2> history2;
    @NotNull
    private final ReentrantReadWriteLock lock;

    public int getSize() {
        int n = this.history1.size();
        int n2 = this.history2.size();
        return Math.min(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(@NotNull ILineId id, @NotNull Pair<? extends T1, ? extends T2> item) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull(item, (String)"item");
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2 - 1;
        if (n3 <= n4) {
            do {
                n = ++n3;
                readLock.unlock();
            } while (n3 != n4);
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            this.assertSameSize();
            this.history1.push(id, item.getFirst());
            this.history2.push(id, item.getSecond());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n = 0;
            int n5 = n2 - 1;
            if (n <= n5) {
                do {
                    int n6 = ++n;
                    readLock.lock();
                } while (n != n5);
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ReplHistoryRecord<Pair<T1, T2>> get(int index2) {
        ReplHistoryRecord<Pair<T1, T2>> replHistoryRecord;
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            this.assertSameSize();
            ReplHistoryRecord r1 = (ReplHistoryRecord)this.history1.get(index2);
            ReplHistoryRecord r2 = (ReplHistoryRecord)this.history2.get(index2);
            this.assertSameId(r1, r2);
            replHistoryRecord = new ReplHistoryRecord<Pair<T1, T2>>(r1.getId(), TuplesKt.to(r1.getItem(), r2.getItem()));
        }
        finally {
            readLock.unlock();
        }
        return replHistoryRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ReplHistoryRecord<Pair<T1, T2>> pop() {
        ReplHistoryRecord<Pair<T1, T2>> replHistoryRecord;
        int n;
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = 0;
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n4 = n3 - 1;
        if (n2 <= n4) {
            do {
                n = ++n2;
                readLock.unlock();
            } while (n2 != n4);
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            this.assertSameSize();
            ReplHistoryRecord<T1> r1 = this.history1.pop();
            ReplHistoryRecord<T2> r2 = this.history2.pop();
            if (r1 == null && r2 == null) {
                ReplHistoryRecord<Pair<T1, T2>> replHistoryRecord2 = null;
                return replHistoryRecord2;
            }
            if (r1 == null || r2 == null) {
                throw (Throwable)new IllegalStateException("Aggregated history mismatch: " + r1 + " vs " + r2);
            }
            this.assertSameId(r1, r2);
            replHistoryRecord = new ReplHistoryRecord<Pair<T1, T2>>(r1.getId(), TuplesKt.to(r1.getItem(), r2.getItem()));
        }
        finally {
            n = 0;
            int r1 = n3 - 1;
            if (n <= r1) {
                do {
                    int r2 = ++n;
                    readLock.lock();
                } while (n != r1);
            }
            writeLock.unlock();
        }
        return replHistoryRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Iterable<ILineId> reset() {
        List list2;
        int n;
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = 0;
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n4 = n3 - 1;
        if (n2 <= n4) {
            do {
                n = ++n2;
                readLock.unlock();
            } while (n2 != n4);
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            this.assertSameSize();
            List i1 = CollectionsKt.toList(this.history1.reset());
            List i2 = CollectionsKt.toList(this.history2.reset());
            if (Intrinsics.areEqual((Object)i1, (Object)i2) ^ true) {
                throw (Throwable)new IllegalStateException("Aggregated history reset lines mismatch: " + i1 + " != " + i2);
            }
            list2 = i1;
        }
        finally {
            n = 0;
            int n5 = n3 - 1;
            if (n <= n5) {
                do {
                    int n6 = ++n;
                    readLock.lock();
                } while (n != n5);
            }
            writeLock.unlock();
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Iterable<ILineId> resetTo(@NotNull ILineId id) {
        List list2;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2 - 1;
        if (n3 <= n4) {
            do {
                n = ++n3;
                readLock.unlock();
            } while (n3 != n4);
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            this.assertSameSize();
            List i1 = CollectionsKt.toList(this.history1.resetTo(id));
            List i2 = CollectionsKt.toList(this.history2.resetTo(id));
            if (Intrinsics.areEqual((Object)i1, (Object)i2) ^ true) {
                throw (Throwable)new IllegalStateException("Aggregated history reset lines mismatch: " + i1 + " != " + i2);
            }
            list2 = i1;
        }
        finally {
            n = 0;
            int n5 = n2 - 1;
            if (n <= n5) {
                do {
                    int n6 = ++n;
                    readLock.lock();
                } while (n != n5);
            }
            writeLock.unlock();
        }
        return list2;
    }

    private final void assertSameSize() {
        if (this.history1.size() != this.history2.size()) {
            throw (Throwable)new IllegalStateException("Aggregated history sizes mismatch: " + this.history1.size() + " != " + this.history2.size());
        }
    }

    private final void assertSameId(ReplHistoryRecord<? extends T1> r1, ReplHistoryRecord<? extends T2> r2) {
        if (Intrinsics.areEqual((Object)r1.getId(), (Object)r2.getId()) ^ true) {
            throw (Throwable)new IllegalStateException("Aggregated history mismatch: " + r1.getId() + " != " + r2.getId());
        }
    }

    @Override
    @NotNull
    public ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    public AggregatedReplStateHistory(@NotNull IReplStageHistory<T1> history1, @NotNull IReplStageHistory<T2> history2, @NotNull ReentrantReadWriteLock lock) {
        Intrinsics.checkParameterIsNotNull(history1, (String)"history1");
        Intrinsics.checkParameterIsNotNull(history2, (String)"history2");
        Intrinsics.checkParameterIsNotNull((Object)lock, (String)"lock");
        this.history1 = history1;
        this.history2 = history2;
        this.lock = lock;
    }

    public /* synthetic */ AggregatedReplStateHistory(IReplStageHistory iReplStageHistory, IReplStageHistory iReplStageHistory2, ReentrantReadWriteLock reentrantReadWriteLock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            reentrantReadWriteLock = new ReentrantReadWriteLock();
        }
        this(iReplStageHistory, iReplStageHistory2, reentrantReadWriteLock);
    }

    @Override
    @Nullable
    public ReplHistoryRecord<Pair<T1, T2>> verifiedPop(@NotNull ILineId id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return IReplStageHistory.DefaultImpls.verifiedPop(this, id);
    }

    @Override
    @Nullable
    public ReplHistoryRecord<Pair<T1, T2>> peek() {
        return IReplStageHistory.DefaultImpls.peek(this);
    }
}

