/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.LibraryInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleOrigin;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleProductionSourceInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleTestSourceInfo;
import org.jetbrains.kotlin.idea.caches.resolve.SdkInfo;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a#\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u0012*\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0014\u00a2\u0006\u0002\u0010\u0015\u001a\u0012\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0006*\u00020\tH\u0000\u001a\f\u0010\u0018\u001a\u00020\u000b*\u00020\tH\u0002\u001a\u0014\u0010\u0019\u001a\u00020\u000b*\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\f\u0010\u001c\u001a\u00020\u000b*\u00020\tH\u0002\u001a\f\u0010\u001d\u001a\u00020\u000b*\u00020\u0007H\u0000\u001a\f\u0010\u001e\u001a\u00020\u000b*\u00020\u0017H\u0000\u001a\f\u0010\u001f\u001a\u0004\u0018\u00010 *\u00020\t\u001a\f\u0010!\u001a\u0004\u0018\u00010\"*\u00020\t\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006#"}, d2={"OriginCapability", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor$Capability;", "Lorg/jetbrains/kotlin/idea/caches/resolve/ModuleOrigin;", "getOriginCapability", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor$Capability;", "ideaModelDependencies", "", "Lorg/jetbrains/kotlin/idea/caches/resolve/IdeaModuleInfo;", "module", "Lcom/intellij/openapi/module/Module;", "productionOnly", "", "orderEntryToModuleInfo", "project", "Lcom/intellij/openapi/project/Project;", "orderEntry", "Lcom/intellij/openapi/roots/OrderEntry;", "cached", "T", "provider", "Lcom/intellij/psi/util/CachedValueProvider;", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/psi/util/CachedValueProvider;)Ljava/lang/Object;", "correspondingModuleInfos", "Lorg/jetbrains/kotlin/idea/caches/resolve/ModuleSourceInfo;", "hasProductionRoots", "hasRootsOfType", "sourceRootType", "Lorg/jetbrains/jps/model/java/JavaSourceRootType;", "hasTestRoots", "isLibraryClasses", "isTests", "productionSourceInfo", "Lorg/jetbrains/kotlin/idea/caches/resolve/ModuleProductionSourceInfo;", "testSourceInfo", "Lorg/jetbrains/kotlin/idea/caches/resolve/ModuleTestSourceInfo;", "idea-analysis"})
public final class IdeaModuleInfosKt {
    @NotNull
    private static final ModuleDescriptor.Capability<ModuleOrigin> OriginCapability = new ModuleDescriptor.Capability("MODULE_ORIGIN");

    private static final List<IdeaModuleInfo> orderEntryToModuleInfo(Project project, OrderEntry orderEntry, boolean productionOnly) {
        List list2;
        Function1<Module, List<? extends ModuleSourceInfo>> toInfos$ = new Function1<Module, List<? extends ModuleSourceInfo>>(productionOnly){
            final /* synthetic */ boolean $productionOnly;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<ModuleSourceInfo> invoke(@NotNull Module $receiver) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                Iterable iterable = $receiver$iv = (Iterable)IdeaModuleInfosKt.correspondingModuleInfos($receiver);
                Collection destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    ModuleSourceInfo it = (ModuleSourceInfo)element$iv$iv;
                    if (!(!this.$productionOnly || it instanceof ModuleProductionSourceInfo)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            {
                this.$productionOnly = bl;
                super(1);
            }
        };
        if (!orderEntry.isValid()) {
            return CollectionsKt.emptyList();
        }
        OrderEntry orderEntry2 = orderEntry;
        if (orderEntry2 instanceof ModuleSourceOrderEntry) {
            list2 = toInfos$.invoke(orderEntry.getOwnerModule());
        } else if (orderEntry2 instanceof ModuleOrderEntry) {
            Module module = ((ModuleOrderEntry)orderEntry).getModule();
            List list3 = module != null ? toInfos$.invoke(module) : null;
            list2 = list3;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
        } else if (orderEntry2 instanceof LibraryOrderEntry) {
            Library library2;
            Library library3 = ((LibraryOrderEntry)orderEntry).getLibrary();
            if (library3 == null) {
                return CollectionsKt.emptyList();
            }
            Library library4 = library2 = library3;
            Intrinsics.checkExpressionValueIsNotNull((Object)library4, (String)"library");
            list2 = CollectionsKt.listOfNotNull((Object)new LibraryInfo(project, library4));
        } else if (orderEntry2 instanceof JdkOrderEntry) {
            Sdk sdk = ((JdkOrderEntry)orderEntry).getJdk();
            if (sdk == null) {
                return CollectionsKt.emptyList();
            }
            Sdk sdk2 = sdk;
            list2 = CollectionsKt.listOfNotNull((Object)new SdkInfo(project, sdk2));
        } else {
            throw (Throwable)new IllegalStateException("Unexpected order entry " + orderEntry);
        }
        return list2;
    }

    public static final <T> T cached(@NotNull Module $receiver, @NotNull CachedValueProvider<T> provider2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(provider2, (String)"provider");
        return (T)CachedValuesManager.getManager((Project)$receiver.getProject()).getCachedValue((UserDataHolder)$receiver, provider2);
    }

    private static final List<IdeaModuleInfo> ideaModelDependencies(Module module, boolean productionOnly) {
        LinkedHashSet result2 = new LinkedHashSet();
        OrderEnumerator dependencyEnumerator = ModuleRootManager.getInstance((Module)module).orderEntries().compileOnly().recursively().exportedOnly();
        if (productionOnly) {
            dependencyEnumerator.productionOnly();
        }
        dependencyEnumerator.forEach((Processor)new Processor<OrderEntry>(result2, module, productionOnly){
            final /* synthetic */ LinkedHashSet $result;
            final /* synthetic */ Module $module;
            final /* synthetic */ boolean $productionOnly;

            public final boolean process(OrderEntry orderEntry) {
                Project project = this.$module.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
                OrderEntry orderEntry2 = orderEntry;
                if (orderEntry2 == null) {
                    Intrinsics.throwNpe();
                }
                this.$result.addAll(IdeaModuleInfosKt.access$orderEntryToModuleInfo(project, orderEntry2, this.$productionOnly));
                return true;
            }
            {
                this.$result = linkedHashSet;
                this.$module = module;
                this.$productionOnly = bl;
            }
        });
        return CollectionsKt.toList((Iterable)result2);
    }

    public static final boolean isTests(@NotNull ModuleSourceInfo $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof ModuleTestSourceInfo;
    }

    @Nullable
    public static final ModuleProductionSourceInfo productionSourceInfo(@NotNull Module $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return IdeaModuleInfosKt.hasProductionRoots($receiver) ? new ModuleProductionSourceInfo($receiver) : null;
    }

    @Nullable
    public static final ModuleTestSourceInfo testSourceInfo(@NotNull Module $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return IdeaModuleInfosKt.hasTestRoots($receiver) ? new ModuleTestSourceInfo($receiver) : null;
    }

    @NotNull
    public static final List<ModuleSourceInfo> correspondingModuleInfos(@NotNull Module $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object[])new ModuleSourceInfo[]{IdeaModuleInfosKt.testSourceInfo($receiver), IdeaModuleInfosKt.productionSourceInfo($receiver)}));
    }

    private static final boolean hasProductionRoots(@NotNull Module $receiver) {
        JavaSourceRootType javaSourceRootType = JavaSourceRootType.SOURCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)javaSourceRootType, (String)"JavaSourceRootType.SOURCE");
        return IdeaModuleInfosKt.hasRootsOfType($receiver, javaSourceRootType);
    }

    private static final boolean hasTestRoots(@NotNull Module $receiver) {
        JavaSourceRootType javaSourceRootType = JavaSourceRootType.TEST_SOURCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)javaSourceRootType, (String)"JavaSourceRootType.TEST_SOURCE");
        return IdeaModuleInfosKt.hasRootsOfType($receiver, javaSourceRootType);
    }

    private static final boolean hasRootsOfType(@NotNull Module $receiver, JavaSourceRootType sourceRootType) {
        boolean bl;
        block1: {
            Object[] $receiver$iv = ProjectRootsUtilKt.getRootManager($receiver).getContentEntries();
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object element$iv = $receiver$iv[i];
                ContentEntry it = (ContentEntry)element$iv;
                Collection collection = it.getSourceFolders((JpsModuleSourceRootType)sourceRootType);
                if (!(!collection.isEmpty())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean isLibraryClasses(@NotNull IdeaModuleInfo $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof SdkInfo || $receiver instanceof LibraryInfo;
    }

    @NotNull
    public static final ModuleDescriptor.Capability<ModuleOrigin> getOriginCapability() {
        return OriginCapability;
    }

    @NotNull
    public static final /* synthetic */ List access$ideaModelDependencies(@NotNull Module module, boolean productionOnly) {
        return IdeaModuleInfosKt.ideaModelDependencies(module, productionOnly);
    }

    @NotNull
    public static final /* synthetic */ List access$orderEntryToModuleInfo(@NotNull Project project, @NotNull OrderEntry orderEntry, boolean productionOnly) {
        return IdeaModuleInfosKt.orderEntryToModuleInfo(project, orderEntry, productionOnly);
    }
}

