/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.LineMarkerNavigator;
import com.intellij.codeInsight.daemon.impl.MarkerType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.Function;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.LightClassUtilKt;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.highlighter.PlatformHeaderAnnotatorKt;
import org.jetbrains.kotlin.idea.highlighter.markers.DeclaredHeaderMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.ImplementedHeaderMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.JavaPsiUtilsKt;
import org.jetbrains.kotlin.idea.highlighter.markers.KotlinLineMarkerProviderKt;
import org.jetbrains.kotlin.idea.highlighter.markers.NavigationPopupDescriptor;
import org.jetbrains.kotlin.idea.highlighter.markers.OverridenFunctionMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.OverridenPropertyMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.ResolveWithParentsResult;
import org.jetbrains.kotlin.idea.highlighter.markers.SuperDeclarationMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.SuperDeclarationMarkerNavigationHandler;
import org.jetbrains.kotlin.idea.highlighter.markers.SuperDeclarationMarkerTooltip;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0004\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0002\u0006\n\u001a\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014H\u0002\u001a\"\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014H\u0002\u001a\"\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014H\u0002\u001a(\u0010\u001a\u001a\u00020\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014H\u0002\u001a(\u0010\u001e\u001a\u00020\u00102\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\u001c2\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014H\u0002\u001a\"\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020!2\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014H\u0002\u001a\u001e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020%0\u001cH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\"\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\"\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"HEADER_DECLARATION", "Lcom/intellij/codeInsight/daemon/impl/MarkerType;", "IMPLEMENTED_MARK", "Ljavax/swing/Icon;", "IMPLEMENTING_MARK", "OVERRIDDEN_FUNCTION", "org/jetbrains/kotlin/idea/highlighter/markers/KotlinLineMarkerProviderKt$OVERRIDDEN_FUNCTION$1", "Lorg/jetbrains/kotlin/idea/highlighter/markers/KotlinLineMarkerProviderKt$OVERRIDDEN_FUNCTION$1;", "OVERRIDDEN_MARK", "OVERRIDDEN_PROPERTY", "org/jetbrains/kotlin/idea/highlighter/markers/KotlinLineMarkerProviderKt$OVERRIDDEN_PROPERTY$1", "Lorg/jetbrains/kotlin/idea/highlighter/markers/KotlinLineMarkerProviderKt$OVERRIDDEN_PROPERTY$1;", "OVERRIDING_MARK", "PLATFORM_IMPLEMENTATION", "SUBCLASSED_CLASS", "collectHeaderMarkers", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "collectImplementationMarkers", "collectInheritedClassMarker", "element", "Lorg/jetbrains/kotlin/psi/KtClass;", "collectOverriddenFunctions", "functions", "", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "collectOverriddenPropertyAccessors", "properties", "collectSuperDeclarationMarkers", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "isImplementsAndNotOverrides", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "overriddenMembers", "idea"})
public final class KotlinLineMarkerProviderKt {
    private static final Icon OVERRIDING_MARK;
    private static final Icon IMPLEMENTING_MARK;
    private static final Icon OVERRIDDEN_MARK;
    private static final Icon IMPLEMENTED_MARK;
    private static final MarkerType SUBCLASSED_CLASS;
    private static final OVERRIDDEN_FUNCTION.1 OVERRIDDEN_FUNCTION;
    private static final OVERRIDDEN_PROPERTY.1 OVERRIDDEN_PROPERTY;
    private static final MarkerType PLATFORM_IMPLEMENTATION;
    private static final MarkerType HEADER_DECLARATION;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isImplementsAndNotOverrides(CallableMemberDescriptor descriptor2, Collection<? extends CallableMemberDescriptor> overriddenMembers) {
        Object element$iv;
        CallableMemberDescriptor it;
        if (!(Intrinsics.areEqual((Object)((Object)descriptor2.getModality()), (Object)((Object)Modality.ABSTRACT)) ^ true)) return false;
        Iterable $receiver$iv = overriddenMembers;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
        } while (Intrinsics.areEqual((Object)((Object)(it = (CallableMemberDescriptor)(element$iv = iterator2.next())).getModality()), (Object)((Object)Modality.ABSTRACT)));
        return false;
    }

    private static final void collectSuperDeclarationMarkers(KtDeclaration declaration2, Collection<LineMarkerInfo<?>> result2) {
        KtNamedDeclaration ktNamedDeclaration;
        boolean bl;
        boolean bl2 = bl = declaration2 instanceof KtNamedFunction || declaration2 instanceof KtProperty || declaration2 instanceof KtParameter;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (!declaration2.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            return;
        }
        ResolveWithParentsResult resolveWithParents = SuperDeclarationMarkerKt.resolveDeclarationWithParents(declaration2);
        if (resolveWithParents.getOverriddenDescriptors().isEmpty()) {
            return;
        }
        CallableMemberDescriptor callableMemberDescriptor = resolveWithParents.getDescriptor();
        if (callableMemberDescriptor == null) {
            Intrinsics.throwNpe();
        }
        boolean bl3 = KotlinLineMarkerProviderKt.isImplementsAndNotOverrides(callableMemberDescriptor, resolveWithParents.getOverriddenDescriptors());
        KtDeclaration ktDeclaration = declaration2;
        if (!(ktDeclaration instanceof KtNamedDeclaration)) {
            ktDeclaration = null;
        }
        if ((ktNamedDeclaration = (KtNamedDeclaration)ktDeclaration) == null || (ktNamedDeclaration = ktNamedDeclaration.getNameIdentifier()) == null) {
            ktNamedDeclaration = declaration2;
        }
        KtNamedDeclaration anchor2 = ktNamedDeclaration;
        result2.add(new LineMarkerInfo((PsiElement)anchor2, anchor2.getTextRange(), bl3 ? IMPLEMENTING_MARK : OVERRIDING_MARK, 11, (Function)SuperDeclarationMarkerTooltip.INSTANCE, (GutterIconNavigationHandler)new SuperDeclarationMarkerNavigationHandler(), GutterIconRenderer.Alignment.RIGHT));
    }

    private static final void collectInheritedClassMarker(KtClass element3, Collection<LineMarkerInfo<?>> result2) {
        if (!PsiModificationUtilsKt.isInheritable(element3)) {
            return;
        }
        KtLightClass ktLightClass = LightClassUtilsKt.toLightClass(element3);
        if (ktLightClass == null) {
            return;
        }
        KtLightClass lightClass2 = ktLightClass;
        if (ClassInheritorsSearch.search((PsiClass)lightClass2, (boolean)false).findFirst() == null) {
            return;
        }
        PsiElement psiElement2 = element3.getNameIdentifier();
        if (psiElement2 == null) {
            psiElement2 = element3;
        }
        PsiElement anchor2 = psiElement2;
        result2.add(new LineMarkerInfo(anchor2, anchor2.getTextRange(), element3.isInterface() ? IMPLEMENTED_MARK : OVERRIDDEN_MARK, 11, SUBCLASSED_CLASS.getTooltip(), SUBCLASSED_CLASS.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT));
    }

    /*
     * WARNING - void declaration
     */
    private static final void collectOverriddenPropertyAccessors(Collection<? extends KtNamedDeclaration> properties2, Collection<LineMarkerInfo<?>> result2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable accessorsPsiMethods2;
        HashMap<Map, KtNamedDeclaration> mappingToJava = new HashMap<Map, KtNamedDeclaration>();
        for (KtNamedDeclaration ktNamedDeclaration : properties2) {
            Map psiMethod222;
            if (!PsiModificationUtilsKt.isOverridable(ktNamedDeclaration)) continue;
            accessorsPsiMethods2 = LightClassUtilKt.getAccessorLightMethods(ktNamedDeclaration);
            for (Map psiMethod222 : accessorsPsiMethods2) {
                mappingToJava.put(psiMethod222, ktNamedDeclaration);
            }
            psiMethod222 = mappingToJava;
            KtNamedDeclaration ktNamedDeclaration2 = ktNamedDeclaration;
            psiMethod222.put(ktNamedDeclaration, ktNamedDeclaration2);
        }
        accessorsPsiMethods2 = $receiver$iv = (Iterable)mappingToJava.keySet();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof PsiMethod)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set<PsiClass> set2 = JavaPsiUtilsKt.collectContainingClasses((List)destination$iv$iv);
        for (KtNamedDeclaration property3 : OverridenFunctionMarkerKt.getOverriddenDeclarations((Map)mappingToJava, set2)) {
            PsiNameIdentifierOwner psiNameIdentifierOwner;
            ProgressManager.checkCanceled();
            KtNamedDeclaration ktNamedDeclaration = property3;
            if (!(ktNamedDeclaration instanceof PsiNameIdentifierOwner)) {
                ktNamedDeclaration = null;
            }
            if ((psiNameIdentifierOwner = (PsiNameIdentifierOwner)ktNamedDeclaration) == null || (psiNameIdentifierOwner = psiNameIdentifierOwner.getNameIdentifier()) == null) {
                psiNameIdentifierOwner = property3;
            }
            PsiNameIdentifierOwner anchor2 = psiNameIdentifierOwner;
            result2.add(new LineMarkerInfo((PsiElement)anchor2, anchor2.getTextRange(), OverridenPropertyMarkerKt.isImplemented(property3) ? IMPLEMENTED_MARK : OVERRIDDEN_MARK, 11, OVERRIDDEN_PROPERTY.getTooltip(), OVERRIDDEN_PROPERTY.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT));
        }
    }

    private static final void collectImplementationMarkers(KtNamedDeclaration declaration2, Collection<LineMarkerInfo<?>> result2) {
        boolean bl;
        block7: {
            DeclarationDescriptor declarationDescriptor = PsiModificationUtilsKt.toDescriptor(declaration2);
            if (!(declarationDescriptor instanceof MemberDescriptor)) {
                declarationDescriptor = null;
            }
            MemberDescriptor memberDescriptor = (MemberDescriptor)declarationDescriptor;
            if (memberDescriptor == null) {
                return;
            }
            MemberDescriptor descriptor2 = memberDescriptor;
            ModuleDescriptor commonModuleDescriptor = ResolutionUtils.findModuleDescriptor(declaration2.getContainingKtFile());
            Iterable $receiver$iv = PlatformHeaderAnnotatorKt.getAllImplementingCompatibleModules(commonModuleDescriptor);
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    ModuleDescriptor it = (ModuleDescriptor)element$iv;
                    if (!ImplementedHeaderMarkerKt.hasImplementationsOf(it, descriptor2)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        PsiElement psiElement2 = declaration2.getNameIdentifier();
        if (psiElement2 == null) {
            psiElement2 = declaration2;
        }
        PsiElement anchor2 = psiElement2;
        result2.add(new LineMarkerInfo(anchor2, anchor2.getTextRange(), KotlinIcons.FROM_HEADER, 11, PLATFORM_IMPLEMENTATION.getTooltip(), PLATFORM_IMPLEMENTATION.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT));
    }

    private static final void collectHeaderMarkers(KtNamedDeclaration declaration2, Collection<LineMarkerInfo<?>> result2) {
        DeclarationDescriptor declarationDescriptor = PsiModificationUtilsKt.toDescriptor(declaration2);
        if (!(declarationDescriptor instanceof MemberDescriptor)) {
            declarationDescriptor = null;
        }
        MemberDescriptor memberDescriptor = (MemberDescriptor)declarationDescriptor;
        if (memberDescriptor == null) {
            return;
        }
        MemberDescriptor descriptor2 = memberDescriptor;
        ModuleDescriptor platformModuleDescriptor = ResolutionUtils.findModuleDescriptor(declaration2.getContainingKtFile());
        ModuleDescriptor moduleDescriptor = DeclaredHeaderMarkerKt.commonModuleOrNull(platformModuleDescriptor);
        if (moduleDescriptor == null) {
            return;
        }
        ModuleDescriptor commonModuleDescriptor = moduleDescriptor;
        if (!DeclaredHeaderMarkerKt.hasDeclarationOf(commonModuleDescriptor, descriptor2)) {
            return;
        }
        PsiElement psiElement2 = declaration2.getNameIdentifier();
        if (psiElement2 == null) {
            psiElement2 = declaration2;
        }
        PsiElement anchor2 = psiElement2;
        result2.add(new LineMarkerInfo(anchor2, anchor2.getTextRange(), KotlinIcons.FROM_IMPL, 11, HEADER_DECLARATION.getTooltip(), HEADER_DECLARATION.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT));
    }

    /*
     * WARNING - void declaration
     */
    private static final void collectOverriddenFunctions(Collection<? extends KtNamedFunction> functions2, Collection<LineMarkerInfo<?>> result2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable method;
        HashMap<Object, KtNamedFunction> mappingToJava = new HashMap<Object, KtNamedFunction>();
        for (KtNamedFunction ktNamedFunction : functions2) {
            if (!PsiModificationUtilsKt.isOverridable(ktNamedFunction)) continue;
            method = LightClassUtil.INSTANCE.getLightClassMethod(ktNamedFunction);
            if (method != null) {
                mappingToJava.put(method, ktNamedFunction);
            }
            mappingToJava.put(ktNamedFunction, ktNamedFunction);
        }
        method = $receiver$iv = (Iterable)mappingToJava.keySet();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof PsiMethod)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set<PsiClass> set2 = JavaPsiUtilsKt.collectContainingClasses((List)destination$iv$iv);
        for (KtNamedFunction function3 : OverridenFunctionMarkerKt.getOverriddenDeclarations((Map)mappingToJava, set2)) {
            ProgressManager.checkCanceled();
            PsiElement psiElement2 = function3.getNameIdentifier();
            if (psiElement2 == null) {
                psiElement2 = function3;
            }
            PsiElement anchor2 = psiElement2;
            result2.add(new LineMarkerInfo(anchor2, anchor2.getTextRange(), OverridenPropertyMarkerKt.isImplemented(function3) ? IMPLEMENTED_MARK : OVERRIDDEN_MARK, 11, OVERRIDDEN_FUNCTION.getTooltip(), OVERRIDDEN_FUNCTION.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT));
        }
    }

    static {
        Icon icon = AllIcons.Gutter.OverridingMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.Gutter.OverridingMethod");
        OVERRIDING_MARK = icon;
        Icon icon2 = AllIcons.Gutter.ImplementingMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"AllIcons.Gutter.ImplementingMethod");
        IMPLEMENTING_MARK = icon2;
        Icon icon3 = AllIcons.Gutter.OverridenMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon3, (String)"AllIcons.Gutter.OverridenMethod");
        OVERRIDDEN_MARK = icon3;
        Icon icon4 = AllIcons.Gutter.ImplementedMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon4, (String)"AllIcons.Gutter.ImplementedMethod");
        IMPLEMENTED_MARK = icon4;
        SUBCLASSED_CLASS = new MarkerType("SUBCLASSED_CLASS", (Function)SUBCLASSED_CLASS.1.INSTANCE, new LineMarkerNavigator(){

            public void browse(@Nullable MouseEvent e, @Nullable PsiElement element3) {
                block0: {
                    PsiClass psiClass2;
                    PsiClass psiClass3 = JavaPsiUtilsKt.getPsiClass(element3);
                    if (psiClass3 == null) break block0;
                    PsiClass it = psiClass2 = psiClass3;
                    MarkerType.navigateToSubclassedClass((MouseEvent)e, (PsiClass)it);
                }
            }
        });
        OVERRIDDEN_FUNCTION = new MarkerType("OVERRIDDEN_FUNCTION", OVERRIDDEN_FUNCTION.2.INSTANCE, new LineMarkerNavigator(){

            public void browse(@Nullable MouseEvent e, @Nullable PsiElement element3) {
                block0: {
                    NavigationPopupDescriptor navigationPopupDescriptor = OverridenFunctionMarkerKt.buildNavigateToOverriddenMethodPopup(e, element3);
                    if (navigationPopupDescriptor == null) break block0;
                    navigationPopupDescriptor.showPopup(e);
                }
            }
        }){

            @NotNull
            public GutterIconNavigationHandler<PsiElement> getNavigationHandler() {
                GutterIconNavigationHandler superHandler = super.getNavigationHandler();
                return (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiElement>(superHandler){
                    final /* synthetic */ GutterIconNavigationHandler $superHandler;

                    public void navigate(@Nullable MouseEvent e, @Nullable PsiElement elt) {
                        this.$superHandler.navigate(e, elt);
                    }

                    @Nullable
                    public NavigationPopupDescriptor getTargetsPopupDescriptor(@Nullable PsiElement element3) {
                        return OverridenFunctionMarkerKt.buildNavigateToOverriddenMethodPopup(null, element3);
                    }
                    {
                        this.$superHandler = $captured_local_variable$0;
                    }
                };
            }
        };
        OVERRIDDEN_PROPERTY = new MarkerType("OVERRIDDEN_PROPERTY", OVERRIDDEN_PROPERTY.2.INSTANCE, new LineMarkerNavigator(){

            public void browse(@Nullable MouseEvent e, @Nullable PsiElement element3) {
                block0: {
                    NavigationPopupDescriptor navigationPopupDescriptor = OverridenPropertyMarkerKt.buildNavigateToPropertyOverriddenDeclarationsPopup(e, element3);
                    if (navigationPopupDescriptor == null) break block0;
                    navigationPopupDescriptor.showPopup(e);
                }
            }
        }){

            @NotNull
            public GutterIconNavigationHandler<PsiElement> getNavigationHandler() {
                GutterIconNavigationHandler superHandler = super.getNavigationHandler();
                return (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiElement>(superHandler){
                    final /* synthetic */ GutterIconNavigationHandler $superHandler;

                    public void navigate(@Nullable MouseEvent e, @Nullable PsiElement elt) {
                        this.$superHandler.navigate(e, elt);
                    }

                    @Nullable
                    public NavigationPopupDescriptor getTargetsPopupDescriptor(@Nullable PsiElement element3) {
                        return OverridenPropertyMarkerKt.buildNavigateToPropertyOverriddenDeclarationsPopup(null, element3);
                    }
                    {
                        this.$superHandler = $captured_local_variable$0;
                    }
                };
            }
        };
        PLATFORM_IMPLEMENTATION = new MarkerType("PLATFORM_IMPLEMENTATION", (Function)PLATFORM_IMPLEMENTATION.1.INSTANCE, new LineMarkerNavigator(){

            public void browse(@Nullable MouseEvent e, @Nullable PsiElement element3) {
                block1: {
                    PsiElement psiElement2;
                    PsiElement psiElement3 = element3;
                    if (psiElement3 == null) break block1;
                    PsiElement it = psiElement2 = psiElement3;
                    PsiElement psiElement4 = it.getParent();
                    if (psiElement4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDeclaration");
                    }
                    ImplementedHeaderMarkerKt.navigateToPlatformImplementation(e, (KtDeclaration)psiElement4);
                }
            }
        });
        HEADER_DECLARATION = new MarkerType("HEADER_DECLARATION", (Function)HEADER_DECLARATION.1.INSTANCE, new LineMarkerNavigator(){

            public void browse(@Nullable MouseEvent e, @Nullable PsiElement element3) {
                block1: {
                    PsiElement psiElement2;
                    PsiElement psiElement3 = element3;
                    if (psiElement3 == null) break block1;
                    PsiElement it = psiElement2 = psiElement3;
                    PsiElement psiElement4 = it.getParent();
                    if (psiElement4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDeclaration");
                    }
                    DeclaredHeaderMarkerKt.navigateToHeaderDeclaration((KtDeclaration)psiElement4);
                }
            }
        });
    }

    public static final /* synthetic */ void access$collectInheritedClassMarker(@NotNull KtClass element3, @NotNull Collection result2) {
        KotlinLineMarkerProviderKt.collectInheritedClassMarker(element3, result2);
    }

    public static final /* synthetic */ void access$collectSuperDeclarationMarkers(@NotNull KtDeclaration declaration2, @NotNull Collection result2) {
        KotlinLineMarkerProviderKt.collectSuperDeclarationMarkers(declaration2, result2);
    }

    public static final /* synthetic */ void access$collectOverriddenFunctions(@NotNull Collection functions2, @NotNull Collection result2) {
        KotlinLineMarkerProviderKt.collectOverriddenFunctions(functions2, result2);
    }

    public static final /* synthetic */ void access$collectOverriddenPropertyAccessors(@NotNull Collection properties2, @NotNull Collection result2) {
        KotlinLineMarkerProviderKt.collectOverriddenPropertyAccessors(properties2, result2);
    }

    public static final /* synthetic */ void access$collectImplementationMarkers(@NotNull KtNamedDeclaration declaration2, @NotNull Collection result2) {
        KotlinLineMarkerProviderKt.collectImplementationMarkers(declaration2, result2);
    }

    public static final /* synthetic */ void access$collectHeaderMarkers(@NotNull KtNamedDeclaration declaration2, @NotNull Collection result2) {
        KotlinLineMarkerProviderKt.collectHeaderMarkers(declaration2, result2);
    }
}

