/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.diagnostics.AbstractDiagnostic;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactoryWithPsiElement;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.highlighter.KotlinPsiChecker;
import org.jetbrains.kotlin.idea.quickfix.CleanupFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.ReplaceObsoleteLabelSyntaxFix;
import org.jetbrains.kotlin.idea.quickfix.replaceWith.DeprecatedSymbolUsageFix;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\"#B\u0005\u00a2\u0006\u0002\u0010\u0003J/\u0010\n\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J6\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\r\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0016J\f\u0010\u001d\u001a\u00020\u0012*\u00020\u001eH\u0002J\f\u0010\u001f\u001a\u00020\u0012*\u00020\u001eH\u0002J\u0012\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019*\u00020\u001eH\u0002J*\u0010!\u001a\u00020\f*\u00020\u001e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\r\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u009f\u0001\u0010\u0004\u001a\u0092\u0001\u0012\u008d\u0001\u0012\u008a\u0001\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012.\b\u0001\u0012*\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0014\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\t0\t \b*D\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012.\b\u0001\u0012*\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0014\u0012\u000e\b\u0001\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\t0\t\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinCleanupInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "cleanupDiagnosticsFactories", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactoryWithPsiElement;", "Lcom/intellij/psi/PsiElement;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/diagnostics/AbstractDiagnostic;", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "createProblemDescriptor", "element", "message", "", "fixes", "", "Lorg/jetbrains/kotlin/idea/quickfix/CleanupFix;", "Lorg/jetbrains/kotlin/psi/KtFile;", "getDisplayName", "isCleanup", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "isObsoleteLabel", "toCleanupFixes", "toProblemDescriptor", "RemoveImportFix", "Wrapper", "idea"})
public final class KotlinCleanupInspection
extends LocalInspectionTool
implements CleanupLocalInspectionTool {
    private final Set<DiagnosticFactoryWithPsiElement<? extends PsiElement, ? extends AbstractDiagnostic<? extends PsiElement>>> cleanupDiagnosticsFactories = SetsKt.setOf((Object[])new DiagnosticFactoryWithPsiElement[]{Errors.MISSING_CONSTRUCTOR_KEYWORD, Errors.UNNECESSARY_NOT_NULL_ASSERTION, Errors.UNNECESSARY_SAFE_CALL, Errors.USELESS_CAST, Errors.USELESS_ELVIS, ErrorsJvm.POSITIONED_VALUE_ARGUMENT_FOR_JAVA_ANNOTATION, Errors.DEPRECATION, Errors.DEPRECATION_ERROR, Errors.NON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION, Errors.OPERATOR_MODIFIER_REQUIRED, Errors.INFIX_MODIFIER_REQUIRED, Errors.DEPRECATED_TYPE_PARAMETER_SYNTAX, Errors.MISPLACED_TYPE_PARAMETER_CONSTRAINTS, Errors.COMMA_IN_WHEN_CONDITION_WITHOUT_ARGUMENT, ErrorsJs.WRONG_EXTERNAL_DECLARATION, Errors.YIELD_IS_RESERVED});

    @NotNull
    public String getDisplayName() {
        return "Usage of redundant or deprecated syntax or deprecated symbols";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Object object2;
        Iterator $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        if (isOnTheFly || !(file2 instanceof KtFile) || !ProjectRootsUtil.isInProjectSource((PsiElement)file2)) {
            return null;
        }
        AnalysisResult analysisResult = ResolutionUtils.analyzeFullyAndGetResult((KtElement)file2, new KtFile[0]);
        if (analysisResult.isError()) {
            throw (Throwable)new ProcessCanceledException(analysisResult.getError());
        }
        Diagnostics diagnostics = analysisResult.getBindingContext().getDiagnostics();
        ArrayList<ProblemDescriptor> problemDescriptors = new ArrayList<ProblemDescriptor>();
        Iterable iterable = $receiver$iv = (Iterable)((KtFile)file2).getImportDirectives();
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            KtImportDirective it = (KtImportDirective)element$iv$iv;
            if (!DeprecatedSymbolUsageFix.Companion.isImportToBeRemoved(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List importsToRemove = (List)destination$iv$iv;
        for (Object object2 : importsToRemove) {
            RemoveImportFix removeImportFix = new RemoveImportFix((KtImportDirective)object2);
            ProblemDescriptor problemDescriptor = this.createProblemDescriptor((PsiElement)object2, removeImportFix.getText(), CollectionsKt.listOf((Object)removeImportFix), (KtFile)file2, manager);
            problemDescriptors.add(problemDescriptor);
        }
        object2 = (PsiElement)file2;
        Function1 action$iv = (Function1)new Function1<PsiElement, Unit>(this, diagnostics, problemDescriptors, file2, manager){
            final /* synthetic */ KotlinCleanupInspection this$0;
            final /* synthetic */ Diagnostics $diagnostics;
            final /* synthetic */ ArrayList $problemDescriptors;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ InspectionManager $manager;

            public final void invoke(@NotNull PsiElement element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                for (Diagnostic diagnostic : this.$diagnostics.forElement(element3)) {
                    Collection fixes;
                    Collection collection;
                    if (!KotlinCleanupInspection.access$isCleanup(this.this$0, diagnostic) || !(!(collection = (fixes = KotlinCleanupInspection.access$toCleanupFixes(this.this$0, diagnostic))).isEmpty())) continue;
                    this.$problemDescriptors.add(KotlinCleanupInspection.access$toProblemDescriptor(this.this$0, diagnostic, fixes, (KtFile)this.$file, this.$manager));
                }
            }
            {
                this.this$0 = kotlinCleanupInspection;
                this.$diagnostics = diagnostics;
                this.$problemDescriptors = arrayList;
                this.$file = psiFile;
                this.$manager = inspectionManager;
                super(1);
            }
        };
        Iterable $receiver$iv$iv2 = $receiver$iv;
        $receiver$iv$iv2.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $captured_local_variable$1;
            }

            public void visitElement(@NotNull PsiElement element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                PsiElement it = element3;
                super.visitElement(element3);
                this.$action.invoke((Object)element3);
            }
        });
        Iterable thisCollection$iv = $receiver$iv = (Collection)problemDescriptors;
        ProblemDescriptor[] problemDescriptorArray = thisCollection$iv.toArray(new ProblemDescriptor[thisCollection$iv.size()]);
        if (problemDescriptorArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return problemDescriptorArray;
    }

    private final boolean isCleanup(@NotNull Diagnostic $receiver) {
        return CollectionsKt.contains((Iterable)this.cleanupDiagnosticsFactories, $receiver.getFactory()) || this.isObsoleteLabel($receiver);
    }

    private final boolean isObsoleteLabel(@NotNull Diagnostic $receiver) {
        PsiElement $receiver$iv = $receiver.getPsiElement();
        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtAnnotationEntry.class, (boolean)false);
        if (ktAnnotationEntry == null) {
            return false;
        }
        KtAnnotationEntry annotationEntry2 = ktAnnotationEntry;
        return ReplaceObsoleteLabelSyntaxFix.Companion.looksLikeObsoleteLabel(annotationEntry2);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<CleanupFix> toCleanupFixes(@NotNull Diagnostic $receiver) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)KotlinPsiChecker.Companion.createQuickFixes($receiver);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof CleanupFix)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final ProblemDescriptor toProblemDescriptor(@NotNull Diagnostic $receiver, Collection<? extends CleanupFix> fixes, KtFile file2, InspectionManager manager) {
        PsiElement psiElement2 = $receiver.getPsiElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"psiElement");
        String string = DefaultErrorMessages.render($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DefaultErrorMessages.render(this)");
        return this.createProblemDescriptor(psiElement2, string, fixes, file2, manager);
    }

    /*
     * WARNING - void declaration
     */
    private final ProblemDescriptor createProblemDescriptor(PsiElement element3, String message2, Collection<? extends CleanupFix> fixes, KtFile file2, InspectionManager manager) {
        Collection<Wrapper> collection;
        void $receiver$iv$iv;
        Collection $receiver$iv;
        Iterable iterable = fixes;
        boolean bl = false;
        String string = message2;
        PsiElement psiElement2 = element3;
        InspectionManager inspectionManager = manager;
        void var7_11 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            CleanupFix cleanupFix = (CleanupFix)item$iv$iv;
            collection = destination$iv$iv;
            Wrapper wrapper = new Wrapper((IntentionAction)it, file2);
            collection.add(wrapper);
        }
        collection = (List)destination$iv$iv;
        Collection thisCollection$iv = $receiver$iv = (Collection)collection;
        Wrapper[] wrapperArray = thisCollection$iv.toArray(new Wrapper[thisCollection$iv.size()]);
        if (wrapperArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        collection = wrapperArray;
        ProblemDescriptor problemDescriptor = inspectionManager.createProblemDescriptor(psiElement2, string, bl, (LocalQuickFix[])collection, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        Intrinsics.checkExpressionValueIsNotNull((Object)problemDescriptor, (String)"manager.createProblemDes\u2026GENERIC_ERROR_OR_WARNING)");
        return problemDescriptor;
    }

    public static final /* synthetic */ boolean access$isCleanup(KotlinCleanupInspection $this, @NotNull Diagnostic $receiver) {
        return $this.isCleanup($receiver);
    }

    @NotNull
    public static final /* synthetic */ Collection access$toCleanupFixes(KotlinCleanupInspection $this, @NotNull Diagnostic $receiver) {
        return $this.toCleanupFixes($receiver);
    }

    @NotNull
    public static final /* synthetic */ ProblemDescriptor access$toProblemDescriptor(KotlinCleanupInspection $this, @NotNull Diagnostic $receiver, @NotNull Collection fixes, @NotNull KtFile file2, @NotNull InspectionManager manager) {
        return $this.toProblemDescriptor($receiver, fixes, file2, manager);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J%\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0004\u001a\u0004\u0018\u00010\u000fH\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinCleanupInspection$Wrapper;", "Lcom/intellij/codeInspection/IntentionWrapper;", "intention", "Lcom/intellij/codeInsight/intention/IntentionAction;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lcom/intellij/codeInsight/intention/IntentionAction;Lorg/jetbrains/kotlin/psi/KtFile;)V", "getIntention", "()Lcom/intellij/codeInsight/intention/IntentionAction;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Lcom/intellij/psi/PsiFile;", "idea"})
    private static final class Wrapper
    extends IntentionWrapper {
        @NotNull
        private final IntentionAction intention;

        public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            if (this.intention.isAvailable(project, editor, file2)) {
                super.invoke(project, editor, file2);
            }
        }

        @NotNull
        public final IntentionAction getIntention() {
            return this.intention;
        }

        public Wrapper(@NotNull IntentionAction intention, @NotNull KtFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)intention, (String)"intention");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            super(intention, (PsiFile)file2);
            this.intention = intention;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinCleanupInspection$RemoveImportFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "Lorg/jetbrains/kotlin/idea/quickfix/CleanupFix;", "import", "(Lorg/jetbrains/kotlin/psi/KtImportDirective;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "idea"})
    private static final class RemoveImportFix
    extends KotlinQuickFixAction<KtImportDirective>
    implements CleanupFix {
        @NotNull
        public String getFamilyName() {
            return "Remove deprecated symbol import";
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        @Override
        protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                KtImportDirective ktImportDirective = (KtImportDirective)this.getElement();
                if (ktImportDirective == null) break block0;
                ktImportDirective.delete();
            }
        }

        public RemoveImportFix(@NotNull KtImportDirective ktImportDirective) {
            Intrinsics.checkParameterIsNotNull((Object)ktImportDirective, (String)"import");
            super((PsiElement)ktImportDirective);
        }
    }
}

