/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.formatter.CollectChangesWithoutApplyModelKt;
import org.jetbrains.kotlin.idea.formatter.FormattingChange;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReformatInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "isEmptyLineReformat", "whitespace", "Lcom/intellij/psi/PsiWhiteSpace;", "change", "Lorg/jetbrains/kotlin/idea/formatter/FormattingChange;", "ReformatQuickFix", "idea"})
public final class ReformatInspection
extends LocalInspectionTool {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        ProblemDescriptorImpl problemDescriptorImpl;
        ProblemDescriptorImpl leaf;
        PsiElement it;
        Collection collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        if (!(file2 instanceof KtFile) || !ProjectRootsUtil.isInProjectSource((PsiElement)file2)) {
            return null;
        }
        Set<FormattingChange> changes = CollectChangesWithoutApplyModelKt.collectFormattingChanges(file2);
        if (changes.isEmpty()) {
            return null;
        }
        Iterable iterable = $receiver$iv = (Iterable)changes;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            int n;
            FormattingChange formattingChange = (FormattingChange)item$iv$iv;
            collection = destination$iv$iv;
            PsiElement psiElement2 = it;
            if (psiElement2 instanceof FormattingChange.ShiftIndentInsideRange) {
                n = ((FormattingChange.ShiftIndentInsideRange)it).getRange().getStartOffset();
            } else if (psiElement2 instanceof FormattingChange.ReplaceWhiteSpace) {
                n = ((FormattingChange.ReplaceWhiteSpace)it).getTextRange().getStartOffset();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            int rangeOffset = n;
            problemDescriptorImpl = file2.findElementAt(rangeOffset) == null ? null : (!leaf.isValid() ? null : (leaf instanceof PsiWhiteSpace && this.isEmptyLineReformat((PsiWhiteSpace)leaf, (FormattingChange)it) ? null : leaf));
            collection.add(problemDescriptorImpl);
        }
        List elements2 = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        $receiver$iv$iv = $receiver$iv = (Iterable)elements2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void elements$iv;
            ProblemDescriptorImpl problemDescriptorImpl2;
            it = (PsiElement)item$iv$iv;
            collection = destination$iv$iv;
            leaf = (ProblemDescriptorImpl)new ReformatQuickFix[]{ReformatQuickFix.INSTANCE};
            String string = "File is not properly formatted";
            PsiElement psiElement3 = it;
            PsiElement psiElement4 = it;
            ProblemDescriptorImpl problemDescriptorImpl3 = problemDescriptorImpl2;
            ProblemDescriptorImpl problemDescriptorImpl4 = problemDescriptorImpl2;
            void var18_21 = elements$iv;
            problemDescriptorImpl3(psiElement4, psiElement3, string, (LocalQuickFix[])var18_21, ProblemHighlightType.WEAK_WARNING, false, null, isOnTheFly);
            problemDescriptorImpl = problemDescriptorImpl4;
            collection.add(problemDescriptorImpl);
        }
        $receiver$iv = (List)destination$iv$iv;
        Iterable thisCollection$iv = $receiver$iv;
        ProblemDescriptorImpl[] problemDescriptorImplArray = thisCollection$iv.toArray(new ProblemDescriptorImpl[thisCollection$iv.size()]);
        if (problemDescriptorImplArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (ProblemDescriptor[])problemDescriptorImplArray;
    }

    private final boolean isEmptyLineReformat(PsiWhiteSpace whitespace, FormattingChange change) {
        char it;
        char element$iv;
        int n;
        if (!(change instanceof FormattingChange.ReplaceWhiteSpace)) {
            return false;
        }
        String beforeText = whitespace.getText();
        String afterText = ((FormattingChange.ReplaceWhiteSpace)change).getWhiteSpace();
        CharSequence $receiver$iv = beforeText;
        int count$iv = 0;
        CharSequence charSequence = $receiver$iv;
        for (n = 0; n < charSequence.length(); ++n) {
            element$iv = charSequence.charAt(n);
            it = element$iv;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        $receiver$iv = afterText;
        int n2 = count$iv;
        count$iv = 0;
        charSequence = $receiver$iv;
        for (n = 0; n < charSequence.length(); ++n) {
            element$iv = charSequence.charAt(n);
            it = element$iv;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        int n3 = count$iv;
        return n2 == n3 && Intrinsics.areEqual((Object)StringsKt.substringAfterLast$default((String)beforeText, (char)'\n', null, (int)2, null), (Object)StringsKt.substringAfterLast$default((String)afterText, (char)'\n', null, (int)2, null));
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReformatInspection$ReformatQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "idea"})
    private static final class ReformatQuickFix
    implements LocalQuickFix {
        public static final ReformatQuickFix INSTANCE;

        @NotNull
        public String getFamilyName() {
            return "Reformat File";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)descriptor2.getPsiElement().getContainingFile());
        }

        private ReformatQuickFix() {
            INSTANCE = this;
        }

        static {
            new ReformatQuickFix();
        }
    }
}

