/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.gradle;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.PluginVersionDependentInspection;
import org.jetbrains.kotlin.idea.inspections.gradle.DifferentKotlinGradleVersionInspection;
import org.jetbrains.kotlin.idea.inspections.gradle.KotlinGradleInspectionVisitor;
import org.jetbrains.kotlin.idea.inspections.gradle.KotlinGradleInspectionVisitorKt;
import org.jetbrains.plugins.gradle.codeInspection.GradleBaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0003\u0014\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J!\u0010\u000b\u001a\u00020\u00052\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000eH\u0014\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00050\u0005H\u0016R(\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005@WX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentKotlinGradleVersionInspection;", "Lorg/jetbrains/plugins/gradle/codeInspection/GradleBaseInspection;", "Lorg/jetbrains/kotlin/idea/inspections/PluginVersionDependentInspection;", "()V", "<set-?>", "", "testVersionMessage", "getTestVersionMessage", "()Ljava/lang/String;", "setTestVersionMessage", "(Ljava/lang/String;)V", "buildErrorString", "args", "", "", "([Ljava/lang/Object;)Ljava/lang/String;", "buildVisitor", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor;", "getGroupDisplayName", "kotlin.jvm.PlatformType", "Companion", "MyVisitor", "VersionFinder", "idea-gradle"})
public final class DifferentKotlinGradleVersionInspection
extends GradleBaseInspection
implements PluginVersionDependentInspection {
    @Nullable
    private String testVersionMessage;
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public String getTestVersionMessage() {
        return this.testVersionMessage;
    }

    @Override
    public void setTestVersionMessage(@Nullable String string) {
        this.testVersionMessage = string;
    }

    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new MyVisitor();
    }

    public String getGroupDisplayName() {
        return BaseInspection.PROBABLE_BUGS;
    }

    @NotNull
    protected String buildErrorString(Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        return "Kotlin version that is used for building with Gradle (" + args[0] + ") differs from the one bundled into the IDE plugin (" + args[1] + ')';
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH$J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentKotlinGradleVersionInspection$VersionFinder;", "Lorg/jetbrains/kotlin/idea/inspections/gradle/KotlinGradleInspectionVisitor;", "()V", "onFound", "", "kotlinPluginVersion", "", "kotlinPluginStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "visitClosure", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "idea-gradle"})
    private static abstract class VersionFinder
    extends KotlinGradleInspectionVisitor {
        protected abstract void onFound(@NotNull String var1, @NotNull GrCallExpression var2);

        public void visitClosure(@NotNull GrClosableBlock closure) {
            Object v2;
            block8: {
                Intrinsics.checkParameterIsNotNull((Object)closure, (String)"closure");
                super.visitClosure(closure);
                PsiElement $receiver$iv = (PsiElement)closure;
                GrMethodCall grMethodCall = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, GrMethodCall.class, (boolean)true);
                if (grMethodCall == null) {
                    return;
                }
                GrMethodCall dependenciesCall = grMethodCall;
                if (Intrinsics.areEqual((Object)dependenciesCall.getInvokedExpression().getText(), (Object)"dependencies") ^ true) {
                    return;
                }
                PsiElement $receiver$iv2 = (PsiElement)dependenciesCall;
                GrMethodCall grMethodCall2 = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, GrMethodCall.class, (boolean)true);
                if (grMethodCall2 == null) {
                    return;
                }
                GrMethodCall buildScriptCall = grMethodCall2;
                if (Intrinsics.areEqual((Object)buildScriptCall.getInvokedExpression().getText(), (Object)"buildscript") ^ true) {
                    return;
                }
                Iterable $receiver$iv3 = Companion.findClassPathStatements(closure);
                for (Object element$iv : $receiver$iv3) {
                    GrCallExpression it = (GrCallExpression)element$iv;
                    if (!StringsKt.contains$default((CharSequence)it.getText(), (CharSequence)KotlinGradleInspectionVisitorKt.getKOTLIN_PLUGIN_CLASSPATH_MARKER(), (boolean)false, (int)2, null)) continue;
                    v2 = element$iv;
                    break block8;
                }
                v2 = null;
            }
            GrCallExpression grCallExpression = v2;
            if (grCallExpression == null) {
                return;
            }
            GrCallExpression kotlinPluginStatement = grCallExpression;
            String string = Companion.getHeuristicKotlinPluginVersion(kotlinPluginStatement);
            if (string == null) {
                PsiFile psiFile = closure.getContainingFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"closure.containingFile");
                string = KotlinGradleInspectionVisitorKt.getResolvedKotlinGradleVersion(psiFile);
            }
            if (string == null) {
                return;
            }
            String kotlinPluginVersion = string;
            this.onFound(kotlinPluginVersion, kotlinPluginStatement);
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0014R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentKotlinGradleVersionInspection$MyVisitor;", "Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentKotlinGradleVersionInspection$VersionFinder;", "(Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentKotlinGradleVersionInspection;)V", "idePluginVersion", "", "getIdePluginVersion", "()Ljava/lang/String;", "idePluginVersion$delegate", "Lkotlin/Lazy;", "onFound", "", "kotlinPluginVersion", "kotlinPluginStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "idea-gradle"})
    private final class MyVisitor
    extends VersionFinder {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        private final Lazy idePluginVersion$delegate = LazyKt.lazy((Function0)idePluginVersion.2.INSTANCE);

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MyVisitor.class), "idePluginVersion", "getIdePluginVersion()Ljava/lang/String;"))};
        }

        private final String getIdePluginVersion() {
            Lazy lazy = this.idePluginVersion$delegate;
            MyVisitor myVisitor = this;
            KProperty kProperty = $$delegatedProperties[0];
            return (String)lazy.getValue();
        }

        @Override
        protected void onFound(@NotNull String kotlinPluginVersion, @NotNull GrCallExpression kotlinPluginStatement) {
            Intrinsics.checkParameterIsNotNull((Object)kotlinPluginVersion, (String)"kotlinPluginVersion");
            Intrinsics.checkParameterIsNotNull((Object)kotlinPluginStatement, (String)"kotlinPluginStatement");
            if (Intrinsics.areEqual((Object)kotlinPluginVersion, (Object)this.getIdePluginVersion()) ^ true) {
                PsiElement psiElement2 = (PsiElement)kotlinPluginStatement;
                Object[] objectArray = new Object[2];
                objectArray[0] = kotlinPluginVersion;
                String string = DifferentKotlinGradleVersionInspection.this.getTestVersionMessage();
                if (string == null) {
                    string = this.getIdePluginVersion();
                }
                objectArray[1] = string;
                this.registerError(psiElement2, objectArray);
            }
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentKotlinGradleVersionInspection$Companion;", "", "()V", "findClassPathStatements", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "getHeuristicKotlinPluginVersion", "", "classpathStatement", "getKotlinPluginVersion", "gradleFile", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFileBase;", "resolveVariableInBuildScript", "name", "idea-gradle"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public final String getKotlinPluginVersion(@NotNull GroovyFileBase gradleFile) {
            void version;
            Intrinsics.checkParameterIsNotNull((Object)gradleFile, (String)"gradleFile");
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            VersionFinder visitor2 = new VersionFinder((Ref.ObjectRef)version){
                final /* synthetic */ Ref.ObjectRef $version;

                public void visitElement(@NotNull GroovyPsiElement element3) {
                    Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                    element3.acceptChildren((GroovyElementVisitor)this);
                }

                protected void onFound(@NotNull String kotlinPluginVersion, @NotNull GrCallExpression kotlinPluginStatement) {
                    Intrinsics.checkParameterIsNotNull((Object)kotlinPluginVersion, (String)"kotlinPluginVersion");
                    Intrinsics.checkParameterIsNotNull((Object)kotlinPluginStatement, (String)"kotlinPluginStatement");
                    this.$version.element = kotlinPluginVersion;
                }
                {
                    this.$version = $captured_local_variable$0;
                }
            };
            gradleFile.accept((GroovyElementVisitor)visitor2);
            return (String)version.element;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String getHeuristicKotlinPluginVersion(GrCallExpression classpathStatement) {
            GrArgumentList grArgumentList;
            GrCallExpression grCallExpression = classpathStatement;
            if (grCallExpression instanceof GrMethodCall) {
                grArgumentList = ((GrMethodCall)classpathStatement).getArgumentList();
            } else {
                PsiElement $receiver$iv = (PsiElement)classpathStatement;
                PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$receiver$iv, GrCommandArgumentList.class);
                if (psiElementArray == null) {
                    Object[] elements$iv$iv = new GrCommandArgumentList[0];
                    psiElementArray = (PsiElement[])elements$iv$iv;
                }
                grArgumentList = (GrArgumentList)ArraysKt.singleOrNull((Object[])psiElementArray);
            }
            if (grArgumentList == null) return null;
            GrArgumentList argumentList2 = grArgumentList;
            Object object = ArraysKt.firstOrNull((Object[])argumentList2.getChildren());
            if (!(object instanceof GrLiteral)) {
                object = null;
            }
            GrLiteral grLiteral = (GrLiteral)object;
            if (grLiteral == null) return null;
            GrLiteral grLiteral2 = grLiteral;
            if (grLiteral2 instanceof GrString && ((Object[])((GrString)grLiteral2).getInjections()).length == 1) {
                GrReferenceExpression grReferenceExpression;
                GrStringInjection grStringInjection = (GrStringInjection)ArraysKt.first((Object[])((GrString)grLiteral2).getInjections());
                if (grStringInjection == null) return null;
                GrStringInjection versionInjection = grStringInjection;
                GrExpression grExpression = versionInjection.getExpression();
                if (!(grExpression instanceof GrReferenceExpression)) {
                    grExpression = null;
                }
                if ((grReferenceExpression = (GrReferenceExpression)grExpression) == null) {
                    GrReferenceExpression[] grReferenceExpressionArray = versionInjection.getClosableBlock();
                    GrReferenceExpression[] grReferenceExpressionArray2 = grReferenceExpressionArray;
                    if (grReferenceExpressionArray == null) return null;
                    PsiElement $receiver$iv = (PsiElement)grReferenceExpressionArray2;
                    PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$receiver$iv, GrReferenceExpression.class);
                    if (psiElementArray == null) {
                        Object[] elements$iv$iv = new GrReferenceExpression[0];
                        psiElementArray = (PsiElement[])elements$iv$iv;
                    }
                    GrReferenceExpression[] grReferenceExpressionArray3 = (GrReferenceExpression[])psiElementArray;
                    grReferenceExpressionArray2 = grReferenceExpressionArray3;
                    if (grReferenceExpressionArray3 == null) return null;
                    grReferenceExpression = (GrReferenceExpression)ArraysKt.singleOrNull((Object[])grReferenceExpressionArray2);
                }
                if (grReferenceExpression == null) return null;
                GrReferenceExpression expression2 = grReferenceExpression;
                String string = expression2.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"expression.text");
                return this.resolveVariableInBuildScript(classpathStatement, string);
            }
            Object object2 = grLiteral2.getValue();
            if (object2 == null) return null;
            Object literalValue = object2;
            String versionText = StringsKt.substringAfterLast$default((String)literalValue.toString(), (char)':', null, (int)2, null);
            CharSequence charSequence = versionText;
            if (charSequence.length() == 0) {
                return null;
            }
            boolean bl = false;
            if (!bl) return versionText;
            return null;
        }

        private final String resolveVariableInBuildScript(GrCallExpression classpathStatement, String name2) {
            PsiElement $receiver$iv = (PsiElement)classpathStatement;
            GrClosableBlock grClosableBlock = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, GrClosableBlock.class, (boolean)true);
            if (grClosableBlock == null) {
                return null;
            }
            GrClosableBlock dependenciesClosure = grClosableBlock;
            PsiElement $receiver$iv2 = (PsiElement)dependenciesClosure;
            GrClosableBlock grClosableBlock2 = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, GrClosableBlock.class, (boolean)true);
            if (grClosableBlock2 == null) {
                return null;
            }
            GrClosableBlock buildScriptClosure = grClosableBlock2;
            PsiElement[] psiElementArray = buildScriptClosure.getChildren();
            for (int i = 0; i < psiElementArray.length; ++i) {
                PsiElement child = psiElementArray[i];
                PsiElement psiElement2 = child;
                if (psiElement2 instanceof GrAssignmentExpression) {
                    GrExpression assignValue;
                    if (!Intrinsics.areEqual((Object)((GrAssignmentExpression)child).getLValue().getText(), (Object)("ext." + name2)) || !((assignValue = ((GrAssignmentExpression)child).getRValue()) instanceof GrLiteral)) continue;
                    return String.valueOf(((GrLiteral)assignValue).getValue());
                }
                if (!(psiElement2 instanceof GrVariableDeclaration)) continue;
                GrVariable[] grVariableArray = ((GrVariableDeclaration)child).getVariables();
                for (int j = 0; j < grVariableArray.length; ++j) {
                    GrExpression assignValue;
                    GrVariable variable2 = grVariableArray[j];
                    if (!Intrinsics.areEqual((Object)variable2.getName(), (Object)name2) || !((assignValue = variable2.getInitializerGroovy()) instanceof GrLiteral)) continue;
                    return String.valueOf(((GrLiteral)assignValue).getValue());
                }
            }
            return null;
        }

        private final List<GrCallExpression> findClassPathStatements(GrClosableBlock closure) {
            PsiElement $receiver$iv = (PsiElement)closure;
            PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$receiver$iv, GrCallExpression.class);
            if (psiElementArray == null) {
                Object[] elements$iv$iv = new GrCallExpression[0];
                psiElementArray = (PsiElement[])elements$iv$iv;
            }
            GrCallExpression[] applicationStatements = (GrCallExpression[])psiElementArray;
            ArrayList<GrCallExpression> classPathStatements = new ArrayList<GrCallExpression>();
            for (int i = 0; i < applicationStatements.length; ++i) {
                GrReferenceExpression startExpression;
                GrCallExpression statement2 = applicationStatements[i];
                PsiElement $receiver$iv2 = (PsiElement)statement2;
                PsiElement[] psiElementArray2 = PsiTreeUtil.getChildrenOfType((PsiElement)$receiver$iv2, GrReferenceExpression.class);
                if (psiElementArray2 == null) {
                    Object[] elements$iv$iv = new GrReferenceExpression[0];
                    psiElementArray2 = (PsiElement[])elements$iv$iv;
                }
                if ((GrReferenceExpression)ArraysKt.firstOrNull((Object[])psiElementArray2) == null) {
                    continue;
                }
                if (!Intrinsics.areEqual((Object)"classpath", (Object)startExpression.getText())) continue;
                classPathStatements.add(statement2);
            }
            return classPathStatements;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

