/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.slicer;

import com.intellij.psi.PsiElement;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.slicer.InflowSlicer;
import org.jetbrains.kotlin.idea.slicer.OutflowSlicer;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0011\u001a\u00020\u0000H\u0014J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015H\u0016J\u001e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceUsage;", "Lcom/intellij/slicer/SliceUsage;", "element", "Lcom/intellij/psi/PsiElement;", "parent", "lambdaLevel", "", "forcedExpressionMode", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/slicer/SliceUsage;IZ)V", "params", "Lcom/intellij/slicer/SliceAnalysisParams;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/slicer/SliceAnalysisParams;)V", "getForcedExpressionMode", "()Z", "getLambdaLevel", "()I", "copy", "processUsagesFlownDownTo", "", "uniqueProcessor", "Lcom/intellij/util/Processor;", "processUsagesFlownFromThe", "idea"})
public class KotlinSliceUsage
extends SliceUsage {
    private final int lambdaLevel;
    private final boolean forcedExpressionMode;

    public final int getLambdaLevel() {
        return this.lambdaLevel;
    }

    public final boolean getForcedExpressionMode() {
        return this.forcedExpressionMode;
    }

    @NotNull
    protected KotlinSliceUsage copy() {
        PsiElement psiElement2 = this.getUsageInfo().getElement();
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        PsiElement element3 = psiElement2;
        if (this.getParent() == null) {
            PsiElement psiElement3 = element3;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"element");
            SliceAnalysisParams sliceAnalysisParams = this.params;
            Intrinsics.checkExpressionValueIsNotNull((Object)sliceAnalysisParams, (String)"params");
            return new KotlinSliceUsage(psiElement3, sliceAnalysisParams);
        }
        PsiElement psiElement4 = element3;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"element");
        SliceUsage sliceUsage = this.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)sliceUsage, (String)"parent");
        return new KotlinSliceUsage(psiElement4, sliceUsage, this.lambdaLevel, this.forcedExpressionMode);
    }

    public void processUsagesFlownDownTo(@NotNull PsiElement element3, @NotNull Processor<SliceUsage> uniqueProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull(uniqueProcessor, (String)"uniqueProcessor");
        PsiElement psiElement2 = element3;
        if (!(psiElement2 instanceof KtExpression)) {
            psiElement2 = null;
        }
        KtExpression ktExpression = (KtExpression)psiElement2;
        if (ktExpression == null) {
            return;
        }
        new InflowSlicer(ktExpression, uniqueProcessor, this).processChildren();
    }

    public void processUsagesFlownFromThe(@NotNull PsiElement element3, @NotNull Processor<SliceUsage> uniqueProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull(uniqueProcessor, (String)"uniqueProcessor");
        PsiElement psiElement2 = element3;
        if (!(psiElement2 instanceof KtExpression)) {
            psiElement2 = null;
        }
        KtExpression ktExpression = (KtExpression)psiElement2;
        if (ktExpression == null) {
            return;
        }
        new OutflowSlicer(ktExpression, uniqueProcessor, this).processChildren();
    }

    public KotlinSliceUsage(@NotNull PsiElement element3, @NotNull SliceUsage parent2, int lambdaLevel, boolean forcedExpressionMode) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
        super(element3, parent2);
        this.lambdaLevel = lambdaLevel;
        this.forcedExpressionMode = forcedExpressionMode;
    }

    public KotlinSliceUsage(@NotNull PsiElement element3, @NotNull SliceAnalysisParams params2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)params2, (String)"params");
        super(element3, params2);
        this.lambdaLevel = 0;
        this.forcedExpressionMode = false;
    }
}

