/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsClassModel;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsGlobalBlock;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModule;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameBinding;
import org.jetbrains.kotlin.js.backend.ast.JsScope;

public class JsProgramFragment {
    private final JsScope scope;
    private final List<JsImportedModule> importedModules;
    private final Map<String, JsExpression> imports;
    private final JsGlobalBlock declarationBlock;
    private final JsGlobalBlock exportBlock;
    private final JsGlobalBlock initializerBlock;
    private final List<JsNameBinding> nameBindings;
    private final Map<JsName, JsClassModel> classes;
    private final Map<String, JsExpression> inlineModuleMap;

    public JsProgramFragment(@NotNull JsScope scope2) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/js/backend/ast/JsProgramFragment", "<init>"));
        }
        this.importedModules = new ArrayList<JsImportedModule>();
        this.imports = new LinkedHashMap<String, JsExpression>();
        this.declarationBlock = new JsGlobalBlock();
        this.exportBlock = new JsGlobalBlock();
        this.initializerBlock = new JsGlobalBlock();
        this.nameBindings = new ArrayList<JsNameBinding>();
        this.classes = new LinkedHashMap<JsName, JsClassModel>();
        this.inlineModuleMap = new LinkedHashMap<String, JsExpression>();
        this.scope = scope2;
    }

    @NotNull
    public JsScope getScope() {
        JsScope jsScope = this.scope;
        if (jsScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsProgramFragment", "getScope"));
        }
        return jsScope;
    }

    @NotNull
    public List<JsImportedModule> getImportedModules() {
        List<JsImportedModule> list2 = this.importedModules;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsProgramFragment", "getImportedModules"));
        }
        return list2;
    }

    @NotNull
    public Map<String, JsExpression> getImports() {
        Map<String, JsExpression> map2 = this.imports;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsProgramFragment", "getImports"));
        }
        return map2;
    }

    @NotNull
    public JsGlobalBlock getDeclarationBlock() {
        JsGlobalBlock jsGlobalBlock = this.declarationBlock;
        if (jsGlobalBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsProgramFragment", "getDeclarationBlock"));
        }
        return jsGlobalBlock;
    }

    @NotNull
    public JsGlobalBlock getExportBlock() {
        JsGlobalBlock jsGlobalBlock = this.exportBlock;
        if (jsGlobalBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsProgramFragment", "getExportBlock"));
        }
        return jsGlobalBlock;
    }

    @NotNull
    public JsGlobalBlock getInitializerBlock() {
        JsGlobalBlock jsGlobalBlock = this.initializerBlock;
        if (jsGlobalBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsProgramFragment", "getInitializerBlock"));
        }
        return jsGlobalBlock;
    }

    @NotNull
    public List<JsNameBinding> getNameBindings() {
        List<JsNameBinding> list2 = this.nameBindings;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsProgramFragment", "getNameBindings"));
        }
        return list2;
    }

    @NotNull
    public Map<JsName, JsClassModel> getClasses() {
        Map<JsName, JsClassModel> map2 = this.classes;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsProgramFragment", "getClasses"));
        }
        return map2;
    }

    @NotNull
    public Map<String, JsExpression> getInlineModuleMap() {
        Map<String, JsExpression> map2 = this.inlineModuleMap;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsProgramFragment", "getInlineModuleMap"));
        }
        return map2;
    }
}

