/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclarationUtil;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinStubWithFqName;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

abstract class KtNamedDeclarationStub<T extends KotlinStubWithFqName<?>>
extends KtDeclarationStub<T>
implements KtNamedDeclaration {
    public KtNamedDeclarationStub(@NotNull T stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/KtNamedDeclarationStub", "<init>"));
        }
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "org/jetbrains/kotlin/psi/KtNamedDeclarationStub", "<init>"));
        }
        super(stub, nodeType);
    }

    public KtNamedDeclarationStub(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtNamedDeclarationStub", "<init>"));
        }
        super(node);
    }

    public String getName() {
        KotlinStubWithFqName stub = (KotlinStubWithFqName)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        PsiElement identifier2 = this.getNameIdentifier();
        if (identifier2 != null) {
            String text2 = identifier2.getText();
            return text2 != null ? KtPsiUtil.unquoteIdentifier(text2) : null;
        }
        return null;
    }

    @Override
    public Name getNameAsName() {
        String name2 = this.getName();
        return name2 != null ? Name.identifier(name2) : null;
    }

    @Override
    @NotNull
    public Name getNameAsSafeName() {
        Name name2 = KtPsiUtil.safeName(this.getName());
        if (name2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtNamedDeclarationStub", "getNameAsSafeName"));
        }
        return name2;
    }

    public PsiElement getNameIdentifier() {
        return this.findChildByType(KtTokens.IDENTIFIER);
    }

    public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
        PsiElement newIdentifier;
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/psi/KtNamedDeclarationStub", "setName"));
        }
        PsiElement identifier2 = this.getNameIdentifier();
        if (identifier2 == null) {
            return null;
        }
        KtModifierList modifierList = this.getModifierList();
        if (modifierList != null && modifierList.hasModifier(KtTokens.OPERATOR_KEYWORD) && !OperatorConventions.isConventionName(Name.identifier(name2))) {
            this.removeModifier(KtTokens.OPERATOR_KEYWORD);
        }
        if ((newIdentifier = KtPsiFactoryKt.KtPsiFactory(this).createNameIdentifierIfPossible(name2)) != null) {
            identifier2.replace(newIdentifier);
        } else {
            identifier2.delete();
        }
        return this;
    }

    public int getTextOffset() {
        PsiElement identifier2 = this.getNameIdentifier();
        return identifier2 != null ? identifier2.getTextRange().getStartOffset() : this.getTextRange().getStartOffset();
    }

    @NotNull
    public SearchScope getUseScope() {
        KtElement enclosingBlock = KtPsiUtil.getEnclosingElementForLocalDeclaration(this, false);
        if (enclosingBlock != null) {
            KtExpression condition2;
            PsiElement enclosingParent = enclosingBlock.getParent();
            if (enclosingParent instanceof KtContainerNode) {
                enclosingParent = enclosingParent.getParent();
            }
            if (enclosingBlock instanceof KtBlockExpression && enclosingParent instanceof KtDoWhileExpression && (condition2 = ((KtDoWhileExpression)enclosingParent).getCondition()) != null) {
                LocalSearchScope localSearchScope = new LocalSearchScope(new PsiElement[]{enclosingBlock, condition2});
                if (localSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtNamedDeclarationStub", "getUseScope"));
                }
                return localSearchScope;
            }
            LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)enclosingBlock);
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtNamedDeclarationStub", "getUseScope"));
            }
            return localSearchScope;
        }
        if (this.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
            KtElement companionObjectClass;
            KtElement containingClass = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)this, KtClassOrObject.class);
            if (containingClass instanceof KtObjectDeclaration && ((KtObjectDeclaration)containingClass).isCompanion() && (companionObjectClass = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)containingClass, KtClassOrObject.class)) != null) {
                containingClass = companionObjectClass;
            }
            if (containingClass != null) {
                LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)containingClass);
                if (localSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtNamedDeclarationStub", "getUseScope"));
                }
                return localSearchScope;
            }
        }
        SearchScope scope2 = super.getUseScope();
        KtClassOrObject classOrObject = KtPsiUtilKt.getContainingClassOrObject(this);
        if (classOrObject != null) {
            scope2 = scope2.intersectWith(classOrObject.getUseScope());
        }
        SearchScope searchScope2 = scope2;
        if (searchScope2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtNamedDeclarationStub", "getUseScope"));
        }
        return searchScope2;
    }

    @Override
    @Nullable
    public FqName getFqName() {
        KotlinStubWithFqName stub = (KotlinStubWithFqName)this.getStub();
        if (stub != null) {
            return stub.getFqName();
        }
        return KtNamedDeclarationUtil.getFQName(this);
    }

    @Override
    public void delete() throws IncorrectOperationException {
        KtClassOrObject classOrObject = KtPsiUtilKt.getContainingClassOrObject(this);
        super.delete();
        if (classOrObject instanceof KtObjectDeclaration && ((KtObjectDeclaration)classOrObject).isCompanion() && classOrObject.getDeclarations().isEmpty()) {
            classOrObject.delete();
        }
    }
}

