/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0012J$\u0010\u001d\u001a\u00020\u00102\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u001f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010 \u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010!\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\"\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010#\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u0006H\u0002J\u000e\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u0004J\u0010\u0010'\u001a\u00020(2\u0006\u0010$\u001a\u00020\u0004H\u0002J\u000e\u0010'\u001a\u00020(2\u0006\u0010$\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/resolve/DataClassDescriptorResolver;", "", "()V", "COMPONENT_FUNCTION_NAME_PREFIX", "", "COPY_METHOD_NAME", "Lorg/jetbrains/kotlin/name/Name;", "getCOPY_METHOD_NAME", "()Lorg/jetbrains/kotlin/name/Name;", "EQUALS_METHOD_NAME", "getEQUALS_METHOD_NAME", "HASH_CODE_METHOD_NAME", "getHASH_CODE_METHOD_NAME", "TO_STRING_METHOD_NAME", "getTO_STRING_METHOD_NAME", "createComponentFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "parameterIndex", "", "property", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "createComponentName", "index", "createCopyFunctionDescriptor", "constructorParameters", "", "createEqualsFunctionDescriptor", "createHashCodeFunctionDescriptor", "createToStringFunctionDescriptor", "doCreateFunctionFromAny", "name", "getComponentIndex", "componentName", "isComponentLike", "", "frontend"})
public final class DataClassDescriptorResolver {
    @NotNull
    private static final Name EQUALS_METHOD_NAME;
    @NotNull
    private static final Name HASH_CODE_METHOD_NAME;
    @NotNull
    private static final Name TO_STRING_METHOD_NAME;
    @NotNull
    private static final Name COPY_METHOD_NAME;
    private static final String COMPONENT_FUNCTION_NAME_PREFIX = "component";
    public static final DataClassDescriptorResolver INSTANCE;

    @NotNull
    public final Name getEQUALS_METHOD_NAME() {
        return EQUALS_METHOD_NAME;
    }

    @NotNull
    public final Name getHASH_CODE_METHOD_NAME() {
        return HASH_CODE_METHOD_NAME;
    }

    @NotNull
    public final Name getTO_STRING_METHOD_NAME() {
        return TO_STRING_METHOD_NAME;
    }

    @NotNull
    public final Name getCOPY_METHOD_NAME() {
        return COPY_METHOD_NAME;
    }

    @NotNull
    public final Name createComponentName(int index2) {
        Name name2 = Name.identifier(COMPONENT_FUNCTION_NAME_PREFIX + index2);
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(COMPONEN\u2026TION_NAME_PREFIX + index)");
        return name2;
    }

    public final int getComponentIndex(@NotNull String componentName) {
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        String string = componentName;
        int n = COMPONENT_FUNCTION_NAME_PREFIX.length();
        String string2 = string.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        string = string2;
        return Integer.parseInt(string);
    }

    public final boolean isComponentLike(@NotNull Name name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        String string = name2.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name.asString()");
        return this.isComponentLike(string);
    }

    private final boolean isComponentLike(String name2) {
        if (!StringsKt.startsWith$default((String)name2, (String)COMPONENT_FUNCTION_NAME_PREFIX, (boolean)false, (int)2, null)) {
            return false;
        }
        try {
            this.getComponentIndex(name2);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @NotNull
    public final SimpleFunctionDescriptor createEqualsFunctionDescriptor(@NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)classDescriptor, (String)"classDescriptor");
        return this.doCreateFunctionFromAny(classDescriptor, EQUALS_METHOD_NAME);
    }

    @NotNull
    public final SimpleFunctionDescriptor createHashCodeFunctionDescriptor(@NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)classDescriptor, (String)"classDescriptor");
        Name name2 = HASH_CODE_METHOD_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"HASH_CODE_METHOD_NAME");
        return this.doCreateFunctionFromAny(classDescriptor, name2);
    }

    @NotNull
    public final SimpleFunctionDescriptor createToStringFunctionDescriptor(@NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)classDescriptor, (String)"classDescriptor");
        Name name2 = TO_STRING_METHOD_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"TO_STRING_METHOD_NAME");
        return this.doCreateFunctionFromAny(classDescriptor, name2);
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleFunctionDescriptor doCreateFunctionFromAny(ClassDescriptor classDescriptor, Name name2) {
        Collection<ValueParameterDescriptor> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        SimpleFunctionDescriptorImpl functionDescriptor2 = SimpleFunctionDescriptorImpl.create(classDescriptor, Annotations.Companion.getEMPTY(), name2, CallableMemberDescriptor.Kind.SYNTHESIZED, classDescriptor.getSource());
        SimpleFunctionDescriptor functionFromAny = (SimpleFunctionDescriptor)CollectionsKt.single((Iterable)DescriptorUtilsKt.getBuiltIns(classDescriptor).getAny().getMemberScope(CollectionsKt.emptyList()).getContributedFunctions(name2, NoLookupLocation.FROM_BUILTINS));
        Iterable iterable = functionFromAny.getValueParameters();
        List<TypeParameterDescriptor> list2 = functionFromAny.getTypeParameters();
        ReceiverParameterDescriptor receiverParameterDescriptor = classDescriptor.getThisAsReceiverParameter();
        KotlinType kotlinType = null;
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor2;
        void var6_10 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl2 = functionDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleFunctionDescriptorImpl2, (String)"functionDescriptor");
            CallableDescriptor callableDescriptor = simpleFunctionDescriptorImpl2;
            Name name3 = it.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"it.name");
            ValueParameterDescriptor valueParameterDescriptor2 = it.copy(callableDescriptor, name3, it.getIndex());
            collection.add(valueParameterDescriptor2);
        }
        collection = (List)destination$iv$iv;
        simpleFunctionDescriptorImpl.initialize(kotlinType, receiverParameterDescriptor, list2, (List)collection, functionFromAny.getReturnType(), Modality.OPEN, Visibilities.PUBLIC);
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl3 = functionDescriptor2;
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleFunctionDescriptorImpl3, (String)"functionDescriptor");
        return simpleFunctionDescriptorImpl3;
    }

    @NotNull
    public final SimpleFunctionDescriptor createComponentFunctionDescriptor(int parameterIndex2, @NotNull PropertyDescriptor property2, @NotNull ValueParameterDescriptor parameter, @NotNull ClassDescriptor classDescriptor, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        Intrinsics.checkParameterIsNotNull((Object)classDescriptor, (String)"classDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        SimpleFunctionDescriptorImpl functionDescriptor2 = SimpleFunctionDescriptorImpl.create(classDescriptor, Annotations.Companion.getEMPTY(), this.createComponentName(parameterIndex2), CallableMemberDescriptor.Kind.SYNTHESIZED, parameter.getSource());
        functionDescriptor2.initialize((KotlinType)null, classDescriptor.getThisAsReceiverParameter(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), property2.getType(), Modality.FINAL, property2.getVisibility());
        functionDescriptor2.setOperator(true);
        trace.record(BindingContext.DATA_CLASS_COMPONENT_FUNCTION, parameter, functionDescriptor2);
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor2;
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleFunctionDescriptorImpl, (String)"functionDescriptor");
        return simpleFunctionDescriptorImpl;
    }

    @NotNull
    public final SimpleFunctionDescriptor createCopyFunctionDescriptor(@NotNull Collection<? extends ValueParameterDescriptor> constructorParameters, @NotNull ClassDescriptor classDescriptor, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(constructorParameters, (String)"constructorParameters");
        Intrinsics.checkParameterIsNotNull((Object)classDescriptor, (String)"classDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        SimpleFunctionDescriptorImpl functionDescriptor2 = SimpleFunctionDescriptorImpl.create(classDescriptor, Annotations.Companion.getEMPTY(), COPY_METHOD_NAME, CallableMemberDescriptor.Kind.SYNTHESIZED, classDescriptor.getSource());
        ArrayList<ValueParameterDescriptorImpl> parameterDescriptors = new ArrayList<ValueParameterDescriptorImpl>();
        for (ValueParameterDescriptor valueParameterDescriptor : constructorParameters) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)trace.getBindingContext().get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, valueParameterDescriptor);
            boolean declaresDefaultValue = propertyDescriptor != null;
            SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleFunctionDescriptorImpl, (String)"functionDescriptor");
            CallableDescriptor callableDescriptor = simpleFunctionDescriptorImpl;
            int n = valueParameterDescriptor.getIndex();
            Annotations annotations2 = valueParameterDescriptor.getAnnotations();
            Name name2 = valueParameterDescriptor.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"parameter.name");
            KotlinType kotlinType = valueParameterDescriptor.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"parameter.type");
            boolean bl = valueParameterDescriptor.isCrossinline();
            boolean bl2 = valueParameterDescriptor.isNoinline();
            KotlinType kotlinType2 = valueParameterDescriptor.getVarargElementType();
            SourceElement sourceElement = valueParameterDescriptor.getSource();
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"parameter.source");
            ValueParameterDescriptorImpl parameterDescriptor = new ValueParameterDescriptorImpl(callableDescriptor, null, n, annotations2, name2, kotlinType, declaresDefaultValue, bl, bl2, kotlinType2, sourceElement);
            parameterDescriptors.add(parameterDescriptor);
            if (!declaresDefaultValue) continue;
            trace.record(BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameterDescriptor, propertyDescriptor);
        }
        functionDescriptor2.initialize((KotlinType)null, classDescriptor.getThisAsReceiverParameter(), CollectionsKt.emptyList(), parameterDescriptors, (KotlinType)classDescriptor.getDefaultType(), Modality.FINAL, Visibilities.PUBLIC);
        trace.record(BindingContext.DATA_CLASS_COPY_FUNCTION, classDescriptor, functionDescriptor2);
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor2;
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleFunctionDescriptorImpl, (String)"functionDescriptor");
        return simpleFunctionDescriptorImpl;
    }

    private DataClassDescriptorResolver() {
        INSTANCE = this;
        EQUALS_METHOD_NAME = OperatorNameConventions.EQUALS;
        HASH_CODE_METHOD_NAME = Name.identifier("hashCode");
        TO_STRING_METHOD_NAME = Name.identifier("toString");
        COPY_METHOD_NAME = Name.identifier("copy");
        COMPONENT_FUNCTION_NAME_PREFIX = COMPONENT_FUNCTION_NAME_PREFIX;
    }

    static {
        new DataClassDescriptorResolver();
    }
}

