/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.resolve.BindingTrace;

public class PlatformClassesMappedToKotlinChecker {
    public static void checkPlatformClassesMappedToKotlin(@NotNull PlatformToKotlinClassMap platformToKotlinMap, @NotNull BindingTrace trace, @NotNull KtImportDirective importDirective, @NotNull Collection<? extends DeclarationDescriptor> descriptors2) {
        if (platformToKotlinMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformToKotlinMap", "org/jetbrains/kotlin/resolve/PlatformClassesMappedToKotlinChecker", "checkPlatformClassesMappedToKotlin"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/PlatformClassesMappedToKotlinChecker", "checkPlatformClassesMappedToKotlin"));
        }
        if (importDirective == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importDirective", "org/jetbrains/kotlin/resolve/PlatformClassesMappedToKotlinChecker", "checkPlatformClassesMappedToKotlin"));
        }
        if (descriptors2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/kotlin/resolve/PlatformClassesMappedToKotlinChecker", "checkPlatformClassesMappedToKotlin"));
        }
        KtExpression importedReference = importDirective.getImportedReference();
        if (importedReference != null) {
            for (DeclarationDescriptor declarationDescriptor : descriptors2) {
                PlatformClassesMappedToKotlinChecker.reportPlatformClassMappedToKotlin(platformToKotlinMap, trace, importedReference, declarationDescriptor);
            }
        }
    }

    public static void reportPlatformClassMappedToKotlin(@NotNull PlatformToKotlinClassMap platformToKotlinMap, @NotNull BindingTrace trace, @NotNull KtElement element3, @NotNull DeclarationDescriptor descriptor2) {
        if (platformToKotlinMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformToKotlinMap", "org/jetbrains/kotlin/resolve/PlatformClassesMappedToKotlinChecker", "reportPlatformClassMappedToKotlin"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/PlatformClassesMappedToKotlinChecker", "reportPlatformClassMappedToKotlin"));
        }
        if (element3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/resolve/PlatformClassesMappedToKotlinChecker", "reportPlatformClassMappedToKotlin"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/PlatformClassesMappedToKotlinChecker", "reportPlatformClassMappedToKotlin"));
        }
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return;
        }
        Collection<ClassDescriptor> kotlinAnalogsForClass = platformToKotlinMap.mapPlatformClass((ClassDescriptor)descriptor2);
        if (!kotlinAnalogsForClass.isEmpty()) {
            trace.report(Errors.PLATFORM_CLASS_MAPPED_TO_KOTLIN.on(element3, kotlinAnalogsForClass));
        }
    }
}

