/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B!\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0015\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "resolutionContext", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "(Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "getDataFlowInfo", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "isAnnotationContext", "", "()Z", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getResolutionContext", "()Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "getScope", "()Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "getTrace", "()Lorg/jetbrains/kotlin/resolve/BindingTrace;", "frontend"})
public final class CallCheckerContext {
    @NotNull
    private final ResolutionContext<?> resolutionContext;
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    @NotNull
    public final LexicalScope getScope() {
        LexicalScope lexicalScope = this.resolutionContext.scope;
        Intrinsics.checkExpressionValueIsNotNull((Object)lexicalScope, (String)"resolutionContext.scope");
        return lexicalScope;
    }

    @NotNull
    public final DataFlowInfo getDataFlowInfo() {
        DataFlowInfo dataFlowInfo = this.resolutionContext.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"resolutionContext.dataFlowInfo");
        return dataFlowInfo;
    }

    public final boolean isAnnotationContext() {
        return this.resolutionContext.isAnnotationContext;
    }

    @NotNull
    public final ResolutionContext<?> getResolutionContext() {
        return this.resolutionContext;
    }

    @NotNull
    public final BindingTrace getTrace() {
        return this.trace;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    public CallCheckerContext(@NotNull ResolutionContext<?> resolutionContext, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull(resolutionContext, (String)"resolutionContext");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.resolutionContext = resolutionContext;
        this.trace = trace;
        this.languageVersionSettings = languageVersionSettings;
    }

    public CallCheckerContext(@NotNull ResolutionContext<?> c, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull(c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        BindingTrace bindingTrace = c.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"c.trace");
        this(c, bindingTrace, languageVersionSettings);
    }
}

