/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.HeaderImplDeclarationChecker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScopeKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.TypeCheckerContext;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002LMB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J0\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\rH\u0002J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\u0017H\u0002J0\u0010\u0018\u001a\u00020\t2\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u00192\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u00192\u0006\u0010\n\u001a\u00020\u000bH\u0002J4\u0010\u001b\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00192\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00192\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\rH\u0002J$\u0010\u001d\u001a\u00020\t2\b\u0010\u0005\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0007\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\n\u001a\u00020\u000bH\u0002J0\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J.\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020!2\u0006\u0010\"\u001a\u00020,2\u0006\u0010$\u001a\u00020%2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ(\u0010-\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020!2\u0006\u0010\"\u001a\u00020,2\u0006\u0010$\u001a\u00020%2\u0006\u0010\b\u001a\u00020\tH\u0002J>\u0010.\u001a\u00020\t\"\u0004\b\u0000\u0010/\"\u0004\b\u0001\u001002\u0006\u00101\u001a\u0002H/2\u0006\u00102\u001a\u0002H/2\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u0002H/\u0012\u0004\u0012\u0002H004H\u0082\b\u00a2\u0006\u0002\u00105JE\u00106\u001a\u00020\t\"\u0004\b\u0000\u0010/\"\u0004\b\u0001\u001002\f\u00101\u001a\b\u0012\u0004\u0012\u0002H/0\u00192\f\u00102\u001a\b\u0012\u0004\u0012\u0002H/0\u00192\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u0002H/\u0012\u0004\u0012\u0002H004H\u0082\bJ,\u00107\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0\u0019\u0018\u0001082\u0006\u00109\u001a\u00020,2\u0006\u0010:\u001a\u00020\u000bH\u0002J4\u0010;\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0\u0019\u0018\u0001082\u0006\u0010<\u001a\u00020,2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010=\u001a\u00020\t2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020?2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010A\u001a\b\u0012\u0004\u0012\u00020C0B*\u00020C2\u0006\u0010D\u001a\u00020\u000bH\u0002J\u0018\u0010E\u001a\b\u0012\u0004\u0012\u00020,0\u0019*\u00020,2\u0006\u0010:\u001a\u00020\u000bJ\u0018\u0010F\u001a\b\u0012\u0004\u0012\u00020,0\u0019*\u00020,2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00060B*\u00020\u00062\u0006\u0010D\u001a\u00020\u000bH\u0002J\u001e\u0010H\u001a\b\u0012\u0004\u0012\u00020,0B*\u00020\u000f2\n\b\u0002\u0010I\u001a\u0004\u0018\u00010JH\u0002J\f\u0010K\u001a\u00020\t*\u00020,H\u0002\u00a8\u0006N"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "areCompatibleCallables", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility;", "a", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "b", "checkImpl", "", "platformModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "parentSubstitutor", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Substitutor;", "areCompatibleClassScopes", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "substitutor", "areCompatibleClassifiers", "other", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "areCompatibleFunctions", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "areCompatibleProperties", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "areCompatibleTypeLists", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "areCompatibleTypeParameters", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "areCompatibleTypes", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkHeaderDeclarationHasImplementation", "reportOn", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "checkImplementationHasHeaderDeclaration", "equalBy", "T", "K", "first", "second", "selector", "Lkotlin/Function1;", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Z", "equalsBy", "findHeaderForImpl", "", "impl", "commonModule", "findImplForHeader", "header", "isHeaderClassAndImplTypeAlias", "headerTypeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "implTypeConstructor", "findClassifiersFromModule", "", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;", "module", "findCompatibleHeaderForImpl", "findCompatibleImplForHeader", "findNamesakesFromModule", "getMembers", "name", "Lorg/jetbrains/kotlin/name/Name;", "isExplicitImplDeclaration", "Compatibility", "Substitutor", "frontend"})
public final class HeaderImplDeclarationChecker
implements DeclarationChecker {
    public static final HeaderImplDeclarationChecker INSTANCE;

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2, @NotNull LanguageVersionSettings languageVersionSettings) {
        boolean checkImpl;
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        if (!languageVersionSettings.supportsFeature(LanguageFeature.MultiPlatformProjects)) {
            return;
        }
        if (!(descriptor2 instanceof MemberDescriptor)) {
            return;
        }
        boolean bl = checkImpl = languageVersionSettings.getFlag(AnalysisFlag.Flags.getMultiPlatformDoNotCheckImpl()) == false;
        if (((MemberDescriptor)descriptor2).isHeader()) {
            this.checkHeaderDeclarationHasImplementation(declaration2, (MemberDescriptor)descriptor2, diagnosticHolder, DescriptorUtilsKt.getModule(descriptor2), checkImpl);
        } else {
            this.checkImplementationHasHeaderDeclaration(declaration2, (MemberDescriptor)descriptor2, diagnosticHolder, checkImpl);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void checkHeaderDeclarationHasImplementation(@NotNull KtDeclaration reportOn, @NotNull MemberDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull ModuleDescriptor platformModule, boolean checkImpl) {
        boolean $receiver$iv2;
        Iterator iterator2;
        Map<Compatibility, List<MemberDescriptor>> compatibility;
        block12: {
            boolean bl;
            Iterable $receiver$iv2;
            Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
            Intrinsics.checkParameterIsNotNull((Object)platformModule, (String)"platformModule");
            if (!(descriptor2.getContainingDeclaration() instanceof PackageFragmentDescriptor)) {
                return;
            }
            Map<Compatibility, List<MemberDescriptor>> map2 = this.findImplForHeader(descriptor2, platformModule, checkImpl);
            if (map2 == null) return;
            compatibility = map2;
            if (!compatibility.isEmpty()) {
                boolean bl2;
                void destination$iv;
                Map<Compatibility, List<MemberDescriptor>> map3;
                Object object = compatibility;
                iterator2 = Compatibility.Compatible.INSTANCE;
                Map<Compatibility, List<MemberDescriptor>> map4 = map3 = object;
                if (map4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
                }
                if (map4.containsKey(iterator2)) return;
                object = compatibility.values();
                iterator2 = new HashSet();
                for (Object element$iv : $receiver$iv2) {
                    List it = (List)element$iv;
                    Iterable list$iv = it;
                    CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                }
                $receiver$iv2 = (Iterable)destination$iv;
                if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object t : $receiver$iv2) {
                        MemberDescriptor impl = (MemberDescriptor)t;
                        Map<Compatibility, List<MemberDescriptor>> headers = INSTANCE.findHeaderForImpl(impl, DescriptorUtilsKt.getModule(descriptor2));
                        if (headers == null) return;
                        if (!headers.keySet().contains(Compatibility.Compatible.INSTANCE)) return;
                        boolean bl3 = true;
                        if (bl3) continue;
                        return;
                    }
                    bl2 = true;
                }
                if (!bl2) return;
            }
            boolean bl4 = true;
            boolean shouldReportError = bl4;
            if (!shouldReportError) return;
            $receiver$iv2 = compatibility.keySet();
            if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                bl = true;
            } else {
                for (Object e : $receiver$iv2) {
                    Compatibility it = (Compatibility)e;
                    if (it instanceof Compatibility.Incompatible) continue;
                    bl = false;
                    break block12;
                }
                bl = $receiver$iv2 = true;
            }
        }
        if (_Assertions.ENABLED && !$receiver$iv2) {
            iterator2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError(iterator2));
        }
        Map<Compatibility, List<MemberDescriptor>> map5 = compatibility;
        if (map5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<org.jetbrains.kotlin.resolve.checkers.HeaderImplDeclarationChecker.Compatibility.Incompatible, kotlin.collections.Collection<org.jetbrains.kotlin.descriptors.MemberDescriptor>>");
        }
        Map<Compatibility, List<MemberDescriptor>> incompatibility = map5;
        diagnosticHolder.report(Errors.HEADER_WITHOUT_IMPLEMENTATION.on((KtDeclaration)((PsiElement)reportOn), descriptor2, platformModule, incompatibility));
    }

    private final Map<Compatibility, List<MemberDescriptor>> findImplForHeader(MemberDescriptor header, ModuleDescriptor platformModule, boolean checkImpl) {
        Object object;
        MemberDescriptor memberDescriptor = header;
        if (memberDescriptor instanceof CallableMemberDescriptor) {
            CallableMemberDescriptor impl;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)this.findNamesakesFromModule((CallableMemberDescriptor)header, platformModule);
            Object destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                impl = (CallableMemberDescriptor)element$iv$iv;
                if (!(Intrinsics.areEqual((Object)header, (Object)impl) ^ true && !impl.isHeader() && DescriptorToSourceUtils.getSourceFromDescriptor(impl) instanceof KtElement)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new LinkedHashMap();
            Iterator iterator2 = $receiver$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object object2;
                Object element$iv$iv;
                Object $receiver$iv$iv$iv = destination$iv$iv;
                element$iv$iv = iterator2.next();
                impl = (CallableMemberDescriptor)element$iv$iv;
                Compatibility key$iv$iv = HeaderImplDeclarationChecker.areCompatibleCallables$default(INSTANCE, (CallableMemberDescriptor)header, impl, checkImpl, null, null, 24, null);
                Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            object = destination$iv$iv;
        } else if (memberDescriptor instanceof ClassDescriptor) {
            ClassifierDescriptorWithTypeParameters impl;
            Iterable $receiver$iv;
            Iterable $receiver$iv$iv = $receiver$iv = (Iterable)this.findClassifiersFromModule((ClassifierDescriptorWithTypeParameters)header, platformModule);
            Object destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                impl = (ClassifierDescriptorWithTypeParameters)element$iv$iv;
                if (!(Intrinsics.areEqual((Object)header, (Object)impl) ^ true && !impl.isHeader() && DescriptorToSourceUtils.getSourceFromDescriptor(impl) instanceof KtElement)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new LinkedHashMap();
            Iterator iterator3 = $receiver$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Object object3;
                Object element$iv$iv;
                Object $receiver$iv$iv$iv = destination$iv$iv;
                element$iv$iv = iterator3.next();
                impl = (ClassifierDescriptorWithTypeParameters)element$iv$iv;
                Compatibility key$iv$iv = INSTANCE.areCompatibleClassifiers((ClassDescriptor)header, impl, checkImpl);
                Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object3;
                list$iv$iv.add(element$iv$iv);
            }
            object = destination$iv$iv;
        } else {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkImplementationHasHeaderDeclaration(KtDeclaration reportOn, MemberDescriptor descriptor2, DiagnosticSink diagnosticHolder, boolean checkImpl) {
        Map<Compatibility, List<MemberDescriptor>> compatibility;
        block25: {
            block26: {
                block27: {
                    Map<Compatibility, List<MemberDescriptor>> map2;
                    Map<Compatibility, List<MemberDescriptor>> map3 = this.findHeaderForImpl(descriptor2, DescriptorUtilsKt.getModule(descriptor2));
                    if (map3 == null) {
                        return;
                    }
                    compatibility = map3;
                    if (descriptor2.isImpl() && reportOn.hasModifier(KtTokens.IMPL_KEYWORD)) break block25;
                    if (!checkImpl) break block26;
                    Map<Compatibility, List<MemberDescriptor>> map4 = compatibility;
                    Compatibility compatibility2 = Compatibility.Compatible.INSTANCE;
                    Map<Compatibility, List<MemberDescriptor>> map5 = map2 = map4;
                    if (map5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
                    }
                    if (map5.containsKey(compatibility2)) break block27;
                    map4 = compatibility;
                    compatibility2 = Compatibility.Incompatible.NoImpl.INSTANCE;
                    Map<Compatibility, List<MemberDescriptor>> map6 = map2 = map4;
                    if (map6 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
                    }
                    if (!map6.containsKey(compatibility2)) break block26;
                }
                diagnosticHolder.report(Errors.IMPL_MISSING.on((KtDeclaration)((PsiElement)reportOn)));
            }
            return;
        }
        Compatibility singleIncompatibility = (Compatibility)CollectionsKt.firstOrNull((Iterable)compatibility.keySet());
        if (singleIncompatibility instanceof Compatibility.Incompatible.ClassScopes) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            boolean bl;
            boolean bl2 = bl = descriptor2 instanceof ClassDescriptor || descriptor2 instanceof TypeAliasDescriptor;
            if (_Assertions.ENABLED && !bl) {
                String string = "Incompatible.ClassScopes is only possible for a class or a typealias: " + descriptor2;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            checkImplementationHasHeaderDeclaration.2 hasSingleImplSuspect$ = checkImplementationHasHeaderDeclaration.2.INSTANCE;
            Iterable iterable = $receiver$iv = (Iterable)((Compatibility.Incompatible.ClassScopes)singleIncompatibility).getUnimplemented();
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Pair p1 = (Pair)element$iv$iv;
                if (checkImplementationHasHeaderDeclaration.2.INSTANCE.invoke((Pair<? extends MemberDescriptor, ? extends Map<Compatibility.Incompatible, ? extends Collection<? extends MemberDescriptor>>>)p1)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List nonTrivialUnimplemented = (List)destination$iv$iv;
            $receiver$iv = nonTrivialUnimplemented;
            if (!$receiver$iv.isEmpty()) {
                ClassDescriptor classDescriptor;
                ClassifierDescriptor classifierDescriptor;
                Object object;
                MemberDescriptor memberDescriptor = descriptor2;
                if (!(memberDescriptor instanceof TypeAliasDescriptor)) {
                    memberDescriptor = null;
                }
                if (!(((object = (TypeAliasDescriptor)memberDescriptor) != null && (object = object.getExpandedType()) != null && (object = ((KotlinType)object).getConstructor()) != null ? object.getDeclarationDescriptor() : (classifierDescriptor = null)) instanceof ClassDescriptor)) {
                    classifierDescriptor = null;
                }
                if ((classDescriptor = (ClassDescriptor)classifierDescriptor) == null) {
                    MemberDescriptor memberDescriptor2 = descriptor2;
                    if (memberDescriptor2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                    }
                    classDescriptor = (ClassDescriptor)memberDescriptor2;
                }
                ClassDescriptor classDescriptor2 = classDescriptor;
                diagnosticHolder.report(Errors.HEADER_CLASS_MEMBERS_ARE_NOT_IMPLEMENTED.on((KtDeclaration)((PsiElement)reportOn), classDescriptor2, nonTrivialUnimplemented));
            }
        } else {
            Map<Compatibility, List<MemberDescriptor>> classDescriptor2;
            Map<Compatibility, List<MemberDescriptor>> hasSingleImplSuspect$ = compatibility;
            Object object = Compatibility.Compatible.INSTANCE;
            Map<Compatibility, List<MemberDescriptor>> map7 = classDescriptor2 = hasSingleImplSuspect$;
            if (map7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
            }
            if (!map7.containsKey(object)) {
                boolean $receiver$iv2;
                block24: {
                    boolean bl;
                    Iterable $receiver$iv2 = compatibility.keySet();
                    if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $receiver$iv2) {
                            Compatibility it = (Compatibility)element$iv;
                            if (it instanceof Compatibility.Incompatible) continue;
                            bl = false;
                            break block24;
                        }
                        bl = $receiver$iv2 = true;
                    }
                }
                if (_Assertions.ENABLED && !$receiver$iv2) {
                    object = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError(object));
                }
                Map<Compatibility, List<MemberDescriptor>> map8 = compatibility;
                if (map8 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<org.jetbrains.kotlin.resolve.checkers.HeaderImplDeclarationChecker.Compatibility.Incompatible, kotlin.collections.Collection<org.jetbrains.kotlin.descriptors.MemberDescriptor>>");
                }
                Map<Compatibility, List<MemberDescriptor>> incompatibility = map8;
                diagnosticHolder.report(Errors.IMPLEMENTATION_WITHOUT_HEADER.on((KtDeclaration)((PsiElement)reportOn), descriptor2, incompatibility));
            }
        }
    }

    private final boolean isExplicitImplDeclaration(@NotNull MemberDescriptor $receiver) {
        MemberDescriptor memberDescriptor = $receiver;
        return memberDescriptor instanceof ConstructorDescriptor ? DescriptorToSourceUtils.getSourceFromDescriptor($receiver) instanceof KtConstructor : (memberDescriptor instanceof CallableMemberDescriptor ? Intrinsics.areEqual((Object)((Object)((CallableMemberDescriptor)$receiver).getKind()), (Object)((Object)CallableMemberDescriptor.Kind.DECLARATION)) : true);
    }

    private final Map<Compatibility, List<MemberDescriptor>> findHeaderForImpl(MemberDescriptor impl, ModuleDescriptor commonModule) {
        Object object;
        MemberDescriptor memberDescriptor = impl;
        if (memberDescriptor instanceof CallableMemberDescriptor) {
            CallableMemberDescriptor declaration2;
            Iterable $receiver$iv$iv;
            Collection collection;
            Collection<MemberDescriptor> headerClass;
            DeclarationDescriptor container2 = ((CallableMemberDescriptor)impl).getContainingDeclaration();
            DeclarationDescriptor declarationDescriptor = container2;
            if (declarationDescriptor instanceof ClassDescriptor) {
                List list2;
                List list3;
                Iterable $receiver$iv;
                Collection<MemberDescriptor> collection2;
                MemberDescriptor memberDescriptor2;
                DeclarationDescriptor declarationDescriptor2 = container2;
                Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor2, (String)"container");
                Map<Compatibility, List<MemberDescriptor>> map2 = this.findHeaderForImpl((MemberDescriptor)declarationDescriptor2, commonModule);
                if (!((map2 != null && (map2 = map2.values()) != null && (map2 = (List)CollectionsKt.firstOrNull((Iterable)((Iterable)((Object)map2)))) != null ? (MemberDescriptor)CollectionsKt.firstOrNull((List)((Object)map2)) : (memberDescriptor2 = null)) instanceof ClassDescriptor)) {
                    memberDescriptor2 = null;
                }
                if ((collection2 = (headerClass = (ClassDescriptor)memberDescriptor2)) != null && (collection2 = this.getMembers((ClassDescriptor)((Object)collection2), ((CallableMemberDescriptor)impl).getName())) != null) {
                    Iterator $receiver$iv$iv2;
                    Iterable iterable = $receiver$iv = (Iterable)collection2;
                    Collection destination$iv$iv = new ArrayList();
                    Iterator iterator2 = $receiver$iv$iv2.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv$iv = iterator2.next();
                        if (!(element$iv$iv instanceof CallableMemberDescriptor)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list3 = (List)destination$iv$iv;
                } else {
                    list3 = null;
                }
                if ((list2 = ($receiver$iv = list3)) == null) {
                    list2 = CollectionsKt.emptyList();
                }
                collection = list2;
            } else if (declarationDescriptor instanceof PackageFragmentDescriptor) {
                collection = this.findNamesakesFromModule((CallableMemberDescriptor)impl, commonModule);
            } else {
                return null;
            }
            Collection candidates2 = collection;
            Iterable $receiver$iv = candidates2;
            headerClass = $receiver$iv;
            Object destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                declaration2 = (CallableMemberDescriptor)element$iv$iv;
                if (!(Intrinsics.areEqual((Object)impl, (Object)declaration2) ^ true && declaration2.isHeader())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new LinkedHashMap();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Object object2;
                Substitutor substitutor3;
                declaration2 = (CallableMemberDescriptor)element$iv$iv;
                if (container2 instanceof ClassDescriptor) {
                    DeclarationDescriptor declarationDescriptor3 = declaration2.getContainingDeclaration();
                    if (declarationDescriptor3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                    }
                    ClassDescriptor headerClass2 = (ClassDescriptor)declarationDescriptor3;
                    List<TypeParameterDescriptor> list4 = headerClass2.getDeclaredTypeParameters();
                    Intrinsics.checkExpressionValueIsNotNull(list4, (String)"headerClass.declaredTypeParameters");
                    List<TypeParameterDescriptor> list5 = ((ClassDescriptor)container2).getDeclaredTypeParameters();
                    Intrinsics.checkExpressionValueIsNotNull(list5, (String)"container.declaredTypeParameters");
                    substitutor3 = new Substitutor(list4, list5, null, 4, null);
                } else {
                    substitutor3 = null;
                }
                Substitutor substitutor4 = substitutor3;
                Compatibility key$iv$iv = HeaderImplDeclarationChecker.areCompatibleCallables$default(INSTANCE, declaration2, (CallableMemberDescriptor)impl, true, null, substitutor4, 8, null);
                Object $receiver$iv$iv$iv = destination$iv$iv;
                Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            object = destination$iv$iv;
        } else if (memberDescriptor instanceof ClassifierDescriptorWithTypeParameters) {
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable candidates2 = $receiver$iv = (Iterable)this.findClassifiersFromModule((ClassifierDescriptorWithTypeParameters)impl, commonModule);
            Object destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                ClassifierDescriptorWithTypeParameters declaration3 = (ClassifierDescriptorWithTypeParameters)element$iv$iv;
                if (!(Intrinsics.areEqual((Object)impl, (Object)declaration3) ^ true && declaration3 instanceof ClassDescriptor && ((ClassDescriptor)declaration3).isHeader())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new LinkedHashMap();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Object object3;
                ClassifierDescriptorWithTypeParameters header;
                ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = header = (ClassifierDescriptorWithTypeParameters)element$iv$iv;
                if (classifierDescriptorWithTypeParameters == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                }
                Object $receiver$iv$iv$iv = destination$iv$iv;
                Compatibility key$iv$iv = INSTANCE.areCompatibleClassifiers((ClassDescriptor)classifierDescriptorWithTypeParameters, (ClassifierDescriptor)((Object)impl), true);
                Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object3;
                list$iv$iv.add(element$iv$iv);
            }
            object = destination$iv$iv;
        } else {
            object = null;
        }
        return object;
    }

    @NotNull
    public final List<MemberDescriptor> findCompatibleImplForHeader(@NotNull MemberDescriptor $receiver, @NotNull ModuleDescriptor platformModule) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)platformModule, (String)"platformModule");
        Map<Compatibility, List<MemberDescriptor>> map2 = this.findImplForHeader($receiver, platformModule, false);
        List list2 = map2 != null ? map2.get(Compatibility.Compatible.INSTANCE) : null;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    @NotNull
    public final List<MemberDescriptor> findCompatibleHeaderForImpl(@NotNull MemberDescriptor $receiver, @NotNull ModuleDescriptor commonModule) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)commonModule, (String)"commonModule");
        Map<Compatibility, List<MemberDescriptor>> map2 = this.findHeaderForImpl($receiver, commonModule);
        List list2 = map2 != null ? map2.get(Compatibility.Compatible.INSTANCE) : null;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    private final Collection<CallableMemberDescriptor> findNamesakesFromModule(@NotNull CallableMemberDescriptor $receiver, ModuleDescriptor module) {
        Collection collection;
        MemberScope it;
        Iterable $receiver$iv$iv;
        Collection destination$iv$iv;
        Iterable $receiver$iv;
        Iterable $receiver$iv2;
        List list2;
        DeclarationDescriptor containingDeclaration = $receiver.getContainingDeclaration();
        DeclarationDescriptor declarationDescriptor = containingDeclaration;
        if (declarationDescriptor instanceof PackageFragmentDescriptor) {
            list2 = CollectionsKt.listOf((Object)module.getPackage(((PackageFragmentDescriptor)containingDeclaration).getFqName()).getMemberScope());
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            Iterable $receiver$iv$iv2;
            Iterable iterable = $receiver$iv2 = (Iterable)this.findClassifiersFromModule((ClassifierDescriptorWithTypeParameters)containingDeclaration, module);
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                if (!(element$iv$iv instanceof ClassDescriptor)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List classes2 = (List)destination$iv$iv2;
            if ($receiver instanceof ConstructorDescriptor) {
                $receiver$iv$iv2 = $receiver$iv2 = (Iterable)classes2;
                destination$iv$iv2 = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv2) {
                    ClassDescriptor it2 = (ClassDescriptor)element$iv$iv;
                    Iterable list$iv$iv = it2.getConstructors();
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                return (List)destination$iv$iv2;
            }
            $receiver$iv$iv2 = $receiver$iv2 = (Iterable)classes2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                ClassDescriptor it2 = (ClassDescriptor)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                MemberScope memberScope2 = it2.getUnsubstitutedMemberScope();
                collection2.add(memberScope2);
            }
            list2 = (List)destination$iv$iv2;
        } else {
            return CollectionsKt.emptyList();
        }
        List scopes = list2;
        declarationDescriptor = $receiver;
        if (declarationDescriptor instanceof FunctionDescriptor) {
            $receiver$iv2 = $receiver$iv = (Iterable)scopes;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (MemberScope)element$iv$iv;
                Name name2 = ((FunctionDescriptor)$receiver).getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"name");
                Iterable list$iv$iv = it.getContributedFunctions(name2, NoLookupLocation.FOR_ALREADY_TRACKED);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else if (declarationDescriptor instanceof PropertyDescriptor) {
            $receiver$iv$iv = $receiver$iv = (Iterable)scopes;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (MemberScope)element$iv$iv;
                Name name3 = ((PropertyDescriptor)$receiver).getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"name");
                Iterable list$iv$iv = it.getContributedVariables(name3, NoLookupLocation.FOR_ALREADY_TRACKED);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unsupported declaration: " + $receiver)));
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<ClassifierDescriptorWithTypeParameters> findClassifiersFromModule(@NotNull ClassifierDescriptorWithTypeParameters $receiver, ModuleDescriptor module) {
        ClassId classId = DescriptorUtilsKt.getClassId($receiver);
        if (classId == null) {
            return CollectionsKt.emptyList();
        }
        ClassId classId2 = classId;
        findClassifiersFromModule.1 getAllClassifiers$ = findClassifiersFromModule.1.INSTANCE;
        List<Name> segments = classId2.getRelativeClassName().pathSegments();
        FqName fqName2 = classId2.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"classId.packageFqName");
        MemberScope memberScope2 = module.getPackage(fqName2).getMemberScope();
        Object object = CollectionsKt.first(segments);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"segments.first()");
        Collection classifiers = getAllClassifiers$.invoke(memberScope2, (Name)object);
        for (Name name2 : segments.subList(1, segments.size())) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)classifiers;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters;
                ClassifierDescriptor classifierDescriptor;
                ClassifierDescriptor classifierDescriptor2;
                Object object2;
                Object element$iv$iv = element$iv$iv$iv;
                ClassifierDescriptorWithTypeParameters classifier = (ClassifierDescriptorWithTypeParameters)element$iv$iv;
                ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters2 = classifier;
                if (!(classifierDescriptorWithTypeParameters2 instanceof ClassDescriptor)) {
                    classifierDescriptorWithTypeParameters2 = null;
                }
                if ((object2 = (ClassDescriptor)classifierDescriptorWithTypeParameters2) != null && (object2 = object2.getUnsubstitutedInnerClassesScope()) != null) {
                    Name name3 = name2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"name");
                    classifierDescriptor2 = object2.getContributedClassifier(name3, NoLookupLocation.FOR_ALREADY_TRACKED);
                } else {
                    classifierDescriptor2 = classifierDescriptor = null;
                }
                if (!(classifierDescriptor2 instanceof ClassifierDescriptorWithTypeParameters)) {
                    classifierDescriptor = null;
                }
                if ((ClassifierDescriptorWithTypeParameters)classifierDescriptor == null) continue;
                ClassifierDescriptorWithTypeParameters it$iv$iv = classifierDescriptorWithTypeParameters;
                destination$iv$iv.add(it$iv$iv);
            }
            classifiers = (List)destination$iv$iv;
        }
        return classifiers;
    }

    /*
     * WARNING - void declaration
     */
    private final Compatibility areCompatibleCallables(CallableMemberDescriptor a, CallableMemberDescriptor b, boolean checkImpl, ModuleDescriptor platformModule, Substitutor parentSubstitutor) {
        boolean bl;
        Object it;
        Iterator first$iv;
        Object $receiver$iv;
        Object object;
        List<ValueParameterDescriptor> bParams;
        List<ValueParameterDescriptor> aParams;
        block48: {
            boolean bl2;
            int i$iv;
            Object this_$iv;
            List<DeclarationDescriptorNonRoot> second$iv;
            block47: {
                boolean bl3;
                DeclarationDescriptorNonRoot p1;
                Substitutor substitutor3;
                List<TypeParameterDescriptor> bTypeParams;
                List<TypeParameterDescriptor> aTypeParams;
                block46: {
                    Object object2;
                    List<ValueParameterDescriptor> $receiver$iv$iv;
                    Object object3;
                    block52: {
                        block51: {
                            KotlinType kotlinType;
                            Object object4;
                            ValueParameterDescriptor it2;
                            ReceiverParameterDescriptor bExtensionReceiver;
                            boolean bl4 = Intrinsics.areEqual((Object)a.getName(), (Object)b.getName());
                            if (_Assertions.ENABLED && !bl4) {
                                String string = "This function should be invoked only for declarations with the same name: " + a + ", " + b;
                                throw (Throwable)((Object)new AssertionError((Object)string));
                            }
                            boolean bl5 = bl4 = a.getContainingDeclaration() instanceof ClassDescriptor == b.getContainingDeclaration() instanceof ClassDescriptor;
                            if (_Assertions.ENABLED && !bl4) {
                                String string = "This function should be invoked only for declarations in the same kind of container (both members or both top level): " + a + ", " + b;
                                throw (Throwable)((Object)new AssertionError((Object)string));
                            }
                            ReceiverParameterDescriptor aExtensionReceiver = a.getExtensionReceiverParameter();
                            if (aExtensionReceiver != null != ((bExtensionReceiver = b.getExtensionReceiverParameter()) != null)) {
                                return Compatibility.Incompatible.ParameterShape.INSTANCE;
                            }
                            aParams = a.getValueParameters();
                            bParams = b.getValueParameters();
                            if (aParams.size() != bParams.size()) {
                                return Compatibility.Incompatible.ParameterCount.INSTANCE;
                            }
                            aTypeParams = a.getTypeParameters();
                            bTypeParams = b.getTypeParameters();
                            if (aTypeParams.size() != bTypeParams.size()) {
                                return Compatibility.Incompatible.TypeParameterCount.INSTANCE;
                            }
                            List<TypeParameterDescriptor> list2 = aTypeParams;
                            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"aTypeParams");
                            List<TypeParameterDescriptor> list3 = bTypeParams;
                            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"bTypeParams");
                            substitutor3 = new Substitutor(list2, list3, parentSubstitutor);
                            object = aParams;
                            object3 = this;
                            void var14_20 = $receiver$iv;
                            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                            for (Object t : $receiver$iv$iv) {
                                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)t;
                                object2 = destination$iv$iv;
                                object4 = substitutor3.invoke(it2.getType());
                                object2.add(object4);
                            }
                            object2 = (List)destination$iv$iv;
                            $receiver$iv = bParams;
                            $receiver$iv$iv = $receiver$iv;
                            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                            for (Object t : $receiver$iv$iv) {
                                void it3;
                                it2 = (ValueParameterDescriptor)t;
                                object4 = destination$iv$iv;
                                KotlinType kotlinType2 = it3.getType();
                                object4.add(kotlinType2);
                            }
                            object4 = (List)destination$iv$iv;
                            if (!((HeaderImplDeclarationChecker)object3).areCompatibleTypeLists((List<? extends KotlinType>)object2, (List<? extends KotlinType>)object4, platformModule)) break block51;
                            HeaderImplDeclarationChecker headerImplDeclarationChecker = this;
                            Annotated annotated = aExtensionReceiver;
                            if (annotated != null && (annotated = annotated.getType()) != null) {
                                $receiver$iv = annotated;
                                object3 = headerImplDeclarationChecker;
                                object2 = ((Function1)substitutor3).invoke($receiver$iv);
                                headerImplDeclarationChecker = object3;
                                kotlinType = (KotlinType)object2;
                            } else {
                                kotlinType = null;
                            }
                            ReceiverParameterDescriptor receiverParameterDescriptor = bExtensionReceiver;
                            if (headerImplDeclarationChecker.areCompatibleTypes(kotlinType, receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null, platformModule)) break block52;
                        }
                        return Compatibility.Incompatible.ParameterTypes.INSTANCE;
                    }
                    if (!this.areCompatibleTypes(substitutor3.invoke(a.getReturnType()), b.getReturnType(), platformModule)) {
                        return Compatibility.Incompatible.ReturnType.INSTANCE;
                    }
                    if (b.hasStableParameterNames()) {
                        boolean bl6;
                        block45: {
                            $receiver$iv = this;
                            List<ValueParameterDescriptor> list4 = aParams;
                            Intrinsics.checkExpressionValueIsNotNull(list4, (String)"aParams");
                            $receiver$iv$iv = list4;
                            List<ValueParameterDescriptor> list5 = bParams;
                            Intrinsics.checkExpressionValueIsNotNull(list5, (String)"bParams");
                            second$iv = list5;
                            int n = 0;
                            int n2 = ((Collection)((Object)first$iv)).size();
                            while (n < n2) {
                                void i$iv2;
                                p1 = (ValueParameterDescriptor)((Object)first$iv.get((int)i$iv2));
                                object3 = p1.getName();
                                if (Intrinsics.areEqual((Object)object3, (Object)(object2 = (p1 = (ValueParameterDescriptor)second$iv.get((int)i$iv2)).getName())) ^ true) {
                                    bl6 = false;
                                    break block45;
                                }
                                ++i$iv2;
                            }
                            bl6 = true;
                        }
                        if (!bl6) {
                            return Compatibility.Incompatible.ParameterNames.INSTANCE;
                        }
                    }
                    this_$iv = this;
                    first$iv = aTypeParams;
                    second$iv = bTypeParams;
                    int i$iv2 = 0;
                    int n = ((Collection)((Object)first$iv)).size();
                    while (i$iv2 < n) {
                        p1 = first$iv.get(i$iv);
                        object3 = p1.getName();
                        if (Intrinsics.areEqual((Object)object3, (Object)(object2 = (p1 = (TypeParameterDescriptor)second$iv.get(i$iv)).getName())) ^ true) {
                            bl3 = false;
                            break block46;
                        }
                        ++i$iv;
                    }
                    bl3 = true;
                }
                if (!bl3) {
                    return Compatibility.Incompatible.TypeParameterNames.INSTANCE;
                }
                if (Intrinsics.areEqual((Object)((Object)a.getModality()), (Object)((Object)b.getModality())) ^ true) {
                    return Compatibility.Incompatible.Modality.INSTANCE;
                }
                if (Intrinsics.areEqual((Object)a.getVisibility(), (Object)b.getVisibility()) ^ true) {
                    return Compatibility.Incompatible.Visibility.INSTANCE;
                }
                this_$iv = this.areCompatibleTypeParameters(aTypeParams, bTypeParams, platformModule, substitutor3);
                it = this_$iv;
                if (Intrinsics.areEqual((Object)it, (Object)Compatibility.Compatible.INSTANCE) ^ true) {
                    return it;
                }
                this_$iv = this;
                List<ValueParameterDescriptor> list6 = aParams;
                Intrinsics.checkExpressionValueIsNotNull(list6, (String)"aParams");
                it = list6;
                List<ValueParameterDescriptor> list7 = bParams;
                Intrinsics.checkExpressionValueIsNotNull(list7, (String)"bParams");
                second$iv = list7;
                int n = ((Collection)((Object)first$iv)).size();
                for (i$iv = 0; i$iv < n; ++i$iv) {
                    boolean bl7;
                    p1 = (ValueParameterDescriptor)((Object)first$iv.get(i$iv));
                    boolean bl8 = p1.declaresDefaultValue();
                    if (!(bl8 == (bl7 = (p1 = (ValueParameterDescriptor)second$iv.get(i$iv)).declaresDefaultValue()) ^ true)) continue;
                    bl2 = false;
                    break block47;
                }
                bl2 = true;
            }
            if (!bl2) {
                return Compatibility.Incompatible.ValueParameterHasDefault.INSTANCE;
            }
            this_$iv = this;
            first$iv = aParams;
            second$iv = bParams;
            int n = ((Collection)((Object)first$iv)).size();
            for (i$iv = 0; i$iv < n; ++i$iv) {
                List list8;
                ValueParameterDescriptor p = (ValueParameterDescriptor)first$iv.get(i$iv);
                boolean bl8 = p.getVarargElementType() != null;
                p = (ValueParameterDescriptor)second$iv.get(i$iv);
                List list9 = CollectionsKt.listOf((Object)bl8);
                if (!(Intrinsics.areEqual((Object)list9, (Object)(list8 = CollectionsKt.listOf((Object)(p.getVarargElementType() != null ? 1 : 0)))) ^ true)) continue;
                bl = false;
                break block48;
            }
            bl = true;
        }
        if (!bl) {
            return Compatibility.Incompatible.ValueParameterVararg.INSTANCE;
        }
        if (a instanceof FunctionDescriptor && ((FunctionDescriptor)a).isInline()) {
            boolean bl9;
            block50: {
                int i;
                boolean bl10;
                block49: {
                    $receiver$iv = (Iterable)CollectionsKt.getIndices((Collection)aParams);
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl10 = false;
                    } else {
                        first$iv = $receiver$iv.iterator();
                        while (first$iv.hasNext()) {
                            int element$iv = ((IntIterator)first$iv).nextInt();
                            i = element$iv;
                            if (!(!aParams.get(i).isNoinline() && bParams.get(i).isNoinline())) continue;
                            bl10 = true;
                            break block49;
                        }
                        bl10 = false;
                    }
                }
                if (bl10) {
                    return Compatibility.Incompatible.ValueParameterNoinline.INSTANCE;
                }
                $receiver$iv = (Iterable)CollectionsKt.getIndices((Collection)aParams);
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl9 = false;
                } else {
                    first$iv = $receiver$iv.iterator();
                    while (first$iv.hasNext()) {
                        int element$iv = ((IntIterator)first$iv).nextInt();
                        i = element$iv;
                        if (!(!aParams.get(i).isCrossinline() && bParams.get(i).isCrossinline())) continue;
                        bl9 = true;
                        break block50;
                    }
                    bl9 = false;
                }
            }
            if (bl9) {
                return Compatibility.Incompatible.ValueParameterCrossinline.INSTANCE;
            }
        }
        if (a instanceof FunctionDescriptor && b instanceof FunctionDescriptor) {
            object = this.areCompatibleFunctions((FunctionDescriptor)a, (FunctionDescriptor)b);
            it = object;
            if (Intrinsics.areEqual((Object)it, (Object)Compatibility.Compatible.INSTANCE) ^ true) {
                return it;
            }
        } else if (a instanceof PropertyDescriptor && b instanceof PropertyDescriptor) {
            object = this.areCompatibleProperties((PropertyDescriptor)a, (PropertyDescriptor)b);
            it = object;
            if (Intrinsics.areEqual((Object)it, (Object)Compatibility.Compatible.INSTANCE) ^ true) {
                return it;
            }
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unsupported declarations: " + a + ", " + b)));
        }
        if (checkImpl && !b.isImpl() && Intrinsics.areEqual((Object)((Object)b.getKind()), (Object)((Object)CallableMemberDescriptor.Kind.DECLARATION))) {
            return Compatibility.Incompatible.NoImpl.INSTANCE;
        }
        return Compatibility.Compatible.INSTANCE;
    }

    static /* bridge */ /* synthetic */ Compatibility areCompatibleCallables$default(HeaderImplDeclarationChecker headerImplDeclarationChecker, CallableMemberDescriptor callableMemberDescriptor, CallableMemberDescriptor callableMemberDescriptor2, boolean bl, ModuleDescriptor moduleDescriptor, Substitutor substitutor3, int n, Object object) {
        if ((n & 8) != 0) {
            moduleDescriptor = DescriptorUtilsKt.getModule(callableMemberDescriptor2);
        }
        if ((n & 0x10) != 0) {
            substitutor3 = null;
        }
        return headerImplDeclarationChecker.areCompatibleCallables(callableMemberDescriptor, callableMemberDescriptor2, bl, moduleDescriptor, substitutor3);
    }

    private final boolean areCompatibleTypes(KotlinType a, KotlinType b, ModuleDescriptor platformModule) {
        NewKotlinTypeChecker newKotlinTypeChecker;
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        NewKotlinTypeChecker $receiver = newKotlinTypeChecker = NewKotlinTypeChecker.INSTANCE;
        TypeCheckerContext context = new TypeCheckerContext(false, platformModule, a, b){
            final /* synthetic */ ModuleDescriptor $platformModule$inlined;
            final /* synthetic */ KotlinType $a$inlined;
            final /* synthetic */ KotlinType $b$inlined;
            {
                this.$platformModule$inlined = moduleDescriptor;
                this.$a$inlined = kotlinType;
                this.$b$inlined = kotlinType2;
                super($super_call_param$1, false, 2, null);
            }

            public boolean areEqualTypeConstructors(@NotNull TypeConstructor a, @NotNull TypeConstructor b) {
                Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
                Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                return HeaderImplDeclarationChecker.access$isHeaderClassAndImplTypeAlias(HeaderImplDeclarationChecker.INSTANCE, a, b, this.$platformModule$inlined) || HeaderImplDeclarationChecker.access$isHeaderClassAndImplTypeAlias(HeaderImplDeclarationChecker.INSTANCE, b, a, this.$platformModule$inlined) || super.areEqualTypeConstructors(a, b);
            }
        };
        return $receiver.equalTypes(context, a.unwrap(), b.unwrap());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isHeaderClassAndImplTypeAlias(TypeConstructor headerTypeConstructor, TypeConstructor implTypeConstructor, ModuleDescriptor platformModule) {
        TypeAliasDescriptor typeAliasDescriptor;
        ClassifierDescriptor header = headerTypeConstructor.getDeclarationDescriptor();
        ClassifierDescriptor impl = implTypeConstructor.getDeclarationDescriptor();
        if (!(header instanceof ClassifierDescriptorWithTypeParameters)) return false;
        if (!((ClassifierDescriptorWithTypeParameters)header).isHeader()) return false;
        if (!(impl instanceof ClassifierDescriptorWithTypeParameters)) return false;
        Iterable $receiver$iv = this.findClassifiersFromModule((ClassifierDescriptorWithTypeParameters)header, platformModule);
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            ClassifierDescriptorWithTypeParameters classifier = (ClassifierDescriptorWithTypeParameters)element$iv;
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = classifier;
            if (!(classifierDescriptorWithTypeParameters instanceof TypeAliasDescriptor)) {
                classifierDescriptorWithTypeParameters = null;
            }
            typeAliasDescriptor = (TypeAliasDescriptor)classifierDescriptorWithTypeParameters;
        } while (!Intrinsics.areEqual((Object)(typeAliasDescriptor != null ? typeAliasDescriptor.getClassDescriptor() : null), (Object)impl));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean areCompatibleTypeLists(List<? extends KotlinType> a, List<? extends KotlinType> b, ModuleDescriptor platformModule) {
        int n = 0;
        int n2 = ((Collection)a).size();
        while (n < n2) {
            void i;
            if (!this.areCompatibleTypes(a.get((int)i), b.get((int)i), platformModule)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Compatibility areCompatibleTypeParameters(List<? extends TypeParameterDescriptor> a, List<? extends TypeParameterDescriptor> b, ModuleDescriptor platformModule, Substitutor substitutor3) {
        boolean bl;
        block11: {
            boolean bl2;
            Iterable $receiver$iv;
            block10: {
                Object object;
                TypeParameterDescriptor it;
                Object object2;
                Iterable $receiver$iv$iv;
                Iterable iterable = a;
                Object object3 = this;
                void var6_7 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
                    object2 = destination$iv$iv;
                    object = substitutor3.invoke(it.getDefaultType());
                    object2.add(object);
                }
                object2 = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv = (Iterable)b;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    it = (TypeParameterDescriptor)item$iv$iv;
                    object = destination$iv$iv;
                    SimpleType simpleType2 = it.getDefaultType();
                    object.add(simpleType2);
                }
                object = (List)destination$iv$iv;
                if (!object3.areCompatibleTypeLists((List<? extends KotlinType>)object2, (List<? extends KotlinType>)object, platformModule)) {
                    return Compatibility.Incompatible.TypeParameterUpperBounds.INSTANCE;
                }
                HeaderImplDeclarationChecker this_$iv = this;
                int $receiver$iv$iv2 = 0;
                int destination$iv$iv2 = ((Collection)a).size();
                while ($receiver$iv$iv2 < destination$iv$iv2) {
                    void i$iv;
                    TypeParameterDescriptor p1 = a.get((int)i$iv);
                    object3 = p1.getVariance();
                    if (Intrinsics.areEqual((Object)object3, (Object)(object2 = (p1 = b.get((int)i$iv)).getVariance())) ^ true) {
                        bl2 = false;
                        break block10;
                    }
                    ++i$iv;
                }
                bl2 = true;
            }
            if (!bl2) {
                return Compatibility.Incompatible.TypeParameterVariance.INSTANCE;
            }
            $receiver$iv = (Iterable)CollectionsKt.getIndices((Collection)a);
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator2 = $receiver$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv = ((IntIterator)iterator2).nextInt();
                    int i = element$iv;
                    if (!(!a.get(i).isReified() && b.get(i).isReified())) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            return Compatibility.Incompatible.TypeParameterReified.INSTANCE;
        }
        return Compatibility.Compatible.INSTANCE;
    }

    private final Compatibility areCompatibleFunctions(FunctionDescriptor a, FunctionDescriptor b) {
        boolean bl;
        HeaderImplDeclarationChecker this_$iv = this;
        FunctionDescriptor f = a;
        boolean bl2 = f.isSuspend();
        if (!(bl2 == (bl = (f = b).isSuspend()))) {
            return Compatibility.Incompatible.FunctionModifiersDifferent.INSTANCE;
        }
        if (a.isExternal() && !b.isExternal() || a.isInfix() && !b.isInfix() || a.isInline() && !b.isInline() || a.isOperator() && !b.isOperator() || a.isTailrec() && !b.isTailrec()) {
            return Compatibility.Incompatible.FunctionModifiersNotSubset.INSTANCE;
        }
        return Compatibility.Compatible.INSTANCE;
    }

    private final Compatibility areCompatibleProperties(PropertyDescriptor a, PropertyDescriptor b) {
        List list2;
        boolean bl;
        HeaderImplDeclarationChecker this_$iv = this;
        PropertyDescriptor p = a;
        boolean bl2 = p.isVar();
        if (!(bl2 == (bl = (p = b).isVar()))) {
            return Compatibility.Incompatible.PropertyKind.INSTANCE;
        }
        this_$iv = this;
        p = a;
        Object[] objectArray = new Boolean[]{p.isConst(), p.isLateInit()};
        p = b;
        List list3 = CollectionsKt.listOf((Object[])objectArray);
        if (!Intrinsics.areEqual((Object)list3, (Object)(list2 = CollectionsKt.listOf((Object[])new Boolean[]{p.isConst(), p.isLateInit()})))) {
            return Compatibility.Incompatible.PropertyModifiers.INSTANCE;
        }
        return Compatibility.Compatible.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final Compatibility areCompatibleClassifiers(ClassDescriptor a, ClassifierDescriptor other, boolean checkImpl) {
        boolean bl;
        Substitutor substitutor3;
        ModuleDescriptor platformModule;
        ClassDescriptor b;
        boolean implTypealias;
        block25: {
            Iterable $receiver$iv$iv;
            Object element$iv$iv2;
            void $receiver$iv$iv2;
            Iterable $receiver$iv;
            Compatibility compatibility;
            List list2;
            ClassDescriptor classDescriptor;
            boolean bl2 = Intrinsics.areEqual((Object)a.getName(), (Object)other.getName());
            if (_Assertions.ENABLED && !bl2) {
                String string = "This function should be invoked only for declarations with the same name: " + a + ", " + other;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            implTypealias = false;
            ClassifierDescriptor classifierDescriptor = other;
            if (classifierDescriptor instanceof ClassDescriptor) {
                classDescriptor = (ClassDescriptor)other;
            } else if (classifierDescriptor instanceof TypeAliasDescriptor) {
                implTypealias = true;
                classDescriptor = ((TypeAliasDescriptor)other).getClassDescriptor();
                if (classDescriptor == null) {
                    return Compatibility.Compatible.INSTANCE;
                }
            } else {
                throw (Throwable)((Object)new AssertionError((Object)("Incorrect impl classifier for " + a + ": " + other)));
            }
            b = classDescriptor;
            if (Intrinsics.areEqual((Object)((Object)a.getKind()), (Object)((Object)b.getKind())) ^ true) {
                return Compatibility.Incompatible.ClassKind.INSTANCE;
            }
            HeaderImplDeclarationChecker this_$iv = this;
            ClassDescriptor it = a;
            Object[] objectArray = new Boolean[]{it.isCompanionObject(), it.isInner()};
            it = b;
            List list3 = CollectionsKt.listOf((Object[])objectArray);
            if (!Intrinsics.areEqual((Object)list3, (Object)(list2 = CollectionsKt.listOf((Object[])new Boolean[]{it.isCompanionObject(), it.isInner()})))) {
                return Compatibility.Incompatible.ClassModifiers.INSTANCE;
            }
            List<TypeParameterDescriptor> aTypeParams = a.getDeclaredTypeParameters();
            List<TypeParameterDescriptor> bTypeParams = b.getDeclaredTypeParameters();
            if (aTypeParams.size() != bTypeParams.size()) {
                return Compatibility.Incompatible.TypeParameterCount.INSTANCE;
            }
            if (!(!(Intrinsics.areEqual((Object)((Object)a.getModality()), (Object)((Object)b.getModality())) ^ true) || Intrinsics.areEqual((Object)((Object)a.getModality()), (Object)((Object)Modality.FINAL)) && Intrinsics.areEqual((Object)((Object)b.getModality()), (Object)((Object)Modality.OPEN)))) {
                return Compatibility.Incompatible.Modality.INSTANCE;
            }
            if (Intrinsics.areEqual((Object)a.getVisibility(), (Object)b.getVisibility()) ^ true) {
                return Compatibility.Incompatible.Visibility.INSTANCE;
            }
            platformModule = DescriptorUtilsKt.getModule(other);
            List<TypeParameterDescriptor> list4 = aTypeParams;
            Intrinsics.checkExpressionValueIsNotNull(list4, (String)"aTypeParams");
            List<TypeParameterDescriptor> list5 = bTypeParams;
            Intrinsics.checkExpressionValueIsNotNull(list5, (String)"bTypeParams");
            substitutor3 = new Substitutor(list4, list5, null, 4, null);
            Compatibility it2 = compatibility = this.areCompatibleTypeParameters(aTypeParams, bTypeParams, platformModule, substitutor3);
            if (Intrinsics.areEqual((Object)it2, (Object)Compatibility.Compatible.INSTANCE) ^ true) {
                return it2;
            }
            Iterable $i$a$3$let = $receiver$iv = (Iterable)a.getTypeConstructor().getSupertypes();
            Iterable destination$iv$iv = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv2) {
                KotlinType p1 = (KotlinType)element$iv$iv2;
                if (KotlinBuiltIns.isAny(p1)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List aSupertypes = (List)destination$iv$iv;
            Iterable $receiver$iv2 = b.getTypeConstructor().getSupertypes();
            destination$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            element$iv$iv2 = $receiver$iv$iv.iterator();
            while (element$iv$iv2.hasNext()) {
                Object element$iv$iv3 = element$iv$iv2.next();
                KotlinType p1 = (KotlinType)element$iv$iv3;
                if (KotlinBuiltIns.isAny(p1)) continue;
                destination$iv$iv2.add(element$iv$iv3);
            }
            List bSupertypes = (List)destination$iv$iv2;
            $receiver$iv2 = aSupertypes;
            $receiver$iv$iv = $receiver$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            element$iv$iv2 = $receiver$iv$iv.iterator();
            while (element$iv$iv2.hasNext()) {
                Object item$iv$iv = element$iv$iv2.next();
                destination$iv$iv2.add(((Function1)substitutor3).invoke(item$iv$iv));
            }
            $receiver$iv2 = (List)destination$iv$iv2;
            if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv2) {
                    boolean bl3;
                    block24: {
                        KotlinType aSupertype = (KotlinType)element$iv;
                        Iterable $receiver$iv3 = bSupertypes;
                        if ($receiver$iv3 instanceof Collection && ((Collection)$receiver$iv3).isEmpty()) {
                            bl3 = true;
                        } else {
                            for (Object element$iv2 : $receiver$iv3) {
                                KotlinType bSupertype = (KotlinType)element$iv2;
                                if (!INSTANCE.areCompatibleTypes(aSupertype, bSupertype, platformModule)) continue;
                                bl3 = false;
                                break block24;
                            }
                            bl3 = true;
                        }
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block25;
                }
                bl = false;
            }
        }
        if (bl) {
            return Compatibility.Incompatible.Supertypes.INSTANCE;
        }
        Compatibility compatibility = this.areCompatibleClassScopes(a, b, checkImpl && !implTypealias, platformModule, substitutor3);
        Compatibility it = compatibility;
        if (Intrinsics.areEqual((Object)it, (Object)Compatibility.Compatible.INSTANCE) ^ true) {
            return it;
        }
        if (checkImpl && !b.isImpl() && !implTypealias) {
            return Compatibility.Incompatible.NoImpl.INSTANCE;
        }
        return Compatibility.Compatible.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final Compatibility areCompatibleClassScopes(ClassDescriptor a, ClassDescriptor b, boolean checkImpl, ModuleDescriptor platformModule, Substitutor substitutor3) {
        Object element$iv$iv;
        Iterator $receiver$iv$iv;
        Iterable $receiver$iv;
        ArrayList<Pair> unimplemented = new ArrayList<Pair>();
        Iterable iterable = $receiver$iv = (Iterable)HeaderImplDeclarationChecker.getMembers$default(this, b, null, 1, null);
        Map destination$iv$iv = new LinkedHashMap();
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Map $receiver$iv$iv$iv = destination$iv$iv;
            element$iv$iv = iterator2.next();
            MemberDescriptor it = (MemberDescriptor)element$iv$iv;
            Name key$iv$iv = it.getName();
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map bMembersByName = destination$iv$iv;
        block1: for (MemberDescriptor aMember : HeaderImplDeclarationChecker.getMembers$default(this, a, null, 1, null)) {
            Object it;
            Object object;
            boolean bl;
            Map mapping2;
            block17: {
                Iterable iterable2;
                List list2;
                Iterable $receiver$iv2;
                if (aMember instanceof CallableMemberDescriptor && !((CallableMemberDescriptor)aMember).getKind().isReal()) continue;
                List list3 = (List)bMembersByName.get(aMember.getName());
                if (list3 != null) {
                    void $receiver$iv$iv2;
                    $receiver$iv2 = list3;
                    element$iv$iv = $receiver$iv2;
                    Collection destination$iv$iv2 = new ArrayList();
                    for (Object element$iv$iv2 : $receiver$iv$iv2) {
                        MemberDescriptor bMember = (MemberDescriptor)element$iv$iv2;
                        if (!(aMember instanceof CallableMemberDescriptor && bMember instanceof CallableMemberDescriptor || aMember instanceof ClassDescriptor && bMember instanceof ClassDescriptor)) continue;
                        destination$iv$iv2.add(element$iv$iv2);
                    }
                    list2 = (List)destination$iv$iv2;
                } else {
                    list2 = null;
                }
                if ((iterable2 = ($receiver$iv2 = list2)) == null) {
                    iterable2 = CollectionsKt.emptyList();
                }
                Iterable bMembers = iterable2;
                mapping2 = org.jetbrains.kotlin.utils.CollectionsKt.keysToMap(bMembers, (Function1)new Function1<MemberDescriptor, Compatibility>(aMember, checkImpl, platformModule, substitutor3, (List)bMembers){
                    final /* synthetic */ MemberDescriptor $aMember;
                    final /* synthetic */ boolean $checkImpl;
                    final /* synthetic */ ModuleDescriptor $platformModule;
                    final /* synthetic */ Substitutor $substitutor;
                    final /* synthetic */ List $bMembers;

                    @NotNull
                    public final Compatibility invoke(@NotNull MemberDescriptor bMember) {
                        Compatibility compatibility;
                        Intrinsics.checkParameterIsNotNull((Object)bMember, (String)"bMember");
                        MemberDescriptor memberDescriptor = this.$aMember;
                        if (memberDescriptor instanceof CallableMemberDescriptor) {
                            compatibility = HeaderImplDeclarationChecker.access$areCompatibleCallables(HeaderImplDeclarationChecker.INSTANCE, (CallableMemberDescriptor)this.$aMember, (CallableMemberDescriptor)bMember, this.$checkImpl, this.$platformModule, this.$substitutor);
                        } else if (memberDescriptor instanceof ClassDescriptor) {
                            compatibility = HeaderImplDeclarationChecker.access$areCompatibleClassifiers(HeaderImplDeclarationChecker.INSTANCE, (ClassDescriptor)this.$aMember, (ClassDescriptor)bMember, this.$checkImpl);
                        } else {
                            throw (Throwable)new UnsupportedOperationException("Unsupported declaration: " + this.$aMember + " (" + this.$bMembers + ')');
                        }
                        return compatibility;
                    }
                    {
                        this.$aMember = memberDescriptor;
                        this.$checkImpl = bl;
                        this.$platformModule = moduleDescriptor;
                        this.$substitutor = substitutor3;
                        this.$bMembers = list2;
                        super(1);
                    }
                });
                Iterable $receiver$iv3 = mapping2.values();
                if ($receiver$iv3 instanceof Collection && ((Collection)$receiver$iv3).isEmpty()) {
                    bl = false;
                } else {
                    object = $receiver$iv3.iterator();
                    while (object.hasNext()) {
                        Object element$iv = object.next();
                        it = (Compatibility)element$iv;
                        if (!Intrinsics.areEqual((Object)it, (Object)Compatibility.Compatible.INSTANCE)) continue;
                        bl = true;
                        break block17;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            Map incompatibilityMap = new LinkedHashMap();
            it = mapping2;
            Iterator iterator3 = it.entrySet().iterator();
            while (iterator3.hasNext()) {
                Object object2;
                Object object3 = object = iterator3.next();
                MemberDescriptor descriptor2 = (MemberDescriptor)object3.getKey();
                object3 = object;
                Compatibility compatibility = (Compatibility)object3.getValue();
                if (Intrinsics.areEqual((Object)(object3 = compatibility), (Object)Compatibility.Compatible.INSTANCE)) continue block1;
                if (!(object3 instanceof Compatibility.Incompatible)) continue;
                Map $receiver$iv4 = incompatibilityMap;
                Object value$iv = $receiver$iv4.get(compatibility);
                if (value$iv == null) {
                    SmartList answer$iv = new SmartList();
                    $receiver$iv4.put(compatibility, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                ((Collection)object2).add(descriptor2);
            }
            unimplemented.add(TuplesKt.to((Object)aMember, (Object)incompatibilityMap));
        }
        if (Intrinsics.areEqual((Object)((Object)a.getKind()), (Object)((Object)ClassKind.ENUM_CLASS))) {
            areCompatibleClassScopes.3 enumEntries$ = areCompatibleClassScopes.3.INSTANCE;
            List<Name> aEntries = enumEntries$.invoke(a);
            List<Name> bEntries = enumEntries$.invoke(b);
            if (!bEntries.containsAll((Collection)aEntries)) {
                return Compatibility.Incompatible.EnumEntries.INSTANCE;
            }
        }
        if (unimplemented.isEmpty()) {
            return Compatibility.Compatible.INSTANCE;
        }
        return new Compatibility.Incompatible.ClassScopes((List<? extends Pair<? extends MemberDescriptor, ? extends Map<Compatibility.Incompatible, ? extends Collection<? extends MemberDescriptor>>>>)unimplemented);
    }

    private final Collection<MemberDescriptor> getMembers(@NotNull ClassDescriptor $receiver, Name name2) {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Function1 nameFilter2 = name2 != null ? (Function1)new Function1<Name, Boolean>(name2){
            final /* synthetic */ Name $name;

            public final boolean invoke(@NotNull Name it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it, (Object)this.$name);
            }
            {
                this.$name = name2;
                super(1);
            }
        } : MemberScope.Companion.getALL_NAME_FILTER();
        Iterable iterable = MemberScopeKt.getDescriptorsFiltered$default($receiver.getDefaultType().getMemberScope(), null, nameFilter2, 1, null);
        void var5_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof MemberDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            DeclarationDescriptor p1 = (DeclarationDescriptor)element$iv$iv;
            if (DescriptorUtils.isEnumEntry(p1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = $receiver.getConstructors();
        Collection collection = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ClassConstructorDescriptor it = (ClassConstructorDescriptor)element$iv$iv;
            Name name3 = it.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"it.name");
            if (!((Boolean)nameFilter2.invoke((Object)name3)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection, (Iterable)list2);
    }

    static /* bridge */ /* synthetic */ Collection getMembers$default(HeaderImplDeclarationChecker headerImplDeclarationChecker, ClassDescriptor classDescriptor, Name name2, int n, Object object) {
        if ((n & 1) != 0) {
            name2 = null;
        }
        return headerImplDeclarationChecker.getMembers(classDescriptor, name2);
    }

    private final <T, K> boolean equalBy(T first, T second, Function1<? super T, ? extends K> selector) {
        return Intrinsics.areEqual((Object)selector.invoke(first), (Object)selector.invoke(second));
    }

    /*
     * WARNING - void declaration
     */
    private final <T, K> boolean equalsBy(List<? extends T> first, List<? extends T> second, Function1<? super T, ? extends K> selector) {
        int n = 0;
        int n2 = ((Collection)first).size();
        while (n < n2) {
            void i;
            if (Intrinsics.areEqual((Object)selector.invoke(first.get((int)i)), (Object)selector.invoke(second.get((int)i))) ^ true) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private HeaderImplDeclarationChecker() {
        INSTANCE = this;
    }

    static {
        new HeaderImplDeclarationChecker();
    }

    public static final /* synthetic */ boolean access$isExplicitImplDeclaration(HeaderImplDeclarationChecker $this, @NotNull MemberDescriptor $receiver) {
        return $this.isExplicitImplDeclaration($receiver);
    }

    @Nullable
    public static final /* synthetic */ Map access$findHeaderForImpl(HeaderImplDeclarationChecker $this, @NotNull MemberDescriptor impl, @NotNull ModuleDescriptor commonModule) {
        return $this.findHeaderForImpl(impl, commonModule);
    }

    public static final /* synthetic */ boolean access$isHeaderClassAndImplTypeAlias(HeaderImplDeclarationChecker $this, @NotNull TypeConstructor headerTypeConstructor, @NotNull TypeConstructor implTypeConstructor, @NotNull ModuleDescriptor platformModule) {
        return $this.isHeaderClassAndImplTypeAlias(headerTypeConstructor, implTypeConstructor, platformModule);
    }

    @NotNull
    public static final /* synthetic */ Compatibility access$areCompatibleCallables(HeaderImplDeclarationChecker $this, @NotNull CallableMemberDescriptor a, @NotNull CallableMemberDescriptor b, boolean checkImpl, @NotNull ModuleDescriptor platformModule, @Nullable Substitutor parentSubstitutor) {
        return $this.areCompatibleCallables(a, b, checkImpl, platformModule, parentSubstitutor);
    }

    @NotNull
    public static final /* synthetic */ Compatibility access$areCompatibleClassifiers(HeaderImplDeclarationChecker $this, @NotNull ClassDescriptor a, @NotNull ClassifierDescriptor other, boolean checkImpl) {
        return $this.areCompatibleClassifiers(a, other, checkImpl);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility;", "", "()V", "Compatible", "Incompatible", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Compatible;", "frontend"})
    public static abstract class Compatibility {
        private Compatibility() {
        }

        public /* synthetic */ Compatibility(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u001b\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !B\u0011\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u001b\"#$%&'()*+,-./0123456789:;<\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility;", "reason", "", "(Ljava/lang/String;)V", "getReason", "()Ljava/lang/String;", "ClassKind", "ClassModifiers", "ClassScopes", "EnumEntries", "FunctionModifiersDifferent", "FunctionModifiersNotSubset", "Modality", "NoImpl", "ParameterCount", "ParameterNames", "ParameterShape", "ParameterTypes", "PropertyKind", "PropertyModifiers", "ReturnType", "Supertypes", "TypeParameterCount", "TypeParameterNames", "TypeParameterReified", "TypeParameterUpperBounds", "TypeParameterVariance", "Unknown", "ValueParameterCrossinline", "ValueParameterHasDefault", "ValueParameterNoinline", "ValueParameterVararg", "Visibility", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ParameterShape;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ParameterCount;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$TypeParameterCount;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ParameterTypes;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ReturnType;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ParameterNames;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$TypeParameterNames;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ValueParameterHasDefault;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ValueParameterVararg;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ValueParameterNoinline;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ValueParameterCrossinline;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$FunctionModifiersDifferent;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$FunctionModifiersNotSubset;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$PropertyKind;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$PropertyModifiers;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ClassKind;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ClassModifiers;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$Supertypes;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ClassScopes;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$EnumEntries;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$Modality;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$Visibility;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$TypeParameterUpperBounds;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$TypeParameterVariance;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$TypeParameterReified;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$NoImpl;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$Unknown;", "frontend"})
        public static abstract class Incompatible
        extends Compatibility {
            @Nullable
            private final String reason;

            @Nullable
            public final String getReason() {
                return this.reason;
            }

            private Incompatible(String reason) {
                super(null);
                this.reason = reason;
            }

            public /* synthetic */ Incompatible(@Nullable String reason, DefaultConstructorMarker $constructor_marker) {
                this(reason);
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ParameterShape;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class ParameterShape
            extends Incompatible {
                public static final ParameterShape INSTANCE;

                private ParameterShape() {
                    super("parameter shapes are different (extension vs non-extension)", null);
                    INSTANCE = this;
                }

                static {
                    new ParameterShape();
                }
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ParameterCount;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class ParameterCount
            extends Incompatible {
                public static final ParameterCount INSTANCE;

                private ParameterCount() {
                    super("number of value parameters is different", null);
                    INSTANCE = this;
                }

                static {
                    new ParameterCount();
                }
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$TypeParameterCount;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class TypeParameterCount
            extends Incompatible {
                public static final TypeParameterCount INSTANCE;

                private TypeParameterCount() {
                    super("number of type parameters is different", null);
                    INSTANCE = this;
                }

                static {
                    new TypeParameterCount();
                }
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ParameterTypes;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class ParameterTypes
            extends Incompatible {
                public static final ParameterTypes INSTANCE;

                private ParameterTypes() {
                    super("parameter types are different", null);
                    INSTANCE = this;
                }

                static {
                    new ParameterTypes();
                }
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ReturnType;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class ReturnType
            extends Incompatible {
                public static final ReturnType INSTANCE;

                private ReturnType() {
                    super("return type is different", null);
                    INSTANCE = this;
                }

                static {
                    new ReturnType();
                }
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ParameterNames;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class ParameterNames
            extends Incompatible {
                public static final ParameterNames INSTANCE;

                private ParameterNames() {
                    super("parameter names are different", null);
                    INSTANCE = this;
                }

                static {
                    new ParameterNames();
                }
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$TypeParameterNames;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class TypeParameterNames
            extends Incompatible {
                public static final TypeParameterNames INSTANCE;

                private TypeParameterNames() {
                    super("names of type parameters are different", null);
                    INSTANCE = this;
                }

                static {
                    new TypeParameterNames();
                }
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ValueParameterHasDefault;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class ValueParameterHasDefault
            extends Incompatible {
                public static final ValueParameterHasDefault INSTANCE;

                private ValueParameterHasDefault() {
                    super("some parameters have default values", null);
                    INSTANCE = this;
                }

                static {
                    new ValueParameterHasDefault();
                }
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ValueParameterVararg;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class ValueParameterVararg
            extends Incompatible {
                public static final ValueParameterVararg INSTANCE;

                private ValueParameterVararg() {
                    super("some value parameter is vararg in one declaration and non-vararg in the other", null);
                    INSTANCE = this;
                }

                static {
                    new ValueParameterVararg();
                }
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ValueParameterNoinline;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class ValueParameterNoinline
            extends Incompatible {
                public static final ValueParameterNoinline INSTANCE;

                private ValueParameterNoinline() {
                    super("some value parameter is noinline in one declaration and not noinline in the other", null);
                    INSTANCE = this;
                }

                static {
                    new ValueParameterNoinline();
                }
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ValueParameterCrossinline;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class ValueParameterCrossinline
            extends Incompatible {
                public static final ValueParameterCrossinline INSTANCE;

                private ValueParameterCrossinline() {
                    super("some value parameter is crossinline in one declaration and not crossinline in the other", null);
                    INSTANCE = this;
                }

                static {
                    new ValueParameterCrossinline();
                }
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$FunctionModifiersDifferent;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class FunctionModifiersDifferent
            extends Incompatible {
                public static final FunctionModifiersDifferent INSTANCE;

                private FunctionModifiersDifferent() {
                    super("modifiers are different (suspend)", null);
                    INSTANCE = this;
                }

                static {
                    new FunctionModifiersDifferent();
                }
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$FunctionModifiersNotSubset;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class FunctionModifiersNotSubset
            extends Incompatible {
                public static final FunctionModifiersNotSubset INSTANCE;

                private FunctionModifiersNotSubset() {
                    super("some modifiers on header declaration are missing on the implementation (external, infix, inline, operator, tailrec)", null);
                    INSTANCE = this;
                }

                static {
                    new FunctionModifiersNotSubset();
                }
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$PropertyKind;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class PropertyKind
            extends Incompatible {
                public static final PropertyKind INSTANCE;

                private PropertyKind() {
                    super("property kinds are different (val vs var)", null);
                    INSTANCE = this;
                }

                static {
                    new PropertyKind();
                }
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$PropertyModifiers;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class PropertyModifiers
            extends Incompatible {
                public static final PropertyModifiers INSTANCE;

                private PropertyModifiers() {
                    super("modifiers are different (const, lateinit)", null);
                    INSTANCE = this;
                }

                static {
                    new PropertyModifiers();
                }
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ClassKind;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class ClassKind
            extends Incompatible {
                public static final ClassKind INSTANCE;

                private ClassKind() {
                    super("class kinds are different (class, interface, object, enum, annotation)", null);
                    INSTANCE = this;
                }

                static {
                    new ClassKind();
                }
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ClassModifiers;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class ClassModifiers
            extends Incompatible {
                public static final ClassModifiers INSTANCE;

                private ClassModifiers() {
                    super("modifiers are different (companion, inner)", null);
                    INSTANCE = this;
                }

                static {
                    new ClassModifiers();
                }
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$Supertypes;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class Supertypes
            extends Incompatible {
                public static final Supertypes INSTANCE;

                private Supertypes() {
                    super("some supertypes are missing in the implementation", null);
                    INSTANCE = this;
                }

                static {
                    new Supertypes();
                }
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u001e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B1\u0012*\u0010\u0002\u001a&\u0012\"\u0012 \u0012\u0004\u0012\u00020\u0005\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u00060\u00040\u0003\u00a2\u0006\u0002\u0010\bR5\u0010\u0002\u001a&\u0012\"\u0012 \u0012\u0004\u0012\u00020\u0005\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00070\u00060\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$ClassScopes;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "unimplemented", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "", "", "(Ljava/util/List;)V", "getUnimplemented", "()Ljava/util/List;", "frontend"})
            public static final class ClassScopes
            extends Incompatible {
                @NotNull
                private final List<Pair<MemberDescriptor, Map<Incompatible, Collection<MemberDescriptor>>>> unimplemented;

                @NotNull
                public final List<Pair<MemberDescriptor, Map<Incompatible, Collection<MemberDescriptor>>>> getUnimplemented() {
                    return this.unimplemented;
                }

                public ClassScopes(@NotNull List<? extends Pair<? extends MemberDescriptor, ? extends Map<Incompatible, ? extends Collection<? extends MemberDescriptor>>>> unimplemented) {
                    Intrinsics.checkParameterIsNotNull(unimplemented, (String)"unimplemented");
                    super("some members are not implemented", null);
                    this.unimplemented = unimplemented;
                }
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$EnumEntries;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class EnumEntries
            extends Incompatible {
                public static final EnumEntries INSTANCE;

                private EnumEntries() {
                    super("some entries from header enum are missing in the impl enum", null);
                    INSTANCE = this;
                }

                static {
                    new EnumEntries();
                }
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$Modality;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class Modality
            extends Incompatible {
                public static final Modality INSTANCE;

                private Modality() {
                    super("modality is different", null);
                    INSTANCE = this;
                }

                static {
                    new Modality();
                }
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$Visibility;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class Visibility
            extends Incompatible {
                public static final Visibility INSTANCE;

                private Visibility() {
                    super("visibility is different", null);
                    INSTANCE = this;
                }

                static {
                    new Visibility();
                }
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$TypeParameterUpperBounds;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class TypeParameterUpperBounds
            extends Incompatible {
                public static final TypeParameterUpperBounds INSTANCE;

                private TypeParameterUpperBounds() {
                    super("upper bounds of type parameters are different", null);
                    INSTANCE = this;
                }

                static {
                    new TypeParameterUpperBounds();
                }
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$TypeParameterVariance;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class TypeParameterVariance
            extends Incompatible {
                public static final TypeParameterVariance INSTANCE;

                private TypeParameterVariance() {
                    super("declaration-site variances of type parameters are different", null);
                    INSTANCE = this;
                }

                static {
                    new TypeParameterVariance();
                }
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$TypeParameterReified;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class TypeParameterReified
            extends Incompatible {
                public static final TypeParameterReified INSTANCE;

                private TypeParameterReified() {
                    super("some type parameter is reified in one declaration and non-reified in the other", null);
                    INSTANCE = this;
                }

                static {
                    new TypeParameterReified();
                }
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$NoImpl;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class NoImpl
            extends Incompatible {
                public static final NoImpl INSTANCE;

                private NoImpl() {
                    super("the implementation is not marked with the 'impl' modifier (-Xno-check-impl)", null);
                    INSTANCE = this;
                }

                static {
                    new NoImpl();
                }
            }

            @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible$Unknown;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Incompatible;", "()V", "frontend"})
            public static final class Unknown
            extends Incompatible {
                public static final Unknown INSTANCE;

                private Unknown() {
                    super(null, null);
                    INSTANCE = this;
                }

                static {
                    new Unknown();
                }
            }
        }

        @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility$Compatible;", "Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Compatibility;", "()V", "frontend"})
        public static final class Compatible
        extends Compatibility {
            public static final Compatible INSTANCE;

            private Compatible() {
                super(null);
                INSTANCE = this;
            }

            static {
                new Compatible();
            }
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B-\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u000b\u001a\u0004\u0018\u00010\u00022\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0096\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Substitutor;", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/types/KotlinType;", "aTypeParams", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "bTypeParams", "parent", "(Ljava/util/List;Ljava/util/List;Lorg/jetbrains/kotlin/resolve/checkers/HeaderImplDeclarationChecker$Substitutor;)V", "typeSubstitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "invoke", "type", "frontend"})
    private static final class Substitutor
    implements Function1<KotlinType, KotlinType> {
        private final TypeSubstitutor typeSubstitutor;
        private final Substitutor parent;

        @Nullable
        public KotlinType invoke(@Nullable KotlinType type2) {
            Object object;
            Object p1;
            TypeSubstitutor typeSubstitutor2;
            Object object2;
            Object object3 = this.parent;
            if (object3 == null || (object3 = ((Substitutor)object3).invoke(type2)) == null) {
                object3 = object2 = type2;
            }
            return object3 != null && (object2 = TypeUtilsKt.asTypeProjection((KotlinType)object2)) != null && (object2 = (typeSubstitutor2 = this.typeSubstitutor).substitute((TypeProjection)(p1 = (object = object2)))) != null ? object2.getType() : null;
        }

        public Substitutor(@NotNull List<? extends TypeParameterDescriptor> aTypeParams, @NotNull List<? extends TypeParameterDescriptor> bTypeParams, @Nullable Substitutor parent2) {
            Intrinsics.checkParameterIsNotNull(aTypeParams, (String)"aTypeParams");
            Intrinsics.checkParameterIsNotNull(bTypeParams, (String)"bTypeParams");
            this.parent = parent2;
            this.typeSubstitutor = TypeSubstitutor.create(TypeConstructorSubstitution.Companion.createByParametersMap(org.jetbrains.kotlin.utils.CollectionsKt.keysToMap((Iterable)aTypeParams, (Function1)new Function1<TypeParameterDescriptor, TypeProjection>(bTypeParams){
                final /* synthetic */ List $bTypeParams;

                @NotNull
                public final TypeProjection invoke(@NotNull TypeParameterDescriptor it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return TypeUtilsKt.asTypeProjection(((TypeParameterDescriptor)this.$bTypeParams.get(it.getIndex())).getDefaultType());
                }
                {
                    this.$bTypeParams = list2;
                    super(1);
                }
            })));
        }

        public /* synthetic */ Substitutor(List list2, List list3, Substitutor substitutor3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                substitutor3 = null;
            }
            this(list2, list3, substitutor3);
        }
    }
}

