/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.ReadOnly;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.context.GlobalContext;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SupertypeLoopChecker;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportsFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.FunctionDescriptorResolver;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.extensions.SyntheticResolveExtension;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProviderImpl;
import org.jetbrains.kotlin.resolve.lazy.DelegationFilter;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.KotlinCodeAnalyzer;
import org.jetbrains.kotlin.resolve.lazy.LazyClassContext;
import org.jetbrains.kotlin.resolve.lazy.LazyDeclarationResolver;
import org.jetbrains.kotlin.resolve.lazy.LocalDescriptorResolver;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassOrObjectInfo;
import org.jetbrains.kotlin.resolve.lazy.data.KtScriptInfo;
import org.jetbrains.kotlin.resolve.lazy.declarations.DeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotations;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationsContextImpl;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyPackageDescriptor;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.storage.ExceptionTracker;
import org.jetbrains.kotlin.storage.LazyResolveStorageManager;
import org.jetbrains.kotlin.storage.LockBasedLazyResolveStorageManager;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNullable;
import org.jetbrains.kotlin.types.WrappedTypeFactory;
import org.jetbrains.kotlin.utils.SmartList;

public class ResolveSession
implements KotlinCodeAnalyzer,
LazyClassContext {
    private final LazyResolveStorageManager storageManager;
    private final ExceptionTracker exceptionTracker;
    private final ModuleDescriptor module;
    private final BindingTrace trace;
    private final DeclarationProviderFactory declarationProviderFactory;
    private final MemoizedFunctionToNullable<FqName, LazyPackageDescriptor> packages;
    private final PackageFragmentProvider packageFragmentProvider;
    private final MemoizedFunctionToNotNull<KtFile, LazyAnnotations> fileAnnotations;
    private final MemoizedFunctionToNotNull<KtFile, LazyAnnotations> danglingAnnotations;
    private KtImportsFactory jetImportFactory;
    private AnnotationResolver annotationResolver;
    private DescriptorResolver descriptorResolver;
    private FunctionDescriptorResolver functionDescriptorResolver;
    private TypeResolver typeResolver;
    private LazyDeclarationResolver lazyDeclarationResolver;
    private FileScopeProvider fileScopeProvider;
    private DeclarationScopeProvider declarationScopeProvider;
    private LookupTracker lookupTracker;
    private LocalDescriptorResolver localDescriptorResolver;
    private SupertypeLoopChecker supertypeLoopsResolver;
    private LanguageVersionSettings languageVersionSettings;
    private DelegationFilter delegationFilter;
    private WrappedTypeFactory wrappedTypeFactory;
    private final SyntheticResolveExtension syntheticResolveExtension;

    @Inject
    public void setJetImportFactory(KtImportsFactory jetImportFactory) {
        this.jetImportFactory = jetImportFactory;
    }

    @Inject
    public void setAnnotationResolve(AnnotationResolver annotationResolver) {
        this.annotationResolver = annotationResolver;
    }

    @Inject
    public void setDescriptorResolver(DescriptorResolver descriptorResolver) {
        this.descriptorResolver = descriptorResolver;
    }

    @Inject
    public void setFunctionDescriptorResolver(FunctionDescriptorResolver functionDescriptorResolver) {
        this.functionDescriptorResolver = functionDescriptorResolver;
    }

    @Inject
    public void setTypeResolver(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    @Inject
    public void setLazyDeclarationResolver(LazyDeclarationResolver lazyDeclarationResolver) {
        this.lazyDeclarationResolver = lazyDeclarationResolver;
    }

    @Inject
    public void setFileScopeProvider(@NotNull FileScopeProvider fileScopeProvider) {
        if (fileScopeProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileScopeProvider", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "setFileScopeProvider"));
        }
        this.fileScopeProvider = fileScopeProvider;
    }

    @Inject
    public void setDeclarationScopeProvider(@NotNull DeclarationScopeProviderImpl declarationScopeProvider) {
        if (declarationScopeProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationScopeProvider", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "setDeclarationScopeProvider"));
        }
        this.declarationScopeProvider = declarationScopeProvider;
    }

    @Inject
    public void setLookupTracker(@NotNull LookupTracker lookupTracker) {
        if (lookupTracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupTracker", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "setLookupTracker"));
        }
        this.lookupTracker = lookupTracker;
    }

    @Inject
    public void setLanguageVersionSettings(@NotNull LanguageVersionSettings languageVersionSettings) {
        if (languageVersionSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageVersionSettings", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "setLanguageVersionSettings"));
        }
        this.languageVersionSettings = languageVersionSettings;
    }

    @Inject
    public void setDelegationFilter(@NotNull DelegationFilter delegationFilter) {
        if (delegationFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegationFilter", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "setDelegationFilter"));
        }
        this.delegationFilter = delegationFilter;
    }

    @Inject
    public void setWrappedTypeFactory(WrappedTypeFactory wrappedTypeFactory) {
        this.wrappedTypeFactory = wrappedTypeFactory;
    }

    @Deprecated
    public ResolveSession(@NotNull Project project, @NotNull GlobalContext globalContext, @NotNull ModuleDescriptor rootDescriptor, @NotNull DeclarationProviderFactory declarationProviderFactory2, @NotNull BindingTrace delegationTrace) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "<init>"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "<init>"));
        }
        if (rootDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDescriptor", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "<init>"));
        }
        if (declarationProviderFactory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationProviderFactory", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "<init>"));
        }
        if (delegationTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegationTrace", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "<init>"));
        }
        LockBasedLazyResolveStorageManager lockBasedLazyResolveStorageManager = new LockBasedLazyResolveStorageManager(globalContext.getStorageManager());
        this.storageManager = lockBasedLazyResolveStorageManager;
        this.exceptionTracker = globalContext.getExceptionTracker();
        this.trace = lockBasedLazyResolveStorageManager.createSafeTrace(delegationTrace);
        this.module = rootDescriptor;
        this.packages = this.storageManager.createMemoizedFunctionWithNullableValues(this::createPackage);
        this.declarationProviderFactory = declarationProviderFactory2;
        this.packageFragmentProvider = new PackageFragmentProvider(){

            @Override
            @NotNull
            public List<PackageFragmentDescriptor> getPackageFragments(@NotNull FqName fqName2) {
                if (fqName2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/resolve/lazy/ResolveSession$1", "getPackageFragments"));
                }
                List list2 = ContainerUtil.createMaybeSingletonList((Object)ResolveSession.this.getPackageFragment(fqName2));
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession$1", "getPackageFragments"));
                }
                return list2;
            }

            @Override
            @NotNull
            public Collection<FqName> getSubPackagesOf(@NotNull FqName fqName2, @NotNull Function1<? super Name, Boolean> nameFilter2) {
                if (fqName2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/resolve/lazy/ResolveSession$1", "getSubPackagesOf"));
                }
                if (nameFilter2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameFilter", "org/jetbrains/kotlin/resolve/lazy/ResolveSession$1", "getSubPackagesOf"));
                }
                LazyPackageDescriptor packageDescriptor = ResolveSession.this.getPackageFragment(fqName2);
                if (packageDescriptor == null) {
                    List<FqName> list2 = Collections.emptyList();
                    if (list2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession$1", "getSubPackagesOf"));
                    }
                    return list2;
                }
                Collection<FqName> collection = packageDescriptor.getDeclarationProvider().getAllDeclaredSubPackages(nameFilter2);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession$1", "getSubPackagesOf"));
                }
                return collection;
            }
        };
        this.fileAnnotations = this.storageManager.createMemoizedFunction(file2 -> this.createAnnotations((KtFile)file2, file2.getAnnotationEntries()));
        this.danglingAnnotations = this.storageManager.createMemoizedFunction(file2 -> this.createAnnotations((KtFile)file2, file2.getDanglingAnnotations()));
        this.syntheticResolveExtension = SyntheticResolveExtension.Companion.getInstance(project);
    }

    private LazyAnnotations createAnnotations(KtFile file2, List<KtAnnotationEntry> annotationEntries) {
        LexicalScope scope2 = this.fileScopeProvider.getFileResolutionScope(file2);
        LazyAnnotationsContextImpl lazyAnnotationContext = new LazyAnnotationsContextImpl(this.annotationResolver, this.storageManager, this.trace, scope2);
        return new LazyAnnotations(lazyAnnotationContext, annotationEntries);
    }

    @Override
    @NotNull
    public PackageFragmentProvider getPackageFragmentProvider() {
        PackageFragmentProvider packageFragmentProvider2 = this.packageFragmentProvider;
        if (packageFragmentProvider2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getPackageFragmentProvider"));
        }
        return packageFragmentProvider2;
    }

    @Override
    @Nullable
    public LazyPackageDescriptor getPackageFragment(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getPackageFragment"));
        }
        return (LazyPackageDescriptor)this.packages.invoke(fqName2);
    }

    @Nullable
    private LazyPackageDescriptor createPackage(FqName fqName2) {
        PackageMemberDeclarationProvider provider2 = this.declarationProviderFactory.getPackageMemberDeclarationProvider(fqName2);
        if (provider2 == null) {
            return null;
        }
        return new LazyPackageDescriptor(this.module, fqName2, this, provider2);
    }

    @Override
    @NotNull
    public ModuleDescriptor getModuleDescriptor() {
        ModuleDescriptor moduleDescriptor = this.module;
        if (moduleDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getModuleDescriptor"));
        }
        return moduleDescriptor;
    }

    @Override
    @NotNull
    public LazyResolveStorageManager getStorageManager() {
        LazyResolveStorageManager lazyResolveStorageManager = this.storageManager;
        if (lazyResolveStorageManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getStorageManager"));
        }
        return lazyResolveStorageManager;
    }

    @NotNull
    public ExceptionTracker getExceptionTracker() {
        ExceptionTracker exceptionTracker = this.exceptionTracker;
        if (exceptionTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getExceptionTracker"));
        }
        return exceptionTracker;
    }

    @Override
    @NotNull
    @ReadOnly
    public Collection<ClassifierDescriptor> getTopLevelClassifierDescriptors(@NotNull FqName fqName2, @NotNull LookupLocation location2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getTopLevelClassifierDescriptors"));
        }
        if (location2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getTopLevelClassifierDescriptors"));
        }
        if (fqName2.isRoot()) {
            List<ClassifierDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getTopLevelClassifierDescriptors"));
            }
            return list2;
        }
        PackageMemberDeclarationProvider provider2 = this.declarationProviderFactory.getPackageMemberDeclarationProvider(fqName2.parent());
        if (provider2 == null) {
            List<ClassifierDescriptor> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getTopLevelClassifierDescriptors"));
            }
            return list3;
        }
        SmartList<ClassifierDescriptor> result2 = new SmartList<ClassifierDescriptor>();
        result2.addAll(ContainerUtil.mapNotNull(provider2.getClassOrObjectDeclarations(fqName2.shortName()), classLikeInfo -> {
            if (location2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "lambda$getTopLevelClassifierDescriptors$2"));
            }
            if (classLikeInfo instanceof KtClassOrObjectInfo) {
                return this.getClassDescriptor(((KtClassOrObjectInfo)classLikeInfo).getCorrespondingClassOrObject(), location2);
            }
            if (classLikeInfo instanceof KtScriptInfo) {
                return this.getScriptDescriptor(((KtScriptInfo)classLikeInfo).getScript());
            }
            throw new IllegalStateException("Unexpected " + classLikeInfo + " of type " + classLikeInfo.getClass().getName());
        }));
        result2.addAll(ContainerUtil.map(provider2.getTypeAliasDeclarations(fqName2.shortName()), alias -> (ClassifierDescriptor)this.lazyDeclarationResolver.resolveToDescriptor((KtDeclaration)alias)));
        SmartList<ClassifierDescriptor> smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getTopLevelClassifierDescriptors"));
        }
        return smartList;
    }

    @Override
    @NotNull
    public ClassDescriptor getClassDescriptor(@NotNull KtClassOrObject classOrObject, @NotNull LookupLocation location2) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getClassDescriptor"));
        }
        if (location2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getClassDescriptor"));
        }
        ClassDescriptor classDescriptor = this.lazyDeclarationResolver.getClassDescriptor(classOrObject, location2);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getClassDescriptor"));
        }
        return classDescriptor;
    }

    @NotNull
    public ScriptDescriptor getScriptDescriptor(@NotNull KtScript script) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getScriptDescriptor"));
        }
        ScriptDescriptor scriptDescriptor = this.lazyDeclarationResolver.getScriptDescriptor(script, NoLookupLocation.FOR_SCRIPT);
        if (scriptDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getScriptDescriptor"));
        }
        return scriptDescriptor;
    }

    @Override
    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext2 = this.trace.getBindingContext();
        if (bindingContext2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getBindingContext"));
        }
        return bindingContext2;
    }

    @Override
    @NotNull
    public BindingTrace getTrace() {
        BindingTrace bindingTrace = this.trace;
        if (bindingTrace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getTrace"));
        }
        return bindingTrace;
    }

    @Override
    @NotNull
    public DeclarationProviderFactory getDeclarationProviderFactory() {
        DeclarationProviderFactory declarationProviderFactory2 = this.declarationProviderFactory;
        if (declarationProviderFactory2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getDeclarationProviderFactory"));
        }
        return declarationProviderFactory2;
    }

    @Override
    @NotNull
    public DeclarationDescriptor resolveToDescriptor(@NotNull KtDeclaration declaration2) {
        if (declaration2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "resolveToDescriptor"));
        }
        this.assertValid();
        if (!ResolveSession.areDescriptorsCreatedForDeclaration(declaration2)) {
            throw new IllegalStateException("No descriptors are created for declarations of type " + declaration2.getClass().getSimpleName() + "\n. Change the caller accordingly");
        }
        if (!KtPsiUtil.isLocal(declaration2)) {
            DeclarationDescriptor declarationDescriptor = this.lazyDeclarationResolver.resolveToDescriptor(declaration2);
            if (declarationDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "resolveToDescriptor"));
            }
            return declarationDescriptor;
        }
        DeclarationDescriptor declarationDescriptor = this.localDescriptorResolver.resolveLocalDeclaration(declaration2);
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "resolveToDescriptor"));
        }
        return declarationDescriptor;
    }

    public static boolean areDescriptorsCreatedForDeclaration(@NotNull KtDeclaration declaration2) {
        if (declaration2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "areDescriptorsCreatedForDeclaration"));
        }
        return !(declaration2 instanceof KtAnonymousInitializer) && !(declaration2 instanceof KtDestructuringDeclaration);
    }

    @NotNull
    public Annotations getFileAnnotations(@NotNull KtFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getFileAnnotations"));
        }
        Annotations annotations2 = (Annotations)this.fileAnnotations.invoke(file2);
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getFileAnnotations"));
        }
        return annotations2;
    }

    @NotNull
    public Annotations getDanglingAnnotations(@NotNull KtFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getDanglingAnnotations"));
        }
        Annotations annotations2 = (Annotations)this.danglingAnnotations.invoke(file2);
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getDanglingAnnotations"));
        }
        return annotations2;
    }

    @NotNull
    private List<LazyPackageDescriptor> getAllPackages() {
        LazyPackageDescriptor rootPackage = this.getPackageFragment(FqName.ROOT);
        assert (rootPackage != null) : "Root package must be initialized";
        List<LazyPackageDescriptor> list2 = this.collectAllPackages(Lists.newArrayList(), rootPackage);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getAllPackages"));
        }
        return list2;
    }

    @NotNull
    private List<LazyPackageDescriptor> collectAllPackages(@NotNull List<LazyPackageDescriptor> result2, @NotNull LazyPackageDescriptor current) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "collectAllPackages"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "collectAllPackages"));
        }
        result2.add(current);
        for (FqName subPackage : this.packageFragmentProvider.getSubPackagesOf(current.getFqName(), MemberScope.Companion.getALL_NAME_FILTER())) {
            LazyPackageDescriptor fragment = this.getPackageFragment(subPackage);
            assert (fragment != null) : "Couldn't find fragment for " + subPackage;
            this.collectAllPackages(result2, fragment);
        }
        List<LazyPackageDescriptor> list2 = result2;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "collectAllPackages"));
        }
        return list2;
    }

    @Override
    public void forceResolveAll() {
        for (LazyPackageDescriptor lazyPackage : this.getAllPackages()) {
            ForceResolveUtil.forceResolveAllContents(lazyPackage);
        }
    }

    @NotNull
    public KtImportsFactory getJetImportsFactory() {
        KtImportsFactory ktImportsFactory = this.jetImportFactory;
        if (ktImportsFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getJetImportsFactory"));
        }
        return ktImportsFactory;
    }

    @Override
    @NotNull
    public AnnotationResolver getAnnotationResolver() {
        AnnotationResolver annotationResolver = this.annotationResolver;
        if (annotationResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getAnnotationResolver"));
        }
        return annotationResolver;
    }

    @Override
    @NotNull
    public DescriptorResolver getDescriptorResolver() {
        DescriptorResolver descriptorResolver = this.descriptorResolver;
        if (descriptorResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getDescriptorResolver"));
        }
        return descriptorResolver;
    }

    @Override
    @NotNull
    public TypeResolver getTypeResolver() {
        TypeResolver typeResolver = this.typeResolver;
        if (typeResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getTypeResolver"));
        }
        return typeResolver;
    }

    @Override
    @NotNull
    public FunctionDescriptorResolver getFunctionDescriptorResolver() {
        FunctionDescriptorResolver functionDescriptorResolver = this.functionDescriptorResolver;
        if (functionDescriptorResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getFunctionDescriptorResolver"));
        }
        return functionDescriptorResolver;
    }

    @Override
    @NotNull
    public DeclarationScopeProvider getDeclarationScopeProvider() {
        DeclarationScopeProvider declarationScopeProvider = this.declarationScopeProvider;
        if (declarationScopeProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getDeclarationScopeProvider"));
        }
        return declarationScopeProvider;
    }

    @Override
    @NotNull
    public FileScopeProvider getFileScopeProvider() {
        FileScopeProvider fileScopeProvider = this.fileScopeProvider;
        if (fileScopeProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getFileScopeProvider"));
        }
        return fileScopeProvider;
    }

    @Override
    @NotNull
    public LookupTracker getLookupTracker() {
        LookupTracker lookupTracker = this.lookupTracker;
        if (lookupTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getLookupTracker"));
        }
        return lookupTracker;
    }

    @Override
    @NotNull
    public SupertypeLoopChecker getSupertypeLoopChecker() {
        SupertypeLoopChecker supertypeLoopChecker = this.supertypeLoopsResolver;
        if (supertypeLoopChecker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getSupertypeLoopChecker"));
        }
        return supertypeLoopChecker;
    }

    @Inject
    public void setSupertypeLoopsResolver(@NotNull SupertypeLoopChecker supertypeLoopsResolver) {
        if (supertypeLoopsResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypeLoopsResolver", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "setSupertypeLoopsResolver"));
        }
        this.supertypeLoopsResolver = supertypeLoopsResolver;
    }

    @Inject
    public void setLocalDescriptorResolver(@NotNull LocalDescriptorResolver localDescriptorResolver) {
        if (localDescriptorResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localDescriptorResolver", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "setLocalDescriptorResolver"));
        }
        this.localDescriptorResolver = localDescriptorResolver;
    }

    @Override
    @NotNull
    public LanguageVersionSettings getLanguageVersionSettings() {
        LanguageVersionSettings languageVersionSettings = this.languageVersionSettings;
        if (languageVersionSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getLanguageVersionSettings"));
        }
        return languageVersionSettings;
    }

    @Override
    @NotNull
    public DelegationFilter getDelegationFilter() {
        DelegationFilter delegationFilter = this.delegationFilter;
        if (delegationFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getDelegationFilter"));
        }
        return delegationFilter;
    }

    @Override
    @NotNull
    public SyntheticResolveExtension getSyntheticResolveExtension() {
        SyntheticResolveExtension syntheticResolveExtension = this.syntheticResolveExtension;
        if (syntheticResolveExtension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getSyntheticResolveExtension"));
        }
        return syntheticResolveExtension;
    }

    @Override
    @NotNull
    public WrappedTypeFactory getWrappedTypeFactory() {
        WrappedTypeFactory wrappedTypeFactory = this.wrappedTypeFactory;
        if (wrappedTypeFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/ResolveSession", "getWrappedTypeFactory"));
        }
        return wrappedTypeFactory;
    }

    @Override
    public void assertValid() {
        this.module.assertValid();
    }
}

