/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.StandardScriptDefinition;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0014\u0010\u0016\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/script/KotlinScriptDefinitionProvider;", "", "()V", "definitions", "", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "definitionsLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "addScriptDefinition", "", "scriptDefinition", "findScriptDefinition", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileName", "", "getAllKnownFileTypes", "", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "isScript", "", "removeScriptDefinition", "setScriptDefinitions", "newDefinitions", "", "Companion", "frontend"})
public final class KotlinScriptDefinitionProvider {
    private final List<KotlinScriptDefinition> definitions = CollectionsKt.arrayListOf((Object[])new KotlinScriptDefinition[]{StandardScriptDefinition.INSTANCE});
    private final ReentrantReadWriteLock definitionsLock = new ReentrantReadWriteLock();
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setScriptDefinitions(@NotNull List<? extends KotlinScriptDefinition> newDefinitions) {
        Intrinsics.checkParameterIsNotNull(newDefinitions, (String)"newDefinitions");
        boolean changed = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.definitionsLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            Object object;
            if (Intrinsics.areEqual(newDefinitions, this.definitions) ^ true) {
                int n;
                object = this.definitionsLock;
                ReentrantReadWriteLock.ReadLock readLock2 = ((ReentrantReadWriteLock)object).readLock();
                int n2 = 0;
                int n3 = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
                int n4 = n3 - 1;
                if (n2 <= n4) {
                    do {
                        n = ++n2;
                        readLock2.unlock();
                    } while (n2 != n4);
                }
                ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
                writeLock.lock();
                try {
                    this.definitions.clear();
                    n4 = this.definitions.addAll((Collection<KotlinScriptDefinition>)newDefinitions) ? 1 : 0;
                }
                finally {
                    n = 0;
                    int n5 = n3 - 1;
                    if (n <= n5) {
                        do {
                            int n6 = ++n;
                            readLock2.lock();
                        } while (n != n5);
                    }
                    writeLock.unlock();
                }
                changed = true;
            }
            object = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
        return changed;
    }

    @Nullable
    public final KotlinScriptDefinition findScriptDefinition(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        String string = file2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
        return this.findScriptDefinition(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final KotlinScriptDefinition findScriptDefinition(@NotNull String fileName) {
        KotlinScriptDefinition kotlinScriptDefinition;
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        ReentrantReadWriteLock reentrantReadWriteLock = this.definitionsLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            Object v0;
            block4: {
                Iterable $receiver$iv = this.definitions;
                for (Object element$iv : $receiver$iv) {
                    KotlinScriptDefinition it = (KotlinScriptDefinition)element$iv;
                    if (!it.isScript(fileName)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            kotlinScriptDefinition = v0;
        }
        finally {
            readLock.unlock();
        }
        return kotlinScriptDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isScript(@NotNull String fileName) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        ReentrantReadWriteLock reentrantReadWriteLock = this.definitionsLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl2;
            block6: {
                Iterable $receiver$iv = this.definitions;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        KotlinScriptDefinition it = (KotlinScriptDefinition)element$iv;
                        if (!it.isScript(fileName)) continue;
                        bl2 = true;
                        break block6;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        }
        finally {
            readLock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addScriptDefinition(@NotNull KotlinScriptDefinition scriptDefinition2) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)scriptDefinition2, (String)"scriptDefinition");
        ReentrantReadWriteLock reentrantReadWriteLock = this.definitionsLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2 - 1;
        if (n3 <= n4) {
            do {
                n = ++n3;
                readLock.unlock();
            } while (n3 != n4);
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            this.definitions.add(0, scriptDefinition2);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n = 0;
            int n5 = n2 - 1;
            if (n <= n5) {
                do {
                    int n6 = ++n;
                    readLock.lock();
                } while (n != n5);
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeScriptDefinition(@NotNull KotlinScriptDefinition scriptDefinition2) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)scriptDefinition2, (String)"scriptDefinition");
        ReentrantReadWriteLock reentrantReadWriteLock = this.definitionsLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2 - 1;
        if (n3 <= n4) {
            do {
                n = ++n3;
                readLock.unlock();
            } while (n3 != n4);
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            n4 = this.definitions.remove(scriptDefinition2) ? 1 : 0;
        }
        finally {
            n = 0;
            int n5 = n2 - 1;
            if (n <= n5) {
                do {
                    int n6 = ++n;
                    readLock.lock();
                } while (n != n5);
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<LanguageFileType> getAllKnownFileTypes() {
        List list2;
        ReentrantReadWriteLock reentrantReadWriteLock = this.definitionsLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)this.definitions;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                KotlinScriptDefinition kotlinScriptDefinition = (KotlinScriptDefinition)item$iv$iv;
                Collection collection = destination$iv$iv;
                LanguageFileType languageFileType = it.getFileType();
                collection.add(languageFileType);
            }
            list2 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        }
        finally {
            readLock.unlock();
        }
        return list2;
    }

    @JvmStatic
    @Nullable
    public static final KotlinScriptDefinitionProvider getInstance(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/script/KotlinScriptDefinitionProvider$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinitionProvider;", "project", "Lcom/intellij/openapi/project/Project;", "frontend"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final KotlinScriptDefinitionProvider getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return (KotlinScriptDefinitionProvider)ServiceManager.getService((Project)project, KotlinScriptDefinitionProvider.class);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

