/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.checker;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeCheckerKt;
import org.jetbrains.kotlin.types.checker.NullabilityChecker;
import org.jetbrains.kotlin.types.checker.TypeCheckerContext;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001c\u0010\u0010\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010\u0014\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/types/checker/NullabilityChecker;", "", "()V", "isPossibleSubtype", "", "context", "Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext;", "subType", "Lorg/jetbrains/kotlin/types/SimpleType;", "superType", "isSubtypeOfAny", "type", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "hasNotNullSupertype", "supertypesPolicy", "Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SupertypesPolicy;", "hasPathByNotMarkedNullableNodes", "start", "end", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "runIsPossibleSubtype", "descriptors"})
public final class NullabilityChecker {
    public static final NullabilityChecker INSTANCE;

    public final boolean isPossibleSubtype(@NotNull TypeCheckerContext context, @NotNull SimpleType subType, @NotNull SimpleType superType) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)subType, (String)"subType");
        Intrinsics.checkParameterIsNotNull((Object)superType, (String)"superType");
        return this.runIsPossibleSubtype(context, subType, superType);
    }

    public final boolean isSubtypeOfAny(@NotNull UnwrappedType type2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        return this.hasNotNullSupertype(new TypeCheckerContext(false, false, 2, null), FlexibleTypesKt.lowerIfFlexible(type2), TypeCheckerContext.SupertypesPolicy.LowerIfFlexible.INSTANCE);
    }

    private final boolean runIsPossibleSubtype(@NotNull TypeCheckerContext $receiver, SimpleType subType, SimpleType superType) {
        boolean bl;
        boolean bl2 = bl = NewKotlinTypeCheckerKt.isIntersectionType(subType) || NewKotlinTypeCheckerKt.isSingleClassifierType(subType) || $receiver.isAllowedTypeVariable(subType);
        if (_Assertions.ENABLED && !bl) {
            String string = "Not singleClassifierType superType: " + superType;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean bl3 = bl = NewKotlinTypeCheckerKt.isSingleClassifierType(superType) || $receiver.isAllowedTypeVariable(superType);
        if (_Assertions.ENABLED && !bl) {
            String string = "Not singleClassifierType superType: " + superType;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (superType.isMarkedNullable()) {
            return true;
        }
        if (this.hasNotNullSupertype($receiver, subType, TypeCheckerContext.SupertypesPolicy.LowerIfFlexible.INSTANCE)) {
            return true;
        }
        if (this.hasNotNullSupertype($receiver, superType, TypeCheckerContext.SupertypesPolicy.UpperIfFlexible.INSTANCE)) {
            return false;
        }
        if (NewKotlinTypeCheckerKt.isClassType(subType)) {
            return false;
        }
        return this.hasPathByNotMarkedNullableNodes($receiver, subType, superType.getConstructor());
    }

    private final boolean hasNotNullSupertype(@NotNull TypeCheckerContext $receiver, SimpleType type2, TypeCheckerContext.SupertypesPolicy supertypesPolicy) {
        return $receiver.anySupertype$descriptors(type2, (Function1<? super SimpleType, Boolean>)((Function1)hasNotNullSupertype.1.INSTANCE), (Function1<? super SimpleType, ? extends TypeCheckerContext.SupertypesPolicy>)((Function1)new Function1<SimpleType, TypeCheckerContext.SupertypesPolicy>(supertypesPolicy){
            final /* synthetic */ TypeCheckerContext.SupertypesPolicy $supertypesPolicy;

            @NotNull
            public final TypeCheckerContext.SupertypesPolicy invoke(@NotNull SimpleType it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.isMarkedNullable() ? (TypeCheckerContext.SupertypesPolicy)TypeCheckerContext.SupertypesPolicy.None.INSTANCE : this.$supertypesPolicy;
            }
            {
                this.$supertypesPolicy = supertypesPolicy;
                super(1);
            }
        }));
    }

    private final boolean hasPathByNotMarkedNullableNodes(@NotNull TypeCheckerContext $receiver, SimpleType start, TypeConstructor end) {
        return $receiver.anySupertype$descriptors(start, (Function1<? super SimpleType, Boolean>)((Function1)new Function1<SimpleType, Boolean>(end){
            final /* synthetic */ TypeConstructor $end;

            public final boolean invoke(@NotNull SimpleType it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return !it.isMarkedNullable() && Intrinsics.areEqual((Object)it.getConstructor(), (Object)this.$end);
            }
            {
                this.$end = typeConstructor2;
                super(1);
            }
        }), (Function1<? super SimpleType, ? extends TypeCheckerContext.SupertypesPolicy>)((Function1)hasPathByNotMarkedNullableNodes.2.INSTANCE));
    }

    private NullabilityChecker() {
        INSTANCE = this;
    }

    static {
        new NullabilityChecker();
    }
}

