/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StartupActionScriptManager {
    public static final String STARTUP_WIZARD_MODE = "StartupWizardMode";
    private static final String ACTION_SCRIPT_FILE = "action.script";

    private StartupActionScriptManager() {
    }

    public static synchronized void executeActionScript() throws IOException {
        try {
            List<ActionCommand> commands = StartupActionScriptManager.loadActionScript();
            for (ActionCommand actionCommand : commands) {
                actionCommand.execute();
            }
        }
        finally {
            StartupActionScriptManager.saveActionScript(null);
        }
    }

    public static synchronized void addActionCommand(ActionCommand command) throws IOException {
        StartupActionScriptManager.addActionCommands(Collections.singletonList(command));
    }

    public static synchronized void addActionCommands(List<ActionCommand> commands) throws IOException {
        if (Boolean.getBoolean(STARTUP_WIZARD_MODE)) {
            for (ActionCommand command : commands) {
                command.execute();
            }
        } else {
            List<ActionCommand> script = StartupActionScriptManager.loadActionScript();
            script.addAll(commands);
            StartupActionScriptManager.saveActionScript(script);
        }
    }

    private static File getActionScriptFile() {
        return new File(PathManager.getPluginTempPath(), ACTION_SCRIPT_FILE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<ActionCommand> loadActionScript() throws IOException {
        File scriptFile = StartupActionScriptManager.getActionScriptFile();
        if (!scriptFile.isFile()) return new ArrayList<ActionCommand>();
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(scriptFile));){
            Object data = ois.readObject();
            if (data instanceof ActionCommand[]) {
                ArrayList<ActionCommand> arrayList = new ArrayList<ActionCommand>(Arrays.asList((ActionCommand[])data));
                return arrayList;
            }
            if (data instanceof List && ((List)data).size() == 0) {
                ArrayList<ActionCommand> arrayList = new ArrayList<ActionCommand>();
                return arrayList;
            }
            throw new IOException("Unexpected object: " + data + "/" + data.getClass());
        }
        catch (ReflectiveOperationException e) {
            throw new IOException("Stream error: " + scriptFile, e);
        }
    }

    private static void saveActionScript(@Nullable List<ActionCommand> commands) throws IOException {
        File scriptFile = StartupActionScriptManager.getActionScriptFile();
        if (commands != null) {
            File tempDir = scriptFile.getParentFile();
            if (!tempDir.exists() && !tempDir.mkdirs()) {
                throw new IOException("Cannot create directory: " + tempDir);
            }
            try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(scriptFile, false));){
                oos.writeObject(commands.toArray(ActionCommand.EMPTY_ARRAY));
            }
        } else if (scriptFile.exists()) {
            FileUtilRt.delete((File)scriptFile);
        }
    }

    public static class DeleteCommand
    implements Serializable,
    ActionCommand {
        private static final long serialVersionUID = 201708031943L;
        private final String mySource;

        public DeleteCommand(@NotNull File source) {
            if (source == null) {
                DeleteCommand.$$$reportNull$$$0(0);
            }
            this.mySource = source.getAbsolutePath();
        }

        @Override
        public void execute() throws IOException {
            File source = new File(this.mySource);
            if (source.exists() && !FileUtilRt.delete((File)source)) {
                throw new IOException("Cannot delete: " + source);
            }
        }

        public String toString() {
            return "delete[" + this.mySource + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/ide/startup/StartupActionScriptManager$DeleteCommand", "<init>"));
        }
    }

    public static class UnzipCommand
    implements Serializable,
    ActionCommand {
        private static final long serialVersionUID = 201708031943L;
        private final String mySource;
        private final String myDestination;
        private final FilenameFilter myFilenameFilter;

        public UnzipCommand(@NotNull File source, @NotNull File destination) {
            if (source == null) {
                UnzipCommand.$$$reportNull$$$0(0);
            }
            if (destination == null) {
                UnzipCommand.$$$reportNull$$$0(1);
            }
            this(source, destination, null);
        }

        public UnzipCommand(@NotNull File source, @NotNull File destination, FilenameFilter filenameFilter) {
            if (source == null) {
                UnzipCommand.$$$reportNull$$$0(2);
            }
            if (destination == null) {
                UnzipCommand.$$$reportNull$$$0(3);
            }
            this.mySource = source.getAbsolutePath();
            this.myDestination = destination.getAbsolutePath();
            this.myFilenameFilter = filenameFilter;
        }

        @Override
        public void execute() throws IOException {
            File source = new File(this.mySource);
            File destination = new File(this.myDestination);
            if (!source.isFile()) {
                throw new IOException("Source file missing: " + source);
            }
            File destDir = destination.getParentFile();
            if (!destDir.exists() && !destDir.mkdirs()) {
                throw new IOException("Cannot create directory: " + destDir);
            }
            ZipUtil.extract((File)source, (File)destination, (FilenameFilter)this.myFilenameFilter);
        }

        public String toString() {
            return "unzip[" + this.mySource + "," + this.myDestination + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "source";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "destination";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/startup/StartupActionScriptManager$UnzipCommand";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CopyCommand
    implements Serializable,
    ActionCommand {
        private static final long serialVersionUID = 201708031943L;
        private final String mySource;
        private final String myDestination;

        public CopyCommand(@NotNull File source, @NotNull File destination) {
            if (source == null) {
                CopyCommand.$$$reportNull$$$0(0);
            }
            if (destination == null) {
                CopyCommand.$$$reportNull$$$0(1);
            }
            this.mySource = source.getAbsolutePath();
            this.myDestination = destination.getAbsolutePath();
        }

        @Override
        public void execute() throws IOException {
            File source = new File(this.mySource);
            File destination = new File(this.myDestination);
            if (!source.isFile()) {
                throw new IOException("Source file missing: " + source);
            }
            File destDir = destination.getParentFile();
            if (!destDir.exists() && !destDir.mkdirs()) {
                throw new IOException("Cannot create directory: " + destDir);
            }
            FileUtilRt.copy((File)source, (File)destination);
        }

        public String toString() {
            return "copy[" + this.mySource + "," + this.myDestination + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "source";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "destination";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/startup/StartupActionScriptManager$CopyCommand";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ActionCommand {
        public static final ActionCommand[] EMPTY_ARRAY = new ActionCommand[0];

        public void execute() throws IOException;
    }
}

