/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.template.impl.TemplateImplUtil;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.ui.HintHint;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class SubstitutionShortInfoHandler
implements DocumentListener,
EditorMouseMotionListener,
CaretListener {
    private static final Key<SubstitutionShortInfoHandler> LISTENER_KEY = Key.create((String)"sslistener.key");
    private static final TooltipGroup SS_INFO_TOOLTIP_GROUP = new TooltipGroup("SS_INFO_TOOLTIP_GROUP", 0);
    private long modificationTimeStamp;
    private final ArrayList<Variable> variables;
    private final Editor editor;
    public static final Key<Configuration> CURRENT_CONFIGURATION_KEY = Key.create((String)"SS.CurrentConfiguration");

    SubstitutionShortInfoHandler(@NotNull Editor _editor) {
        if (_editor == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(0);
        }
        this.variables = new ArrayList();
        this.editor = _editor;
    }

    public void mouseMoved(EditorMouseEvent e) {
        LogicalPosition position = this.editor.xyToLogicalPosition(e.getMouseEvent().getPoint());
        this.handleInputFocusMovement(position);
    }

    private void handleInputFocusMovement(LogicalPosition position) {
        int start;
        this.checkModelValidity();
        int offset = this.editor.logicalPositionToOffset(position);
        int length = this.editor.getDocument().getTextLength();
        CharSequence elements = this.editor.getDocument().getCharsSequence();
        for (start = offset - 1; start >= 0 && Character.isJavaIdentifierPart(elements.charAt(start)) && elements.charAt(start) != '$'; --start) {
        }
        String text = "";
        int end = -1;
        if (start >= 0 && elements.charAt(start) == '$') {
            for (end = offset; end < length && Character.isJavaIdentifierPart(elements.charAt(end)) && elements.charAt(end) != '$'; ++end) {
            }
            if (end < length && elements.charAt(end) == '$') {
                String varname = elements.subSequence(start + 1, end).toString();
                Variable foundVar = null;
                for (Variable var : this.variables) {
                    if (!var.getName().equals(varname)) continue;
                    foundVar = var;
                    break;
                }
                if (foundVar != null) {
                    text = SubstitutionShortInfoHandler.getShortParamString((Configuration)this.editor.getUserData(CURRENT_CONFIGURATION_KEY), varname);
                }
            }
        }
        if (text.length() > 0) {
            SubstitutionShortInfoHandler.showTooltip(this.editor, start, end + 1, text);
        } else {
            TooltipController.getInstance().cancelTooltips();
        }
    }

    private void checkModelValidity() {
        Document document = this.editor.getDocument();
        if (this.modificationTimeStamp != document.getModificationStamp()) {
            this.variables.clear();
            this.variables.addAll(TemplateImplUtil.parseVariables((CharSequence)document.getCharsSequence()).values());
            this.modificationTimeStamp = document.getModificationStamp();
        }
    }

    public void mouseDragged(EditorMouseEvent e) {
    }

    public void caretPositionChanged(CaretEvent e) {
        this.handleInputFocusMovement(e.getNewPosition());
    }

    public ArrayList<Variable> getVariables() {
        this.checkModelValidity();
        return this.variables;
    }

    private static String getShortParamString(Configuration config, String varname) {
        if (config == null) {
            return "";
        }
        return SubstitutionShortInfoHandler.getShortParamString(config.findVariable(varname));
    }

    @NotNull
    static String getShortParamString(NamedScriptableDefinition namedScriptableDefinition) {
        String script;
        if (namedScriptableDefinition == null) {
            String string = SSRBundle.message("no.constraints.specified.tooltip.message", new Object[0]);
            if (string == null) {
                SubstitutionShortInfoHandler.$$$reportNull$$$0(1);
            }
            return string;
        }
        StringBuilder buf = new StringBuilder();
        if (namedScriptableDefinition instanceof MatchVariableConstraint) {
            String name;
            String text;
            MatchVariableConstraint constraint = (MatchVariableConstraint)namedScriptableDefinition;
            if (constraint.isPartOfSearchResults()) {
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("target.tooltip.message", new Object[0]));
            }
            if (constraint.getRegExp() != null && !constraint.getRegExp().isEmpty()) {
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("text.tooltip.message", constraint.isInvertRegExp() ? SSRBundle.message("not.tooltip.message", new Object[0]) : "", constraint.getRegExp()));
            }
            if (constraint.isWithinHierarchy() || constraint.isStrictlyWithinHierarchy()) {
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("within.hierarchy.tooltip.message", new Object[0]));
            }
            if (!StringUtil.isEmpty((String)constraint.getReferenceConstraint())) {
                text = StringUtil.unquoteString((String)constraint.getReferenceConstraint());
                SubstitutionShortInfoHandler.append(buf, "reference target matches: " + text);
            }
            if (constraint.getNameOfExprType() != null && !constraint.getNameOfExprType().isEmpty()) {
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("exprtype.tooltip.message", constraint.isInvertExprType() ? SSRBundle.message("not.tooltip.message", new Object[0]) : "", constraint.getNameOfExprType(), constraint.isExprTypeWithinHierarchy() ? SSRBundle.message("supertype.tooltip.message", new Object[0]) : ""));
            }
            if (constraint.getNameOfFormalArgType() != null && !constraint.getNameOfFormalArgType().isEmpty()) {
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("expected.type.tooltip.message", constraint.isInvertFormalType() ? SSRBundle.message("not.tooltip.message", new Object[0]) : "", constraint.getNameOfFormalArgType(), constraint.isFormalArgTypeWithinHierarchy() ? SSRBundle.message("supertype.tooltip.message", new Object[0]) : ""));
            }
            if (StringUtil.isNotEmpty((String)constraint.getWithinConstraint())) {
                text = StringUtil.unquoteString((String)constraint.getWithinConstraint());
                SubstitutionShortInfoHandler.append(buf, constraint.isInvertWithinConstraint() ? SSRBundle.message("not.within.constraints.tooltip.message", text) : SSRBundle.message("within.constraints.tooltip.message", text));
            }
            if (!"__context__".equals(name = constraint.getName())) {
                if (constraint.getMinCount() == constraint.getMaxCount()) {
                    SubstitutionShortInfoHandler.append(buf, SSRBundle.message("occurs.tooltip.message", constraint.getMinCount()));
                } else {
                    SubstitutionShortInfoHandler.append(buf, SSRBundle.message("min.occurs.tooltip.message", constraint.getMinCount(), constraint.getMaxCount() == Integer.MAX_VALUE ? StringUtil.decapitalize((String)SSRBundle.message("editvarcontraints.unlimited", new Object[0])) : Integer.valueOf(constraint.getMaxCount())));
                }
            }
        }
        if ((script = namedScriptableDefinition.getScriptCodeConstraint()) != null && script.length() > 2) {
            String str = SSRBundle.message("script.tooltip.message", StringUtil.unquoteString((String)script));
            SubstitutionShortInfoHandler.append(buf, str);
        }
        if (buf.length() == 0) {
            String string = SSRBundle.message("no.constraints.specified.tooltip.message", new Object[0]);
            if (string == null) {
                SubstitutionShortInfoHandler.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = buf.toString();
        if (string == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static void append(StringBuilder buf, String str) {
        if (buf.length() > 0) {
            buf.append(", ");
        }
        buf.append(str);
    }

    private static void showTooltip(@NotNull Editor editor, int start, int end, @NotNull String text) {
        if (editor == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(4);
        }
        if (text == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(5);
        }
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        Point left = editor.logicalPositionToXY(editor.offsetToLogicalPosition(start));
        int documentLength = editor.getDocument().getTextLength();
        if (end >= documentLength) {
            end = documentLength;
        }
        Point right = editor.logicalPositionToXY(editor.offsetToLogicalPosition(end));
        Point bestPoint = new Point(left.x + (right.x - left.x) / 2, right.y + editor.getLineHeight() / 2);
        if (visibleArea.x > bestPoint.x) {
            bestPoint.x = visibleArea.x;
        } else if (visibleArea.x + visibleArea.width < bestPoint.x) {
            bestPoint.x = visibleArea.x + visibleArea.width - 5;
        }
        Point p = SwingUtilities.convertPoint(editor.getContentComponent(), bestPoint, editor.getComponent().getRootPane().getLayeredPane());
        HintHint hint = new HintHint(editor, bestPoint).setAwtTooltip(true).setHighlighterType(true).setShowImmediately(true).setCalloutShift(editor.getLineHeight() / 2 - 1);
        TooltipController.getInstance().showTooltip(editor, p, StringUtil.escapeXml((String)text), visibleArea.width, false, SS_INFO_TOOLTIP_GROUP, hint);
    }

    static SubstitutionShortInfoHandler retrieve(Editor editor) {
        return (SubstitutionShortInfoHandler)editor.getUserData(LISTENER_KEY);
    }

    static void install(Editor editor) {
        SubstitutionShortInfoHandler handler = new SubstitutionShortInfoHandler(editor);
        editor.addEditorMouseMotionListener((EditorMouseMotionListener)handler);
        editor.getDocument().addDocumentListener((DocumentListener)handler);
        editor.getCaretModel().addCaretListener((CaretListener)handler);
        editor.putUserData(LISTENER_KEY, (Object)handler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_editor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/SubstitutionShortInfoHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/SubstitutionShortInfoHandler";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortParamString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showTooltip";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

