/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.VisitedModelsDelegateProcessor;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class CachedLocalModel
implements CommonSpringModel {
    private volatile Collection<SpringBeanPointer> myLocalBeans;
    private final AtomicNotNullLazyValue<Collection<SpringBeanPointer>> myLocalDomBeans = new AtomicNotNullLazyValue<Collection<SpringBeanPointer>>(){

        @NotNull
        protected Collection<SpringBeanPointer> compute() {
            Collection<SpringBeanPointer> collection = CachedLocalModel.this.calculateDomBeans();
            if (collection == null) {
                1.$$$reportNull$$$0(0);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/CachedLocalModel$1", "compute"));
        }
    };
    private final Map<SpringQualifier, List<SpringBeanPointer>> myLocalBeansByQualifier = ConcurrentFactoryMap.createMap(key -> this.computeLocalBeansByQualifier((SpringQualifier)key));

    @Override
    @NotNull
    public final Collection<SpringBeanPointer> getAllCommonBeans() {
        LinkedHashSet pointers = ContainerUtil.newLinkedHashSet();
        this.processAllBeans((Processor<SpringBeanPointer>)Processors.cancelableCollectProcessor((Collection)pointers));
        Set<SpringBeanPointer> set = Collections.unmodifiableSet(pointers);
        if (set == null) {
            CachedLocalModel.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    public boolean processAllBeans(@NotNull Processor<SpringBeanPointer> processor) {
        if (processor == null) {
            CachedLocalModel.$$$reportNull$$$0(1);
        }
        return this.processAllBeansRelatedModels(CachedLocalModel.getDelegateProcessor(processor));
    }

    public Collection<SpringBeanPointer> getLocalBeans() {
        return this.myLocalBeans == null ? (this.myLocalBeans = this.calculateLocalBeans()) : this.myLocalBeans;
    }

    @Override
    @NotNull
    public final Collection<SpringBeanPointer> getAllDomBeans() {
        Collection collection = (Collection)this.myLocalDomBeans.getValue();
        if (collection == null) {
            CachedLocalModel.$$$reportNull$$$0(2);
        }
        return collection;
    }

    protected Iterable<CommonSpringModel> getRelatedModels() {
        return Collections.emptySet();
    }

    protected abstract Collection<SpringBeanPointer> calculateLocalBeans();

    protected abstract Collection<SpringBeanPointer> calculateDomBeans();

    @Override
    @NotNull
    public List<SpringBeanPointer> findQualifiedBeans(@NotNull SpringQualifier qualifier) {
        if (qualifier == null) {
            CachedLocalModel.$$$reportNull$$$0(3);
        }
        List<SpringBeanPointer> list = this.myLocalBeansByQualifier.get(qualifier);
        if (list == null) {
            CachedLocalModel.$$$reportNull$$$0(4);
        }
        return list;
    }

    private List<SpringBeanPointer> computeLocalBeansByQualifier(SpringQualifier springQualifier) {
        SmartList beans = new SmartList();
        Collection<SpringBeanPointer> pointers = this.getAllCommonBeans();
        for (SpringBeanPointer beanPointer : pointers) {
            if (!beanPointer.isValid()) continue;
            Object bean = beanPointer.getSpringBean();
            for (SpringQualifier qualifier : bean.getSpringQualifiers()) {
                if (!qualifier.compareQualifiers(springQualifier, this.getModule())) continue;
                beans.add(beanPointer);
            }
        }
        return beans.isEmpty() ? Collections.emptyList() : beans;
    }

    public boolean processRelatedModels(@NotNull Processor<CommonSpringModel> processor) {
        Boolean aBoolean;
        if (processor == null) {
            CachedLocalModel.$$$reportNull$$$0(5);
        }
        return (aBoolean = (Boolean)RecursionManager.doPreventingRecursion((Object)this, (boolean)false, () -> {
            if (processor == null) {
                CachedLocalModel.$$$reportNull$$$0(15);
            }
            for (CommonSpringModel model : this.getRelatedModels()) {
                ProgressManager.checkCanceled();
                if (processor.process((Object)model)) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        })) == null ? true : aBoolean;
    }

    @Override
    public boolean processByClass(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<SpringBeanPointer> processor) {
        if (params == null) {
            CachedLocalModel.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            CachedLocalModel.$$$reportNull$$$0(7);
        }
        if (!params.canSearch()) {
            return true;
        }
        return this.processRelatedModels(params, (Processor<SpringBeanPointer>)CachedLocalModel.getDelegateProcessor(processor));
    }

    @Override
    public boolean processByName(@NotNull SpringModelSearchParameters.BeanName params, @NotNull Processor<SpringBeanPointer> processor) {
        if (params == null) {
            CachedLocalModel.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            CachedLocalModel.$$$reportNull$$$0(9);
        }
        if (!params.canSearch()) {
            return true;
        }
        return this.processRelatedModels(params, (Processor<SpringBeanPointer>)CachedLocalModel.getDelegateProcessor(processor));
    }

    protected boolean processAllBeansRelatedModels(Processor<SpringBeanPointer> processor) {
        return this.processRelatedModels((Processor<CommonSpringModel>)((Processor)model -> !CachedLocalModel.shouldProcess(model, processor) || model.processAllBeans(processor)));
    }

    protected boolean processRelatedModels(SpringModelSearchParameters.BeanClass params, Processor<SpringBeanPointer> processor) {
        return this.processRelatedModels((Processor<CommonSpringModel>)((Processor)model -> !CachedLocalModel.shouldProcess(model, processor) || model.processByClass(params, processor)));
    }

    protected boolean processRelatedModels(SpringModelSearchParameters.BeanName params, Processor<SpringBeanPointer> processor) {
        return this.processRelatedModels((Processor<CommonSpringModel>)((Processor)model -> !CachedLocalModel.shouldProcess(model, processor) || model.processByName(params, processor)));
    }

    private static boolean shouldProcess(@NotNull CommonSpringModel model, @NotNull Processor<SpringBeanPointer> processor) {
        if (model == null) {
            CachedLocalModel.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            CachedLocalModel.$$$reportNull$$$0(11);
        }
        if (processor instanceof VisitedModelsDelegateProcessor) {
            if (((VisitedModelsDelegateProcessor)processor).hasBeenVisited(model)) {
                return false;
            }
            ((VisitedModelsDelegateProcessor)processor).addVisited(model);
        }
        return true;
    }

    @NotNull
    private static VisitedModelsDelegateProcessor getDelegateProcessor(@NotNull Processor<SpringBeanPointer> processor) {
        if (processor == null) {
            CachedLocalModel.$$$reportNull$$$0(12);
        }
        if (processor instanceof VisitedModelsDelegateProcessor) {
            VisitedModelsDelegateProcessor visitedModelsDelegateProcessor = (VisitedModelsDelegateProcessor)processor;
            if (visitedModelsDelegateProcessor == null) {
                CachedLocalModel.$$$reportNull$$$0(13);
            }
            return visitedModelsDelegateProcessor;
        }
        VisitedModelsDelegateProcessor visitedModelsDelegateProcessor = new VisitedModelsDelegateProcessor(processor);
        if (visitedModelsDelegateProcessor == null) {
            CachedLocalModel.$$$reportNull$$$0(14);
        }
        return visitedModelsDelegateProcessor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/CachedLocalModel";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCommonBeans";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/CachedLocalModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDomBeans";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findQualifiedBeans";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegateProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processAllBeans";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findQualifiedBeans";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processRelatedModels";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processByClass";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processByName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcess";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDelegateProcessor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processRelatedModels$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

