/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.Choreographer;
import com.android.tools.adtui.EventData;
import com.android.tools.adtui.TimelineData;
import com.android.tools.adtui.common.AdtUiUtils;
import gnu.trove.TIntObjectHashMap;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TimelineComponent
extends AnimatedComponent {
    private static final int LEFT_MARGIN = 120;
    private static final int RIGHT_MARGIN = 200;
    private static final int TOP_MARGIN = 10;
    private static final int BOTTOM_MARGIN = 30;
    private static final float X_SCALE = 20.0f;
    private final float mBufferTime;
    @NotNull
    private final TimelineData mData;
    @NotNull
    private final EventData mEvents;
    private final float mInitialMax;
    private final float mAbsoluteMax;
    private final float mInitialMarkerSeparation;
    private Map<Integer, Style> mStyles;
    private boolean mFirstFrame;
    private boolean mStackStreams;
    private float mCurrentMax;
    private float mCurrentMin;
    private float mMarkerSeparation;
    private float mEvenMarkersAlpha;
    private int mBottom;
    private int mRight;
    private float mYScale;
    private float mEndTime;
    private float mBeginTime;
    private TIntObjectHashMap<EventInfo> mEventsInfo;
    private String mUnits;
    private int mSize;
    private float[] mTimes;
    private int[] mTypes;
    private final List<StreamComponent> mStreamComponents;
    private final List<LabelRow> mLabelRows;
    private final List<Listener> myListeners;
    private int mEventsSize;
    private float[] mEventStart;
    private float[] mEventEnd;
    private int[] mEventTypes;
    private float mEventProgressStart;
    private float mEventProgressDir;
    private float mEventProgress;
    private List<Reference> mReferences;

    public TimelineComponent(@NotNull TimelineData data, @NotNull EventData events, float bufferTime, float initialMax, float absoluteMax, float initialMarkerSeparation) {
        if (data == null) {
            TimelineComponent.$$$reportNull$$$0(0);
        }
        if (events == null) {
            TimelineComponent.$$$reportNull$$$0(1);
        }
        this.mStackStreams = true;
        this.mStreamComponents = new ArrayList<StreamComponent>();
        this.mLabelRows = new ArrayList<LabelRow>();
        this.myListeners = new ArrayList<Listener>();
        this.mEventProgressDir = 1.0f;
        this.mReferences = new ArrayList<Reference>();
        this.mData = data;
        this.mEvents = events;
        this.mBufferTime = bufferTime;
        this.mInitialMax = initialMax;
        this.mAbsoluteMax = absoluteMax;
        this.mInitialMarkerSeparation = initialMarkerSeparation;
        this.mSize = 0;
        this.mStyles = new HashMap<Integer, Style>();
        this.mUnits = "";
        this.mEventsInfo = new TIntObjectHashMap();
        this.setOpaque(true);
        for (int i = 0; i < this.mData.getStreamCount(); ++i) {
            this.addStream(this.mData.getStream(i).getId());
        }
        this.reset();
    }

    public void setStackStreams(boolean stackStreams) {
        this.mStackStreams = stackStreams;
    }

    public void configureStream(int stream, String name, Color color) {
        this.configureStream(stream, name, color, false);
    }

    public void configureStream(int stream, String name, Color color, boolean isMirrored) {
        assert (stream < this.mStreamComponents.size()) : String.format("Attempting to configure out of bounds stream: Stream: %1$d, Size %2$d", stream, this.mStreamComponents.size());
        StreamComponent streamComponent = this.mStreamComponents.get(stream);
        streamComponent.name = name;
        streamComponent.color = color;
        streamComponent.isMirrored = isMirrored;
    }

    private void addStream(String id) {
        int newStreamIndex = this.mStreamComponents.size();
        int streamValuesSize = this.mTimes != null ? this.mTimes.length : 0;
        StreamComponent component = new StreamComponent(streamValuesSize, id, Color.BLACK, false);
        this.mStreamComponents.add(component);
        this.mLabelRows.add(new LabelRow(component, null));
        for (Listener listener : this.myListeners) {
            listener.onStreamAdded(newStreamIndex, id);
        }
    }

    public boolean linkStreams(@NotNull String streamId1, @NotNull String streamId2) {
        if (streamId1 == null) {
            TimelineComponent.$$$reportNull$$$0(2);
        }
        if (streamId2 == null) {
            TimelineComponent.$$$reportNull$$$0(3);
        }
        assert (!streamId1.equals(streamId2)) : String.format("Attempt to link a stream %1$s with itself", streamId1);
        LabelRow labelRow1 = null;
        LabelRow labelRow2 = null;
        StreamComponent stream1 = null;
        StreamComponent stream2 = null;
        for (LabelRow row : this.mLabelRows) {
            if (row.stream1.id.equals(streamId1)) {
                labelRow1 = row;
                stream1 = row.stream1;
                continue;
            }
            if (!row.stream1.id.equals(streamId2)) continue;
            labelRow2 = row;
            stream2 = row.stream1;
        }
        if (stream1 != null && stream2 != null) {
            labelRow1.stream2 = stream2;
            this.mLabelRows.remove(labelRow2);
            return true;
        }
        return false;
    }

    public void addListener(@NotNull Listener listener) {
        if (listener == null) {
            TimelineComponent.$$$reportNull$$$0(4);
        }
        this.myListeners.add(listener);
    }

    public void configureEvent(int type, int stream, Icon icon, Color color, Color progress, boolean range) {
        this.mEventsInfo.put(type, (Object)new EventInfo(type, stream, icon, color, progress, range));
    }

    public void configureType(int type, Style style) {
        this.mStyles.put(type, style);
    }

    public void configureUnits(String units) {
        this.mUnits = units;
    }

    @Override
    public void reset() {
        super.reset();
        this.mCurrentMax = this.mInitialMax;
        this.mCurrentMin = 0.0f;
        this.mMarkerSeparation = this.mInitialMarkerSeparation;
        this.mEvenMarkersAlpha = 1.0f;
        this.mFirstFrame = true;
    }

    @Override
    protected void draw(Graphics2D g2d, Dimension dim) {
        this.mBottom = Math.max(10, dim.height - 30);
        this.mRight = Math.max(120, dim.width - 200);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        g2d.setClip(0, 0, dim.width, dim.height);
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, dim.width, dim.height);
        g2d.setClip(120, 10, this.mRight - 120, this.mBottom - 10);
        this.drawTimelineData(g2d);
        this.drawEvents(g2d);
        g2d.setClip(0, 0, dim.width, dim.height);
        this.drawLabels(g2d);
        this.drawTimeMarkers(g2d);
        this.drawMarkers(g2d);
        this.drawReferenceLines(g2d);
        this.drawGuides(g2d);
        this.mFirstFrame = false;
    }

    @Override
    protected void debugDraw(Graphics2D g2d) {
        int drawn = 0;
        g2d.setFont((Font)AdtUiUtils.DEFAULT_FONT.deriveFont(5.0f));
        for (int i = 0; i < this.mSize; ++i) {
            if (!(this.mTimes[i] > this.mBeginTime) || !(this.mTimes[i] < this.mEndTime)) continue;
            for (int j = 0; j < this.mStreamComponents.size(); ++j) {
                int x = (int)this.timeToX(this.mTimes[i]);
                int y = (int)this.valueToY(this.mStreamComponents.get((int)j).values[i]);
                g2d.setColor(new Color(17 * this.mTypes[i] % 255, 121 * this.mTypes[i] % 255, 71 * this.mTypes[i] % 255));
                g2d.drawLine(x, y - 2, x, y + 2);
                g2d.drawLine(x - 2, y, x + 2, y);
                g2d.setColor(AdtUiUtils.DEFAULT_FONT_COLOR);
            }
            ++drawn;
        }
        this.addDebugInfo("Drawn samples: %d", drawn);
    }

    private void drawTimelineData(Graphics2D g2d) {
        this.mYScale = (float)(this.mBottom - 10) / (this.mCurrentMax - this.mCurrentMin);
        if (this.mSize > 1) {
            int from;
            for (from = 0; from < this.mSize - 1 && this.mTimes[from + 1] < this.mBeginTime; ++from) {
            }
            int to = from;
            while (to + 1 < this.mSize && this.mTimes[to] <= this.mEndTime) {
                ++to;
            }
            if (from == to) {
                return;
            }
            int drawnSegments = 0;
            for (int j = this.mStreamComponents.size() - 1; j >= 0; --j) {
                Path2D.Float path = new Path2D.Float();
                path.moveTo(this.timeToX(this.mTimes[from]), this.valueToY(0.0f));
                float[] values = this.mStreamComponents.get((int)j).values;
                for (int i = from; i <= to; ++i) {
                    path.lineTo(this.timeToX(this.mTimes[i]), this.valueToY(Math.min(values[i], this.mAbsoluteMax)));
                }
                path.lineTo(this.timeToX(this.mTimes[to]), this.valueToY(0.0f));
                g2d.setColor(this.mStreamComponents.get((int)j).color);
                g2d.fill(path);
                if (this.mStyles.isEmpty()) continue;
                path = new Path2D.Float();
                Stroke current = g2d.getStroke();
                float step = 3.0f;
                float x0 = this.timeToX(this.mTimes[from]);
                float y0 = this.valueToY(values[from]);
                g2d.setColor(this.mStreamComponents.get((int)j).color.darker());
                BasicStroke stroke = null;
                float strokeScale = Float.NaN;
                for (int i = from + 1; i <= to; ++i) {
                    float x1 = this.timeToX(this.mTimes[i]);
                    float y1 = this.valueToY(values[i]);
                    Style style = this.mStyles.get(this.mTypes[i]);
                    if (style != null && style != Style.NONE) {
                        BasicStroke str = new BasicStroke(1.0f);
                        float scale = 0.0f;
                        if (style == Style.DASHED) {
                            float distance = (float)Point2D.distance(x0, y0, x1, y1);
                            float delta = this.mTimes[i] * 20.0f;
                            scale = distance / (x1 - x0);
                            float dash = step * scale;
                            float dashPhase = delta * scale % (step * scale * 2.0f);
                            if (dash > 0.0f && dashPhase >= 0.0f) {
                                str = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{dash}, dashPhase);
                            }
                        }
                        if (scale != strokeScale) {
                            if (stroke != null) {
                                g2d.setStroke(stroke);
                                g2d.draw(path);
                                path.reset();
                                ++drawnSegments;
                            }
                            strokeScale = scale;
                            stroke = str;
                            path.moveTo(x0, y0);
                        }
                        path.lineTo(x1, y1);
                    }
                    x0 = x1;
                    y0 = y1;
                }
                if (stroke != null) {
                    g2d.setStroke(stroke);
                    g2d.draw(path);
                    ++drawnSegments;
                }
                g2d.setStroke(current);
            }
            this.addDebugInfo("Drawn segments: %d", drawnSegments);
        }
        this.addDebugInfo("Total samples: %d", this.mSize);
    }

    private float interpolate(int stream, int sample, float time) {
        int prev = sample > 0 ? sample - 1 : 0;
        int next = sample < this.mSize ? sample : this.mSize - 1;
        float[] values = this.mStreamComponents.get((int)stream).values;
        float a = values[prev];
        float b = values[next];
        float delta = this.mTimes[next] - this.mTimes[prev];
        float ratio = delta != 0.0f ? (time - this.mTimes[prev]) / delta : 1.0f;
        return (b - a) * ratio + a;
    }

    private void drawEvents(Graphics2D g2d) {
        if (this.mSize > 0) {
            int drawnEvents = 0;
            AffineTransform tx = g2d.getTransform();
            Stroke stroke = g2d.getStroke();
            int s = 0;
            int e = 0;
            while (e < this.mEventsSize) {
                if (s < this.mSize && this.mTimes[s] < this.mEventStart[e]) {
                    ++s;
                    continue;
                }
                if (Float.isNaN(this.mEventEnd[e]) || this.mEventEnd[e] > this.mBeginTime && this.mEventEnd[e] > this.mTimes[0]) {
                    boolean closed;
                    ++drawnEvents;
                    EventInfo info = (EventInfo)this.mEventsInfo.get(this.mEventTypes[e]);
                    float x = this.timeToX(this.mEventStart[e]);
                    float y = this.valueToY(this.interpolate(info.stream, s, this.mEventStart[e]));
                    AffineTransform dt = new AffineTransform(tx);
                    dt.translate(x, y);
                    g2d.setTransform(dt);
                    info.icon.paintIcon(this, g2d, -info.icon.getIconWidth() / 2, -info.icon.getIconHeight() - 5);
                    g2d.setTransform(tx);
                    g2d.setStroke(new BasicStroke(1.5f, 1, 1));
                    Path2D.Float p = new Path2D.Float();
                    boolean bl = closed = !Float.isNaN(this.mEventEnd[e]);
                    if (info.range) {
                        int i;
                        p.moveTo(x, this.mBottom);
                        p.lineTo(x, y);
                        float endTime = Float.isNaN(this.mEventEnd[e]) ? this.mEndTime : this.mEventEnd[e];
                        float[] values = this.mStreamComponents.get((int)info.stream).values;
                        for (i = s; i < this.mSize && this.mTimes[i] < endTime; ++i) {
                            p.lineTo(this.timeToX(this.mTimes[i]), this.valueToY(values[i]));
                        }
                        p.lineTo(this.timeToX(endTime), this.valueToY(this.interpolate(info.stream, i, endTime)));
                        p.lineTo(this.timeToX(closed ? this.mEventEnd[e] : endTime), this.valueToY(0.0f));
                        if (info.color != null) {
                            g2d.setColor(info.color);
                            g2d.fill(p);
                        }
                        g2d.setColor(info.progress);
                        g2d.draw(p);
                    } else {
                        p.moveTo(x, y - 2.0f);
                        p.lineTo(x, y + 2.0f);
                        g2d.setColor(info.progress);
                        g2d.draw(p);
                    }
                    if (!closed) {
                        g2d.setColor(info.progress);
                        float end = 360.0f * this.mEventProgress;
                        float start = this.mEventProgressStart;
                        if (this.mEventProgressDir < 0.0f) {
                            start += end;
                            end = 360.0f - end;
                        }
                        g2d.draw(new Arc2D.Float(x + (float)(info.icon.getIconWidth() / 2) + 3.0f, y - (float)info.icon.getIconHeight() - 3.0f, 6.0f, 6.0f, start, end, 0));
                    }
                    ++e;
                    continue;
                }
                ++e;
            }
            g2d.setStroke(stroke);
            this.addDebugInfo("Drawn events: %d", drawnEvents);
        }
    }

    private float valueToY(float val) {
        return (float)this.mBottom - (val - this.mCurrentMin) * this.mYScale;
    }

    private float timeToX(float time) {
        return 120.0f + (time - this.mBeginTime) * 20.0f;
    }

    private void drawLabels(Graphics2D g2d) {
        g2d.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        FontMetrics metrics = g2d.getFontMetrics();
        int y = 25;
        int i = this.mLabelRows.size() - 1;
        while (i >= 0 && this.mSize > 0) {
            LabelRow labelRow = this.mLabelRows.get(i);
            StreamComponent stream1 = labelRow.stream1;
            if (labelRow.stream2 == null) {
                g2d.setColor(stream1.color);
                g2d.fillRect(this.mRight + 20, y, 15, 15);
                g2d.setColor(AdtUiUtils.DEFAULT_FONT_COLOR);
                g2d.drawString(String.format("%s [%.2f %s]", stream1.name, Float.valueOf(stream1.currentValue), this.mUnits), (float)(this.mRight + 40), (float)(y + 7) + (float)metrics.getAscent() * 0.5f);
            } else {
                StreamComponent stream2 = labelRow.stream2;
                this.fillTriangle(new Point(this.mRight + 20, y), new Point(this.mRight + 35, y), new Point(this.mRight + 20, y + 15), stream2.color, g2d);
                this.fillTriangle(new Point(this.mRight + 35, y), new Point(this.mRight + 35, y + 15), new Point(this.mRight + 20, y + 15), stream1.color, g2d);
                g2d.setColor(AdtUiUtils.DEFAULT_FONT_COLOR);
                g2d.drawString(String.format("%1$s, %2$s [%3$.2f %4$s, %5$.2f %6$s]", stream1.name, stream2.name, Float.valueOf(stream1.currentValue), this.mUnits, Float.valueOf(stream2.currentValue), this.mUnits), (float)(this.mRight + 40), (float)(y + 7) + (float)metrics.getAscent() * 0.5f);
            }
            --i;
            y += 20;
        }
    }

    private void fillTriangle(Point p1, Point p2, Point p3, Color color, Graphics2D g2d) {
        g2d.setColor(color);
        Path2D.Float path = new Path2D.Float();
        ((Path2D)path).moveTo(p1.getX(), p1.getY());
        ((Path2D)path).lineTo(p2.getX(), p2.getY());
        ((Path2D)path).lineTo(p3.getX(), p3.getY());
        ((Path2D)path).lineTo(p1.getX(), p1.getY());
        g2d.fill(path);
    }

    private void drawTimeMarkers(Graphics2D g2d) {
        g2d.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        g2d.setColor(AdtUiUtils.DEFAULT_FONT_COLOR);
        FontMetrics metrics = g2d.getFontMetrics();
        float offset = (float)metrics.stringWidth("000") * 0.5f;
        Path2D.Float lines = new Path2D.Float();
        float zeroY = this.valueToY(0.0f);
        int sec = Math.max((int)Math.ceil(this.mBeginTime), 0);
        while ((float)sec < this.mEndTime) {
            boolean big;
            float x = this.timeToX(sec);
            boolean bl = big = sec % 5 == 0;
            if (big) {
                String text = TimelineComponent.formatTime(sec);
                g2d.drawString(text, x - (float)metrics.stringWidth(text) + offset, zeroY + (float)metrics.getAscent() + 5.0f);
            }
            lines.moveTo(x, zeroY);
            lines.lineTo(x, zeroY + (float)(big ? 5 : 2));
            ++sec;
        }
        g2d.draw(lines);
    }

    static String formatTime(int seconds) {
        char[] suffix = new char[]{'h', 'm', 's'};
        int[] secsPer = new int[]{3600, 60, 1};
        StringBuilder sb = new StringBuilder(12);
        for (int i = 0; i < suffix.length; ++i) {
            int value = seconds / secsPer[i];
            seconds %= secsPer[i];
            if (value == 0 && sb.length() == 0 && i != suffix.length - 1) continue;
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(value);
            sb.append(suffix[i]);
        }
        return sb.toString();
    }

    private void drawMarkers(Graphics2D g2d) {
        int minimumGap;
        int zeroY;
        this.drawMarkers(g2d, 1.0f, this.mCurrentMax);
        this.drawMarkers(g2d, -1.0f, this.mCurrentMin);
        if (this.mCurrentMin < 0.0f && this.mBottom - (zeroY = (int)this.valueToY(0.0f)) > (minimumGap = this.getFontMetrics((Font)AdtUiUtils.DEFAULT_FONT).getAscent()) && zeroY - 10 > minimumGap) {
            this.drawValueMarker(0.0f, zeroY, g2d);
        }
    }

    private void drawMarkers(Graphics2D g2d, float direction, float max) {
        if (this.mYScale <= 0.0f) {
            return;
        }
        boolean drawNegativeMarkersAsPositive = this.hasMirroredStream();
        int markers = (int)(max / this.mMarkerSeparation * direction);
        for (int i = 0; i < markers + 1; ++i) {
            float markerValue = (float)(i + 1) * this.mMarkerSeparation * direction;
            int y = (int)this.valueToY(markerValue);
            if (direction * (max - markerValue) < this.mMarkerSeparation * 0.5f) {
                markerValue = max;
                i = markers;
                y = (int)this.valueToY(max);
            }
            if (i < markers && i % 2 == 0 && this.mEvenMarkersAlpha < 1.0f) {
                g2d.setColor(new Color(AdtUiUtils.DEFAULT_FONT_COLOR.getColorSpace(), AdtUiUtils.DEFAULT_FONT_COLOR.getColorComponents(null), this.mEvenMarkersAlpha));
            } else {
                g2d.setColor(AdtUiUtils.DEFAULT_FONT_COLOR);
            }
            g2d.drawLine(118, y, 120, y);
            this.drawValueMarker(drawNegativeMarkersAsPositive ? Math.abs(markerValue) : markerValue, y, g2d);
        }
    }

    private void drawValueMarker(float value, int y, Graphics2D g2d) {
        FontMetrics metrics = this.getFontMetrics((Font)AdtUiUtils.DEFAULT_FONT);
        String marker = String.format("%.2f %s", Float.valueOf(value), this.mUnits);
        g2d.drawString(marker, (float)(110 - metrics.stringWidth(marker)), (float)y + (float)metrics.getAscent() * 0.5f);
    }

    private boolean hasMirroredStream() {
        for (int i = 0; i < this.mStreamComponents.size(); ++i) {
            if (!this.mStreamComponents.get((int)i).isMirrored) continue;
            return true;
        }
        return false;
    }

    private void drawReferenceLines(Graphics2D g2d) {
        for (Reference reference : this.mReferences) {
            if (!(reference.value <= this.mCurrentMax) || !(reference.value >= this.mCurrentMin)) continue;
            g2d.setColor(reference.color);
            int y = (int)this.valueToY(reference.value);
            g2d.drawLine(120, y, this.mRight, y);
        }
    }

    public void addReference(float reference, @NotNull Color color) {
        if (color == null) {
            TimelineComponent.$$$reportNull$$$0(5);
        }
        this.mReferences.add(new Reference(reference, color));
    }

    private void drawGuides(Graphics2D g2d) {
        g2d.setColor(AdtUiUtils.DEFAULT_FONT_COLOR);
        int zeroY = (int)this.valueToY(0.0f);
        g2d.drawLine(110, zeroY, this.mRight + 10, zeroY);
        if (this.mYScale > 0.0f) {
            g2d.drawLine(120, this.mBottom, 120, 10);
            g2d.drawLine(this.mRight, this.mBottom, this.mRight, 10);
        }
    }

    private void removeStreamFromLabelRow(StreamComponent streamComponent) {
        Iterator<LabelRow> iterator = this.mLabelRows.iterator();
        while (iterator.hasNext()) {
            LabelRow labelRow = iterator.next();
            if (streamComponent.equals(labelRow.stream1)) {
                if (labelRow.stream2 != null) {
                    labelRow.stream1 = labelRow.stream2;
                    labelRow.stream2 = null;
                    break;
                }
                iterator.remove();
                break;
            }
            if (!streamComponent.equals(labelRow.stream2)) continue;
            labelRow.stream2 = null;
            break;
        }
    }

    private void updateStreams() {
        int streamCountFromData = this.mData.getStreamCount();
        int streamIndex = 0;
        Iterator<StreamComponent> iterator = this.mStreamComponents.iterator();
        while (iterator.hasNext()) {
            StreamComponent streamComponent = iterator.next();
            if (streamIndex < streamCountFromData && streamComponent.id.equals(this.mData.getStream(streamIndex).getId())) {
                ++streamIndex;
                continue;
            }
            iterator.remove();
            this.removeStreamFromLabelRow(streamComponent);
        }
        for (int i = streamIndex; i < streamCountFromData; ++i) {
            this.addStream(this.mData.getStream(i).getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateData() {
        long start;
        Object object = this.mData;
        synchronized (object) {
            float lastUpdatedTime;
            this.updateStreams();
            start = this.mData.getStartTime();
            this.mSize = this.mData.size();
            float f = lastUpdatedTime = this.mTimes != null ? this.mTimes[this.mTimes.length - 1] : 0.0f;
            if (this.mTimes == null || this.mTimes.length < this.mSize) {
                int alloc = Math.max(this.mSize, this.mTimes == null ? 64 : this.mTimes.length * 2);
                this.mTimes = new float[alloc];
                this.mTypes = new int[alloc];
                for (int j = 0; j < this.mData.getStreamCount(); ++j) {
                    this.mStreamComponents.get((int)j).values = new float[alloc];
                }
            }
            for (int i = 0; i < this.mSize; ++i) {
                TimelineData.SampleInfo info = this.mData.getSampleInfo(i);
                this.mTimes[i] = info.time;
                this.mTypes[i] = info.type;
            }
            float cappedMax = 0.0f;
            float cappedMin = 0.0f;
            StreamComponent lastStreamForNonMirroredStack = null;
            StreamComponent lastStreamForMirroredStack = null;
            for (int streamIndex = 0; streamIndex < this.mStreamComponents.size(); ++streamIndex) {
                StreamComponent streamComponent = this.mStreamComponents.get(streamIndex);
                TimelineData.Stream streamFromData = this.mData.getStream(streamIndex);
                for (int i = 0; i < this.mSize; ++i) {
                    float value = streamFromData.get(i);
                    if (streamComponent.isMirrored) {
                        value = -Math.abs(value);
                    }
                    if (this.mStackStreams) {
                        if (streamComponent.isMirrored && lastStreamForMirroredStack != null) {
                            value += lastStreamForMirroredStack.values[i];
                        } else if (!streamComponent.isMirrored && lastStreamForNonMirroredStack != null) {
                            value += lastStreamForNonMirroredStack.values[i];
                        }
                    }
                    streamComponent.values[i] = value;
                    if (!(this.mTimes[i] > lastUpdatedTime)) continue;
                    cappedMax = Math.max(cappedMax, value);
                    cappedMin = Math.min(cappedMin, value);
                }
                if (this.mSize > 0) {
                    streamComponent.currentValue = streamFromData.get(this.mSize - 1);
                }
                if (streamComponent.isMirrored) {
                    lastStreamForMirroredStack = streamComponent;
                    continue;
                }
                lastStreamForNonMirroredStack = streamComponent;
            }
            this.mEndTime = this.mData.getEndTime() - this.mBufferTime;
            this.mBeginTime = this.mEndTime - (float)(this.mRight - 120) / 20.0f;
            cappedMax = Math.min(this.mAbsoluteMax, Math.max(this.mCurrentMax, cappedMax));
            cappedMin = Math.max(-this.mAbsoluteMax, Math.min(this.mCurrentMin, cappedMin));
            if (cappedMax > this.mCurrentMax) {
                this.mCurrentMax = Choreographer.lerp(this.mCurrentMax, cappedMax, this.mFirstFrame ? 1.0f : 0.95f, this.mFrameLength);
            }
            if (cappedMin == 0.0f || cappedMin < this.mCurrentMin) {
                this.mCurrentMin = Choreographer.lerp(this.mCurrentMin, cappedMin, this.mFirstFrame ? 1.0f : 0.95f, this.mFrameLength);
            }
            FontMetrics metrics = this.getFontMetrics((Font)AdtUiUtils.DEFAULT_FONT);
            int ascent = metrics.getAscent();
            float distance = this.mMarkerSeparation * this.mYScale;
            float evenMarkersTarget = 1.0f;
            if (distance < (float)(ascent * 2)) {
                if (this.mEvenMarkersAlpha < 0.1f) {
                    this.mMarkerSeparation *= 2.0f;
                    this.mEvenMarkersAlpha = 1.0f;
                } else {
                    evenMarkersTarget = 0.0f;
                }
            } else if (distance > (float)(ascent * 5) && this.mEvenMarkersAlpha > 0.9f) {
                this.mMarkerSeparation /= 2.0f;
                this.mEvenMarkersAlpha = 0.0f;
            }
            this.mEvenMarkersAlpha = Choreographer.lerp(this.mEvenMarkersAlpha, evenMarkersTarget, 0.999f, this.mFrameLength);
        }
        object = this.mEvents;
        synchronized (object) {
            this.mEventsSize = this.mEvents.size();
            if (this.mEventStart == null || this.mEventStart.length < this.mEventsSize) {
                int alloc = Math.max(this.mEventsSize, this.mEventStart == null ? 64 : this.mEventStart.length * 2);
                this.mEventStart = new float[alloc];
                this.mEventEnd = new float[alloc];
                this.mEventTypes = new int[alloc];
            }
            for (int i = 0; i < this.mEventsSize; ++i) {
                EventData.Event event = this.mEvents.get(i);
                this.mEventStart[i] = (float)(event.from - start) / 1000.0f;
                this.mEventEnd[i] = event.to == -1L ? Float.NaN : (float)(event.to - start) / 1000.0f;
                this.mEventTypes[i] = event.type;
            }
            if (this.mEventProgress > 0.95f) {
                this.mEventProgressDir = -this.mEventProgressDir;
                this.mEventProgress = 0.0f;
            }
            this.mEventProgressStart = (this.mEventProgressStart + this.mFrameLength * 200.0f) % 360.0f;
            this.mEventProgress = Choreographer.lerp(this.mEventProgress, 1.0f, 0.99f, this.mFrameLength);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamId1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamId2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/adtui/TimelineComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "linkStreams";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class EventInfo {
        public final int type;
        public final int stream;
        public final Icon icon;
        public final Color color;
        public final Color progress;
        public final boolean range;

        private EventInfo(int type, int stream, Icon icon, Color color, Color progress, boolean range) {
            this.type = type;
            this.stream = stream;
            this.icon = icon;
            this.color = color;
            this.progress = progress;
            this.range = range;
        }
    }

    private static class Reference {
        public final float value;
        @NotNull
        public final Color color;

        private Reference(float value, @NotNull Color color) {
            if (color == null) {
                Reference.$$$reportNull$$$0(0);
            }
            this.value = value;
            this.color = color;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/adtui/TimelineComponent$Reference", "<init>"));
        }
    }

    public static enum Style {
        NONE,
        SOLID,
        DASHED;

    }

    private static class LabelRow {
        @NotNull
        public StreamComponent stream1;
        @Nullable
        public StreamComponent stream2;

        public LabelRow(@NotNull StreamComponent stream1, @Nullable StreamComponent stream2) {
            if (stream1 == null) {
                LabelRow.$$$reportNull$$$0(0);
            }
            this.stream1 = stream1;
            this.stream2 = stream2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream1", "com/android/tools/adtui/TimelineComponent$LabelRow", "<init>"));
        }
    }

    private static class StreamComponent {
        public float[] values;
        public float currentValue;
        public final String id;
        public String name;
        public Color color;
        public boolean isMirrored;

        public StreamComponent(int valueSize, @NotNull String id, @NotNull Color color, boolean isMirrored) {
            if (id == null) {
                StreamComponent.$$$reportNull$$$0(0);
            }
            if (color == null) {
                StreamComponent.$$$reportNull$$$0(1);
            }
            this.values = new float[valueSize];
            this.currentValue = 0.0f;
            this.id = id;
            this.name = id;
            this.color = color;
            this.isMirrored = isMirrored;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "id";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "color";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/adtui/TimelineComponent$StreamComponent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Listener {
        public void onStreamAdded(int var1, @NotNull String var2);
    }
}

