/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.beans;

import com.intellij.cdi.beans.AbstractCdiBeanDescriptor;
import com.intellij.cdi.beans.ProducerBeanDescriptor;
import com.intellij.cdi.manager.CdiDescriptorsFactory;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CdiBeanPsiClassDescriptor
extends AbstractCdiBeanDescriptor<PsiClass> {
    private final PsiClass myPsiClass;

    protected CdiBeanPsiClassDescriptor(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiBeanPsiClassDescriptor.$$$reportNull$$$0(0);
        }
        this.myPsiClass = psiClass;
    }

    @Override
    @NotNull
    public PsiClass getAnnotatedItem() {
        PsiClass psiClass = this.myPsiClass;
        if (psiClass == null) {
            CdiBeanPsiClassDescriptor.$$$reportNull$$$0(1);
        }
        return psiClass;
    }

    @Override
    protected PsiClass getDefaultDeploymentType() {
        return this.getAnnotationClass("javax.enterprise.inject.deployment.Production");
    }

    @NotNull
    public List<PsiMethod> getInjectedConstructors() {
        PsiMethod[] methods;
        ArrayList<PsiMethod> constructors = new ArrayList<PsiMethod>();
        for (PsiMethod psiMethod : methods = this.getAnnotatedItem().getConstructors()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)"javax.inject.Inject", (boolean)true)) continue;
            constructors.add(psiMethod);
        }
        ArrayList<PsiMethod> arrayList = constructors;
        if (arrayList == null) {
            CdiBeanPsiClassDescriptor.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    public List<PsiMethod> getInjectedMethods() {
        PsiMethod[] methods;
        ArrayList<PsiMethod> injectedMethods = new ArrayList<PsiMethod>();
        for (PsiMethod psiMethod : methods = this.getAnnotatedItem().getAllMethods()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)"javax.inject.Inject", (boolean)true)) continue;
            injectedMethods.add(psiMethod);
        }
        ArrayList<PsiMethod> arrayList = injectedMethods;
        if (arrayList == null) {
            CdiBeanPsiClassDescriptor.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public List<ProducerBeanDescriptor> getProducerDescriptors() {
        List list = ContainerUtil.mapNotNull(this.collectProducesPsiMembers(), psiMember -> CdiDescriptorsFactory.createProducerCdiBeanDescriptor(psiMember));
        if (list == null) {
            CdiBeanPsiClassDescriptor.$$$reportNull$$$0(4);
        }
        return list;
    }

    private List<PsiMember> collectProducesPsiMembers() {
        ArrayList<PsiMember> candidates = new ArrayList<PsiMember>();
        candidates.addAll(this.getProducerMethods());
        candidates.addAll(this.getProducerFields());
        return candidates;
    }

    public List<PsiMethod> getProducerMethods() {
        return CdiCommonUtils.getProducerMethods(this.getAnnotatedItem());
    }

    public List<PsiField> getProducerFields() {
        return CdiCommonUtils.getProducerFields(this.getAnnotatedItem());
    }

    @NotNull
    public List<PsiField> getInjectedFields() {
        ArrayList<PsiField> injectedFields = new ArrayList<PsiField>();
        for (PsiField psiField : this.getAnnotatedItem().getFields()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiField, (String)"javax.inject.Inject", (boolean)true)) continue;
            injectedFields.add(psiField);
        }
        ArrayList<PsiField> arrayList = injectedFields;
        if (arrayList == null) {
            CdiBeanPsiClassDescriptor.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CdiBeanPsiClassDescriptor)) {
            return false;
        }
        CdiBeanPsiClassDescriptor that = (CdiBeanPsiClassDescriptor)o;
        return !(this.myPsiClass != null ? !this.myPsiClass.equals(that.myPsiClass) : that.myPsiClass != null);
    }

    public int hashCode() {
        return this.myPsiClass != null ? this.myPsiClass.hashCode() : 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/beans/CdiBeanPsiClassDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/beans/CdiBeanPsiClassDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotatedItem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedConstructors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedMethods";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProducerDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

