/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core.matcher;

import java.awt.Frame;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.core.matcher.NamedComponentMatcherTemplate;

public final class FrameMatcher
extends NamedComponentMatcherTemplate<Frame> {
    private Object title;

    public static FrameMatcher withName(@Nullable String name) {
        return new FrameMatcher(name, FrameMatcher.anyValue());
    }

    public static FrameMatcher withTitle(@Nonnull String title) {
        if (title == null) {
            FrameMatcher.$$$reportNull$$$0(0);
        }
        return new FrameMatcher(FrameMatcher.anyValue(), (Object)title);
    }

    @Nonnull
    public static FrameMatcher withTitle(@Nonnull Pattern pattern) {
        if (pattern == null) {
            FrameMatcher.$$$reportNull$$$0(1);
        }
        FrameMatcher frameMatcher = new FrameMatcher(FrameMatcher.anyValue(), (Object)pattern);
        if (frameMatcher == null) {
            FrameMatcher.$$$reportNull$$$0(2);
        }
        return frameMatcher;
    }

    @Nonnull
    public static FrameMatcher any() {
        FrameMatcher frameMatcher = new FrameMatcher(FrameMatcher.anyValue(), FrameMatcher.anyValue());
        if (frameMatcher == null) {
            FrameMatcher.$$$reportNull$$$0(3);
        }
        return frameMatcher;
    }

    private FrameMatcher(@Nullable Object name, @Nullable Object title) {
        super(Frame.class, name);
        this.title = title;
    }

    @Nonnull
    public FrameMatcher andTitle(@Nonnull String newTitle) {
        if (newTitle == null) {
            FrameMatcher.$$$reportNull$$$0(4);
        }
        this.title = newTitle;
        FrameMatcher frameMatcher = this;
        if (frameMatcher == null) {
            FrameMatcher.$$$reportNull$$$0(5);
        }
        return frameMatcher;
    }

    @Nonnull
    public FrameMatcher andTitle(@Nonnull Pattern titlePattern) {
        if (titlePattern == null) {
            FrameMatcher.$$$reportNull$$$0(6);
        }
        this.title = titlePattern;
        FrameMatcher frameMatcher = this;
        if (frameMatcher == null) {
            FrameMatcher.$$$reportNull$$$0(7);
        }
        return frameMatcher;
    }

    @Nonnull
    public FrameMatcher andShowing() {
        this.requireShowing(true);
        FrameMatcher frameMatcher = this;
        if (frameMatcher == null) {
            FrameMatcher.$$$reportNull$$$0(8);
        }
        return frameMatcher;
    }

    @Override
    @RunsInCurrentThread
    protected boolean isMatching(@Nonnull Frame frame) {
        if (frame == null) {
            FrameMatcher.$$$reportNull$$$0(9);
        }
        return this.isNameMatching(frame.getName()) && this.arePropertyValuesMatching(this.title, frame.getTitle());
    }

    public String toString() {
        String format = "%s[name=%s, title=%s, requireShowing=%b]";
        return String.format(format, this.getClass().getName(), this.quotedName(), this.quoted(this.title), this.requireShowing());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/core/matcher/FrameMatcher";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTitle";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titlePattern";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/core/matcher/FrameMatcher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "withTitle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "any";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "andTitle";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "andShowing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withTitle";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "andTitle";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isMatching";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

