/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.data;

import javax.annotation.Nonnull;
import javax.swing.JTable;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JTableCellReader;
import org.fest.swing.data.TableCell;
import org.fest.swing.data.TableCellFinder;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.ActionFailedException;
import org.fest.util.Preconditions;

public class TableCellInSelectedRow
implements TableCellFinder {
    private final int column;

    @Nonnull
    public static TableCellBuilder selectedRow() {
        TableCellBuilder tableCellBuilder = new TableCellBuilder();
        if (tableCellBuilder == null) {
            TableCellInSelectedRow.$$$reportNull$$$0(0);
        }
        return tableCellBuilder;
    }

    protected TableCellInSelectedRow(int column) {
        this.column = column;
    }

    @Override
    @Nonnull
    public TableCell findCell(@Nonnull JTable table, @Nonnull JTableCellReader cellReader) {
        int selectedRow;
        if (table == null) {
            TableCellInSelectedRow.$$$reportNull$$$0(1);
        }
        if (cellReader == null) {
            TableCellInSelectedRow.$$$reportNull$$$0(2);
        }
        if ((selectedRow = TableCellInSelectedRow.selectedRowOf(table)) == -1) {
            throw ActionFailedException.actionFailure("The given JTable does not have any selection");
        }
        TableCell tableCell = new TableCell(selectedRow, this.column);
        if (tableCell == null) {
            TableCellInSelectedRow.$$$reportNull$$$0(3);
        }
        return tableCell;
    }

    @RunsInEDT
    private static int selectedRowOf(final JTable table) {
        Integer result = GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() {
                return table.getSelectedRow();
            }
        });
        return (Integer)Preconditions.checkNotNull((Object)result);
    }

    public String toString() {
        return String.format("%s[column=%d]", this.getClass().getName(), this.column);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/data/TableCellInSelectedRow";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "selectedRow";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/data/TableCellInSelectedRow";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findCell";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findCell";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TableCellBuilder {
        @Nonnull
        public TableCellInSelectedRow column(int column) {
            TableCellInSelectedRow tableCellInSelectedRow = new TableCellInSelectedRow(column);
            if (tableCellInSelectedRow == null) {
                TableCellBuilder.$$$reportNull$$$0(0);
            }
            return tableCellInSelectedRow;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/fest/swing/data/TableCellInSelectedRow$TableCellBuilder", "column"));
        }
    }
}

