/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JList;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JListCellReader;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JListCellBoundsQuery;
import org.fest.swing.driver.JListCellCenterQuery;
import org.fest.swing.driver.JListItemPreconditions;
import org.fest.swing.driver.JListMatchingItemQuery;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.util.Pair;
import org.fest.swing.util.TextMatcher;
import org.fest.util.Preconditions;

final class JListScrollToItemTask {
    static final Pair<Integer, Point> ITEM_NOT_FOUND = Pair.of(-1, null);

    @Nonnull
    @RunsInEDT
    static Point scrollToItem(final @Nonnull JList list, final int index) {
        if (list == null) {
            JListScrollToItemTask.$$$reportNull$$$0(0);
        }
        Point result = GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(list);
                JListItemPreconditions.checkIndexInBounds(list, index);
                return JListScrollToItemTask.scrollToItemWithIndex(list, index);
            }
        });
        Point point = (Point)Preconditions.checkNotNull((Object)result);
        if (point == null) {
            JListScrollToItemTask.$$$reportNull$$$0(1);
        }
        return point;
    }

    @Nonnull
    @RunsInEDT
    static Pair<Integer, Point> scrollToItem(final @Nonnull JList list, final @Nonnull TextMatcher matcher, final @Nonnull JListCellReader cellReader) {
        if (list == null) {
            JListScrollToItemTask.$$$reportNull$$$0(2);
        }
        if (matcher == null) {
            JListScrollToItemTask.$$$reportNull$$$0(3);
        }
        if (cellReader == null) {
            JListScrollToItemTask.$$$reportNull$$$0(4);
        }
        Pair<Integer, Point> result = GuiActionRunner.execute(new GuiQuery<Pair<Integer, Point>>(){

            @Override
            protected Pair<Integer, Point> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(list);
                int index = JListMatchingItemQuery.matchingItemIndex(list, matcher, cellReader);
                if (index < 0) {
                    return ITEM_NOT_FOUND;
                }
                return Pair.of(index, JListScrollToItemTask.scrollToItemWithIndex(list, index));
            }
        });
        Pair pair = (Pair)Preconditions.checkNotNull(result);
        if (pair == null) {
            JListScrollToItemTask.$$$reportNull$$$0(5);
        }
        return pair;
    }

    @Nonnull
    @RunsInEDT
    static Pair<Integer, Point> scrollToItemIfNotSelectedYet(final @Nonnull JList list, final @Nonnull TextMatcher matcher, final @Nonnull JListCellReader cellReader) {
        if (list == null) {
            JListScrollToItemTask.$$$reportNull$$$0(6);
        }
        if (matcher == null) {
            JListScrollToItemTask.$$$reportNull$$$0(7);
        }
        if (cellReader == null) {
            JListScrollToItemTask.$$$reportNull$$$0(8);
        }
        Pair<Integer, Point> result = GuiActionRunner.execute(new GuiQuery<Pair<Integer, Point>>(){

            @Override
            protected Pair<Integer, Point> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(list);
                int index = JListMatchingItemQuery.matchingItemIndex(list, matcher, cellReader);
                if (index < 0) {
                    return ITEM_NOT_FOUND;
                }
                return Pair.of(index, JListScrollToItemTask.scrollToItemWithIndexIfNotSelectedYet(list, index));
            }
        });
        Pair pair = (Pair)Preconditions.checkNotNull(result);
        if (pair == null) {
            JListScrollToItemTask.$$$reportNull$$$0(9);
        }
        return pair;
    }

    @Nullable
    @RunsInEDT
    static Point scrollToItemIfNotSelectedYet(final @Nonnull JList list, final int index) {
        if (list == null) {
            JListScrollToItemTask.$$$reportNull$$$0(10);
        }
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(list);
                JListItemPreconditions.checkIndexInBounds(list, index);
                return JListScrollToItemTask.scrollToItemWithIndexIfNotSelectedYet(list, index);
            }
        });
    }

    @Nullable
    @RunsInCurrentThread
    private static Point scrollToItemWithIndexIfNotSelectedYet(@Nonnull JList list, int index) {
        if (list == null) {
            JListScrollToItemTask.$$$reportNull$$$0(11);
        }
        if (list.getSelectedIndex() == index) {
            return null;
        }
        return JListScrollToItemTask.scrollToItemWithIndex(list, index);
    }

    @Nonnull
    @RunsInCurrentThread
    private static Point scrollToItemWithIndex(@Nonnull JList list, int index) {
        if (list == null) {
            JListScrollToItemTask.$$$reportNull$$$0(12);
        }
        Rectangle cellBounds = (Rectangle)Preconditions.checkNotNull((Object)JListCellBoundsQuery.cellBounds(list, index));
        list.scrollRectToVisible(cellBounds);
        Point point = JListCellCenterQuery.cellCenter(list, cellBounds);
        if (point == null) {
            JListScrollToItemTask.$$$reportNull$$$0(13);
        }
        return point;
    }

    private JListScrollToItemTask() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JListScrollToItemTask";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JListScrollToItemTask";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "scrollToItem";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "scrollToItemIfNotSelectedYet";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "scrollToItemWithIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "scrollToItem";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "scrollToItemIfNotSelectedYet";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "scrollToItemWithIndexIfNotSelectedYet";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "scrollToItemWithIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

