/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.driver.AbstractButtonTextQuery;
import org.fest.util.Objects;
import org.fest.util.Strings;

public class JMenuItemMatcher
implements ComponentMatcher {
    private static final String SEPARATOR = "|";
    private final String label;

    public JMenuItemMatcher(String ... path) {
        if (path == null) {
            JMenuItemMatcher.$$$reportNull$$$0(0);
        }
        this.label = Strings.join((String[])path).with(SEPARATOR);
    }

    @Override
    @RunsInCurrentThread
    public boolean matches(@Nullable Component c) {
        if (!(c instanceof JMenuItem)) {
            return false;
        }
        JMenuItem menuItem = (JMenuItem)c;
        String text = menuItem.getText();
        return Objects.areEqual((Object)this.label, (Object)text) || Objects.areEqual((Object)this.label, (Object)this.pathOf(menuItem));
    }

    @RunsInCurrentThread
    private String pathOf(@Nonnull JMenuItem menuItem) {
        Component parent;
        if (menuItem == null) {
            JMenuItemMatcher.$$$reportNull$$$0(1);
        }
        if ((parent = this.parentOrInvokerOf(menuItem)) instanceof JMenuItem) {
            return Strings.concat((Object[])new Object[]{this.pathOf((JMenuItem)parent), SEPARATOR, AbstractButtonTextQuery.textOf(menuItem)});
        }
        return AbstractButtonTextQuery.textOf(menuItem);
    }

    @RunsInCurrentThread
    private Component parentOrInvokerOf(@Nonnull JMenuItem menuItem) {
        Component parent;
        if (menuItem == null) {
            JMenuItemMatcher.$$$reportNull$$$0(2);
        }
        if ((parent = menuItem.getParent()) instanceof JPopupMenu) {
            parent = ((JPopupMenu)parent).getInvoker();
        }
        return parent;
    }

    public String toString() {
        return String.format("%s[label=%s]", this.getClass().getName(), Strings.quote((String)this.label));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "menuItem";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/driver/JMenuItemMatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "pathOf";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parentOrInvokerOf";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

