/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Point;
import javax.annotation.Nonnull;
import javax.swing.JComboBox;
import javax.swing.JTable;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.AbstractJTableCellWriter;
import org.fest.swing.driver.JComboBoxDriver;
import org.fest.swing.driver.JComboBoxEditableQuery;
import org.fest.swing.driver.JTableStopCellEditingTask;
import org.fest.util.Lists;

public class JTableComboBoxEditorCellWriter
extends AbstractJTableCellWriter {
    private final JComboBoxDriver driver;

    public JTableComboBoxEditorCellWriter(@Nonnull Robot robot) {
        if (robot == null) {
            JTableComboBoxEditorCellWriter.$$$reportNull$$$0(0);
        }
        super(robot);
        this.driver = new JComboBoxDriver(robot);
    }

    @Override
    @RunsInEDT
    public void enterValue(@Nonnull JTable table, int row, int column, @Nonnull String value) {
        if (table == null) {
            JTableComboBoxEditorCellWriter.$$$reportNull$$$0(1);
        }
        if (value == null) {
            JTableComboBoxEditorCellWriter.$$$reportNull$$$0(2);
        }
        JComboBox editor = this.doStartCellEditing(table, row, column);
        this.selectOrType(editor, value);
        JTableStopCellEditingTask.stopEditing(table, row, column);
    }

    private void selectOrType(@Nonnull JComboBox editor, @Nonnull String value) {
        boolean selectValue;
        if (editor == null) {
            JTableComboBoxEditorCellWriter.$$$reportNull$$$0(3);
        }
        if (value == null) {
            JTableComboBoxEditorCellWriter.$$$reportNull$$$0(4);
        }
        boolean bl = selectValue = !JComboBoxEditableQuery.isEditable(editor);
        if (!selectValue) {
            selectValue = Lists.newArrayList((Object[])this.driver.contentsOf(editor)).contains(value);
        }
        if (selectValue) {
            this.driver.selectItem(editor, value);
            return;
        }
        this.driver.enterText(editor, value);
    }

    @Override
    @RunsInEDT
    public void startCellEditing(@Nonnull JTable table, int row, int column) {
        if (table == null) {
            JTableComboBoxEditorCellWriter.$$$reportNull$$$0(5);
        }
        this.doStartCellEditing(table, row, column);
    }

    @RunsInEDT
    private JComboBox doStartCellEditing(@Nonnull JTable table, int row, int column) {
        if (table == null) {
            JTableComboBoxEditorCellWriter.$$$reportNull$$$0(6);
        }
        Point cellLocation = JTableComboBoxEditorCellWriter.cellLocation(table, row, column, this.location());
        this.robot.click((Component)table, cellLocation);
        JComboBox comboBox = this.waitForEditorActivation(table, row, column);
        this.cellEditor(JTableComboBoxEditorCellWriter.cellEditor(table, row, column));
        return comboBox;
    }

    @RunsInEDT
    private JComboBox waitForEditorActivation(@Nonnull JTable table, int row, int column) {
        if (table == null) {
            JTableComboBoxEditorCellWriter.$$$reportNull$$$0(7);
        }
        return this.waitForEditorActivation(table, row, column, JComboBox.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/driver/JTableComboBoxEditorCellWriter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "enterValue";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "selectOrType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "startCellEditing";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "doStartCellEditing";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "waitForEditorActivation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

