/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Point;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.AbstractJTableCellWriter;
import org.fest.swing.driver.JTextComponentDriver;
import org.fest.swing.exception.ActionFailedException;
import org.fest.util.Preconditions;

public class JTableTextComponentEditorCellWriter
extends AbstractJTableCellWriter {
    protected final JTextComponentDriver driver;

    public JTableTextComponentEditorCellWriter(@Nonnull Robot robot) {
        if (robot == null) {
            JTableTextComponentEditorCellWriter.$$$reportNull$$$0(0);
        }
        super(robot);
        this.driver = new JTextComponentDriver(robot);
    }

    @Override
    @RunsInEDT
    public void enterValue(@Nonnull JTable table, int row, int column, @Nonnull String value) {
        if (table == null) {
            JTableTextComponentEditorCellWriter.$$$reportNull$$$0(1);
        }
        if (value == null) {
            JTableTextComponentEditorCellWriter.$$$reportNull$$$0(2);
        }
        JTextComponent editor = this.doStartCellEditing(table, row, column);
        this.driver.replaceText(editor, value);
        this.stopCellEditing(table, row, column);
    }

    @Override
    @RunsInEDT
    public void startCellEditing(@Nonnull JTable table, int row, int column) {
        if (table == null) {
            JTableTextComponentEditorCellWriter.$$$reportNull$$$0(3);
        }
        this.doStartCellEditing(table, row, column);
    }

    @Nonnull
    @RunsInEDT
    private JTextComponent doStartCellEditing(@Nonnull JTable table, int row, int column) {
        if (table == null) {
            JTableTextComponentEditorCellWriter.$$$reportNull$$$0(4);
        }
        Point cellLocation = JTableTextComponentEditorCellWriter.cellLocation(table, row, column, this.location());
        JTextComponent textComponent = null;
        try {
            textComponent = this.activateEditorWithF2Key(table, row, column, cellLocation);
        }
        catch (ActionFailedException e) {
            textComponent = this.activateEditorWithDoubleClick(table, row, column, cellLocation);
        }
        this.cellEditor(JTableTextComponentEditorCellWriter.cellEditor(table, row, column));
        JTextComponent jTextComponent = (JTextComponent)Preconditions.checkNotNull((Object)textComponent);
        if (jTextComponent == null) {
            JTableTextComponentEditorCellWriter.$$$reportNull$$$0(5);
        }
        return jTextComponent;
    }

    @Nullable
    @RunsInEDT
    private JTextComponent activateEditorWithF2Key(@Nonnull JTable table, int row, int column, @Nonnull Point cellLocation) {
        if (table == null) {
            JTableTextComponentEditorCellWriter.$$$reportNull$$$0(6);
        }
        if (cellLocation == null) {
            JTableTextComponentEditorCellWriter.$$$reportNull$$$0(7);
        }
        this.robot.click((Component)table, cellLocation);
        this.robot.pressAndReleaseKeys(113);
        return this.waitForEditorActivation(table, row, column);
    }

    @Nullable
    @RunsInEDT
    private JTextComponent activateEditorWithDoubleClick(@Nonnull JTable table, int row, int column, @Nonnull Point cellLocation) {
        if (table == null) {
            JTableTextComponentEditorCellWriter.$$$reportNull$$$0(8);
        }
        if (cellLocation == null) {
            JTableTextComponentEditorCellWriter.$$$reportNull$$$0(9);
        }
        this.robot.click(table, cellLocation, MouseButton.LEFT_BUTTON, 2);
        return this.waitForEditorActivation(table, row, column);
    }

    @Nullable
    @RunsInEDT
    private JTextComponent waitForEditorActivation(@Nonnull JTable table, int row, int column) {
        if (table == null) {
            JTableTextComponentEditorCellWriter.$$$reportNull$$$0(10);
        }
        return this.waitForEditorActivation(table, row, column, JTextComponent.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JTableTextComponentEditorCellWriter";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JTableTextComponentEditorCellWriter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doStartCellEditing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "enterValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "startCellEditing";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doStartCellEditing";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "activateEditorWithF2Key";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "activateEditorWithDoubleClick";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "waitForEditorActivation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

