/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import javax.annotation.Nonnull;
import javax.swing.JToolBar;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.util.Arrays;

public final class JToolBarLocation {
    private static String[] VALID_CONSTRAINTS = new String[]{"North", "East", "South", "West"};

    @Nonnull
    @RunsInCurrentThread
    public Point pointToGrab(@Nonnull JToolBar toolBar) {
        if (toolBar == null) {
            JToolBarLocation.$$$reportNull$$$0(0);
        }
        Insets insets = toolBar.getInsets();
        int width = toolBar.getWidth();
        int height = toolBar.getHeight();
        if (Math.max(Math.max(Math.max(insets.left, insets.top), insets.right), insets.bottom) == insets.left) {
            Point point = new Point(insets.left / 2, height / 2);
            if (point == null) {
                JToolBarLocation.$$$reportNull$$$0(1);
            }
            return point;
        }
        if (Math.max(Math.max(insets.top, insets.right), insets.bottom) == insets.top) {
            Point point = new Point(width / 2, insets.top / 2);
            if (point == null) {
                JToolBarLocation.$$$reportNull$$$0(2);
            }
            return point;
        }
        if (Math.max(insets.right, insets.bottom) == insets.right) {
            Point point = new Point(width - insets.right / 2, height / 2);
            if (point == null) {
                JToolBarLocation.$$$reportNull$$$0(3);
            }
            return point;
        }
        Point point = new Point(width / 2, height - insets.bottom / 2);
        if (point == null) {
            JToolBarLocation.$$$reportNull$$$0(4);
        }
        return point;
    }

    @Nonnull
    @RunsInCurrentThread
    public Point dockLocation(@Nonnull JToolBar toolBar, @Nonnull Container dock, @Nonnull String constraint) {
        if (toolBar == null) {
            JToolBarLocation.$$$reportNull$$$0(5);
        }
        if (dock == null) {
            JToolBarLocation.$$$reportNull$$$0(6);
        }
        if (constraint == null) {
            JToolBarLocation.$$$reportNull$$$0(7);
        }
        this.checkValid(constraint);
        Insets insets = dock.getInsets();
        int offset = this.isHorizontal(toolBar) ? toolBar.getHeight() : toolBar.getWidth();
        Dimension dockSize = dock.getSize();
        if ("North".equals(constraint)) {
            Point point = new Point(dockSize.width / 2, insets.top);
            if (point == null) {
                JToolBarLocation.$$$reportNull$$$0(8);
            }
            return point;
        }
        if ("East".equals(constraint)) {
            Point point = new Point(dockSize.width - insets.right - 1, this.verticalDockingYCoordinate(dockSize.height, insets, offset));
            if (point == null) {
                JToolBarLocation.$$$reportNull$$$0(9);
            }
            return point;
        }
        if ("West".equals(constraint)) {
            Point point = new Point(insets.left, this.verticalDockingYCoordinate(dockSize.height, insets, offset));
            if (point == null) {
                JToolBarLocation.$$$reportNull$$$0(10);
            }
            return point;
        }
        int x = dockSize.width / 2;
        if (x < insets.left + offset) {
            x = insets.left + offset;
        } else if (x > dockSize.width - insets.right - offset - 1) {
            x = dockSize.width - insets.right - offset - 1;
        }
        Point point = new Point(x, dockSize.height - insets.bottom - 1);
        if (point == null) {
            JToolBarLocation.$$$reportNull$$$0(11);
        }
        return point;
    }

    @RunsInCurrentThread
    private boolean isHorizontal(@Nonnull JToolBar toolBar) {
        if (toolBar == null) {
            JToolBarLocation.$$$reportNull$$$0(12);
        }
        return toolBar.getOrientation() == 0;
    }

    private void checkValid(@Nonnull String constraint) {
        if (constraint == null) {
            JToolBarLocation.$$$reportNull$$$0(13);
        }
        for (String validConstraint : VALID_CONSTRAINTS) {
            if (!validConstraint.equals(constraint)) continue;
            return;
        }
        throw this.invalidConstraint(constraint);
    }

    private IllegalArgumentException invalidConstraint(@Nonnull String constraint) {
        if (constraint == null) {
            JToolBarLocation.$$$reportNull$$$0(14);
        }
        String format = "'%s' is not a valid constraint. Valid constraints are %s";
        String msg = String.format(format, constraint, Arrays.format((Object)VALID_CONSTRAINTS));
        throw new IllegalArgumentException(msg);
    }

    private int verticalDockingYCoordinate(int dockHeight, @Nonnull Insets insets, int offset) {
        int y;
        if (insets == null) {
            JToolBarLocation.$$$reportNull$$$0(15);
        }
        if ((y = dockHeight / 2) < insets.top + offset) {
            y = insets.top + offset;
        }
        return y;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolBar";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JToolBarLocation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dock";
                break;
            }
            case 7: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JToolBarLocation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "pointToGrab";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "dockLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "pointToGrab";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "dockLocation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isHorizontal";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkValid";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "invalidConstraint";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "verticalDockingYCoordinate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

