/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.ContainerDriver;
import org.fest.swing.driver.WindowLikeContainers;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class WindowDriver
extends ContainerDriver {
    public WindowDriver(@Nonnull Robot robot) {
        if (robot == null) {
            WindowDriver.$$$reportNull$$$0(0);
        }
        super(robot);
    }

    @RunsInEDT
    public void resizeWidthTo(@Nonnull Window w, int width) {
        if (w == null) {
            WindowDriver.$$$reportNull$$$0(1);
        }
        this.doResizeWidth(w, width);
    }

    @RunsInEDT
    public void resizeHeightTo(@Nonnull Window w, int height) {
        if (w == null) {
            WindowDriver.$$$reportNull$$$0(2);
        }
        this.doResizeHeight(w, height);
    }

    @RunsInEDT
    public void resizeTo(@Nonnull Window w, @Nonnull Dimension size) {
        if (w == null) {
            WindowDriver.$$$reportNull$$$0(3);
        }
        if (size == null) {
            WindowDriver.$$$reportNull$$$0(4);
        }
        this.resize(w, size.width, size.height);
    }

    public void moveTo(@Nonnull Window w, @Nonnull Point where) {
        if (w == null) {
            WindowDriver.$$$reportNull$$$0(5);
        }
        if (where == null) {
            WindowDriver.$$$reportNull$$$0(6);
        }
        this.move(w, where.x, where.y);
    }

    @RunsInEDT
    public void close(@Nonnull Window w) {
        if (w == null) {
            WindowDriver.$$$reportNull$$$0(7);
        }
        this.moveMouseIgnoringAnyError(w, WindowDriver.closeInfo(w));
        this.robot.close(w);
    }

    @Nonnull
    @RunsInEDT
    private static Point closeInfo(final @Nonnull Window w) {
        if (w == null) {
            WindowDriver.$$$reportNull$$$0(8);
        }
        Point result = GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(w);
                return WindowLikeContainers.closeButtonLocation(w);
            }
        });
        Point point = (Point)Preconditions.checkNotNull((Object)result);
        if (point == null) {
            WindowDriver.$$$reportNull$$$0(9);
        }
        return point;
    }

    @RunsInEDT
    public void show(@Nonnull Window w) {
        if (w == null) {
            WindowDriver.$$$reportNull$$$0(10);
        }
        this.robot.showWindow(w);
    }

    @RunsInEDT
    public void show(@Nonnull Window w, @Nonnull Dimension size) {
        if (w == null) {
            WindowDriver.$$$reportNull$$$0(11);
        }
        if (size == null) {
            WindowDriver.$$$reportNull$$$0(12);
        }
        this.robot.showWindow(w, size);
    }

    @RunsInEDT
    public void moveToFront(@Nonnull Window w) {
        if (w == null) {
            WindowDriver.$$$reportNull$$$0(13);
        }
        WindowDriver.doMoveToFront(w);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void doMoveToFront(final @Nonnull Window w) {
        if (w == null) {
            WindowDriver.$$$reportNull$$$0(14);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                w.toFront();
            }
        });
    }

    @RunsInEDT
    public void moveToBack(@Nonnull Window w) {
        if (w == null) {
            WindowDriver.$$$reportNull$$$0(15);
        }
        WindowDriver.doMoveToBack(w);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void doMoveToBack(final @Nonnull Window w) {
        if (w == null) {
            WindowDriver.$$$reportNull$$$0(16);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                w.toBack();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "w";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/WindowDriver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/WindowDriver";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "closeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resizeWidthTo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resizeHeightTo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resizeTo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "moveTo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "close";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "closeInfo";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "moveToFront";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doMoveToFront";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "moveToBack";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doMoveToBack";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

