/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.Assertions;
import org.fest.assertions.BasicDescription;
import org.fest.assertions.Description;
import org.fest.assertions.ObjectAssert;
import org.fest.swing.util.Colors;
import org.fest.util.Preconditions;

public class ColorFixture {
    private final Color target;
    private final Description description;

    public ColorFixture(@Nonnull Color target) {
        if (target == null) {
            ColorFixture.$$$reportNull$$$0(0);
        }
        this(target, (Description)null);
    }

    public ColorFixture(@Nonnull Color target, @Nonnull String description) {
        if (target == null) {
            ColorFixture.$$$reportNull$$$0(1);
        }
        if (description == null) {
            ColorFixture.$$$reportNull$$$0(2);
        }
        this(target, (Description)new BasicDescription(description));
    }

    public ColorFixture(@Nonnull Color target, @Nullable Description description) {
        if (target == null) {
            ColorFixture.$$$reportNull$$$0(3);
        }
        this.target = (Color)Preconditions.checkNotNull((Object)target);
        this.description = description;
    }

    @Nonnull
    public ColorFixture requireEqualTo(@Nonnull String hexValue) {
        if (hexValue == null) {
            ColorFixture.$$$reportNull$$$0(4);
        }
        ColorFixture colorFixture = this.requireEqualTo(Colors.colorFromHexString(hexValue));
        if (colorFixture == null) {
            ColorFixture.$$$reportNull$$$0(5);
        }
        return colorFixture;
    }

    @Nonnull
    public ColorFixture requireEqualTo(@Nullable Color color) {
        ((ObjectAssert)Assertions.assertThat((Object)this.target).as(this.description)).isEqualTo((Object)color);
        ColorFixture colorFixture = this;
        if (colorFixture == null) {
            ColorFixture.$$$reportNull$$$0(6);
        }
        return colorFixture;
    }

    @Nonnull
    public ColorFixture requireNotEqualTo(@Nonnull String hexValue) {
        if (hexValue == null) {
            ColorFixture.$$$reportNull$$$0(7);
        }
        ColorFixture colorFixture = this.requireNotEqualTo(Colors.colorFromHexString(hexValue));
        if (colorFixture == null) {
            ColorFixture.$$$reportNull$$$0(8);
        }
        return colorFixture;
    }

    @Nonnull
    public ColorFixture requireNotEqualTo(@Nullable Color color) {
        ((ObjectAssert)Assertions.assertThat((Object)this.target).as(this.description)).isNotEqualTo((Object)color);
        ColorFixture colorFixture = this;
        if (colorFixture == null) {
            ColorFixture.$$$reportNull$$$0(9);
        }
        return colorFixture;
    }

    @Nonnull
    public Color target() {
        Color color = this.target;
        if (color == null) {
            ColorFixture.$$$reportNull$$$0(10);
        }
        return color;
    }

    @Nullable
    public final String description() {
        return this.description != null ? this.description.value() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hexValue";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/fixture/ColorFixture";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/fixture/ColorFixture";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "requireEqualTo";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "requireNotEqualTo";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "requireEqualTo";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "requireNotEqualTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

