/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.keystroke;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.KeyStroke;
import org.fest.swing.keystroke.KeyStrokeMapCollection;
import org.fest.swing.keystroke.KeyStrokeMapping;
import org.fest.swing.keystroke.KeyStrokeMappingProvider;
import org.fest.swing.keystroke.KeyStrokeMappingProviderPicker;
import org.fest.swing.util.Platform;
import org.fest.util.VisibleForTesting;

public class KeyStrokeMap {
    private static KeyStrokeMapCollection maps = new KeyStrokeMapCollection();

    public static void reloadFromSystemSettings() {
        KeyStrokeMappingProviderPicker picker = new KeyStrokeMappingProviderPicker();
        maps.clear();
        KeyStrokeMap.addKeyStrokesFrom(picker.providerFor(Platform.osFamily(), Locale.getDefault()));
    }

    @VisibleForTesting
    static void updateKeyStrokeMapCollection(@Nonnull KeyStrokeMapCollection c) {
        if (c == null) {
            KeyStrokeMap.$$$reportNull$$$0(0);
        }
        maps = c;
    }

    public static void addKeyStrokesFrom(@Nonnull KeyStrokeMappingProvider provider) {
        if (provider == null) {
            KeyStrokeMap.$$$reportNull$$$0(1);
        }
        for (KeyStrokeMapping entry : provider.keyStrokeMappings()) {
            KeyStrokeMap.add(Character.valueOf(entry.character()), entry.keyStroke());
        }
    }

    private static void add(@Nonnull Character character, @Nonnull KeyStroke keyStroke) {
        if (character == null) {
            KeyStrokeMap.$$$reportNull$$$0(2);
        }
        if (keyStroke == null) {
            KeyStrokeMap.$$$reportNull$$$0(3);
        }
        maps.add(character, keyStroke);
    }

    public static void clearKeyStrokes() {
        maps.clear();
    }

    public static boolean hasKeyStrokes() {
        return !maps.isEmpty();
    }

    @Nullable
    public static KeyStroke keyStrokeFor(char character) {
        return maps.keyStrokeFor(character);
    }

    public static char charFor(@Nonnull KeyStroke keyStroke) {
        Character character;
        if (keyStroke == null) {
            KeyStrokeMap.$$$reportNull$$$0(4);
        }
        if ((character = maps.charFor(keyStroke)) == null) {
            character = KeyStrokeMap.charWithoutModifiersButShift(keyStroke);
        }
        if (character == null) {
            return '\uffff';
        }
        return character.charValue();
    }

    @Nullable
    private static Character charWithoutModifiersButShift(@Nonnull KeyStroke keyStroke) {
        if (keyStroke == null) {
            KeyStrokeMap.$$$reportNull$$$0(5);
        }
        int mask = keyStroke.getModifiers() & 0xFFFFFFFE;
        return maps.charFor(KeyStroke.getKeyStroke(keyStroke.getKeyCode(), mask));
    }

    private KeyStrokeMap() {
    }

    static {
        KeyStrokeMap.reloadFromSystemSettings();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "character";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyStroke";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/keystroke/KeyStrokeMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateKeyStrokeMapCollection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addKeyStrokesFrom";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "charFor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "charWithoutModifiersButShift";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

