/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv.ui;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.ui.CsvFormatUISettings;
import com.intellij.database.csv.ui.CsvFormatsListComponent;
import com.intellij.database.csv.ui.CsvFormatsSettingsUI;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvFormatsSelectionUI
extends CsvFormatsSettingsUI {
    private SaveActionSupport mySaveActionSupport;

    public CsvFormatsSelectionUI(@NotNull Disposable parent, @Nullable SaveActionSupport support, @NotNull CsvFormatUISettings settings) {
        if (parent == null) {
            CsvFormatsSelectionUI.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            CsvFormatsSelectionUI.$$$reportNull$$$0(1);
        }
        super(false, parent, settings);
        this.mySaveActionSupport = support;
    }

    public void notifySaved(@NotNull CsvFormat format) {
        if (format == null) {
            CsvFormatsSelectionUI.$$$reportNull$$$0(2);
        }
        this.getFormatsListComponent().markUnmodified(format);
    }

    @Override
    @NotNull
    protected ToolbarDecorator createFormatListDecorator() {
        AnActionButton action = new AnActionButton("", AllIcons.Actions.Menu_saveall){
            ActionGroup group;
            {
                this.group = CsvFormatsSelectionUI.this.getSaveActionsGroup();
            }

            public void actionPerformed(AnActionEvent e) {
                Component component = e.getInputEvent().getComponent();
                if (component == null) {
                    return;
                }
                ActionManager.getInstance().createActionPopupMenu("ProjectViewToolbar", this.group).getComponent().show(component, 0, component.getHeight());
            }
        };
        action.addCustomUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return CsvFormatsSelectionUI.this.hasChanges();
            }
        });
        ToolbarDecorator toolbarDecorator = super.createFormatListDecorator().disableUpDownActions().addExtraAction(action);
        if (toolbarDecorator == null) {
            CsvFormatsSelectionUI.$$$reportNull$$$0(3);
        }
        return toolbarDecorator;
    }

    @NotNull
    private ActionGroup getSaveActionsGroup() {
        abstract class SaveAction
        extends AnAction {
            public SaveAction(String text2) {
                super(text2);
            }

            public void update(AnActionEvent e) {
                CsvFormat selectedFormat = CsvFormatsSelectionUI.this.getSelectedFormat();
                e.getPresentation().setEnabled(CsvFormatsSelectionUI.this.mySaveActionSupport != null && selectedFormat != null && CsvFormatsSelectionUI.this.getFormatsListComponent().isModified(selectedFormat));
            }
        }
        DefaultActionGroup saveActionsGroup = new DefaultActionGroup(new AnAction[]{new SaveAction("Save"){
            {
                super(text2);
            }

            public void actionPerformed(AnActionEvent e) {
                CsvFormatsSelectionUI.this.mySaveActionSupport.save(CsvFormatsSelectionUI.this, (CsvFormat)ObjectUtils.assertNotNull((Object)CsvFormatsSelectionUI.this.getSelectedFormat()));
            }
        }, new SaveAction("Save As..."){
            {
                super(text2);
            }

            public void actionPerformed(AnActionEvent e) {
                CsvFormat toSaveAs = (CsvFormat)ObjectUtils.assertNotNull((Object)CsvFormatsSelectionUI.this.getSelectedFormat());
                CsvFormatsListComponent formatsList = CsvFormatsSelectionUI.this.getFormatsListComponent();
                formatsList.resetFormat(toSaveAs.name);
                CsvFormat newFormat = formatsList.newFormat(toSaveAs);
                formatsList.editFormatName(newFormat, (Consumer<CsvFormat>)((Consumer)format -> CsvFormatsSelectionUI.this.mySaveActionSupport.save(CsvFormatsSelectionUI.this, (CsvFormat)format)));
            }
        }, new SaveAction("Save All"){
            {
                super(text2);
            }

            @Override
            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(CsvFormatsSelectionUI.this.mySaveActionSupport != null && CsvFormatsSelectionUI.this.hasChanges());
            }

            public void actionPerformed(AnActionEvent e) {
                DatabaseSettings.getSettings().setCsvFormats(CsvFormatsSelectionUI.this.getFormats());
            }
        }});
        saveActionsGroup.setPopup(true);
        DefaultActionGroup defaultActionGroup = saveActionsGroup;
        if (defaultActionGroup == null) {
            CsvFormatsSelectionUI.$$$reportNull$$$0(4);
        }
        return defaultActionGroup;
    }

    private boolean hasChanges() {
        return !this.getFormats().equals(DatabaseSettings.getSettings().getCsvFormats());
    }

    @NotNull
    public static CsvFormatsSelectionUI createDatabaseSettingsBackedForm(@NotNull Disposable parent) {
        if (parent == null) {
            CsvFormatsSelectionUI.$$$reportNull$$$0(5);
        }
        CsvFormatsSelectionUI csvFormatsSelectionUI = CsvFormatsSelectionUI.createDatabaseSettingsBackedForm(parent, CsvFormatUISettings.DEFAULT);
        if (csvFormatsSelectionUI == null) {
            CsvFormatsSelectionUI.$$$reportNull$$$0(6);
        }
        return csvFormatsSelectionUI;
    }

    @NotNull
    public static CsvFormatsSelectionUI createDatabaseSettingsBackedForm(@NotNull Disposable parent, @NotNull CsvFormatUISettings settings) {
        if (parent == null) {
            CsvFormatsSelectionUI.$$$reportNull$$$0(7);
        }
        if (settings == null) {
            CsvFormatsSelectionUI.$$$reportNull$$$0(8);
        }
        CsvFormatsSelectionUI form = new CsvFormatsSelectionUI(parent, new DatabaseSettingsSaveActionSupport(), settings);
        form.reset(DatabaseSettings.getSettings().getCsvFormats(), null);
        CsvFormatsSelectionUI csvFormatsSelectionUI = form;
        if (csvFormatsSelectionUI == null) {
            CsvFormatsSelectionUI.$$$reportNull$$$0(9);
        }
        return csvFormatsSelectionUI;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/csv/ui/CsvFormatsSelectionUI";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/csv/ui/CsvFormatsSelectionUI";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFormatListDecorator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSaveActionsGroup";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDatabaseSettingsBackedForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "notifySaved";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDatabaseSettingsBackedForm";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DatabaseSettingsSaveActionSupport
    implements SaveActionSupport {
        private DatabaseSettingsSaveActionSupport() {
        }

        @Override
        public void save(@NotNull CsvFormatsSelectionUI form, @NotNull CsvFormat format) {
            DatabaseSettings settings;
            ArrayList formats;
            int idx;
            if (form == null) {
                DatabaseSettingsSaveActionSupport.$$$reportNull$$$0(0);
            }
            if (format == null) {
                DatabaseSettingsSaveActionSupport.$$$reportNull$$$0(1);
            }
            if ((idx = CsvFormat.indexOfFormatNamed(formats = ContainerUtil.newArrayList((settings = DatabaseSettings.getSettings()).getCsvFormats()), format.name)) != -1) {
                formats.set(idx, format);
            } else {
                formats.add(format);
            }
            settings.setCsvFormats(formats);
            DatabaseSettings.fireSettingsChanged();
            form.notifySaved(format);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "form";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "format";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/csv/ui/CsvFormatsSelectionUI$DatabaseSettingsSaveActionSupport";
            objectArray[2] = "save";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface SaveActionSupport {
        public void save(@NotNull CsvFormatsSelectionUI var1, @NotNull CsvFormat var2);
    }
}

