/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseModelLoader;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSyncManager {
    private static final Logger LOG = Logger.getInstance(DataSourceSyncManager.class);
    private static final DataSourceSyncManager INSTANCE = new DataSourceSyncManager();
    private static final DatabaseExecutor NEW_CONNECTION_EXECUTOR = (t, path, op) -> DatabaseConnectionManager.getInstance().build(t.context.getProject(), t.context.getDataSource()).setDestination(path).sync(c -> {
        op.consume((Object)c);
        return null;
    }, t.context.getErrorHandler());
    private final MultiMap<Object, SyncProcessor> myActive = MultiMap.create();

    public static DataSourceSyncManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAbleToPerform(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DataSourceSyncManager.$$$reportNull$$$0(0);
        }
        if (dataSource.isLoading()) {
            return false;
        }
        MultiMap<Object, SyncProcessor> multiMap = this.myActive;
        synchronized (multiMap) {
            return !this.myActive.containsKey(DataSourceSyncManager.getKey(dataSource));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CompletionStage<SyncResult> tryPerform(@NotNull LoaderContext context, boolean stopRunning, boolean merge, @Nullable DatabaseExecutor executor) {
        if (context == null) {
            DataSourceSyncManager.$$$reportNull$$$0(1);
        }
        if (context.getDataSource().isLoading()) {
            return null;
        }
        MultiMap<Object, SyncProcessor> multiMap = this.myActive;
        synchronized (multiMap) {
            Object key2 = DataSourceSyncManager.getKey(context.getDataSource());
            Collection queue = this.myActive.getModifiable(key2);
            List dropped = ContainerUtil.newSmartList();
            SyncProcessor current = DataSourceSyncManager.shrinkQueueRunning(queue, (Consumer<SyncProcessor>)((Consumer)p -> dropped.add(((SyncProcessor)p).myTask)));
            SyncTask task = new SyncTask(context);
            if (merge) {
                if (current != null && stopRunning) {
                    task = SyncTask.merge(task, current.myTask);
                }
                for (SyncTask droppedTask : dropped) {
                    task = SyncTask.merge(task, droppedTask);
                }
            }
            SyncProcessor processor = new SyncProcessor(task, executor);
            queue.add(processor);
            return current == null ? this.startProcessor(key2, processor) : DataSourceSyncManager.queuedProcessor(current, processor, stopRunning);
        }
    }

    @Nullable
    public CompletionStage<SyncResult> tryPerform(@NotNull LoaderContext context, boolean stopRunning, boolean merge) {
        if (context == null) {
            DataSourceSyncManager.$$$reportNull$$$0(2);
        }
        return this.tryPerform(context, stopRunning, merge, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public CompletionStage<SyncResult> stopSynchronization(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DataSourceSyncManager.$$$reportNull$$$0(3);
        }
        MultiMap<Object, SyncProcessor> multiMap = this.myActive;
        // MONITORENTER : multiMap
        Object key2 = DataSourceSyncManager.getKey(dataSource);
        Collection queue = this.myActive.getModifiable(key2);
        SyncProcessor current = DataSourceSyncManager.shrinkQueueRunning(queue, null);
        if (current == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            // MONITOREXIT : multiMap
            if (completableFuture != null) return completableFuture;
            DataSourceSyncManager.$$$reportNull$$$0(4);
            return completableFuture;
        }
        current.cancel();
        CompletableFuture completableFuture = current.myResult;
        // MONITOREXIT : multiMap
        if (completableFuture != null) return completableFuture;
        DataSourceSyncManager.$$$reportNull$$$0(5);
        return completableFuture;
    }

    @NotNull
    private static Object getKey(@NotNull LocalDataSource dataSource) {
        String uniqueId;
        if (dataSource == null) {
            DataSourceSyncManager.$$$reportNull$$$0(6);
        }
        if ((uniqueId = dataSource.getUniqueId()) != null) {
            String string = uniqueId;
            if (string == null) {
                DataSourceSyncManager.$$$reportNull$$$0(7);
            }
            return string;
        }
        Object object = ObjectUtils.chooseNotNull((Object)dataSource.getUrl(), (Object)"");
        if (object == null) {
            DataSourceSyncManager.$$$reportNull$$$0(8);
        }
        return object;
    }

    @Nullable
    private static SyncProcessor shrinkQueueRunning(@NotNull Collection<SyncProcessor> queue, @Nullable Consumer<SyncProcessor> droppedConsumer) {
        if (queue == null) {
            DataSourceSyncManager.$$$reportNull$$$0(9);
        }
        SyncProcessor first = null;
        if (queue.size() < 2) {
            return (SyncProcessor)ContainerUtil.getFirstItem(queue);
        }
        ArrayList toStop = ContainerUtil.newArrayList();
        Iterator<SyncProcessor> it = queue.iterator();
        while (it.hasNext()) {
            SyncProcessor cur = it.next();
            if (first == null) {
                first = cur;
                continue;
            }
            toStop.add(cur);
            if (droppedConsumer != null) {
                droppedConsumer.consume((Object)cur);
            }
            it.remove();
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            for (SyncProcessor processor : toStop) {
                try {
                    processor.myResult.cancel(false);
                }
                catch (Throwable e) {
                    LOG.warn(e);
                }
            }
        });
        return first;
    }

    @NotNull
    private static CompletionStage<SyncResult> queuedProcessor(@NotNull SyncProcessor current, @NotNull SyncProcessor processor, boolean stopExisting) {
        if (current == null) {
            DataSourceSyncManager.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            DataSourceSyncManager.$$$reportNull$$$0(11);
        }
        if (stopExisting) {
            current.cancel();
        }
        CompletableFuture completableFuture = processor.myResult;
        if (completableFuture == null) {
            DataSourceSyncManager.$$$reportNull$$$0(12);
        }
        return completableFuture;
    }

    @NotNull
    private CompletionStage<SyncResult> startProcessor(@NotNull Object key2, @NotNull SyncProcessor processor) {
        if (key2 == null) {
            DataSourceSyncManager.$$$reportNull$$$0(13);
        }
        if (processor == null) {
            DataSourceSyncManager.$$$reportNull$$$0(14);
        }
        CompletionStage<SyncResult> completionStage = processor.run().whenComplete((r, ignored) -> {
            if (key2 == null) {
                DataSourceSyncManager.$$$reportNull$$$0(16);
            }
            if (processor == null) {
                DataSourceSyncManager.$$$reportNull$$$0(17);
            }
            MultiMap<Object, SyncProcessor> multiMap = this.myActive;
            synchronized (multiMap) {
                Collection queue = this.myActive.getModifiable(key2);
                if (ContainerUtil.getFirstItem((Collection)queue) != processor) {
                    LOG.warn("Unexpected sync queue corruption");
                }
                queue.remove(processor);
                if (queue.isEmpty()) {
                    this.myActive.remove(key2);
                } else {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        if (key2 == null) {
                            DataSourceSyncManager.$$$reportNull$$$0(18);
                        }
                        return this.startProcessor(key2, (SyncProcessor)queue.iterator().next());
                    });
                }
            }
        });
        if (completionStage == null) {
            DataSourceSyncManager.$$$reportNull$$$0(15);
        }
        return completionStage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceSyncManager";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceSyncManager";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "stopSynchronization";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "queuedProcessor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAbleToPerform";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryPerform";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "stopSynchronization";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 15: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getKey";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shrinkQueueRunning";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "queuedProcessor";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "startProcessor";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$startProcessor$5";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SyncProcessor {
        private final SyncTask myTask;
        private final CompletableFuture<SyncResult> myResult;
        private final long myStartTime;
        private final MyProgress myProgress;
        private final TransactionId myTransactionId;
        private final DatabaseExecutor myDbExecutor;
        private long mySyncStartTime;

        public SyncProcessor(@NotNull SyncTask task, @Nullable DatabaseExecutor executor) {
            if (task == null) {
                SyncProcessor.$$$reportNull$$$0(0);
            }
            this.myProgress = new MyProgress();
            this.myTask = task;
            this.myResult = new CompletableFuture();
            this.myStartTime = System.currentTimeMillis();
            this.myTransactionId = TransactionGuard.getInstance().getContextTransaction();
            this.myDbExecutor = executor != null ? executor : NEW_CONNECTION_EXECUTOR;
        }

        public void cancel() {
            this.myProgress.cancel();
        }

        @NotNull
        public CompletionStage<SyncResult> run() {
            CompletionStage<SyncResult> completionStage = AsyncUtil.supplyAsync(() -> this.prepareAndRefresh(), AsyncUtil.transactionExecutor((Disposable)this.myTask.context.getProject(), this.myTransactionId)).whenComplete((r, e) -> {
                if (e != null) {
                    this.myResult.completeExceptionally((Throwable)e);
                } else {
                    this.myResult.complete((SyncResult)r);
                }
            });
            if (completionStage == null) {
                SyncProcessor.$$$reportNull$$$0(1);
            }
            return completionStage;
        }

        private CompletionStage<SyncResult> prepareAndRefresh() {
            ProgressIndicator indicator;
            if (this.myTask.context.getProject().isOpen() && (indicator = this.myProgress.start()) != null) {
                try {
                    return ((CompletableFuture)AsyncUtil.underProgress(() -> {
                        FileDocumentManager.getInstance().saveAllDocuments();
                        return CompletableFuture.supplyAsync(AsyncUtil.captureIndicator(this::performSync), AsyncUtil.POOL_EXECUTOR);
                    }, indicator)).whenComplete((r, e) -> this.myProgress.stop());
                }
                catch (Throwable e2) {
                    this.myProgress.stop();
                    return AsyncUtil.exceptional(e2);
                }
            }
            return AsyncUtil.cancelled();
        }

        @NotNull
        private SyncResult performSync() {
            this.mySyncStartTime = System.currentTimeMillis();
            ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
            if (indicator == null) {
                indicator = new EmptyProgressIndicator();
            }
            try {
                new DatabaseModelLoader.IntrospectionSession(this.myTask.context, indicator, this.myTransactionId){

                    @Override
                    public void perform(@Nullable ObjectPath path, @NotNull ThrowableConsumer<DatabaseConnection, Exception> consumer) throws SQLException {
                        if (consumer == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        myDbExecutor.perform(myTask, path, consumer);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dataSource/DataSourceSyncManager$SyncProcessor$1", "perform"));
                    }
                }.run();
            }
            catch (SQLException e) {
                AsyncUtil.addUnhandledError(this.myTask.context.getErrorHandler(), e, this.myTask.context.getDataSource().getName(), DbImplUtil.getDatabaseDialect(this.myTask.context.getDataSource()).getFamilyId());
                throw new ProcessCanceledException();
            }
            finally {
                DbSrcUtils.refresh();
            }
            SyncResult syncResult = new SyncResult(this.myTask, System.currentTimeMillis() - this.myStartTime);
            if (syncResult == null) {
                SyncProcessor.$$$reportNull$$$0(2);
            }
            return syncResult;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceSyncManager$SyncProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceSyncManager$SyncProcessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "run";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "performSync";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class MyProgress {
            private boolean myCanceled = false;
            private ProgressIndicatorEx myIndicator;

            private MyProgress() {
            }

            public synchronized void cancel() {
                if (this.myIndicator != null) {
                    this.myIndicator.cancel();
                }
                this.myCanceled = true;
            }

            @Nullable
            public synchronized ProgressIndicator start() {
                if (this.myCanceled) {
                    return null;
                }
                this.myIndicator = this.createIndicator();
                this.myIndicator.start();
                return this.myIndicator;
            }

            public synchronized void stop() {
                if (this.myIndicator == null) {
                    return;
                }
                this.myIndicator.stop();
                this.myIndicator.processFinish();
            }

            private ProgressIndicatorEx createIndicator() {
                return AsyncUtil.createBackgroundIndicator(((SyncProcessor)SyncProcessor.this).myTask.context.getProject(), ((SyncProcessor)SyncProcessor.this).myTask.context.getDataSource().getName());
            }
        }
    }

    public static class SyncTask {
        public final LoaderContext context;

        public SyncTask(@NotNull LoaderContext context) {
            if (context == null) {
                SyncTask.$$$reportNull$$$0(0);
            }
            this.context = context;
        }

        @NotNull
        public static SyncTask merge(@NotNull SyncTask task1, @NotNull SyncTask task2) {
            if (task1 == null) {
                SyncTask.$$$reportNull$$$0(1);
            }
            if (task2 == null) {
                SyncTask.$$$reportNull$$$0(2);
            }
            LoaderContext context = task1.context.merge(task2.context);
            context.setErrorHandler(task1.context.getErrorHandler());
            SyncTask syncTask = new SyncTask(context);
            if (syncTask == null) {
                SyncTask.$$$reportNull$$$0(3);
            }
            return syncTask;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DataSourceSyncManager$SyncTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DataSourceSyncManager$SyncTask";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "merge";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "merge";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class SyncResult {
        public final long elapsedTime;
        public final SyncTask task;

        public SyncResult(SyncTask task, long elapsedTime) {
            this.task = task;
            this.elapsedTime = elapsedTime;
        }
    }

    public static interface DatabaseExecutor {
        public void perform(@NotNull SyncTask var1, @Nullable ObjectPath var2, @NotNull ThrowableConsumer<DatabaseConnection, Exception> var3);
    }
}

