/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.impl.RemoteBatchPreparedStatement;
import com.intellij.database.remote.jdbc.impl.RemoteBatchPreparedStatementImpl;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.util.ObjectUtils;
import java.rmi.RemoteException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import org.jetbrains.annotations.NotNull;

public class DatabaseConnection {
    private volatile Connection myJdbcConnection;
    private final ConsoleRunConfiguration myConfiguration;
    private final DatabaseConnectionPoint myConnectionPoint;

    public DatabaseConnection(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull Connection jdbcConnection, @NotNull ConsoleRunConfiguration configuration) {
        if (connectionPoint == null) {
            DatabaseConnection.$$$reportNull$$$0(0);
        }
        if (jdbcConnection == null) {
            DatabaseConnection.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            DatabaseConnection.$$$reportNull$$$0(2);
        }
        this.myJdbcConnection = jdbcConnection;
        this.myConnectionPoint = connectionPoint;
        this.myConfiguration = configuration;
    }

    private DatabaseConnection(@NotNull Connection jdbcConnection) {
        if (jdbcConnection == null) {
            DatabaseConnection.$$$reportNull$$$0(3);
        }
        this.myJdbcConnection = jdbcConnection;
        this.myConnectionPoint = new LocalDataSource();
        this.myConfiguration = null;
    }

    public static DatabaseConnection wrap(@NotNull Connection jdbcConnection) {
        if (jdbcConnection == null) {
            DatabaseConnection.$$$reportNull$$$0(4);
        }
        return new DatabaseConnection(jdbcConnection);
    }

    @NotNull
    public DatabaseConnectionPoint getConnectionPoint() {
        DatabaseConnectionPoint databaseConnectionPoint = this.myConnectionPoint;
        if (databaseConnectionPoint == null) {
            DatabaseConnection.$$$reportNull$$$0(5);
        }
        return databaseConnectionPoint;
    }

    @NotNull
    public Statement createStatement() throws SQLException {
        Statement statement = this.myJdbcConnection.createStatement();
        if (statement == null) {
            DatabaseConnection.$$$reportNull$$$0(6);
        }
        return statement;
    }

    @NotNull
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement statement = this.myJdbcConnection.createStatement(resultSetType, resultSetConcurrency);
        if (statement == null) {
            DatabaseConnection.$$$reportNull$$$0(7);
        }
        return statement;
    }

    @NotNull
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement preparedStatement = this.myJdbcConnection.prepareStatement(sql);
        if (preparedStatement == null) {
            DatabaseConnection.$$$reportNull$$$0(8);
        }
        return preparedStatement;
    }

    @NotNull
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement preparedStatement = this.myJdbcConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        if (preparedStatement == null) {
            DatabaseConnection.$$$reportNull$$$0(9);
        }
        return preparedStatement;
    }

    @NotNull
    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement callableStatement = this.myJdbcConnection.prepareCall(sql);
        if (callableStatement == null) {
            DatabaseConnection.$$$reportNull$$$0(10);
        }
        return callableStatement;
    }

    @NotNull
    public RemoteBatchPreparedStatement prepareBatchStatement(@NotNull RemoteBatchPreparedStatementImpl.Configuration configuration) throws RemoteException, SQLException {
        if (configuration == null) {
            DatabaseConnection.$$$reportNull$$$0(11);
        }
        RemoteBatchPreparedStatement remoteBatchPreparedStatement = ((RemoteConnection)RemoteUtil.castToRemoteNotNull((Object)this.myJdbcConnection, RemoteConnection.class)).prepareBatchStatement(configuration);
        if (remoteBatchPreparedStatement == null) {
            DatabaseConnection.$$$reportNull$$$0(12);
        }
        return remoteBatchPreparedStatement;
    }

    @NotNull
    public DatabaseMetaData getMetaData() throws SQLException {
        DatabaseMetaData databaseMetaData = this.myJdbcConnection.getMetaData();
        if (databaseMetaData == null) {
            DatabaseConnection.$$$reportNull$$$0(13);
        }
        return databaseMetaData;
    }

    Connection release() {
        Connection released = this.myJdbcConnection;
        this.myJdbcConnection = null;
        return released;
    }

    @NotNull
    public Connection getJdbcConnection() {
        Connection connection = this.myJdbcConnection;
        if (connection == null) {
            DatabaseConnection.$$$reportNull$$$0(14);
        }
        return connection;
    }

    @NotNull
    public ConsoleRunConfiguration getConfiguration() {
        ConsoleRunConfiguration consoleRunConfiguration = (ConsoleRunConfiguration)((Object)ObjectUtils.assertNotNull((Object)((Object)this.myConfiguration)));
        if (consoleRunConfiguration == null) {
            DatabaseConnection.$$$reportNull$$$0(15);
        }
        return consoleRunConfiguration;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.myJdbcConnection.setAutoCommit(autoCommit);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.myJdbcConnection.getAutoCommit();
    }

    public void setReadOnly(boolean only) throws SQLException {
        this.myJdbcConnection.setReadOnly(only);
    }

    public void rollback() throws SQLException {
        this.myJdbcConnection.rollback();
    }

    public void rollback(@NotNull Savepoint savepoint) throws SQLException {
        if (savepoint == null) {
            DatabaseConnection.$$$reportNull$$$0(16);
        }
        this.myJdbcConnection.rollback(savepoint);
    }

    public void releaseSavepoint(@NotNull Savepoint savepoint) throws SQLException {
        if (savepoint == null) {
            DatabaseConnection.$$$reportNull$$$0(17);
        }
        this.myJdbcConnection.releaseSavepoint(savepoint);
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.myJdbcConnection.setSavepoint();
    }

    public void commit() throws SQLException {
        this.myJdbcConnection.commit();
    }

    void cancelAll() {
        try {
            ((RemoteConnection)RemoteUtil.castToRemoteNotNull((Object)this.myJdbcConnection, RemoteConnection.class)).cancelAll();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionPoint";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdbcConnection";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseConnection";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "savepoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseConnection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionPoint";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createStatement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareStatement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareCall";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareBatchStatement";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaData";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdbcConnection";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "prepareBatchStatement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "rollback";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "releaseSavepoint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

