/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.AbstractDatabaseDialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasCluster;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.MetaModelImpl;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.oracle.OraModModel;
import com.intellij.database.model.oracle.OraModRoot;
import com.intellij.database.model.oracle.OraModSchema;
import com.intellij.database.model.oracle.OraModTable;
import com.intellij.database.model.oracle.OraModTableColumn;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.operations.oracle.OracleDdlOperationsBuilder;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.swing.Icon;
import javax.xml.bind.DatatypeConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Oracle;

public class OracleDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    public static final MetaModel META_MODEL = MetaModelImpl.builder().put(ObjectKind.ROOT, ObjectKind.SCHEMA).put(ObjectKind.SCHEMA, ObjectKind.CLUSTER).put(ObjectKind.SCHEMA, ObjectKind.TABLE).put(ObjectKind.SCHEMA, ObjectKind.VIEW).put(ObjectKind.SCHEMA, ObjectKind.MAT_VIEW).put(ObjectKind.SCHEMA, ObjectKind.ROUTINE).put(ObjectKind.SCHEMA, ObjectKind.OPERATOR).put(ObjectKind.SCHEMA, ObjectKind.SEQUENCE).put(ObjectKind.SCHEMA, ObjectKind.OBJECT_TYPE).put(ObjectKind.SCHEMA, ObjectKind.COLLECTION_TYPE).put(ObjectKind.SCHEMA, ObjectKind.PACKAGE).put(ObjectKind.SCHEMA, ObjectKind.SYNONYM).put(ObjectKind.CLUSTER, ObjectKind.COLUMN).put(ObjectKind.CLUSTER, ObjectKind.INDEX).put(ObjectKind.TABLE, ObjectKind.COLUMN).put(ObjectKind.TABLE, ObjectKind.INDEX).put(ObjectKind.TABLE, ObjectKind.KEY).put(ObjectKind.TABLE, ObjectKind.FOREIGN_KEY).put(ObjectKind.TABLE, ObjectKind.CHECK).put(ObjectKind.TABLE, ObjectKind.TRIGGER).put(ObjectKind.MAT_VIEW, ObjectKind.COLUMN).put(ObjectKind.VIEW, ObjectKind.COLUMN).put(ObjectKind.VIEW, ObjectKind.TRIGGER).put(ObjectKind.OBJECT_TYPE, ObjectKind.BODY).put(ObjectKind.OBJECT_TYPE, ObjectKind.OBJECT_ATTRIBUTE).put(ObjectKind.OBJECT_TYPE, ObjectKind.ROUTINE).put(ObjectKind.PACKAGE, ObjectKind.BODY).put(ObjectKind.PACKAGE, ObjectKind.ROUTINE).put(ObjectKind.ROUTINE, ObjectKind.ARGUMENT).put(ObjectKind.BODY, ObjectKind.ROUTINE).build();
    public static final OracleDialect INSTANCE = new OracleDialect();

    protected OracleDialect() {
        super(META_MODEL, new TypeHelper.OracleTypeHelper(), new KeywordHelper.OracleKeywords(), Casing.create((Case)Case.UPPER, (Case)Case.EXACT));
    }

    @Override
    public boolean supportsColumnCommentsInTableDefinition() {
        return false;
    }

    @Override
    @NotNull
    protected DdlOperations getDdlOperations() {
        DdlOperations ddlOperations = new OracleDdlOperationsBuilder(this).build();
        if (ddlOperations == null) {
            OracleDialect.$$$reportNull$$$0(0);
        }
        return ddlOperations;
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.ORACLE;
        if (databaseFamilyId == null) {
            OracleDialect.$$$reportNull$$$0(1);
        }
        return databaseFamilyId;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.Oracle;
        if (icon == null) {
            OracleDialect.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("Oracle" == null) {
            OracleDialect.$$$reportNull$$$0(3);
        }
        return "Oracle";
    }

    @Override
    public int getJavaTypeForNativeType(@NotNull String nativeColumnTypeName) {
        if (nativeColumnTypeName == null) {
            OracleDialect.$$$reportNull$$$0(4);
        }
        if (nativeColumnTypeName.toLowerCase(Locale.ENGLISH).equals("nvarchar2")) {
            return -9;
        }
        if (nativeColumnTypeName.toLowerCase(Locale.ENGLISH).equals("nchar")) {
            return -15;
        }
        if (nativeColumnTypeName.toLowerCase(Locale.ENGLISH).equals("nclob")) {
            return 2011;
        }
        if (nativeColumnTypeName.toLowerCase(Locale.ENGLISH).startsWith("TIMESTAMP")) {
            return 93;
        }
        return super.getJavaTypeForNativeType(nativeColumnTypeName);
    }

    @Override
    public boolean supportsSynonymDefinition() {
        return true;
    }

    @Override
    protected void sqlParameter(@NotNull DdlBuilder builder, DasArgument parameter, boolean longMode) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(5);
        }
        DialectUtils.sqlParameter(builder, parameter, longMode, 1, true);
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSynonymDefinition(@NotNull DasObject element) {
        if (element == null) {
            OracleDialect.$$$reportNull$$$0(6);
        }
        Pair pair = Pair.create((Object)("select dbms_metadata.get_ddl('SYNONYM', '" + element.getName() + "', '" + DasUtil.getSchema((DasObject)element) + "') from dual"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            OracleDialect.$$$reportNull$$$0(7);
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadSynonymDefinition(DasTable table, DatabaseConnection connection) throws Exception {
        Pair<String, DbImplUtil.ConcatenationProps> pair = this.sqlSynonymDefinition((DasObject)table);
        String string = DbImplUtil.concatStringResults(connection, this, (String)pair.first, 1, (DbImplUtil.ConcatenationProps)pair.second);
        if (string == null) {
            OracleDialect.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlTableDefinition(@NotNull DasObject element) {
        if (element == null) {
            OracleDialect.$$$reportNull$$$0(9);
        }
        Pair pair = Pair.create((Object)("select dbms_metadata.get_ddl('TABLE', '" + element.getName() + "', '" + DasUtil.getSchema((DasObject)element) + "') from dual"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            OracleDialect.$$$reportNull$$$0(10);
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection) throws Exception {
        if (table == null) {
            OracleDialect.$$$reportNull$$$0(11);
        }
        if (connection == null) {
            OracleDialect.$$$reportNull$$$0(12);
        }
        Pair<String, DbImplUtil.ConcatenationProps> pair = this.sqlTableDefinition((DasObject)table);
        String string = DbImplUtil.concatStringResults(connection, this, (String)pair.first, 1, (DbImplUtil.ConcatenationProps)pair.second);
        if (string == null) {
            OracleDialect.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnection connection) throws Exception {
        if (element == null) {
            OracleDialect.$$$reportNull$$$0(14);
        }
        if (connection == null) {
            OracleDialect.$$$reportNull$$$0(15);
        }
        Map<String, Object> map2 = DbImplUtil.resultRowAsMap(connection, String.format("SELECT NUM_ROWS as \"rows\",  TABLESPACE_NAME as \"tablespace\",  LAST_ANALYZED as \"analyzed on\" FROM SYS.all_tables WHERE owner LIKE '%s' ESCAPE '#' AND table_name LIKE '%s' ESCAPE '#'", DbImplUtil.escapeSql(DasUtil.getSchema((DasObject)element), true, this), DbImplUtil.escapeSql(element.getName(), true, this)), new String[0]);
        if (map2 == null) {
            OracleDialect.$$$reportNull$$$0(16);
        }
        return map2;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DatabaseSystem system, @NotNull DatabaseConnection connection) throws SQLException {
        String s;
        if (system == null) {
            OracleDialect.$$$reportNull$$$0(17);
        }
        if (connection == null) {
            OracleDialect.$$$reportNull$$$0(18);
        }
        return StringUtil.isEmpty((String)(s = DbImplUtil.concatStringResults(connection, this, "select sys_context('userenv', 'current_schema') x from dual", 1, DbImplUtil.ConcatenationProps.NO_CONCAT))) ? null : SearchPath.of((ObjectPath)new ObjectPath(ObjectKind.SCHEMA, Collections.singletonList(s)));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            OracleDialect.$$$reportNull$$$0(19);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("alter session set current_schema = %s", this.quoteIdentifier(current.getName(), false, false));
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            OracleDialect.$$$reportNull$$$0(20);
        }
        if (databaseProductName == null) {
            return false;
        }
        return databaseProductName.trim().toLowerCase(Locale.ENGLISH).startsWith("oracle");
    }

    public boolean supportsColumnComment() {
        return true;
    }

    @Override
    public boolean supportsTableComment() {
        return true;
    }

    @NotNull
    public DdlBuilder sqlAlterColumnComment(@NotNull DdlBuilder builder, @NotNull DasColumn column) throws UnsupportedOperationException {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(21);
        }
        if (column == null) {
            OracleDialect.$$$reportNull$$$0(22);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnCommentAlterSQL(builder, column, this.isCommentDroppedByNull(), DbSqlUtil.getSqlDialect(this));
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(23);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsDropColumn() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(24);
        }
        if (column == null) {
            OracleDialect.$$$reportNull$$$0(25);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDropSQL(builder, column, "DROP COLUMN", false, "");
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(26);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTable(@NotNull DdlBuilder builder, @NotNull DasTable table, boolean cascadeConstraints, boolean isMaterializedView, @NotNull DasModel model) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(27);
        }
        if (table == null) {
            OracleDialect.$$$reportNull$$$0(28);
        }
        if (model == null) {
            OracleDialect.$$$reportNull$$$0(29);
        }
        String cascadeClause = "";
        if (!isMaterializedView) {
            cascadeClause = "CASCADE CONSTRAINTS";
        }
        DdlBuilder ddlBuilder = DialectUtils.getTableDropSQL(builder, table, true, cascadeConstraints, true, cascadeClause, isMaterializedView);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(30);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            OracleDialect.$$$reportNull$$$0(31);
        }
        if (dataType.jdbcType == 0) {
            String string = dataType.getSpecification();
            if (string == null) {
                OracleDialect.$$$reportNull$$$0(32);
            }
            return string;
        }
        String typeName = dataType.typeName;
        int jdbcType = dataType.jdbcType;
        int precision = dataType.getPrecision();
        int scale = dataType.getScale();
        if ("NUMBER".equals(typeName)) {
            String string = "number" + (precision == 0 && scale == -127 ? "" : "(" + precision + (scale == 0 ? "" : ", " + scale) + ")");
            if (string == null) {
                OracleDialect.$$$reportNull$$$0(33);
            }
            return string;
        }
        if ("LONG".equals(typeName) && jdbcType == -1 && precision == 0 && scale == 0) {
            if ("long" == null) {
                OracleDialect.$$$reportNull$$$0(34);
            }
            return "long";
        }
        if ("DATE".equals(typeName) && jdbcType == 93 && precision == 7 && scale == 0) {
            if ("date" == null) {
                OracleDialect.$$$reportNull$$$0(35);
            }
            return "date";
        }
        if ("ROWID".equals(typeName) && jdbcType == 1111 && precision == 10 && scale == 0) {
            if ("rowid" == null) {
                OracleDialect.$$$reportNull$$$0(36);
            }
            return "rowid";
        }
        if ("UROWID".equals(typeName) && jdbcType == 1111 && precision == 4000 && scale == 0) {
            if ("urowid" == null) {
                OracleDialect.$$$reportNull$$$0(37);
            }
            return "urowid";
        }
        String string = super.getTypeName(dataType);
        if (string == null) {
            OracleDialect.$$$reportNull$$$0(38);
        }
        return string;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(39);
        }
        if (pk == null) {
            OracleDialect.$$$reportNull$$$0(40);
        }
        builder.keyword("ALTER TABLE").space();
        DasTable table = pk.getTable();
        builder.qualifiedRef((DasObject)table).space();
        builder.keyword("ADD").space();
        String pkName = pk.getName();
        if (StringUtil.isNotEmpty((String)pkName) && !"PRIMARY".equalsIgnoreCase(pkName)) {
            builder.keyword("CONSTRAINT").space().constraintRef((DasObject)pk).space();
        }
        builder.keywords("PRIMARY", "KEY").space();
        DialectUtils.columnList(builder, (MultiRef<? extends DasTypedObject>)pk.getColumnsRef());
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(41);
        }
        return ddlBuilder;
    }

    public boolean supportsRenameColumn() {
        return true;
    }

    @NotNull
    public DdlBuilder sqlAlterColumnName(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull String toName) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(42);
        }
        if (from == null) {
            OracleDialect.$$$reportNull$$$0(43);
        }
        if (toName == null) {
            OracleDialect.$$$reportNull$$$0(44);
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)from.getTable()).space();
        builder.keywords("RENAME", "COLUMN").space();
        builder.columnRef((DasObject)from).space();
        builder.keyword("TO").space();
        builder.newName(toName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(45);
        }
        return ddlBuilder;
    }

    public boolean supportsAlterColumnType() {
        return true;
    }

    @NotNull
    public DdlBuilder sqlAlterColumnTypeNullabilityDefault(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to) throws UnsupportedOperationException {
        boolean modifyDefault;
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(46);
        }
        if (from == null) {
            OracleDialect.$$$reportNull$$$0(47);
        }
        if (to == null) {
            OracleDialect.$$$reportNull$$$0(48);
        }
        boolean modifyType = false;
        boolean modifyNullability = false;
        if (from.getDataType().jdbcType == 12 && to.getDataType().jdbcType == 2005 || from.getDataType().jdbcType == 2005 && to.getDataType().jdbcType == 12) {
            DasColumn newInfo = (DasColumn)DialectUtils.withNewModel(Oracle.RDBMS, OraModModel.class, OraModRoot.class, root2 -> {
                if (from == null) {
                    OracleDialect.$$$reportNull$$$0(157);
                }
                if (to == null) {
                    OracleDialect.$$$reportNull$$$0(158);
                }
                OraModTableColumn o = (OraModTableColumn)DialectUtils.create(((OraModTable)DialectUtils.create(((OraModSchema)DialectUtils.create(root2.getSchemas(), DasUtil.getSchemaObject((DasObject)from))).getTables(), (DasObject)from.getTable())).getColumns(), to.getName() + "_2");
                o.setDataType(to.getDataType());
                o.setNotNull(to.isNotNull());
                return o;
            });
            this.sqlAddColumn(builder, newInfo, DasUtil.NO_ATTRS);
            builder.newStatement();
            builder.keyword("UPDATE").space();
            builder.qualifiedRef((DasObject)from.getTable());
            builder.space().keyword("SET").space();
            builder.columnRef((DasObject)newInfo);
            builder.space().symbol("=").space();
            builder.columnRef((DasObject)from);
            builder.newStatement();
            this.sqlDropColumn(builder, from).newStatement();
            this.sqlAlterColumnName(builder, newInfo, to.getName()).newStatement();
            if (!StringUtil.isEmpty((String)to.getComment()) && OracleDialect.isSameComment(from, to)) {
                this.sqlAlterColumnComment(builder, to).newStatement();
            }
            modifyDefault = !StringUtil.isEmpty((String)to.getDefault());
        } else {
            modifyType = !this.isSameType(from, to);
            modifyNullability = !OracleDialect.isSameNullability(from, to);
            boolean bl = modifyDefault = !OracleDialect.isSameDefault(from, to);
        }
        if (modifyDefault || modifyNullability || modifyType) {
            DialectUtils.getColumnDefaultAlterSQL(builder, to, "MODIFY", modifyType, "DEFAULT");
            if (modifyNullability) {
                DialectUtils.addNullabilityClause(builder, to, true);
            }
        }
        builder.newStatement();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(49);
        }
        return ddlBuilder;
    }

    public boolean supportsAlterColumnNull() {
        return true;
    }

    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateTable(@NotNull DdlBuilder builder, @NotNull List<? extends DasTable> tables, boolean constraintsAtEnd, @Nullable Set<? extends DasForeignKey> ignoreFks) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(50);
        }
        if (tables == null) {
            OracleDialect.$$$reportNull$$$0(51);
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateTableSQL(builder, tables, constraintsAtEnd, this, ignoreFks);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(52);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSchema(@NotNull DdlBuilder builder, @NotNull DasNamespace schema) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(53);
        }
        if (schema == null) {
            OracleDialect.$$$reportNull$$$0(54);
        }
        DdlBuilder ddlBuilder = builder.keywords("CREATE", "SCHEMA", "AUTHORIZATION").space().qualifiedRef((DasObject)schema);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(55);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefinition(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to, boolean forceOutput) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(56);
        }
        if (from == null) {
            OracleDialect.$$$reportNull$$$0(57);
        }
        if (to == null) {
            OracleDialect.$$$reportNull$$$0(58);
        }
        int before = builder.getStatements().size();
        if (!OracleDialect.isSameName(from, to)) {
            this.sqlAlterColumnName(builder, from, to.getName()).newStatement();
        }
        if (!(this.isSameType(from, to) && OracleDialect.isSameDefault(from, to) && OracleDialect.isSameNullability(from, to))) {
            this.sqlAlterColumnTypeNullabilityDefault(builder, from, to).newStatement();
        }
        if (!OracleDialect.isSameComment(from, to)) {
            this.sqlAlterColumnComment(builder, to).newStatement();
        }
        if (!OracleDialect.isSameAutoInc(from, to)) {
            this.sqlAddColumnAutoIncrement(builder, to).newStatement();
        }
        if (builder.getStatements().size() == before && forceOutput) {
            this.sqlAlterColumnName(builder, from, to.getName()).newStatement();
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(59);
        }
        return ddlBuilder;
    }

    public String[] getIndexAccessMethodsTypes() {
        return new String[]{"default", "unique", "bitmap"};
    }

    public String[] getIndexStorageOptions() {
        return null;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(60);
        }
        if (column == null) {
            OracleDialect.$$$reportNull$$$0(61);
        }
        DasTable table = column.getTable();
        String seqName = column.getName() + "_AUTOINC_SEQ";
        DasTable sequence = (DasTable)DialectUtils.withNewModel(Oracle.RDBMS, OraModModel.class, OraModRoot.class, root2 -> (OraModTable)DialectUtils.create(((OraModSchema)DialectUtils.create(root2.getSchemas(), DasUtil.getSchemaObject((DasObject)table))).getTables(), seqName));
        this.sqlCreateSequence(builder, sequence, "1", "1", "", "1", "", false);
        builder.newStatement();
        String trigName = column.getName() + "_AUTOINC_TRIG";
        builder.keyword("CREATE OR REPLACE TRIGGER").space().identifier(trigName).newLine();
        builder.keyword("BEFORE INSERT ON").space().qualifiedRef((DasObject)table).newLine();
        builder.keyword("FOR EACH ROW").newLine();
        builder.keyword("DECLARE").newLine();
        builder.tab().ref(null, "nextid").space().ref(null, "number").symbol("(").literal("8").symbol(")").space().symbol(":=").space().literal("0").symbol(";").newLine();
        builder.keyword("BEGIN").newLine();
        builder.tab().keyword("SELECT").space().ref((DasObject)sequence, sequence.getName()).symbol(".").ref(null, "nextval").space().keyword("into").space().ref(null, "nextid").space().keyword("from").space().ref(null, "dual").symbol(";").newLine();
        builder.tab().keyword(":new").symbol(".").columnRef((DasObject)column).space().symbol(":=").space().ref(null, "nextid").symbol(";").newLine();
        builder.keyword("END").symbol(";").space();
        builder.newStatement();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(62);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column, @NotNull Set<DasColumn.Attribute> attrs) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(63);
        }
        if (column == null) {
            OracleDialect.$$$reportNull$$$0(64);
        }
        if (attrs == null) {
            OracleDialect.$$$reportNull$$$0(65);
        }
        builder.suppressQuoteConstraints(true);
        DialectUtils.getAddColumnSQL(builder, column, true, true, true);
        if (StringUtil.isNotEmpty((String)column.getComment())) {
            builder.newStatement();
            DialectUtils.getColumnCommentAlterSQL(builder, column, this.isCommentDroppedByNull(), DbSqlUtil.getSqlDialect(this));
        }
        DdlBuilder ddlBuilder = builder.suppressQuoteConstraints(false);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(66);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddForeignKey(@NotNull DdlBuilder builder, @NotNull DasForeignKey keyInfo, boolean matchFull, boolean autoFKIndex) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(67);
        }
        if (keyInfo == null) {
            OracleDialect.$$$reportNull$$$0(68);
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddForeignKeyConstraintSQL(builder, keyInfo, false, autoFKIndex, this);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(69);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineForeignKey(@NotNull DdlBuilder builder, DasForeignKey info, boolean matchFull) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(70);
        }
        DdlBuilder ddlBuilder = DialectUtils.foreignKeyTail(builder, info, null, false, info.getDeleteRule() == DasForeignKey.RuleAction.CASCADE ? DasForeignKey.RuleAction.CASCADE : DasForeignKey.RuleAction.NO_ACTION, DasForeignKey.RuleAction.NO_ACTION);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(71);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsDropPackage() {
        return true;
    }

    @Override
    public boolean supportsDropCluster() {
        return true;
    }

    @Override
    public boolean supportsDropSynonym() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropPackage(@NotNull DdlBuilder builder, @NotNull DasSchemaChild pkg) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(72);
        }
        if (pkg == null) {
            OracleDialect.$$$reportNull$$$0(73);
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "PACKAGE").space().qualifiedRef((DasObject)pkg);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(74);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropCluster(@NotNull DdlBuilder builder, @NotNull DasCluster cluster) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(75);
        }
        if (cluster == null) {
            OracleDialect.$$$reportNull$$$0(76);
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "CLUSTER").space().qualifiedRef((DasObject)cluster);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(77);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsRenameSchema() {
        return false;
    }

    @Override
    @NotNull
    protected DatabaseEditorCapabilities.ForeignKeyEditorCaps getForeignKeyEditorCaps(boolean existing) {
        boolean fkRecreateable = this.supportsAddForeignKey() && this.supportsDropForeignKey();
        DatabaseEditorCapabilities.ForeignKeyEditorCaps foreignKeyEditorCaps = new DatabaseEditorCapabilities.ForeignKeyEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || fkRecreateable), DatabaseEditorCapabilities.Capability.UNAVAILABLE, DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.Deferrability.values()), DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.RuleAction.class), DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.RuleAction.CASCADE, DasForeignKey.RuleAction.RESTRICT));
        if (foreignKeyEditorCaps == null) {
            OracleDialect.$$$reportNull$$$0(78);
        }
        return foreignKeyEditorCaps;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddUniqueConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName, @NotNull List<DasColumn> columns2) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(79);
        }
        if (table == null) {
            OracleDialect.$$$reportNull$$$0(80);
        }
        if (constraintName == null) {
            OracleDialect.$$$reportNull$$$0(81);
        }
        if (columns2 == null) {
            OracleDialect.$$$reportNull$$$0(82);
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddUniqueConstraintSQL(builder, table, constraint, constraintName, columns2);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(83);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String restart, @NotNull String cache, boolean cycle) {
        String cycleClause;
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(84);
        }
        if (sequence == null) {
            OracleDialect.$$$reportNull$$$0(85);
        }
        if (increment == null) {
            OracleDialect.$$$reportNull$$$0(86);
        }
        if (minimum == null) {
            OracleDialect.$$$reportNull$$$0(87);
        }
        if (maximum == null) {
            OracleDialect.$$$reportNull$$$0(88);
        }
        if (restart == null) {
            OracleDialect.$$$reportNull$$$0(89);
        }
        if (cache == null) {
            OracleDialect.$$$reportNull$$$0(90);
        }
        String string = cycleClause = cycle ? "CYCLE" : "NOCYCLE";
        if (!restart.isEmpty()) {
            builder.comment("Oracle cannot change the start value of a sequence.");
            builder.newStatement();
            builder.comment("Must drop and re-create.");
            builder.newStatement();
            DialectUtils.getDropSequenceSQL(builder, (DasObject)sequence, null);
            builder.newStatement();
            DialectUtils.getCreateSequenceSQL(builder, sequence, increment, minimum, maximum, restart, cache, cycleClause);
            builder.newStatement();
            DdlBuilder ddlBuilder = builder;
            if (ddlBuilder == null) {
                OracleDialect.$$$reportNull$$$0(91);
            }
            return ddlBuilder;
        }
        DialectUtils.getAlterSequenceSQL(builder, sequence, increment, minimum, maximum, "", cache, cycleClause);
        builder.newStatement();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(92);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateIndex(@NotNull DdlBuilder builder, @NotNull DasIndex index, @NotNull String accessMethod, @NotNull String tablespace, @NotNull String constraints) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(93);
        }
        if (index == null) {
            OracleDialect.$$$reportNull$$$0(94);
        }
        if (accessMethod == null) {
            OracleDialect.$$$reportNull$$$0(95);
        }
        if (tablespace == null) {
            OracleDialect.$$$reportNull$$$0(96);
        }
        if (constraints == null) {
            OracleDialect.$$$reportNull$$$0(97);
        }
        builder.keyword("CREATE").space();
        if (index.isUnique() && !accessMethod.equalsIgnoreCase("bitmap")) {
            builder.keyword("UNIQUE").space();
        }
        if (!accessMethod.isEmpty() && accessMethod.equalsIgnoreCase("bitmap")) {
            builder.keyword(accessMethod);
            builder.space();
        }
        builder.keyword("INDEX").space();
        builder.qualifiedRefOpt((DasObject)index, index.getName());
        builder.space().keyword("ON").space();
        builder.qualifiedRef((DasObject)index.getTable());
        DialectUtils.columnList(builder, index);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(98);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String start, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(99);
        }
        if (sequence == null) {
            OracleDialect.$$$reportNull$$$0(100);
        }
        if (increment == null) {
            OracleDialect.$$$reportNull$$$0(101);
        }
        if (minimum == null) {
            OracleDialect.$$$reportNull$$$0(102);
        }
        if (maximum == null) {
            OracleDialect.$$$reportNull$$$0(103);
        }
        if (start == null) {
            OracleDialect.$$$reportNull$$$0(104);
        }
        if (cache == null) {
            OracleDialect.$$$reportNull$$$0(105);
        }
        String minValue = minimum;
        String minClause = "MINVALUE";
        if (minValue.isEmpty()) {
            minValue = "";
            minClause = "NOMINVALUE";
        }
        String maxValue = maximum;
        String maxClause = "MAXVALUE";
        if (maxValue.isEmpty()) {
            maxValue = "";
            maxClause = "NOMAXVALUE";
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateSequenceSQL(builder, sequence, increment, minClause, minValue, maxClause, maxValue, start, cache, "");
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(106);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(107);
        }
        if (view == null) {
            OracleDialect.$$$reportNull$$$0(108);
        }
        if (definition == null) {
            OracleDialect.$$$reportNull$$$0(109);
        }
        if (checkOption == null) {
            OracleDialect.$$$reportNull$$$0(110);
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateViewSQL(builder, view, definition, checkOption, this);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(111);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(112);
        }
        if (table == null) {
            OracleDialect.$$$reportNull$$$0(113);
        }
        if (constraintName == null) {
            OracleDialect.$$$reportNull$$$0(114);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropConstraintSQL(builder, table, constraint, constraintName);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(115);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropIndex(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasIndex index, @NotNull String indexName, boolean cascade) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(116);
        }
        if (table == null) {
            OracleDialect.$$$reportNull$$$0(117);
        }
        if (indexName == null) {
            OracleDialect.$$$reportNull$$$0(118);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropIndexSQL(builder, table, index, indexName, null, false);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(119);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(120);
        }
        if (sequence == null) {
            OracleDialect.$$$reportNull$$$0(121);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropSequenceSQL(builder, sequence, null);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(122);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(123);
        }
        if (view == null) {
            OracleDialect.$$$reportNull$$$0(124);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL(builder, view, null);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(125);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameTable(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull String newName) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(126);
        }
        if (table == null) {
            OracleDialect.$$$reportNull$$$0(127);
        }
        if (newName == null) {
            OracleDialect.$$$reportNull$$$0(128);
        }
        builder.keyword("ALTER").space().keyword("TABLE").space();
        builder.qualifiedRef((DasObject)table);
        builder.space().keyword("RENAME").space().keyword("TO").space();
        builder.newName(newName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(129);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String newName) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(130);
        }
        if (view == null) {
            OracleDialect.$$$reportNull$$$0(131);
        }
        if (newName == null) {
            OracleDialect.$$$reportNull$$$0(132);
        }
        DdlBuilder ddlBuilder = builder.keywords("RENAME").space().identifier(view.getName()).space().keyword("TO").space().newName(newName);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(133);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlSequenceInformation(@NotNull DdlBuilder builder, @NotNull DasTable sequence) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(134);
        }
        if (sequence == null) {
            OracleDialect.$$$reportNull$$$0(135);
        }
        SqlLanguageDialect language = DbSqlUtil.getSqlDialect(this);
        builder.keyword("SELECT").space();
        builder.ref(null, "last_number").symbol(",").space();
        builder.ref(null, "max_value").symbol(",").space();
        builder.ref(null, "min_value").symbol(",").space();
        builder.ref(null, "cache_size").symbol(",").space();
        builder.ref(null, "increment_by").symbol(",").space();
        builder.keyword("case").space().ref(null, "cycle_flag").space().keyword("when").space().literal("'N'").space().keyword("then").space().literal("0").space().keyword("else").space().literal("1").space().keyword("end").space().keyword("as").space().plain("cycle_flag").space();
        builder.keyword("FROM").space().ref(null, "USER_SEQUENCES").space();
        String seq = builder.copied().qualifiedRef((DasObject)sequence).getStatement();
        builder.keyword("WHERE").space().ref(null, "sequence_name").space().symbol("=").space().plain("upper").symbol("(").literal(language.asStringLiteral(seq)).symbol(")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(136);
        }
        return ddlBuilder;
    }

    public boolean supportsAccessMethods() {
        return true;
    }

    public boolean supportsAddForeignKey() {
        return true;
    }

    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    public boolean supportsAlterSequence() {
        return true;
    }

    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    public boolean supportsCreateIndex() {
        return true;
    }

    public boolean supportsCreateSequence() {
        return true;
    }

    @Override
    public boolean supportsCreateTable() {
        return true;
    }

    @Override
    public boolean supportsDropMaterializedView() {
        return true;
    }

    @Override
    public boolean supportsDropType() {
        return true;
    }

    public boolean supportsCreateView() {
        return true;
    }

    public boolean supportsDropConstraint() {
        return true;
    }

    public boolean supportsDropIndex() {
        return true;
    }

    public boolean supportsDropSequence() {
        return true;
    }

    public boolean supportsDropView() {
        return true;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    public boolean supportsIndexes() {
        return true;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlPackageBodyDefinition(@NotNull DasObject element) {
        if (element == null) {
            OracleDialect.$$$reportNull$$$0(137);
        }
        Pair pair = Pair.create((Object)OracleDialect.getPackageDefinitionQuery(element, "PACKAGE BODY"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            OracleDialect.$$$reportNull$$$0(138);
        }
        return pair;
    }

    @Override
    public boolean supportsPackageDefinition() {
        return true;
    }

    private static String getPackageDefinitionQuery(DasObject element, String type) {
        return "select TEXT FROM SYS.ALL_SOURCE WHERE OWNER = '" + DasUtil.getSchema((DasObject)element) + "' AND NAME = '" + element.getName() + "' AND TYPE = '" + type + "' ORDER BY LINE";
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlPackageDefinition(@NotNull DasObject element) {
        if (element == null) {
            OracleDialect.$$$reportNull$$$0(139);
        }
        Pair pair = Pair.create((Object)OracleDialect.getPackageDefinitionQuery(element, "PACKAGE"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            OracleDialect.$$$reportNull$$$0(140);
        }
        return pair;
    }

    @Override
    public boolean supportsSequenceDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSequenceDefinition(@NotNull DasObject element) {
        if (element == null) {
            OracleDialect.$$$reportNull$$$0(141);
        }
        Pair pair = Pair.create((Object)("select dbms_metadata.get_ddl('SEQUENCE', '" + element.getName() + "', '" + DasUtil.getSchema((DasObject)element) + "') from dual"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            OracleDialect.$$$reportNull$$$0(142);
        }
        return pair;
    }

    public boolean supportsMultipleRowInserts() {
        return false;
    }

    public boolean supportsRenameTable() {
        return true;
    }

    public boolean supportsRenameView() {
        return true;
    }

    public boolean supportsSequence() {
        return true;
    }

    public boolean supportsSequenceInformation() {
        return true;
    }

    public boolean supportsTablespace() {
        return true;
    }

    public boolean supportsAddColumn() {
        return true;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            OracleDialect.$$$reportNull$$$0(143);
        }
        return Pair.create((Object)("select TEXT FROM SYS.ALL_VIEWS WHERE OWNER = '" + DasUtil.getSchema((DasObject)element) + "' AND VIEW_NAME = '" + element.getName() + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            OracleDialect.$$$reportNull$$$0(144);
        }
        StringBuilder result2 = new StringBuilder();
        result2.append("select TEXT ");
        result2.append("FROM SYS.ALL_SOURCE ");
        result2.append("WHERE OWNER = ");
        result2.append("'");
        result2.append(DasUtil.getSchema((DasObject)element));
        result2.append("'");
        result2.append(" AND NAME = ");
        result2.append("'");
        result2.append(element.getName());
        result2.append("'");
        String type = StringUtil.toUpperCase((String)element.getRoutineKind().name());
        result2.append(" AND TYPE = ");
        result2.append("'");
        result2.append(StringUtil.toUpperCase((String)type));
        result2.append("'");
        result2.append(" ORDER BY LINE");
        Pair pair = Pair.create((Object)result2.toString(), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            OracleDialect.$$$reportNull$$$0(145);
        }
        return pair;
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            OracleDialect.$$$reportNull$$$0(146);
        }
        if (!Character.isLetter(identifier.charAt(0))) {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 1; i2 < len; ++i2) {
            char c = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '$' || c == '#') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            OracleDialect.$$$reportNull$$$0(147);
        }
        if (qualifier == null) {
            OracleDialect.$$$reportNull$$$0(148);
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        String pkgName = qualifier instanceof DasRoutine ? ((DasRoutine)qualifier).getPackageName() : null;
        DasObject pkg = pkgName == null ? null : qualifier.getDasParent();
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), null, null, pkg, pkgName);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(149);
        }
        return ddlBuilder;
    }

    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    protected String randomShorterUUID() {
        UUID uuid = UUID.randomUUID();
        return DatatypeConverter.printBase64Binary((byte[])ByteBuffer.allocate(16).putLong(uuid.getLeastSignificantBits()).putLong(uuid.getMostSignificantBits()).array());
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze2) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(150);
        }
        if (statement == null) {
            OracleDialect.$$$reportNull$$$0(151);
        }
        if (analyze2) {
            throw new UnsupportedOperationException("Oracle does not support EXPLAIN ANALYZE");
        }
        String uid = this.randomShorterUUID();
        builder.keywords("explain", "plan").space().keyword("set").space().plain("statement_id").symbol("=").symbol("'").plain(uid).symbol("'").space().keyword("for").space().plain(statement).newStatement();
        builder.keyword("select").space().symbol("*").space().keyword("from").space().keyword("table").symbol("(").plain("DBMS_XPLAN.DISPLAY").symbol("(").symbol("'").plain("PLAN_TABLE").symbol("'").symbol(",").symbol("'").plain(uid).symbol("'").symbol(")").symbol(")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(152);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    protected DdlBuilder appendLimit(@NotNull DdlBuilder builder, @Nullable DatabaseSystem system, int rows) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(153);
        }
        DdlBuilder ddlBuilder = OracleDialect.rowNumLimit(builder, rows);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(154);
        }
        return ddlBuilder;
    }

    @Override
    public boolean hasRowId(@Nullable DatabaseSystem system) {
        return true;
    }

    @Override
    @NotNull
    protected DdlBuilder appendRowId(@NotNull DdlBuilder builder, @Nullable DatabaseSystem system) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(155);
        }
        DdlBuilder ddlBuilder = builder.symbol(",").space().literal("ROWID");
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(156);
        }
        return ddlBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 112: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 130: 
            case 131: 
            case 132: 
            case 134: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 143: 
            case 144: 
            case 146: 
            case 147: 
            case 148: 
            case 150: 
            case 151: 
            case 153: 
            case 155: 
            case 157: 
            case 158: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 112: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 130: 
            case 131: 
            case 132: 
            case 134: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 143: 
            case 144: 
            case 146: 
            case 147: 
            case 148: 
            case 150: 
            case 151: 
            case 153: 
            case 155: 
            case 157: 
            case 158: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/OracleDialect";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeColumnTypeName";
                break;
            }
            case 5: 
            case 21: 
            case 24: 
            case 27: 
            case 39: 
            case 42: 
            case 46: 
            case 50: 
            case 53: 
            case 56: 
            case 60: 
            case 63: 
            case 67: 
            case 70: 
            case 72: 
            case 75: 
            case 79: 
            case 84: 
            case 93: 
            case 99: 
            case 107: 
            case 112: 
            case 116: 
            case 120: 
            case 123: 
            case 126: 
            case 130: 
            case 134: 
            case 150: 
            case 153: 
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: 
            case 9: 
            case 14: 
            case 137: 
            case 139: 
            case 141: 
            case 143: 
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 28: 
            case 80: 
            case 113: 
            case 117: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseProductVersion";
                break;
            }
            case 22: 
            case 25: 
            case 61: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pk";
                break;
            }
            case 43: 
            case 47: 
            case 57: 
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toName";
                break;
            }
            case 48: 
            case 58: 
            case 158: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tables";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyInfo";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cluster";
                break;
            }
            case 81: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintName";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 85: 
            case 100: 
            case 121: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 86: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "increment";
                break;
            }
            case 87: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimum";
                break;
            }
            case 88: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maximum";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restart";
                break;
            }
            case 90: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessMethod";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tablespace";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 108: 
            case 124: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkOption";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 128: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 146: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDdlOperations";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 112: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 130: 
            case 131: 
            case 132: 
            case 134: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 143: 
            case 144: 
            case 146: 
            case 147: 
            case 148: 
            case 150: 
            case 151: 
            case 153: 
            case 155: 
            case 157: 
            case 158: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/OracleDialect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlSynonymDefinition";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadSynonymDefinition";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlTableDefinition";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnComment";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropColumn";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropTable";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddPrimaryKey";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnName";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnTypeNullabilityDefault";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateTable";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateSchema";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnDefinition";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddColumn";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddForeignKey";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineForeignKey";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropPackage";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropCluster";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getForeignKeyEditorCaps";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddUniqueConstraint";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterSequence";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateIndex";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateSequence";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateView";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropConstraint";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropIndex";
                break;
            }
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropSequence";
                break;
            }
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameTable";
                break;
            }
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameView";
                break;
            }
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlSequenceInformation";
                break;
            }
            case 138: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlPackageBodyDefinition";
                break;
            }
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlPackageDefinition";
                break;
            }
            case 142: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlSequenceDefinition";
                break;
            }
            case 145: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 149: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 152: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlExplainPlan";
                break;
            }
            case 154: {
                objectArray = objectArray2;
                objectArray2[1] = "appendLimit";
                break;
            }
            case 156: {
                objectArray = objectArray2;
                objectArray2[1] = "appendRowId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getJavaTypeForNativeType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sqlParameter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sqlSynonymDefinition";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sqlTableDefinition";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "supportsProduct";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnComment";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropColumn";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropTable";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddPrimaryKey";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnName";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnTypeNullabilityDefault";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateTable";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateSchema";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnDefinition";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumn";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddForeignKey";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineForeignKey";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropPackage";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropCluster";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddUniqueConstraint";
                break;
            }
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterSequence";
                break;
            }
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateIndex";
                break;
            }
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateSequence";
                break;
            }
            case 107: 
            case 108: 
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 112: 
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropConstraint";
                break;
            }
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropIndex";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 126: 
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameTable";
                break;
            }
            case 130: 
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameView";
                break;
            }
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceInformation";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "sqlPackageBodyDefinition";
                break;
            }
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "sqlPackageDefinition";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceDefinition";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 150: 
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "appendLimit";
                break;
            }
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "appendRowId";
                break;
            }
            case 157: 
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "lambda$sqlAlterColumnTypeNullabilityDefault$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 112: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 130: 
            case 131: 
            case 132: 
            case 134: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 143: 
            case 144: 
            case 146: 
            case 147: 
            case 148: 
            case 150: 
            case 151: 
            case 153: 
            case 155: 
            case 157: 
            case 158: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

