/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.tz.TimeZonedTime;
import com.intellij.database.remote.jdbc.JdbcNativeUtil;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.openapi.diagnostic.Logger;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;

public class DataGridFormattersUtil {
    public static final LocalDate START_DATE = LocalDate.of(1970, 1, 1);
    private static final Logger LOG = Logger.getInstance(DataGridFormattersUtil.class);
    private static DateTimeFormatter OFFSET_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss G ZZZ", Locale.US);
    private static DateFormat TIMESTAMP_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss G Z", Locale.US);
    private static final int DEFAULT_ERA = 1;

    private DataGridFormattersUtil() {
    }

    public static int getEra(@NotNull Date date) {
        if (date == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(0);
        }
        return DataGridFormattersUtil.getEra(Instant.ofEpochMilli(date.getTime()).atZone(ZoneOffset.UTC).withZoneSameInstant(ZoneId.systemDefault()));
    }

    public static int getEra(@NotNull TemporalAccessor date) {
        if (date == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(1);
        }
        return date.isSupported(ChronoField.ERA) ? date.get(ChronoField.ERA) : 1;
    }

    @NotNull
    public static Date getBoundedValue(@NotNull Object value, @NotNull ModelIndex<DataConsumer.Column> column, @NotNull DataGrid grid) {
        if (value == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(2);
        }
        if (column == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(3);
        }
        if (grid == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(4);
        }
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(grid);
        DataConsumer.Column gridColumn = grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(column);
        BoundaryValueResolver resolver = BoundaryValueResolver.getResolver(dialect.getFamilyId(), gridColumn);
        Date date = resolver.bound(value);
        if (date == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(5);
        }
        return date;
    }

    @NotNull
    public static OffsetTime convert(@NotNull TimeZonedTime time) {
        if (time == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(6);
        }
        OffsetTime offsetTime = (OffsetTime)time.getValue();
        if (offsetTime == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(7);
        }
        return offsetTime;
    }

    @NotNull
    public static ZoneOffset getDefaultOffset() {
        ZoneOffset zoneOffset = ZoneOffset.UTC;
        if (zoneOffset == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(8);
        }
        return zoneOffset;
    }

    @NotNull
    public static ZoneOffset getLocalTimeOffset() {
        ZoneOffset zoneOffset = ZonedDateTime.of(LocalDateTime.of(1970, 1, 1, 0, 0, 1), ZoneId.systemDefault()).getOffset();
        if (zoneOffset == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(9);
        }
        return zoneOffset;
    }

    @NotNull
    public static OffsetDateTime fromTimestamp(@NotNull Timestamp timestamp) {
        OffsetDateTime offsetDateTime;
        if (timestamp == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(10);
        }
        TIMESTAMP_FORMATTER.setTimeZone(DataGridFormattersUtil.getDefaultTimeZone());
        try {
            offsetDateTime = OFFSET_DATE_TIME_FORMATTER.parse((CharSequence)TIMESTAMP_FORMATTER.format(timestamp), OffsetDateTime::from).withNano(timestamp.getNanos()).withOffsetSameInstant(DataGridFormattersUtil.getDefaultOffset());
        }
        catch (DateTimeParseException e) {
            LOG.warn((Throwable)e);
            OffsetDateTime offsetDateTime2 = timestamp.toLocalDateTime().atZone(ZoneId.systemDefault()).toOffsetDateTime().withOffsetSameInstant(DataGridFormattersUtil.getDefaultOffset());
            if (offsetDateTime2 == null) {
                DataGridFormattersUtil.$$$reportNull$$$0(12);
            }
            return offsetDateTime2;
        }
        if (offsetDateTime == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(11);
        }
        return offsetDateTime;
    }

    @NotNull
    public static Timestamp fromOffsetDateTime(@NotNull OffsetDateTime offsetDateTime) {
        Timestamp timestamp;
        if (offsetDateTime == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(13);
        }
        try {
            Date date = (Date)TIMESTAMP_FORMATTER.parseObject(OFFSET_DATE_TIME_FORMATTER.format(offsetDateTime));
            Timestamp timestamp2 = new Timestamp(date.getTime());
            timestamp2.setNanos(offsetDateTime.getNano());
            timestamp = timestamp2;
        }
        catch (ParseException e) {
            LOG.warn((Throwable)e);
            Timestamp timestamp3 = Timestamp.valueOf(offsetDateTime.atZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime());
            if (timestamp3 == null) {
                DataGridFormattersUtil.$$$reportNull$$$0(15);
            }
            return timestamp3;
        }
        if (timestamp == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(14);
        }
        return timestamp;
    }

    @NotNull
    public static TimeZone getDefaultTimeZone() {
        TimeZone timeZone = JdbcNativeUtil.UTC;
        if (timeZone == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(16);
        }
        return timeZone;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "date";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DataGridFormattersUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "time";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestamp";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsetDateTime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DataGridFormattersUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoundedValue";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultOffset";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalTimeOffset";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "fromTimestamp";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "fromOffsetDateTime";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTimeZone";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEra";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBoundedValue";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fromTimestamp";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fromOffsetDateTime";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

