/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.renderers;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.run.ui.grid.renderers.DefaultBooleanRendererFactory;
import com.intellij.database.run.ui.grid.renderers.DefaultNumericRendererFactory;
import com.intellij.database.run.ui.grid.renderers.DefaultTextRendererFactory;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class GridCellRendererFactories {
    private static final GridCellRendererFactories INSTANCE = new GridCellRendererFactories();
    private final List<GridCellRendererFactory> myDefaultFactories = ContainerUtil.list((Object[])new GridCellRendererFactory[]{new DefaultBooleanRendererFactory(), new DefaultNumericRendererFactory(), new DefaultTextRendererFactory()});

    GridCellRendererFactories() {
    }

    public static GridCellRendererFactories getInstance() {
        return INSTANCE;
    }

    public ImmutableList<GridCellRendererFactory> getFactoriesFor(@NotNull DatabaseDialect dialect, @NotNull DataConsumer.Column column) {
        if (dialect == null) {
            GridCellRendererFactories.$$$reportNull$$$0(0);
        }
        if (column == null) {
            GridCellRendererFactories.$$$reportNull$$$0(1);
        }
        return ContainerUtil.immutableList((List)ContainerUtil.filter(this.myDefaultFactories, factory -> {
            if (dialect == null) {
                GridCellRendererFactories.$$$reportNull$$$0(2);
            }
            if (column == null) {
                GridCellRendererFactories.$$$reportNull$$$0(3);
            }
            return factory.supportsDialect(dialect) && factory.supportsColumn(column);
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/ui/grid/renderers/GridCellRendererFactories";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFactoriesFor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getFactoriesFor$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

