/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.google.common.collect.Iterables;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasCluster;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasOperator;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.scripting.DeleteTableHelper;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class LegacyDeleteGenerator {
    private final DatabaseDialectEx myDialect;
    private final DasModel myModel;
    private final Set<DasTable> myTables = ContainerUtil.newLinkedHashSet();
    private final Set<DasRoutine> myProcedures = ContainerUtil.newLinkedHashSet();
    private final Set<DasObject> myPackages = ContainerUtil.newLinkedHashSet();
    private final Set<DasColumn> myColumns = ContainerUtil.newLinkedHashSet();
    private final Set<DasIndex> myIndices = ContainerUtil.newLinkedHashSet();
    private final Set<DasTableKey> myKeys = ContainerUtil.newLinkedHashSet();
    private final Set<DasForeignKey> myForeignKeys = ContainerUtil.newLinkedHashSet();
    private final Set<DasTrigger> myTriggers = ContainerUtil.newLinkedHashSet();
    private final Set<DasTableChild> myRules = ContainerUtil.newLinkedHashSet();
    private final Set<DasOperator> myOperators = ContainerUtil.newLinkedHashSet();
    private final Set<DasObject> mySequences = ContainerUtil.newLinkedHashSet();
    private final Set<DasUserDefinedType> myCustomTypes = ContainerUtil.newLinkedHashSet();
    private final Set<DasCluster> myClusters = ContainerUtil.newLinkedHashSet();
    private final Set<DasSynonym> mySynonyms = ContainerUtil.newLinkedHashSet();
    private final Set<DasNamespace> mySchemasAndDbs = ContainerUtil.newLinkedHashSet();
    private final Set<DasObject> myCollations = ContainerUtil.newLinkedHashSet();
    private final Set<DasObject> myUserMappings = ContainerUtil.newLinkedHashSet();
    private final Set<DasObject> myForeignServers = ContainerUtil.newLinkedHashSet();
    private final Set<DasObject> myForeignDataWrappers = ContainerUtil.newLinkedHashSet();

    public static boolean canDeleteElement(DatabaseDialectEx dialect, ObjectKind kind, Iterable<ObjectKind> context) {
        ObjectKind pKind = (ObjectKind)Iterables.getFirst(context, null);
        return kind != ObjectKind.VIEW && ModelConsts.TABLE_OR_VIEW_KINDS.contains(kind) || kind == ObjectKind.VIEW && dialect.supportsDropView() || kind == ObjectKind.ROUTINE || kind == ObjectKind.COLUMN && pKind == ObjectKind.TABLE && dialect.supportsDropColumn() || kind == ObjectKind.INDEX && ModelConsts.TABLE_OR_VIEW_KINDS.contains(pKind) && dialect.supportsDropIndex() || kind == ObjectKind.SYNONYM && dialect.supportsDropSynonym() || kind == ObjectKind.KEY && ModelConsts.TABLE_OR_VIEW_KINDS.contains(pKind) && (dialect.supportsDropPrimaryKey() || dialect.supportsDropConstraint()) || kind == ObjectKind.FOREIGN_KEY && dialect.supportsDropForeignKey() || kind == ObjectKind.TRIGGER && dialect.supportsDropTrigger() || (kind == ObjectKind.ALIAS_TYPE || kind == ObjectKind.TABLE_TYPE || kind == ObjectKind.COLLECTION_TYPE || kind == ObjectKind.OBJECT_TYPE) && dialect.supportsDropType() || kind == ObjectKind.PACKAGE && dialect.supportsDropPackage() || kind == ObjectKind.CLUSTER && dialect.supportsDropCluster() || kind == ObjectKind.SCHEMA && dialect.supportsDropSchema() || kind == ObjectKind.DATABASE && dialect.supportsDropDatabase() || kind == ObjectKind.SEQUENCE && dialect.supportsDropSequence() || kind == ObjectKind.RULE && dialect.supportsDropRule() || kind == ObjectKind.OPERATOR || kind == ObjectKind.COLLATION && dialect.supportsDropCollation() || kind == ObjectKind.USER_MAPPING && dialect.supportsDropUserMapping() || kind == ObjectKind.SERVER && dialect.supportsDropForeignServer() || kind == ObjectKind.FOREIGN_DATA_WRAPPER && dialect.supportsDropForeignDataWrapper();
    }

    public LegacyDeleteGenerator(DatabaseDialectEx dialect, DasModel model, Collection<DasObject> elements) {
        this.myDialect = dialect;
        this.myModel = model;
        JBIterable namespaces = JBIterable.from(elements).filter(DasNamespace.class);
        namespaces.filter(DasUtil.byKind((ObjectKind)ObjectKind.DATABASE)).addAllTo(this.mySchemasAndDbs);
        namespaces.filter(DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA)).filter(s -> !this.mySchemasAndDbs.contains(s.getDasParent())).addAllTo(this.mySchemasAndDbs);
        for (DasObject e : elements) {
            if (!LegacyDeleteGenerator.canDeleteElement(dialect, e.getKind(), (Iterable<ObjectKind>)DasUtil.dasParents((DasObject)e).skip(1).transform(DasUtil.TO_KIND))) continue;
            if (e.getKind() == ObjectKind.SEQUENCE) {
                this.mySequences.add(e);
                continue;
            }
            if (e instanceof DasTableChild && e.getKind() == ObjectKind.RULE) {
                this.myRules.add((DasTableChild)e);
                continue;
            }
            if (e instanceof DasUserDefinedType) {
                this.myCustomTypes.add((DasUserDefinedType)e);
                continue;
            }
            if (e instanceof DasRoutine) {
                this.myProcedures.add((DasRoutine)e);
                continue;
            }
            if (e instanceof DasTable) {
                this.myTables.add((DasTable)e);
                continue;
            }
            if (e instanceof DasColumn && e.getKind() == ObjectKind.COLUMN) {
                this.myColumns.add((DasColumn)e);
                continue;
            }
            if (e.getKind() == ObjectKind.PACKAGE) {
                this.myPackages.add(e);
                continue;
            }
            if (e instanceof DasCluster) {
                this.myClusters.add((DasCluster)e);
                continue;
            }
            if (e instanceof DasIndex) {
                this.myIndices.add((DasIndex)e);
                continue;
            }
            if (e instanceof DasTableKey) {
                this.myKeys.add((DasTableKey)e);
                continue;
            }
            if (e instanceof DasForeignKey) {
                this.myForeignKeys.add((DasForeignKey)e);
                continue;
            }
            if (e instanceof DasTrigger) {
                this.myTriggers.add((DasTrigger)e);
                continue;
            }
            if (e instanceof DasSynonym) {
                this.mySynonyms.add((DasSynonym)e);
                continue;
            }
            if (e instanceof DasOperator) {
                this.myOperators.add((DasOperator)e);
                continue;
            }
            if (e.getKind() == ObjectKind.COLLATION) {
                this.myCollations.add(e);
                continue;
            }
            if (e.getKind() == ObjectKind.USER_MAPPING) {
                this.myUserMappings.add(e);
                continue;
            }
            if (e.getKind() == ObjectKind.SERVER) {
                this.myForeignServers.add(e);
                continue;
            }
            if (e.getKind() != ObjectKind.FOREIGN_DATA_WRAPPER) continue;
            this.myForeignDataWrappers.add(e);
        }
    }

    @NotNull
    public DdlBuilder generateQueries(@NotNull List<String> messages) {
        DasTable table;
        List<DasTable> tablesDeletionOrder;
        if (messages == null) {
            LegacyDeleteGenerator.$$$reportNull$$$0(0);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        try {
            tablesDeletionOrder = DeleteTableHelper.getDeletionOrder(this.myModel, this.myTables, this.myDialect.supportsDropForeignKey());
        }
        catch (UnsupportedOperationException e) {
            messages.add("Deletion failed: " + e.getMessage());
            DdlBuilder ddlBuilder = DatabaseDialogsHelper.createDdlBuilder(null, this.myDialect, (CasingProvider)this.myModel, false);
            if (ddlBuilder == null) {
                LegacyDeleteGenerator.$$$reportNull$$$0(1);
            }
            return ddlBuilder;
        }
        tablesDeletionOrder.remove(null);
        DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder(null, this.myDialect, (CasingProvider)this.myModel, false);
        DdlBuilder keyBuilder = DatabaseDialogsHelper.createDdlBuilder(null, this.myDialect, (CasingProvider)this.myModel, false);
        if (this.myDialect.supportsDropForeignKey()) {
            for (DasForeignKey dasForeignKey : this.myForeignKeys) {
                table = dasForeignKey.getTable();
                if (this.myTables.contains(table) || QNameUtil.isFakeName(dasForeignKey.getName())) continue;
                this.myDialect.sqlDropForeignKey(keyBuilder, table, dasForeignKey, dasForeignKey.getName()).newStatement();
            }
        }
        if (this.myDialect.supportsDropConstraint() || this.myDialect.supportsDropPrimaryKey()) {
            for (DasTableKey dasTableKey : this.myKeys) {
                table = dasTableKey.getTable();
                if (this.myTables.contains(table) || QNameUtil.isFakeName(dasTableKey.getName())) continue;
                if (dasTableKey.isPrimary() && this.myDialect.supportsDropPrimaryKey()) {
                    this.myDialect.sqlDropPrimaryKey(keyBuilder, dasTableKey).newStatement();
                    continue;
                }
                if (dasTableKey.isPrimary() || !this.myDialect.supportsDropConstraint()) continue;
                this.myDialect.sqlDropConstraint(keyBuilder, table, (DasObject)dasTableKey, dasTableKey.getName()).newStatement();
            }
        }
        if (this.myDialect.supportsDropTrigger()) {
            for (DasTrigger dasTrigger : this.myTriggers) {
                table = dasTrigger.getTable();
                if (this.myTables.contains(table) || QNameUtil.isFakeName(dasTrigger.getName())) continue;
                this.myDialect.sqlDropTrigger(keyBuilder, dasTrigger).newStatement();
            }
        }
        if (this.myDialect.supportsDropRule()) {
            for (DasTableChild dasTableChild : this.myRules) {
                table = dasTableChild.getTable();
                if (this.myTables.contains(table)) continue;
                this.myDialect.sqlDropRule(keyBuilder, dasTableChild).newStatement();
            }
        }
        if (this.myDialect.supportsDropOperator()) {
            for (DasOperator dasOperator : this.myOperators) {
                this.myDialect.sqlDropOperator(keyBuilder, dasOperator).newStatement();
            }
        }
        if (this.myDialect.supportsDropType()) {
            for (DasUserDefinedType dasUserDefinedType : this.myCustomTypes) {
                this.myDialect.sqlDropType(keyBuilder, dasUserDefinedType).newStatement();
            }
        }
        if (this.myDialect.supportsDropSynonym()) {
            for (DasSynonym dasSynonym : this.mySynonyms) {
                this.myDialect.sqlDropSynonym(keyBuilder, dasSynonym).newStatement();
            }
        }
        if (this.myDialect.supportsDropCluster()) {
            for (DasCluster dasCluster : this.myClusters) {
                this.myDialect.sqlDropCluster(keyBuilder, dasCluster).newStatement();
            }
        }
        if (this.myDialect.supportsDropCollation()) {
            for (DasObject dasObject : this.myCollations) {
                this.myDialect.sqlDropCollation(keyBuilder, dasObject).newStatement();
            }
        }
        if (this.myDialect.supportsDropUserMapping()) {
            for (DasObject dasObject : this.myUserMappings) {
                this.myDialect.sqlDropUserMapping(keyBuilder, dasObject);
            }
        }
        if (this.myDialect.supportsDropForeignServer()) {
            for (DasObject dasObject : this.myForeignServers) {
                this.myDialect.sqlDropForeignServer(keyBuilder, dasObject);
            }
        }
        if (this.myDialect.supportsDropForeignDataWrapper()) {
            for (DasObject dasObject : this.myForeignDataWrappers) {
                this.myDialect.sqlDropForeignDataWrapper(keyBuilder, dasObject);
            }
        }
        for (DasTable dasTable : tablesDeletionOrder) {
            ObjectKind kind = dasTable.getKind();
            if (kind == ObjectKind.TABLE || kind == ObjectKind.VIRTUAL_TABLE || kind == ObjectKind.FOREIGN_TABLE) {
                for (DasForeignKey keyInfo : DasUtil.getForeignKeys((DasTable)dasTable)) {
                    if (!this.myDialect.supportsDropForeignKey() || this.myTables.size() <= 1 || QNameUtil.isFakeName(keyInfo.getName())) continue;
                    this.myDialect.sqlDropForeignKey(keyBuilder, dasTable, keyInfo, keyInfo.getName()).newStatement();
                }
                this.myDialect.sqlDropTable(builder, dasTable, false, false, this.myModel).newStatement();
                continue;
            }
            if (kind == ObjectKind.VIEW && this.myDialect.supportsDropView()) {
                this.myDialect.sqlDropView(builder, dasTable, false).newStatement();
                continue;
            }
            if (kind == ObjectKind.MAT_VIEW && this.myDialect.supportsDropMaterializedView()) {
                this.myDialect.sqlDropMaterializedView(builder, dasTable).newStatement();
                continue;
            }
            messages.add("Don't know how to drop " + kind.code() + " `" + dasTable.getName() + "`");
        }
        if (this.myDialect.supportsDropSequence()) {
            for (DasObject dasObject : this.mySequences) {
                this.myDialect.sqlDropSequence(builder, dasObject, false).newStatement();
            }
        }
        if (this.myDialect.supportsDropSchema()) {
            for (DasNamespace dasNamespace : this.mySchemasAndDbs) {
                if (dasNamespace.getKind() != ObjectKind.SCHEMA) continue;
                this.myDialect.sqlDropSchema(builder, dasNamespace).newStatement();
            }
        }
        if (this.myDialect.supportsDropDatabase()) {
            for (DasNamespace dasNamespace : this.mySchemasAndDbs) {
                if (dasNamespace.getKind() != ObjectKind.DATABASE) continue;
                this.myDialect.sqlDropDatabase(builder, dasNamespace).newStatement();
            }
        }
        result2.addAll(keyBuilder.getStatements());
        result2.addAll(builder.getStatements());
        result2.addAll(this.generateDropColumnsAndIndexQueries(this.myDialect, new LinkedHashSet<DasTable>(tablesDeletionOrder)).getStatements());
        DdlBuilder procedureBuilder = DatabaseDialogsHelper.createDdlBuilder(null, this.myDialect, (CasingProvider)this.myModel, false);
        if (this.myDialect.supportsDropProcedure()) {
            for (DasRoutine p : this.myProcedures) {
                this.myDialect.sqlDropProcedure(procedureBuilder, p).newStatement();
            }
        }
        if (this.myDialect.supportsDropPackage()) {
            for (DasObject pkg : this.myPackages) {
                this.myDialect.sqlDropPackage(procedureBuilder, (DasSchemaChild)pkg).newStatement();
            }
        }
        result2.addAll(procedureBuilder.getStatements());
        DdlBuilder ddlBuilder = DatabaseDialogsHelper.createDdlBuilder(null, this.myDialect, (CasingProvider)this.myModel, false);
        ddlBuilder.getStatements().addAll(result2);
        DdlBuilder ddlBuilder2 = ddlBuilder;
        if (ddlBuilder2 == null) {
            LegacyDeleteGenerator.$$$reportNull$$$0(2);
        }
        return ddlBuilder2;
    }

    private DdlBuilder generateDropColumnsAndIndexQueries(DatabaseDialectEx dialect, Set<DasTable> alreadyDroppedTables) {
        DasTable table;
        DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder(null, this.myDialect, (CasingProvider)this.myModel, false);
        if (this.myColumns.isEmpty() && this.myIndices.isEmpty()) {
            return builder;
        }
        if (dialect.supportsDropIndex()) {
            for (DasIndex index : this.myIndices) {
                String indexName = index.getName();
                if (QNameUtil.isFakeName(indexName) || alreadyDroppedTables.contains(table = index.getTable())) continue;
                dialect.sqlDropIndex(builder, table, index, indexName, true).newStatement();
            }
        }
        Map classify = ContainerUtil.classify(this.myColumns.iterator(), o -> o.getTable());
        for (Map.Entry entry : classify.entrySet()) {
            table = (DasTable)entry.getKey();
            Set columns2 = (Set)entry.getValue();
            TreeSet<String> columnNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            for (DasColumn c : columns2) {
                columnNames.add(c.getName());
            }
            if (dialect.supportsDropForeignKey()) {
                for (DasForeignKey key2 : DasUtil.getForeignKeys((DasTable)table)) {
                    TreeSet fkCols = new TreeSet(String.CASE_INSENSITIVE_ORDER);
                    Iterables.addAll(fkCols, (Iterable)key2.getColumnsRef().names());
                    if (fkCols.isEmpty() || !columnNames.containsAll(fkCols) || this.myForeignKeys.contains(key2)) continue;
                    dialect.sqlDropForeignKey(builder, table, key2, key2.getName()).newStatement();
                }
            }
            LinkedHashSet droppedIndices = ContainerUtil.newLinkedHashSet();
            if (dialect.supportsDropIndex()) {
                for (DasIndex index : DasUtil.getIndices((DasTable)table)) {
                    TreeSet indexCols = new TreeSet(String.CASE_INSENSITIVE_ORDER);
                    Iterables.addAll(indexCols, (Iterable)index.getColumnsRef().names());
                    if (indexCols.isEmpty() || !columnNames.containsAll(indexCols) || droppedIndices.contains(index) || this.myIndices.contains(index)) continue;
                    dialect.sqlDropIndex(builder, table, index, index.getName(), false).newStatement();
                    droppedIndices.add(index);
                }
            }
            if (alreadyDroppedTables.contains(table)) continue;
            if (Iterables.size((Iterable)DasUtil.getColumns((DasObject)table)) == columns2.size() && !dialect.supportsEmptyTables()) {
                dialect.sqlDropTable(builder, table, false, false, this.myModel).newStatement();
                continue;
            }
            if (!dialect.supportsDropColumn()) continue;
            for (DasColumn column : this.myColumns) {
                dialect.sqlDropColumn(builder, column).newStatement();
            }
        }
        return builder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/scripting/LegacyDeleteGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/scripting/LegacyDeleteGenerator";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateQueries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateQueries";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

