/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.introspection.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.scripting.SqlModelBuilderUtils;
import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.sql.database.DasPath;
import com.intellij.sql.database.SqlLanguageObjectBuilder;
import com.intellij.sql.database.SqlObjectBuilder;
import com.intellij.sql.database.SqlTxModelWrapper;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlModelBuilder {
    private final Project myProject;
    private final BasicModModel myModel;
    private final SqlObjectBuilder myObjectBuilder;
    private final Map<DasObject, BasicElement> mySources;
    private Map<BasicElement, SmartPsiElementPointer<SqlElement>> myMapping;

    public SqlModelBuilder(@NotNull Project project, @NotNull SqlObjectBuilder objectBuilder, @NotNull BasicModModel model, @NotNull Map<BasicElement, SmartPsiElementPointer<SqlElement>> mapping) {
        if (project == null) {
            SqlModelBuilder.$$$reportNull$$$0(0);
        }
        if (objectBuilder == null) {
            SqlModelBuilder.$$$reportNull$$$0(1);
        }
        if (model == null) {
            SqlModelBuilder.$$$reportNull$$$0(2);
        }
        if (mapping == null) {
            SqlModelBuilder.$$$reportNull$$$0(3);
        }
        this.mySources = ContainerUtil.newHashMap();
        this.myProject = project;
        this.myModel = model;
        this.myMapping = mapping;
        this.myObjectBuilder = objectBuilder;
        for (Map.Entry<BasicElement, SmartPsiElementPointer<SqlElement>> entry : mapping.entrySet()) {
            DasObject object = (DasObject)ObjectUtils.tryCast((Object)entry.getValue().getElement(), DasObject.class);
            if (object == null) continue;
            this.mySources.put(object, entry.getKey());
        }
    }

    public SqlModelBuilder(@NotNull Project project, @NotNull SqlLanguageDialect language, @NotNull BasicModModel model, @NotNull Map<BasicElement, SmartPsiElementPointer<SqlElement>> mapping) {
        if (project == null) {
            SqlModelBuilder.$$$reportNull$$$0(4);
        }
        if (language == null) {
            SqlModelBuilder.$$$reportNull$$$0(5);
        }
        if (model == null) {
            SqlModelBuilder.$$$reportNull$$$0(6);
        }
        if (mapping == null) {
            SqlModelBuilder.$$$reportNull$$$0(7);
        }
        this(project, (SqlObjectBuilder)SqlLanguageObjectBuilder.INSTANCE.forLanguage((Language)language), model, mapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void introspect(@NotNull List<SqlFile> files, boolean clear2, long syncTimeout, @NotNull PairConsumer<Integer, Map<BasicElement, SmartPsiElementPointer<SqlElement>>> onDone, boolean bl) {
        int i2;
        void saveSources;
        if (files == null) {
            SqlModelBuilder.$$$reportNull$$$0(8);
        }
        if (onDone == null) {
            SqlModelBuilder.$$$reportNull$$$0(9);
        }
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        SqlTxModelWrapper stagingModel = new SqlTxModelWrapper(this.myModel, this.mySources, (boolean)saveSources);
        SqlFileProcessor processor = new SqlFileProcessor(this.myProject, stagingModel, this.myObjectBuilder);
        long time = System.currentTimeMillis();
        try {
            for (i2 = 0; i2 < files.size(); ++i2) {
                SqlFile file = files.get(i2);
                if (indicator != null) {
                    indicator.setFraction(((double)i2 + 0.0) / (double)files.size());
                    indicator.setText2(file.getName());
                }
                stagingModel.modify(() -> processor.process(file));
                long cur = System.currentTimeMillis();
                if (cur - time <= syncTimeout && i2 + 1 != files.size()) continue;
                time = cur;
                this.myMapping = this.apply(processor, clear2);
                onDone.consume((Object)i2, this.myMapping);
                clear2 = false;
            }
        }
        finally {
            if (i2 != 0) {
                this.myModel.modify(BasicModRoot.class, r -> this.finish());
            }
        }
    }

    @NotNull
    public Map<BasicElement, SmartPsiElementPointer<SqlElement>> apply(SqlFileProcessor processor, boolean clear2) {
        final Map<BasicElement, SmartPsiElementPointer<SqlElement>> tmp = processor.reverseMap();
        this.myModel.modify(BasicModRoot.class, r -> {
            if (clear2) {
                this.prepare();
            }
            processor.apply();
        });
        final HashMap result2 = ContainerUtil.newHashMap(this.myMapping);
        new SqlTxModelWrapper.TwoModelVisitor(){

            @Override
            public void visit(@NotNull BasicElement guide, @NotNull BasicElement guided) {
                if (guide == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (guided == null) {
                    1.$$$reportNull$$$0(1);
                }
                ContainerUtil.putIfNotNull((Object)guide, tmp.get(guided), (Map)result2);
                super.visit(guide, guided);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "guide";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "guided";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/database/SqlModelBuilder$1";
                objectArray[2] = "visit";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.visit(this.myModel.getRoot(), processor.getRoot());
        HashMap hashMap = result2;
        if (hashMap == null) {
            SqlModelBuilder.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    public void prepare() {
        for (BasicModElement element : this.myModel.traverser().preOrderDfsTraversal().filter(BasicModElement.class)) {
            for (ModFamily<? extends BasicModElement> modFamily : element.getFamilies()) {
                modFamily.markChildrenAsSyncPending();
            }
        }
    }

    public void finish() {
        for (BasicModElement element : this.myModel.traverser().preOrderDfsTraversal().filter(BasicModElement.class)) {
            for (ModFamily<? extends BasicModElement> modFamily : element.getFamilies()) {
                modFamily.removeSyncPendingChildren();
                modFamily.sort();
            }
        }
        this.finalizeObjects();
    }

    public void finalizeObjects() {
        for (BasicModElement element : this.myModel.traverser().preOrderDfsTraversal().filter(BasicModElement.class)) {
            this.myObjectBuilder.finalize((DasObject)element);
        }
    }

    public static boolean isIgnored(DatabaseFamilyId familyId, ObjectKind p, ObjectKind c) {
        if (c == SqlDbElementType.ANY) {
            return true;
        }
        if (p == ObjectKind.SCHEMA && c == SqlDbElementType.ROLE) {
            return true;
        }
        if (familyId.isOracle()) {
            if (p == ObjectKind.BODY) {
                return true;
            }
            if (p == ObjectKind.PACKAGE) {
                return c != ObjectKind.ROUTINE;
            }
            if (p == ObjectKind.SCHEMA) {
                return c == ObjectKind.OPERATOR || "exception".equals(c.name()) || "library".equals(c.name()) || "INDEX TYPE".equals(c.name());
            }
        }
        if (p == SqlDbElementType.DOMAIN) {
            return c == SqlDbElementType.CONSTRAINT;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectBuilder";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onDone";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlModelBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlModelBuilder";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "introspect";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SqlFileProcessor {
        private final Project myProject;
        private final Map<DasPath, BasicModElement> myObjects;
        private final Map<DasObject, DasPath> myPaths;
        private final Set<DasObject> myProcessed;
        private final Set<DasObject> myDelayed;
        private final SqlTxModelWrapper myModel;
        @NotNull
        private final SqlObjectBuilder myObjectBuilder;
        private final DatabaseFamilyId myFamilyId;
        private final Map<DasObject, PsiElement> myOraPackageRestarter;

        public SqlFileProcessor(@NotNull Project project, @NotNull SqlTxModelWrapper model, @NotNull SqlObjectBuilder objectBuilder) {
            if (project == null) {
                SqlFileProcessor.$$$reportNull$$$0(0);
            }
            if (model == null) {
                SqlFileProcessor.$$$reportNull$$$0(1);
            }
            if (objectBuilder == null) {
                SqlFileProcessor.$$$reportNull$$$0(2);
            }
            this.myObjects = ContainerUtil.newHashMap();
            this.myPaths = ContainerUtil.newHashMap();
            this.myProcessed = ContainerUtil.newHashSet();
            this.myDelayed = ContainerUtil.newLinkedHashSet();
            this.myOraPackageRestarter = ContainerUtil.newHashMap();
            this.myProject = project;
            this.myModel = model;
            this.myObjectBuilder = objectBuilder;
            this.myFamilyId = (DatabaseFamilyId)ObjectUtils.chooseNotNull((Object)GenericIntrospectorLegacyModelUtils.findFamily(this.myModel.getRdbms()), (Object)DatabaseFamilyId.UNKNOWN);
        }

        public void processDelayed() {
            while (!this.myDelayed.isEmpty()) {
                Iterator<DasObject> it = this.myDelayed.iterator();
                DasObject d = it.next();
                it.remove();
                d.getDasChildren(null).forEach(o -> this.process((DasObject)o));
            }
        }

        public void process(@NotNull SqlFile file) {
            if (file == null) {
                SqlFileProcessor.$$$reportNull$$$0(3);
            }
            ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
            for (DasObject obj : file.traverser().preOrderDfsTraversal()) {
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                this.process(obj);
            }
            this.processDelayed();
        }

        @Nullable
        private BasicModElement process(@NotNull DasObject obj) {
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(4);
            }
            if (obj instanceof SqlRenameToClause || obj instanceof PsiElement && !(obj instanceof FakePsiElement) && !(obj instanceof SqlStubbedElement)) {
                return null;
            }
            DasPath path = DasPath.of(obj, this.myFamilyId, this.myPaths);
            if (this.myProcessed.contains(obj)) {
                return this.myModel.nullize(this.myObjects.get(path));
            }
            BasicModElement parent = this.getParent(obj);
            return this.processSingle(obj, path, parent);
        }

        @Nullable
        private BasicModElement processSingle(@NotNull DasObject obj, @NotNull DasPath path, @Nullable BasicModElement parent) {
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(5);
            }
            if (path == null) {
                SqlFileProcessor.$$$reportNull$$$0(6);
            }
            ObjectKind kind = this.myModel.getMetaModel().unaliased(obj.getKind());
            if (this.myModel.getMetaModel().findKind(kind.code()) == null) {
                return null;
            }
            this.processOddities(obj, parent, kind);
            BasicModElement target2 = this.myModel.createOrGet(obj, parent, path);
            this.markObjectReady(path, obj, target2);
            if (target2 == null) {
                ObjectKind parentKind;
                boolean ignored = false;
                DasPath p = path;
                while (p.parent != null && !ignored) {
                    if (SqlModelBuilder.isIgnored(this.myFamilyId, p.parent.kind, p.kind)) {
                        ignored = true;
                    }
                    p = p.parent;
                }
                ObjectKind objectKind = parentKind = parent == null ? ObjectKind.NONE : parent.getKind();
                if (!ignored && !SqlModelBuilder.isIgnored(this.myFamilyId, parentKind, obj.getKind())) {
                    SqlModelBuilderUtils.hardWarning("No family " + kind.code() + " in " + parentKind.code());
                }
            } else {
                if (!(target2 instanceof DasNamespace)) {
                    target2.getFamilies().forEach(ModFamily::markChildrenAsSyncPending);
                }
                this.processRequiredChildren(obj, target2);
                this.myObjectBuilder.build((DasObject)target2, obj);
            }
            return target2;
        }

        private void processRequiredChildren(@NotNull DasObject obj, @NotNull BasicModElement target2) {
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(7);
            }
            if (target2 == null) {
                SqlFileProcessor.$$$reportNull$$$0(8);
            }
            if (target2 instanceof BasicModRoutine) {
                for (DasObject argument : obj.getDasChildren(ObjectKind.ARGUMENT)) {
                    this.processSingle(argument, DasPath.of(argument, this.myFamilyId, this.myPaths), target2);
                }
            }
        }

        private void markObjectReady(DasPath path, @NotNull DasObject obj, @Nullable BasicModElement target2) {
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(9);
            }
            this.myObjects.put(path, this.myModel.notNullize(target2));
            this.myProcessed.add(obj);
        }

        private void processOddities(@NotNull DasObject obj, @Nullable BasicModElement parent, @NotNull ObjectKind kind) {
            PsiElement element;
            PsiObject pkg;
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(10);
            }
            if (kind == null) {
                SqlFileProcessor.$$$reportNull$$$0(11);
            }
            if (this.myFamilyId.isOracle() && parent != null && parent.getKind() == ObjectKind.PACKAGE && kind != ObjectKind.BODY && (pkg = (PsiObject)JBIterable.generate((Object)ObjectUtils.tryCast((Object)obj, PsiElement.class), x -> x.getContext()).filter(PsiObject.class).skip(1).first()) != null && pkg.getKind() == ObjectKind.PACKAGE && ((element = this.myOraPackageRestarter.get(parent)) == null || element != pkg)) {
                this.myOraPackageRestarter.put(parent, (PsiElement)pkg);
                JBIterable.from(parent.getFamilyKinds()).filter(x -> x != ObjectKind.BODY).transform(parent::familyOf).forEach(ModFamily::markChildrenAsSyncPending);
            }
        }

        @Nullable
        private BasicModElement getParent(@NotNull DasObject obj) {
            ObjectKind kind;
            DasObject parent;
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(12);
            }
            if ((parent = obj.getDasParent()) != null && !this.isValidParent(parent, obj)) {
                parent = null;
            }
            ObjectKind objectKind = kind = parent == null ? ObjectKind.NONE : parent.getKind();
            if (kind == ObjectKind.NONE || kind == ObjectKind.ROOT) {
                return this.myModel.getEmptyParent(obj.getKind());
            }
            DasPath parentPath = DasPath.of(parent, this.myFamilyId, this.myPaths);
            BasicModElement element = this.myObjects.get(parentPath);
            if (element != null) {
                return this.myModel.nullize(element);
            }
            if (!(parent instanceof DasNamespace)) {
                this.myDelayed.add(parent);
            }
            return this.process(parent);
        }

        private boolean isValidParent(DasObject parent, @NotNull DasObject obj) {
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(13);
            }
            boolean ok = false;
            ObjectKind pk = parent.getKind();
            if (pk == ObjectKind.NONE) {
                pk = ObjectKind.ROOT;
            }
            ObjectKind ck = obj.getKind();
            for (Couple couple : this.myModel.getDialect().getMetaModel().getKindCouples()) {
                if (couple.first != pk || couple.second != ck) continue;
                ok = true;
                break;
            }
            return ok;
        }

        @NotNull
        public Map<BasicElement, SmartPsiElementPointer<SqlElement>> reverseMap() {
            HashMap res = ContainerUtil.newHashMap();
            SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)this.myProject);
            for (Map.Entry<DasObject, DasPath> entry : this.myPaths.entrySet()) {
                BasicModElement target2;
                SqlElement object = (SqlElement)ObjectUtils.tryCast((Object)entry.getKey(), SqlElement.class);
                if (object == null || this.myModel.nullize(target2 = this.myObjects.get(entry.getValue())) == null) continue;
                res.put(target2, pointerManager.createSmartPsiElementPointer((PsiElement)object));
            }
            HashMap hashMap = res;
            if (hashMap == null) {
                SqlFileProcessor.$$$reportNull$$$0(14);
            }
            return hashMap;
        }

        public void apply() {
            this.myModel.apply();
        }

        @NotNull
        public BasicElement getRoot() {
            BasicModElement basicModElement = this.myModel.getRoot();
            if (basicModElement == null) {
                SqlFileProcessor.$$$reportNull$$$0(15);
            }
            return basicModElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 14: 
                case 15: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 14: 
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objectBuilder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "reverseMap";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "processSingle";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "processRequiredChildren";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "markObjectReady";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "processOddities";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getParent";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "isValidParent";
                    break;
                }
                case 14: 
                case 15: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 14: 
                case 15: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

