/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.introspection.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModCheck;
import com.intellij.database.model.basic.BasicModColumniation;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.basic.BasicModTypedElement;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.database.SqlObjectBuilder;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlForeignKeyDefinitionImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00f2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001:\u0001_B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u001f\u001a\n !*\u0004\u0018\u00010 0 2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#H\u0002J \u0010$\u001a\n !*\u0004\u0018\u00010 0 2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#H\u0002J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00170\u001b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010(\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020)2\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010*\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020+2\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00170-2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010.\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010/\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u0002002\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u00101\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u00102\u001a\u0004\u0018\u00010\u00172\b\u0010\u0007\u001a\u0004\u0018\u000103H\u0002J\u0014\u00104\u001a\u0004\u0018\u00010\u00172\b\u0010\u0007\u001a\u0004\u0018\u000105H\u0002J\u0018\u00106\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u00107\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u0002082\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u00109\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020:2\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010;\u001a\u00020<2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010=\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020>2\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0012\u0010?\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0007\u001a\u00020\bH\u0002J2\u0010@\u001a$\u0012\f\u0012\n !*\u0004\u0018\u00010B0B !*\u0010\u0012\f\u0012\n !*\u0004\u0018\u00010B0B0-0A2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010E\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020F2\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0012\u0010G\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010H\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010I\u001a\n !*\u0004\u0018\u00010J0J2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00170\u001b2\u000e\u0010L\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0MH\u0002J\u0010\u0010N\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0016J\u0010\u0010N\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0016J\u0010\u0010O\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020)H\u0014J+\u0010P\u001a\u0004\u0018\u0001032\b\u0010Q\u001a\u0004\u0018\u0001032\u0014\b\u0004\u0010R\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020\u001d0SH\u0084\bJ\u001c\u0010P\u001a\u0004\u0018\u0001032\b\u0010T\u001a\u0004\u0018\u0001032\u0006\u0010U\u001a\u00020VH\u0004J\u001c\u0010W\u001a\u0004\u0018\u0001032\b\u0010X\u001a\u0004\u0018\u0001032\u0006\u0010U\u001a\u00020VH\u0004J3\u0010W\u001a\u0004\u0018\u0001032\b\u0010X\u001a\u0004\u0018\u0001032\u0006\u0010Y\u001a\u00020Z2\u0014\b\u0004\u0010R\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020\u001d0SH\u0084\bJ$\u0010W\u001a\u0004\u0018\u0001032\b\u0010X\u001a\u0004\u0018\u0001032\u0006\u0010Y\u001a\u00020Z2\u0006\u0010U\u001a\u00020VH\u0004J'\u0010[\u001a\u00020\u00042\b\u0010Q\u001a\u0004\u0018\u0001032\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020\u00040SH\u0084\bJ'\u0010\\\u001a\u00020\u00042\b\u0010]\u001a\u0004\u0018\u0001032\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020\u00040SH\u0084\bJ\u0018\u0010^\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006`"}, d2={"Lcom/intellij/sql/database/SqlObjectBuilderImpl;", "Lcom/intellij/sql/database/SqlObjectBuilder;", "()V", "assignName", "", "obj", "Lcom/intellij/database/model/basic/BasicModNamedElement;", "source", "Lcom/intellij/database/model/DasObject;", "build", "Lcom/intellij/database/model/basic/BasicModElement;", "buildArgument", "Lcom/intellij/database/model/basic/BasicModArgument;", "buildArgumentDir", "Lcom/intellij/database/model/DasArgument$Direction;", "buildArranged", "Lcom/intellij/database/model/basic/BasicModArrangedElement;", "buildArrangedPos", "", "buildBasicElement", "buildCheck", "Lcom/intellij/database/model/basic/BasicModCheck;", "buildCheckPredicate", "", "buildColumniation", "Lcom/intellij/database/model/basic/BasicModColumniation;", "buildColumniationRefs", "", "buildFkIsDeferrable", "", "buildFkIsDeferred", "buildFkOnDelete", "Lcom/intellij/database/model/properties/CascadeRule;", "kotlin.jvm.PlatformType", "rdbms", "Lorg/jetbrains/dekaf/Rdbms;", "buildFkOnUpdate", "buildFkRefColumns", "buildFkRefSchemaName", "buildFkRefTableName", "buildForeignKey", "Lcom/intellij/database/model/basic/BasicModForeignKey;", "buildIndex", "Lcom/intellij/database/model/basic/BasicModIndex;", "buildIndexReverseColumns", "", "buildIndexUnique", "buildKey", "Lcom/intellij/database/model/basic/BasicModKey;", "buildKeyIsPrimary", "buildNameFromPsiElement", "Lcom/intellij/psi/PsiElement;", "buildNameFromRef", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "buildNamedElement", "buildNamespace", "Lcom/intellij/database/model/basic/BasicModNamespace;", "buildRoutine", "Lcom/intellij/database/model/basic/BasicModRoutine;", "buildRoutineKind", "Lcom/intellij/database/model/DasRoutine$Kind;", "buildTrigger", "Lcom/intellij/database/model/basic/BasicModTrigger;", "buildTriggerCondition", "buildTriggerEvents", "", "Lcom/intellij/database/model/TrigEvent;", "buildTriggerTurn", "Lcom/intellij/database/model/TrigTurn;", "buildTyped", "Lcom/intellij/database/model/basic/BasicModTypedElement;", "buildTypedDef", "buildTypedNotNull", "buildTypedType", "Lcom/intellij/database/model/DataType;", "collectNames", "ref", "Lcom/intellij/database/model/MultiRef;", "finalize", "finalizeForeignKey", "findChild", "el", "action", "Lkotlin/Function1;", "parent", "type", "Lcom/intellij/psi/tree/IElementType;", "findSibling", "element", "direction", "Lcom/intellij/sql/database/SqlObjectBuilderImpl$Direction;", "forEachChild", "forEachSibling", "first", "partialBuild", "Direction", "sql-impl"})
public abstract class SqlObjectBuilderImpl
implements SqlObjectBuilder {
    public void partialBuild(@NotNull DasObject obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
    }

    public void build(@NotNull DasObject obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.build((BasicModElement)obj, source);
    }

    public void finalize(@NotNull DasObject obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        this.finalize((BasicModElement)obj);
    }

    public void finalize(@NotNull BasicModElement obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        if (obj instanceof BasicModForeignKey) {
            this.finalizeForeignKey((BasicModForeignKey)obj);
        }
    }

    protected void finalizeForeignKey(@NotNull BasicModForeignKey obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        BasicTableOrView basicTableOrView = obj.getRefTable();
        if (basicTableOrView == null) {
            return;
        }
        BasicTableOrView refTable = basicTableOrView;
        List<String> refCols = obj.getRefColNames();
        if (refCols.isEmpty()) {
            BasicKey key2;
            BasicKey basicKey = key2 = refTable.getPrimaryKey();
            obj.setRefKeyName(basicKey != null ? basicKey.getName() : null);
            if (key2 != null) {
                obj.setRefColNames(key2.getColNames());
            }
        } else {
            BasicKey key3;
            BasicKey basicKey = key3 = refTable.getKeys().find((Predicate<? extends BasicKey>)new Predicate<BasicKey>(refCols){
                final /* synthetic */ List $refCols;

                public final boolean test(BasicKey k) {
                    return k.areColNames(this.$refCols);
                }
                {
                    this.$refCols = list;
                }
            });
            obj.setRefKeyName(basicKey != null ? basicKey.getName() : null);
        }
    }

    public void build(@NotNull BasicModElement obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        BasicModElement basicModElement = obj;
        if (basicModElement instanceof BasicModNamespace) {
            this.buildNamespace((BasicModNamespace)obj, source);
        } else if (basicModElement instanceof BasicModArgument) {
            this.buildArgument((BasicModArgument)obj, source);
        } else if (basicModElement instanceof BasicModForeignKey) {
            this.buildForeignKey((BasicModForeignKey)obj, source);
        } else if (basicModElement instanceof BasicModIndex) {
            this.buildIndex((BasicModIndex)obj, source);
        } else if (basicModElement instanceof BasicModKey) {
            this.buildKey((BasicModKey)obj, source);
        } else if (basicModElement instanceof BasicModRoutine) {
            this.buildRoutine((BasicModRoutine)obj, source);
        } else if (basicModElement instanceof BasicModTrigger) {
            this.buildTrigger((BasicModTrigger)obj, source);
        } else if (basicModElement instanceof BasicModCheck) {
            this.buildCheck((BasicModCheck)obj, source);
        } else {
            this.buildBasicElement(obj, source);
        }
    }

    protected void buildBasicElement(@NotNull BasicModElement obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (obj instanceof BasicModNamedElement) {
            this.buildNamedElement((BasicModNamedElement)obj, source);
        }
        if (obj instanceof BasicModArrangedElement) {
            this.buildArranged((BasicModArrangedElement)obj, source);
        }
        if (obj instanceof BasicModTypedElement) {
            this.buildTyped((BasicModTypedElement)obj, source);
        }
        if (obj instanceof BasicModColumniation) {
            this.buildColumniation((BasicModColumniation)obj, source);
        }
    }

    protected void buildForeignKey(@NotNull BasicModForeignKey obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildBasicElement(obj, source);
        Rdbms rdbms = ((BasicModModel)obj.getModel()).getRdbms();
        obj.setDeferrable(this.buildFkIsDeferrable(source));
        obj.setInitiallyDeferred(this.buildFkIsDeferred(source));
        Rdbms rdbms2 = rdbms;
        Intrinsics.checkExpressionValueIsNotNull((Object)rdbms2, (String)"rdbms");
        obj.setOnDelete(this.buildFkOnDelete(source, rdbms2));
        obj.setOnUpdate(this.buildFkOnUpdate(source, rdbms));
        obj.setRefColNames(this.buildFkRefColumns(source));
        obj.setRefTableName(this.buildFkRefTableName(source));
        obj.setRefSchemaName(this.buildFkRefSchemaName(source));
    }

    private final String buildFkRefSchemaName(DasObject source) {
        String string;
        DasObject dasObject = source;
        if (dasObject instanceof SqlForeignKeyDefinitionImpl) {
            SqlReferenceExpression sqlReferenceExpression = ((SqlForeignKeyDefinitionImpl)source).getRefTableReference();
            Object object = sqlReferenceExpression != null ? sqlReferenceExpression.getParent() : null;
            if (!(object instanceof SqlReferenceExpression)) {
                object = null;
            }
            string = this.buildNameFromRef((SqlReferenceExpression)object);
        } else {
            string = dasObject instanceof DasForeignKey ? StringUtil.nullize((String)((DasForeignKey)source).getRefTableSchema(), (boolean)true) : null;
        }
        return string;
    }

    private final String buildFkRefTableName(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof SqlForeignKeyDefinitionImpl ? this.buildNameFromRef(((SqlForeignKeyDefinitionImpl)source).getRefTableReference()) : (dasObject instanceof DasForeignKey ? ((DasForeignKey)source).getRefTableName() : null);
    }

    private final List<String> buildFkRefColumns(DasObject source) {
        List<String> list;
        DasObject dasObject = source;
        if (dasObject instanceof DasForeignKey) {
            MultiRef multiRef = ((DasForeignKey)source).getRefColumns();
            Intrinsics.checkExpressionValueIsNotNull((Object)multiRef, (String)"source.refColumns");
            list = this.collectNames((MultiRef<? extends DasObject>)multiRef);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final String buildNameFromRef(SqlReferenceExpression source) {
        if (source == null) {
            return null;
        }
        String string = this.buildNameFromPsiElement(source.resolve());
        if (string == null) {
            string = source.getName();
        }
        return string;
    }

    private final String buildNameFromPsiElement(PsiElement source) {
        PsiElement psiElement = source;
        return psiElement instanceof DasObject ? ((DasObject)source).getName() : (psiElement instanceof SqlNameElement ? ((SqlNameElement)source).getName() : null);
    }

    private final List<String> collectNames(MultiRef<? extends DasObject> ref) {
        ArrayList res = ContainerUtil.newArrayList();
        MultiRef.It it = ref.iterate();
        while (it.hasNext()) {
            String name = (String)it.next();
            DasObject obj = (DasObject)it.resolve();
            Object object = obj;
            if (object == null || (object = object.getName()) == null) {
                object = name;
            }
            res.add(object);
        }
        ArrayList arrayList = res;
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"res");
        return arrayList;
    }

    private final CascadeRule buildFkOnDelete(DasObject source, Rdbms rdbms) {
        DasObject dasObject = source;
        return dasObject instanceof DasForeignKey ? GenericIntrospectorLegacyModelUtils.asCascadeRule(((DasForeignKey)source).getDeleteRule(), rdbms) : CascadeRule.no_action;
    }

    private final CascadeRule buildFkOnUpdate(DasObject source, Rdbms rdbms) {
        DasObject dasObject = source;
        return dasObject instanceof DasForeignKey ? GenericIntrospectorLegacyModelUtils.asCascadeRule(((DasForeignKey)source).getUpdateRule(), rdbms) : CascadeRule.no_action;
    }

    private final boolean buildFkIsDeferred(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasForeignKey ? Intrinsics.areEqual((Object)((DasForeignKey)source).getDeferrability(), (Object)DasForeignKey.Deferrability.INITIALLY_DEFERRED) : false;
    }

    private final boolean buildFkIsDeferrable(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasForeignKey ? ((DasForeignKey)source).getDeferrability() != null && Intrinsics.areEqual((Object)((DasForeignKey)source).getDeferrability(), (Object)DasForeignKey.Deferrability.NOT_DEFERRABLE) ^ true : false;
    }

    protected void buildRoutine(@NotNull BasicModRoutine obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildBasicElement(obj, source);
        obj.setRoutineKind(this.buildRoutineKind(source));
    }

    private final DasRoutine.Kind buildRoutineKind(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasRoutine ? ((DasRoutine)source).getRoutineKind() : DasRoutine.Kind.NONE;
    }

    protected void buildCheck(@NotNull BasicModCheck obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildBasicElement(obj, source);
        obj.setPredicate(this.buildCheckPredicate(source));
    }

    private final String buildCheckPredicate(DasObject source) {
        String string;
        DasObject dasObject = source;
        if (dasObject instanceof SqlConstraintDefinition) {
            SqlExpression sqlExpression = (SqlExpression)((SqlConstraintDefinition)source).getConstraintParameter(SqlConstraintDefinition.EXPRESSION);
            string = sqlExpression != null ? sqlExpression.getText() : null;
        } else {
            string = null;
        }
        return string;
    }

    protected void buildTrigger(@NotNull BasicModTrigger obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildBasicElement(obj, source);
        obj.setEvents(this.buildTriggerEvents(source));
        obj.setTurn(this.buildTriggerTurn(source));
        obj.setCondition(this.buildTriggerCondition(source));
    }

    private final Set<TrigEvent> buildTriggerEvents(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasTrigger ? ((DasTrigger)source).getEvents() : SetsKt.emptySet();
    }

    private final TrigTurn buildTriggerTurn(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasTrigger ? ((DasTrigger)source).getTurn() : null;
    }

    private final String buildTriggerCondition(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasTrigger ? ((DasTrigger)source).getCondition() : null;
    }

    protected void buildIndex(@NotNull BasicModIndex obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildBasicElement(obj, source);
        obj.setUnique(this.buildIndexUnique(source));
        obj.setReverseColNames(this.buildIndexReverseColumns(source));
    }

    private final boolean buildIndexUnique(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasIndex ? ((DasIndex)source).isUnique() : false;
    }

    private final Set<String> buildIndexReverseColumns(DasObject source) {
        Set set;
        DasObject dasObject = source;
        if (dasObject instanceof DasIndex) {
            DasTypedObject it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv = ((DasIndex)source).getColumnsRef().resolveObjects();
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (DasTypedObject)element$iv$iv;
                if (!Intrinsics.areEqual((Object)((DasIndex)source).getColumnSorting(it), (Object)DasIndex.Sorting.DESCENDING)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it = (DasTypedObject)item$iv$iv;
                Collection collection = destination$iv$iv;
                String string = it.getName();
                collection.add(string);
            }
            set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    protected void buildKey(@NotNull BasicModKey obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildBasicElement(obj, source);
        obj.setPrimary(this.buildKeyIsPrimary(source));
    }

    private final boolean buildKeyIsPrimary(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasTableKey ? ((DasTableKey)source).isPrimary() : false;
    }

    protected void buildArgument(@NotNull BasicModArgument obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildBasicElement(obj, source);
        obj.setArgumentDirection(this.buildArgumentDir(source));
    }

    private final DasArgument.Direction buildArgumentDir(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasArgument ? ((DasArgument)source).getArgumentDirection() : DasArgument.Direction.IN;
    }

    protected void buildColumniation(@NotNull BasicModColumniation obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        obj.setColNames(this.buildColumniationRefs(source));
    }

    private final List<String> buildColumniationRefs(DasObject source) {
        List<String> list;
        DasObject dasObject = source;
        if (dasObject instanceof DasConstraint) {
            MultiRef multiRef = ((DasConstraint)source).getColumnsRef();
            Intrinsics.checkExpressionValueIsNotNull((Object)multiRef, (String)"source.columnsRef");
            list = this.collectNames((MultiRef<? extends DasObject>)multiRef);
        } else if (dasObject instanceof DasIndex) {
            MultiRef multiRef = ((DasIndex)source).getColumnsRef();
            Intrinsics.checkExpressionValueIsNotNull((Object)multiRef, (String)"source.columnsRef");
            list = this.collectNames((MultiRef<? extends DasObject>)multiRef);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    protected void buildArranged(@NotNull BasicModArrangedElement obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (source instanceof DasPositioned) {
            obj.setPosition(((DasPositioned)source).getPosition());
        }
    }

    private final short buildArrangedPos(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasPositioned ? ((DasPositioned)source).getPosition() : (short)0;
    }

    protected void buildTyped(@NotNull BasicModTypedElement obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        obj.setDataType(this.buildTypedType(source));
        obj.setDefaultExpression(this.buildTypedDef(source));
        obj.setNotNull(this.buildTypedNotNull(source));
    }

    private final DataType buildTypedType(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasTypedObject ? ((DasTypedObject)source).getDataType() : DataType.UNKNOWN;
    }

    private final String buildTypedDef(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasTypedObject ? ((DasTypedObject)source).getDefault() : null;
    }

    private final boolean buildTypedNotNull(DasObject source) {
        DasObject dasObject = source;
        return dasObject instanceof DasTypedObject ? ((DasTypedObject)source).isNotNull() : false;
    }

    protected void buildNamedElement(@NotNull BasicModNamedElement obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.assignName(obj, source);
        obj.setComment(source.getComment());
        obj.setNameQuoted(DbSqlUtil.isQuoted(source));
        obj.setNameScripted(DbSqlUtil.isSqlObject(source));
    }

    protected void assignName(@NotNull BasicModNamedElement obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        obj.setName(source.getName());
    }

    protected void buildNamespace(@NotNull BasicModNamespace obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.buildBasicElement(obj, source);
        if (obj instanceof BasicModMateNamespace) {
            ((BasicModMateNamespace)obj).setVisible(true);
        }
    }

    protected final void forEachChild(@Nullable PsiElement el, @NotNull Function1<? super PsiElement, Unit> action) {
        PsiElement first$iv;
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        PsiElement psiElement = el;
        for (PsiElement tmp$iv = first$iv = (v822234) != null ? (v822234).getFirstChild() : null; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
            action.invoke((Object)tmp$iv);
        }
    }

    protected final void forEachSibling(@Nullable PsiElement first, @NotNull Function1<? super PsiElement, Unit> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        for (PsiElement tmp = first; tmp != null; tmp = tmp.getNextSibling()) {
            action.invoke((Object)tmp);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final PsiElement findChild(@Nullable PsiElement parent, @NotNull IElementType type) {
        PsiElement psiElement;
        block2: {
            void element$iv$iv;
            SqlObjectBuilderImpl this_$iv;
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv = this;
            PsiElement psiElement2 = parent;
            PsiElement psiElement3 = psiElement2 != null ? psiElement2.getFirstChild() : null;
            Direction direction$iv$iv = Direction.NEXT;
            PsiElement tmp$iv$iv = element$iv$iv;
            while (tmp$iv$iv != null) {
                void it = tmp$iv$iv;
                ASTNode aSTNode = it.getNode();
                if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)type)) {
                    psiElement = tmp$iv$iv;
                    break block2;
                }
                tmp$iv$iv = direction$iv$iv.next(tmp$iv$iv);
            }
            psiElement = null;
        }
        return psiElement;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final PsiElement findChild(@Nullable PsiElement el, @NotNull Function1<? super PsiElement, Boolean> action) {
        PsiElement psiElement;
        block2: {
            void element$iv;
            Intrinsics.checkParameterIsNotNull(action, (String)"action");
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
            PsiElement psiElement2 = el;
            PsiElement psiElement3 = psiElement2 != null ? psiElement2.getFirstChild() : null;
            Direction direction$iv = Direction.NEXT;
            PsiElement tmp$iv = element$iv;
            while (tmp$iv != null) {
                if (((Boolean)action.invoke((Object)tmp$iv)).booleanValue()) {
                    psiElement = tmp$iv;
                    break block2;
                }
                tmp$iv = direction$iv.next(tmp$iv);
            }
            psiElement = null;
        }
        return psiElement;
    }

    @Nullable
    protected final PsiElement findSibling(@Nullable PsiElement element, @NotNull IElementType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return this.findSibling(element, Direction.NEXT, type);
    }

    @Nullable
    protected final PsiElement findSibling(@Nullable PsiElement element, @NotNull Direction direction, @NotNull IElementType type) {
        PsiElement psiElement;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)((Object)direction), (String)"direction");
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            SqlObjectBuilderImpl this_$iv = this;
            PsiElement tmp$iv = element;
            while (tmp$iv != null) {
                PsiElement it = tmp$iv;
                ASTNode aSTNode = it.getNode();
                if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)type)) {
                    psiElement = tmp$iv;
                    break block2;
                }
                tmp$iv = direction.next(tmp$iv);
            }
            psiElement = null;
        }
        return psiElement;
    }

    @Nullable
    protected final PsiElement findSibling(@Nullable PsiElement element, @NotNull Direction direction, @NotNull Function1<? super PsiElement, Boolean> action) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)direction), (String)"direction");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        PsiElement tmp = element;
        while (tmp != null) {
            if (((Boolean)action.invoke((Object)tmp)).booleanValue()) {
                return tmp;
            }
            tmp = direction.next(tmp);
        }
        return null;
    }

    public static final /* synthetic */ void access$forEachSibling(SqlObjectBuilderImpl $this, @Nullable PsiElement first, @NotNull Function1 action) {
        $this.forEachSibling(first, (Function1<? super PsiElement, Unit>)action);
    }

    @Nullable
    public static final /* synthetic */ PsiElement access$findSibling(SqlObjectBuilderImpl $this, @Nullable PsiElement element, @NotNull Direction direction, @NotNull Function1 action) {
        return $this.findSibling(element, direction, (Function1<? super PsiElement, Boolean>)action);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H&j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/database/SqlObjectBuilderImpl$Direction;", "", "(Ljava/lang/String;I)V", "next", "Lcom/intellij/psi/PsiElement;", "element", "NEXT", "PREVIOUS", "sql-impl"})
    public static final abstract class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction NEXT;
        public static final /* enum */ Direction PREVIOUS;
        private static final /* synthetic */ Direction[] $VALUES;

        static {
            Direction[] directionArray = new Direction[2];
            Direction[] directionArray2 = directionArray;
            directionArray[0] = NEXT = new NEXT("NEXT", 0);
            directionArray[1] = PREVIOUS = new PREVIOUS("PREVIOUS", 1);
            $VALUES = directionArray;
        }

        @Nullable
        public abstract PsiElement next(@NotNull PsiElement var1);

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        public static Direction valueOf(String string) {
            return Enum.valueOf(Direction.class, string);
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/sql/database/SqlObjectBuilderImpl$Direction$NEXT;", "Lcom/intellij/sql/database/SqlObjectBuilderImpl$Direction;", "(Ljava/lang/String;I)V", "next", "Lcom/intellij/psi/PsiElement;", "element", "sql-impl"})
        public static final class NEXT
        extends Direction {
            @Override
            @Nullable
            public PsiElement next(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                return element.getNextSibling();
            }

            NEXT() {
            }
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/sql/database/SqlObjectBuilderImpl$Direction$PREVIOUS;", "Lcom/intellij/sql/database/SqlObjectBuilderImpl$Direction;", "(Ljava/lang/String;I)V", "next", "Lcom/intellij/psi/PsiElement;", "element", "sql-impl"})
        public static final class PREVIOUS
        extends Direction {
            @Override
            @Nullable
            public PsiElement next(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                return element.getPrevSibling();
            }

            PREVIOUS() {
            }
        }
    }
}

