/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.ide.scratch.LRUPopupBuilder;
import com.intellij.ide.scratch.ScratchFileActions;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlDialectsConfigurable;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlLanguageSubstitutor;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeDialectAction
extends ScratchFileActions.LanguageAction {
    @NotNull
    protected String getLanguageTerm() {
        if ("Dialect" == null) {
            ChangeDialectAction.$$$reportNull$$$0(0);
        }
        return "Dialect";
    }

    @NotNull
    protected Condition<VirtualFile> fileFilter(Project project) {
        Condition<VirtualFile> condition = ChangeDialectAction.FILE_FILTER(project);
        if (condition == null) {
            ChangeDialectAction.$$$reportNull$$$0(1);
        }
        return condition;
    }

    @NotNull
    public static Condition<VirtualFile> FILE_FILTER(final Project project) {
        Condition<VirtualFile> condition = new Condition<VirtualFile>(){
            PsiManager psiManager;
            {
                this.psiManager = PsiManager.getInstance((Project)project);
            }

            public boolean value(VirtualFile file) {
                if (file.getFileType() == SqlFileType.INSTANCE) {
                    return true;
                }
                if (JdbcConsole.getConsole(project, file) != null) {
                    return true;
                }
                if (ScratchRootType.getInstance().containsFile(file)) {
                    return false;
                }
                return this.psiManager.findFile(file) instanceof SqlFile && file.isInLocalFileSystem();
            }
        };
        if (condition == null) {
            ChangeDialectAction.$$$reportNull$$$0(2);
        }
        return condition;
    }

    @NotNull
    protected Function<VirtualFile, Language> fileLanguage(Project project) {
        Function function = virtualFile -> SqlLanguageSubstitutor.getSqlLanguageDialect(virtualFile, project);
        if (function == null) {
            ChangeDialectAction.$$$reportNull$$$0(3);
        }
        return function;
    }

    protected void actionPerformedImpl(AnActionEvent e, Project project, JBIterable<VirtualFile> files) {
        ListPopup popup = ChangeDialectAction.buildDialectsPopup(project, files);
        popup.showInBestPositionFor(e.getDataContext());
    }

    @NotNull
    public static ListPopup buildDialectsPopup(@NotNull Project project, @NotNull JBIterable<VirtualFile> files) {
        if (project == null) {
            ChangeDialectAction.$$$reportNull$$$0(4);
        }
        if (files == null) {
            ChangeDialectAction.$$$reportNull$$$0(5);
        }
        LRUPopupBuilder builder = LRUPopupBuilder.languagePopupBuilder((Project)project, (String)"SQL Dialects").withComparator(LanguageUtil.LANGUAGE_COMPARATOR).forValues(SqlDialectMappings.getAvailableDialects());
        builder.onChosen(language -> {
            if (project == null) {
                ChangeDialectAction.$$$reportNull$$$0(9);
            }
            if (files == null) {
                ChangeDialectAction.$$$reportNull$$$0(10);
            }
            ChangeDialectAction.setDialectImpl(project, files, language);
        });
        if (files.find(ScratchUtil::isScratch) == null) {
            builder.withExtra((Object)Language.ANY, "SQL Dialects...", null);
        }
        ListPopup listPopup = builder.buildPopup();
        if (listPopup == null) {
            ChangeDialectAction.$$$reportNull$$$0(6);
        }
        return listPopup;
    }

    public static void setDialectImpl(@NotNull Project project, @NotNull JBIterable<VirtualFile> files, @Nullable Language language) {
        if (project == null) {
            ChangeDialectAction.$$$reportNull$$$0(7);
        }
        if (files == null) {
            ChangeDialectAction.$$$reportNull$$$0(8);
        }
        if (language == null || language == Language.ANY) {
            SqlDialectImplUtil.LOG.assertTrue(files.find(file -> ScratchUtil.isScratch((VirtualFile)file)) == null);
            SqlDialectsConfigurable.openDialectsConfigurable(project, (VirtualFile)files.first());
            return;
        }
        ScratchRootType scratchRootType = ScratchRootType.getInstance();
        for (VirtualFile file2 : files) {
            LocalDataSource dataSource;
            if (scratchRootType.containsFile(file2)) {
                ScratchFileService.getInstance().getScratchesMapping().setMapping(file2, (Object)language);
                continue;
            }
            if (file2 instanceof DatabaseElementVirtualFileImpl) {
                dataSource = DbImplUtil.getMaybeLocalDataSource((DatabaseSystem)((DatabaseElementVirtualFileImpl)file2).findDataSource());
            } else {
                JdbcConsole console = JdbcConsole.getConsole(project, file2);
                LocalDataSource localDataSource = dataSource = console == null ? null : (LocalDataSource)console.getTarget();
            }
            if (dataSource != null) {
                dataSource.setDefaultDialect(language.getID());
                DataSourceStorage.getProjectStorage(project).updateDataSource(dataSource);
                continue;
            }
            if (file2.isInLocalFileSystem()) {
                SqlDialectMappings.getInstance(project).setMapping(file2, (SqlLanguageDialect)language);
                continue;
            }
            if (!(file2 instanceof LightVirtualFile)) continue;
            ((LightVirtualFile)file2).setLanguage(language);
        }
        FileContentUtilCore.reparseFiles((Collection)files.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/ChangeDialectAction";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageTerm";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "fileFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "FILE_FILTER";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fileLanguage";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/ChangeDialectAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDialectsPopup";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildDialectsPopup";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setDialectImpl";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildDialectsPopup$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

