/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.openapi.impl;

import com.intellij.debugger.ui.HotSwapUI;
import com.intellij.j2ee.openapi.ex.DeploymentManagerEx;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.deployment.DeploymentSettings;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.deployment.DeploymentStatus;
import com.intellij.javaee.deployment.DeploymentViewEx;
import com.intellij.javaee.deployment.DeploymentViewImpl;
import com.intellij.javaee.deployment.JavaeeDeploymentListener;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentManagerImpl
extends DeploymentManagerEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.j2ee.openapi.impl.JspDeploymentManagerImpl");
    private final Project myProject;
    private final Map<Pair<DeploymentSource, CommonModel>, DeploymentData> myDeploymentKey2Data = new com.intellij.util.containers.HashMap();
    private final Map<J2EEServerInstance, EventDispatcher<JavaeeDeploymentListener>> myDeploymentListeners = new HashMap<J2EEServerInstance, EventDispatcher<JavaeeDeploymentListener>>();

    public DeploymentManagerImpl(Project project) {
        this.myProject = project;
    }

    public void setDeploymentStatus(DeploymentModel model, DeploymentStatus status, CommonModel instanceConfiguration, J2EEServerInstance serverInstance) {
        DeploymentData data = this.getDeploymentData(model, instanceConfiguration);
        if (data.isReadingInitialStatus() && ArrayUtil.contains((Object)status, (Object[])new DeploymentStatus[]{DeploymentStatus.DEPLOYED, DeploymentStatus.NOT_DEPLOYED, DeploymentStatus.UNKNOWN})) {
            data.setReadingInitialStatus(false);
            data.setKeepDeployedAfterDisconnect(status == DeploymentStatus.DEPLOYED);
            return;
        }
        data.setStatus(status);
        this.fireDeploymentListeners(serverInstance, model, status, instanceConfiguration);
    }

    @NotNull
    public DeploymentStatus getDeploymentStatus(@NotNull DeploymentModel model, CommonModel instanceConfiguration) {
        if (model == null) {
            DeploymentManagerImpl.$$$reportNull$$$0(0);
        }
        DeploymentStatus deploymentStatus = this.getDeploymentData(model, instanceConfiguration).getStatus();
        if (deploymentStatus == null) {
            DeploymentManagerImpl.$$$reportNull$$$0(1);
        }
        return deploymentStatus;
    }

    public boolean isKeepDeployedAfterDisconnect(DeploymentModel model, CommonModel instanceConfiguration) {
        return this.getDeploymentData(model, instanceConfiguration).isKeepDeployedAfterDisconnect();
    }

    public void setKeepDeployedAfterDisconnect(DeploymentModel deploymentModel, CommonModel commonModel, boolean keepDeployedAfterDisconnect) {
        this.getDeploymentData(deploymentModel, commonModel).setKeepDeployedAfterDisconnect(keepDeployedAfterDisconnect);
    }

    public void initKeepDeployedAfterDisconnect(J2EEServerInstance instance, CommonModel instanceConfiguration) {
        CommonStrategy commonStrategy = (CommonStrategy)instanceConfiguration;
        DeploymentSettings settings = commonStrategy.getDeploymentSettings();
        if (settings == null) {
            return;
        }
        for (DeploymentModel model : settings.getDeploymentModels()) {
            this.getDeploymentData(model, instanceConfiguration).setReadingInitialStatus(true);
        }
        this.updateAllDeploymentStatus(instance, instanceConfiguration);
    }

    private DeploymentData getDeploymentData(DeploymentModel model, CommonModel instanceConfiguration) {
        Pair key = Pair.create((Object)model.getDeploymentSource(), (Object)instanceConfiguration);
        DeploymentData data = this.myDeploymentKey2Data.get(key);
        if (data == null) {
            data = new DeploymentData();
            this.myDeploymentKey2Data.put((Pair<DeploymentSource, CommonModel>)key, data);
        }
        return data;
    }

    @Override
    public void addDeploymentListener(J2EEServerInstance serverInstance, JavaeeDeploymentListener listener) {
        EventDispatcher dispatcher = this.myDeploymentListeners.get(serverInstance);
        if (dispatcher == null) {
            dispatcher = EventDispatcher.create(JavaeeDeploymentListener.class);
            this.myDeploymentListeners.put(serverInstance, (EventDispatcher<JavaeeDeploymentListener>)dispatcher);
        }
        dispatcher.addListener((EventListener)listener);
    }

    @Override
    public void addDeploymentListener(final J2EEServerInstance serverInstance, final JavaeeDeploymentListener listener, Disposable parentDisposable) {
        this.addDeploymentListener(serverInstance, listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                DeploymentManagerImpl.this.removeDeploymentListener(serverInstance, listener);
            }
        });
    }

    @Override
    public void removeDeploymentListener(J2EEServerInstance serverInstance, JavaeeDeploymentListener listener) {
        EventDispatcher<JavaeeDeploymentListener> dispatcher = this.myDeploymentListeners.get(serverInstance);
        if (dispatcher != null) {
            dispatcher.removeListener((EventListener)listener);
            if (!dispatcher.hasListeners()) {
                this.myDeploymentListeners.remove(serverInstance);
            }
        }
    }

    private void fireDeploymentListeners(J2EEServerInstance serverInstance, DeploymentModel deploymentModel, DeploymentStatus newStatus, CommonModel runConfiguration) {
        EventDispatcher<JavaeeDeploymentListener> eventDispatcher = this.myDeploymentListeners.get(serverInstance);
        if (eventDispatcher == null) {
            return;
        }
        ((JavaeeDeploymentListener)eventDispatcher.getMulticaster()).deploymentStatusChanged(deploymentModel, newStatus, runConfiguration);
    }

    @Override
    public boolean isAllModulesDeployed(CommonModel commonModel) {
        DeploymentSettings deploymentSettings = commonModel.getDeploymentSettings();
        if (deploymentSettings != null) {
            for (DeploymentModel deploymentModel : deploymentSettings.getDeploymentModels()) {
                if (this.getDeploymentStatus(deploymentModel, commonModel) == DeploymentStatus.DEPLOYED) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public List<Artifact> getSupportedArtifacts(@NotNull DeploymentProvider deploymentProvider) {
        if (deploymentProvider == null) {
            DeploymentManagerImpl.$$$reportNull$$$0(2);
        }
        if (this.myProject.isDefault()) {
            List<Artifact> list = Collections.emptyList();
            if (list == null) {
                DeploymentManagerImpl.$$$reportNull$$$0(3);
            }
            return list;
        }
        Artifact[] artifacts = ArtifactManager.getInstance((Project)this.myProject).getSortedArtifacts();
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        Collection supportedTypes = deploymentProvider.getSupportedArtifactTypes();
        for (Artifact artifact : artifacts) {
            if (!supportedTypes.contains(artifact.getArtifactType())) continue;
            result.add(artifact);
        }
        ArrayList<Artifact> arrayList = result;
        if (arrayList == null) {
            DeploymentManagerImpl.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public void clean(J2EEServerInstance instance, CommonModel runConfiguration) {
        CommonStrategy commonStrategy = (CommonStrategy)runConfiguration;
        DeploymentSettings settings = commonStrategy.getDeploymentSettings();
        if (settings == null) {
            return;
        }
        ArrayList<DeploymentModel> deploymentModels = new ArrayList<DeploymentModel>();
        for (DeploymentModel model : settings.getDeploymentModels()) {
            if (this.isKeepDeployedAfterDisconnect(model, commonStrategy)) continue;
            deploymentModels.add(model);
        }
        if (!deploymentModels.isEmpty()) {
            commonStrategy.getDeploymentProvider().cleanDeployments(instance, deploymentModels);
        }
    }

    @Override
    public void deployArtifactsWithoutCompilation(J2EEServerInstance serverInstance, Collection<? extends Artifact> artifacts) {
        CommonModel commonModel = serverInstance.getCommonModel();
        DeploymentSettings deploymentSettings = commonModel.getDeploymentSettings();
        if (deploymentSettings == null) {
            return;
        }
        for (Artifact artifact : artifacts) {
            DeploymentProvider deploymentProvider;
            DeploymentModel model = deploymentSettings.getModel(artifact);
            if (model == null || (deploymentProvider = DeploymentManagerEx.getProvider(commonModel)) == null) continue;
            deploymentProvider.doDeploy(commonModel.getProject(), serverInstance, model);
        }
    }

    public void deployModules(J2EEServerInstance instance, CommonModel runConfiguration, boolean makeBeforeDeploy, @Nullable Runnable callback, List<DeploymentModel> modules) {
        Project project = runConfiguration.getProject();
        CommonStrategy commonStrategy = (CommonStrategy)runConfiguration;
        DeploymentSettings settings = commonStrategy.getDeploymentSettings();
        if (settings == null) {
            return;
        }
        List deploymentModels = modules.isEmpty() ? settings.getDeploymentModels() : modules;
        final Runnable deployAction = () -> {
            try {
                for (DeploymentModel model : deploymentModels) {
                    commonStrategy.getDeploymentProvider().doDeploy(project, instance, model);
                }
                if (callback != null) {
                    callback.run();
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        };
        if (makeBeforeDeploy) {
            HotSwapUI.getInstance((Project)project).dontPerformHotswapAfterThisCompilation();
            CompilerManager.getInstance((Project)project).make(commonStrategy.getCompileScope(), new CompileStatusNotification(){

                public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                    if (!aborted && errors == 0) {
                        deployAction.run();
                    }
                }
            });
        } else {
            deployAction.run();
        }
    }

    public void undeployNonKeptModules(J2EEServerInstance instance, CommonModel runConfiguration) {
        CommonStrategy commonStrategy = (CommonStrategy)runConfiguration;
        DeploymentSettings settings = commonStrategy.getDeploymentSettings();
        if (settings == null) {
            return;
        }
        for (DeploymentModel model : ContainerUtil.iterateBackward((List)settings.getDeploymentModels())) {
            if (this.isKeepDeployedAfterDisconnect(model, commonStrategy) || this.getDeploymentStatus(model, commonStrategy) != DeploymentStatus.DEPLOYED) continue;
            commonStrategy.getDeploymentProvider().startUndeploy(instance, model);
        }
    }

    public File getDeploymentSource(DeploymentModel model) {
        return model.getDeploymentSource().getFile();
    }

    public String getDeploymentSourcePath(DeploymentModel model) {
        return model.getDeploymentSource().getFilePath();
    }

    public void updateAllDeploymentStatus(J2EEServerInstance instance, CommonModel runConfiguration) {
        if (instance == null) {
            return;
        }
        CommonStrategy commonStrategy = (CommonStrategy)runConfiguration;
        DeploymentProvider deploymentProvider = commonStrategy.getDeploymentProvider();
        LOG.assertTrue(deploymentProvider != null);
        DeploymentSettings settings = commonStrategy.getDeploymentSettings();
        if (settings != null) {
            for (DeploymentModel model : settings.getDeploymentModels()) {
                deploymentProvider.updateDeploymentStatus(instance, model);
            }
        }
    }

    public DeploymentModel getModelForFacet(@NotNull CommonModel commonModel, @NotNull JavaeeFacet facet) {
        DeploymentSettings deploymentSettings;
        if (commonModel == null) {
            DeploymentManagerImpl.$$$reportNull$$$0(5);
        }
        if (facet == null) {
            DeploymentManagerImpl.$$$reportNull$$$0(6);
        }
        if ((deploymentSettings = commonModel.getDeploymentSettings()) == null) {
            return null;
        }
        List artifacts = deploymentSettings.getDeployedArtifacts();
        for (Artifact artifact : artifacts) {
            Collection facets = JavaeeArtifactUtil.getInstance().getFacetsIncludedInArtifact(this.myProject, artifact, null);
            if (!facets.contains(facet)) continue;
            return deploymentSettings.getModel(artifact);
        }
        return null;
    }

    @Override
    public DeploymentViewEx createDeploymentView(AppServerIntegration integration, CommonModel commonModel, J2EEServerInstance serverInstance) {
        CommonStrategy strategy = (CommonStrategy)commonModel;
        return new DeploymentViewImpl(this.myProject, strategy, this, serverInstance);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/j2ee/openapi/impl/DeploymentManagerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/j2ee/openapi/impl/DeploymentManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentStatus";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedArtifacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDeploymentStatus";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSupportedArtifacts";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModelForFacet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DeploymentData {
        private DeploymentStatus myStatus = DeploymentStatus.UNKNOWN;
        private boolean myKeepDeployedAfterDisconnect = false;
        private boolean myReadingInitialStatus = false;

        private DeploymentData() {
        }

        public DeploymentStatus getStatus() {
            return this.myStatus;
        }

        public void setStatus(DeploymentStatus status) {
            this.myStatus = status;
        }

        public boolean isKeepDeployedAfterDisconnect() {
            return this.myKeepDeployedAfterDisconnect;
        }

        public void setKeepDeployedAfterDisconnect(boolean keepDeployedAfterDisconnect) {
            this.myKeepDeployedAfterDisconnect = keepDeployedAfterDisconnect;
        }

        public boolean isReadingInitialStatus() {
            return this.myReadingInitialStatus;
        }

        public void setReadingInitialStatus(boolean readingInitialStatus) {
            this.myReadingInitialStatus = readingInitialStatus;
        }
    }
}

