/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.inspections;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.ejb.OldEjbRolesUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEjbInspection
extends LocalInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.JAVAEE_GROUP_NAME;
        if (string == null) {
            AbstractEjbInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected abstract JavaElementVisitor createJavaVisitor(@NotNull ProblemsHolder var1, boolean var2);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AbstractEjbInspection.$$$reportNull$$$0(1);
        }
        final JavaElementVisitor javaVisitor = this.createJavaVisitor(holder, isOnTheFly);
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){
            private Boolean myIsFileRelated = null;

            public void visitElement(PsiElement element) {
                PsiClass psiClass;
                if (this.myIsFileRelated == null) {
                    this.myIsFileRelated = AbstractEjbInspection.this.isFileEjbRelated(element.getContainingFile());
                }
                if (!this.myIsFileRelated.booleanValue()) {
                    return;
                }
                Object object = element instanceof PsiClass ? (PsiClass)element : (psiClass = element instanceof PsiMember ? ((PsiMember)element).getContainingClass() : null);
                if (psiClass != null && !AbstractEjbInspection.this.acceptClass(psiClass)) {
                    return;
                }
                element.accept((PsiElementVisitor)javaVisitor);
            }
        };
        if (psiElementVisitor == null) {
            AbstractEjbInspection.$$$reportNull$$$0(2);
        }
        return psiElementVisitor;
    }

    protected boolean acceptClass(PsiClass psiClass) {
        return OldEjbRolesUtil.getEjbRoles(psiClass).length > 0;
    }

    private boolean isFileEjbRelated(PsiFile file) {
        if (JavaeeFacetUtil.getInstance().getJavaeeFacets(EjbFacet.ID, file.getProject()).isEmpty()) {
            return false;
        }
        if (!JamCommonUtil.isPlainJavaFile((PsiElement)file)) {
            return false;
        }
        for (PsiClass psiClass : ((PsiJavaFile)file).getClasses()) {
            if (!this.acceptClass(psiClass)) continue;
            return true;
        }
        return false;
    }

    protected static EnumSet<EjbClassRoleEnum> getRoleTypes(EjbClassRole[] classRoles) {
        EnumSet<EjbClassRoleEnum> roleTypes = EnumSet.noneOf(EjbClassRoleEnum.class);
        for (EjbClassRole role : classRoles) {
            roleTypes.add(role.getType());
        }
        return roleTypes;
    }

    protected static <T extends EnterpriseBean> boolean isOfType(Class<T> beanType, EjbClassRole[] classRoles) {
        for (EjbClassRole classRole : classRoles) {
            EnterpriseBean ejb = classRole.getEnterpriseBean();
            if (ejb == null || !beanType.isInstance(ejb)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/inspections/AbstractEjbInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/inspections/AbstractEjbInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

