/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.agent;

import com.intellij.javaee.oss.agent.ParametersMap;
import com.intellij.javaee.process.common.DocumentReader;
import com.intellij.javaee.process.common.DocumentWriter;
import com.intellij.javaee.process.common.EncodingUtil;
import com.intellij.javaee.process.common.JavaeeProcessUtilException;
import com.intellij.javaee.process.common.OutputWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametersMapImpl
extends HashMap<String, String>
implements ParametersMap {
    private static final String PARAMETERS_ROOT = "parameters";

    public static ParametersMap load(String serializedParameters) throws JavaeeProcessUtilException {
        final ParametersMapImpl result = new ParametersMapImpl();
        InputSource inputSource = new InputSource(new StringReader(serializedParameters));
        DocumentReader documentReader = new DocumentReader(inputSource, PARAMETERS_ROOT);
        documentReader.iterateParams(new DocumentReader.ParamProcessor(){

            public void processParam(String name, String value) {
                result.put(name, EncodingUtil.decodeBase64(value));
            }
        });
        return result;
    }

    @Override
    public String save() throws JavaeeProcessUtilException {
        Document document = OutputWriter.createDocument();
        DocumentWriter resultWriter = new DocumentWriter(document, PARAMETERS_ROOT);
        for (Map.Entry param : this.entrySet()) {
            resultWriter.addParam((String)param.getKey(), EncodingUtil.encodeBase64((String)param.getValue()));
        }
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        OutputWriter.putDocument(streamResult, document);
        return stringWriter.toString();
    }
}

