/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.util;

import com.intellij.javaee.oss.util.FilteringIterator;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ConfigBase {
    protected static Element getChild(Element parent, @NonNls String tag) {
        return parent.getChild(tag, parent.getNamespace());
    }

    @Nullable
    protected static Element getChild(Element parent, @NonNls String tag, @NonNls String name, @NonNls String value) {
        for (Object o : parent.getChildren(tag, parent.getNamespace())) {
            Element element = (Element)o;
            if (!StringUtil.equals((CharSequence)element.getAttributeValue(name), (CharSequence)value)) continue;
            return element;
        }
        return null;
    }

    @Nullable
    protected static Element getChildByPattern(Element parent, @NonNls String tag, @NonNls String name, @NonNls String valuePattern) {
        for (Object o : parent.getChildren(tag, parent.getNamespace())) {
            Element element = (Element)o;
            if (!element.getAttributeValue(name).matches(valuePattern)) continue;
            return element;
        }
        return null;
    }

    protected static List<Element> getChildren(Element parent, @NonNls String tag) {
        return parent.getChildren(tag, parent.getNamespace());
    }

    protected static Iterable<Element> getChildren(final Element parent, final @NonNls String tag, final @NonNls String name, final @NonNls String value) {
        return new Iterable<Element>(){

            @Override
            public Iterator<Element> iterator() {
                return new FilteringIterator<Element>(ConfigBase.getChildren(parent, tag).iterator()){

                    @Override
                    protected boolean matches(Element element) {
                        return element.getAttributeValue(name).matches(value);
                    }
                };
            }
        };
    }

    protected static Element getOrCreateChild(Element parent, @NonNls String tag) {
        Element result = parent.getChild(tag);
        if (result == null) {
            result = new Element(tag);
            parent.addContent(result);
        }
        return result;
    }
}

