/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.validation;

import com.intellij.execution.ExecutionException;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.AppServerSpecificValidator;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.make.AppServerSpecificValidatorsManager;
import com.intellij.javaee.serverInstances.ApplicationServersManager;
import com.intellij.javaee.validation.AppServerValidatorsEditor;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.ArtifactPropertiesEditor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Property;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AppServerSpecificValidatorsProperties
extends ArtifactProperties<AppServerValidatorsState> {
    private final List<ApplicationServer> myValidatorOwners = new ArrayList<ApplicationServer>();
    private final ArtifactType myArtifactType;

    public AppServerSpecificValidatorsProperties(ArtifactType artifactType) {
        this.myArtifactType = artifactType;
    }

    public ArtifactPropertiesEditor createEditor(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            AppServerSpecificValidatorsProperties.$$$reportNull$$$0(0);
        }
        return new AppServerValidatorsEditor(this.myArtifactType, context.getProject(), new AppServerSpecificValidatorsManager(){

            @Override
            public ApplicationServer[] getValidatorOwners() {
                return AppServerSpecificValidatorsProperties.this.myValidatorOwners.toArray(new ApplicationServer[AppServerSpecificValidatorsProperties.this.myValidatorOwners.size()]);
            }

            @Override
            public void setValidatorsOwners(ApplicationServer[] validators) {
                AppServerSpecificValidatorsProperties.this.myValidatorOwners.clear();
                ContainerUtil.addAll((Collection)AppServerSpecificValidatorsProperties.this.myValidatorOwners, (Object[])validators);
            }
        });
    }

    public void onBuildFinished(@NotNull Artifact artifact, @NotNull CompileContext compileContext) {
        if (artifact == null) {
            AppServerSpecificValidatorsProperties.$$$reportNull$$$0(1);
        }
        if (compileContext == null) {
            AppServerSpecificValidatorsProperties.$$$reportNull$$$0(2);
        }
        for (ApplicationServer server : this.myValidatorOwners) {
            AppServerIntegration sourceIntegration = server.getSourceIntegration();
            if (sourceIntegration == null) continue;
            AppServerSpecificValidator validator = sourceIntegration.getAppServerSpecificValidator(server, artifact.getArtifactType(), compileContext.getProject());
            String outputPath = artifact.getOutputFilePath();
            if (validator == null || outputPath == null) continue;
            try {
                validator.validate(artifact, new File(FileUtil.toSystemDependentName((String)outputPath)), compileContext);
            }
            catch (ExecutionException e) {
                compileContext.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
            }
        }
    }

    public AppServerValidatorsState getState() {
        AppServerValidatorsState state = new AppServerValidatorsState();
        for (ApplicationServer server : this.myValidatorOwners) {
            state.getServerNames().add(server.getName());
        }
        return state;
    }

    public void loadState(AppServerValidatorsState state) {
        this.myValidatorOwners.clear();
        for (String serverName : state.getServerNames()) {
            ApplicationServer applicationServer = ApplicationServersManager.getInstance().findByName(serverName);
            ContainerUtil.addIfNotNull(this.myValidatorOwners, (Object)applicationServer);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compileContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javaee/validation/AppServerSpecificValidatorsProperties";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onBuildFinished";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class AppServerValidatorsState {
        private List<String> myServerNames = new ArrayList<String>();

        @Property(surroundWithTag=false)
        @AbstractCollection(elementTag="validator", elementValueAttribute="server-name", surroundWithTag=false)
        public List<String> getServerNames() {
            return this.myServerNames;
        }

        public void setServerNames(List<String> serverNames) {
            this.myServerNames = serverNames;
        }
    }
}

