/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.util;

import com.intellij.execution.filters.AbstractFileHyperlinkFilter;
import com.intellij.execution.filters.PatternBasedFileHyperlinkFilter;
import com.intellij.execution.filters.PatternBasedFileHyperlinkRawDataFinder;
import com.intellij.execution.filters.PatternHyperlinkFormat;
import com.intellij.execution.filters.PatternHyperlinkPart;
import com.intellij.openapi.project.Project;
import java.util.Locale;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowserStacktraceFilters {
    @Nullable
    public static AbstractFileHyperlinkFilter createFilter(@NotNull String browserName, @NotNull Project project, @Nullable String baseDir) {
        if (browserName == null) {
            BrowserStacktraceFilters.$$$reportNull$$$0(0);
        }
        if (project == null) {
            BrowserStacktraceFilters.$$$reportNull$$$0(1);
        }
        if ((browserName = browserName.toLowerCase(Locale.US)).startsWith("chrome")) {
            return new ChromeStacktraceFilter(project, baseDir);
        }
        if (browserName.startsWith("firefox")) {
            return new FirefoxStacktraceFilter(project, baseDir);
        }
        if (browserName.startsWith("opera")) {
            return new ChromeStacktraceFilter(project, baseDir);
        }
        if (browserName.startsWith("phantomjs")) {
            return new PhantomStacktraceFilter(project, baseDir);
        }
        if (browserName.startsWith("safari")) {
            return new PhantomStacktraceFilter(project, baseDir);
        }
        if (browserName.startsWith("ie") || browserName.contains("internet explorer")) {
            return new IEStacktraceFilter(project, baseDir);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "browserName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/javascript/testFramework/util/BrowserStacktraceFilters";
        objectArray[2] = "createFilter";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class IEStacktraceFilter
    extends PatternBasedFileHyperlinkFilter {
        public static final PatternBasedFileHyperlinkRawDataFinder FINDER = new PatternBasedFileHyperlinkRawDataFinder(new PatternHyperlinkFormat[]{new PatternHyperlinkFormat(Pattern.compile("^\\s*at.*\\(([^)]*):(\\d+):(\\d+)\\)$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN})});

        public IEStacktraceFilter(@NotNull Project project, @Nullable String baseDir) {
            if (project == null) {
                IEStacktraceFilter.$$$reportNull$$$0(0);
            }
            super(project, baseDir, FINDER);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilters$IEStacktraceFilter", "<init>"));
        }
    }

    public static class PhantomStacktraceFilter
    extends PatternBasedFileHyperlinkFilter {
        public static final PatternBasedFileHyperlinkRawDataFinder FINDER = new PatternBasedFileHyperlinkRawDataFinder(new PatternHyperlinkFormat[]{new PatternHyperlinkFormat(Pattern.compile("^\\s*([^\\s].*):(\\d+):(\\d+)$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN}), new PatternHyperlinkFormat(Pattern.compile("^.* in (.*) \\(line (\\d+)\\)$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE})});

        public PhantomStacktraceFilter(@NotNull Project project, @Nullable String baseDir) {
            if (project == null) {
                PhantomStacktraceFilter.$$$reportNull$$$0(0);
            }
            super(project, baseDir, FINDER);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilters$PhantomStacktraceFilter", "<init>"));
        }
    }

    public static class FirefoxStacktraceFilter
    extends PatternBasedFileHyperlinkFilter {
        public static final PatternBasedFileHyperlinkRawDataFinder FINDER = new PatternBasedFileHyperlinkRawDataFinder(new PatternHyperlinkFormat[]{new PatternHyperlinkFormat(Pattern.compile("^.*@(.*):(\\d+)(:\\d+)$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN}), new PatternHyperlinkFormat(Pattern.compile("^.* in (.*) \\(line (\\d+)\\)$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE})});

        public FirefoxStacktraceFilter(@NotNull Project project, @Nullable String baseDir) {
            if (project == null) {
                FirefoxStacktraceFilter.$$$reportNull$$$0(0);
            }
            super(project, baseDir, FINDER);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilters$FirefoxStacktraceFilter", "<init>"));
        }
    }

    public static class ChromeStacktraceFilter
    extends PatternBasedFileHyperlinkFilter {
        public static final PatternBasedFileHyperlinkRawDataFinder FINDER = new PatternBasedFileHyperlinkRawDataFinder(new PatternHyperlinkFormat[]{new PatternHyperlinkFormat(Pattern.compile("^\\s*at\\s+([^\\s(].*):(\\d+)(:\\d+)$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN}), new PatternHyperlinkFormat(Pattern.compile("^\\s*at\\s.*\\(([^(]*):(\\d+)(:\\d+)\\)$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN})});

        public ChromeStacktraceFilter(@NotNull Project project, @Nullable String baseDir) {
            if (project == null) {
                ChromeStacktraceFilter.$$$reportNull$$$0(0);
            }
            super(project, baseDir, FINDER);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilters$ChromeStacktraceFilter", "<init>"));
        }
    }
}

