/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.media.css3;

import java.util.ArrayList;
import org.w3c.css.media.Media;
import org.w3c.css.media.MediaFeature;
import org.w3c.css.parser.AtRule;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;

public class AtRuleMedia
extends org.w3c.css.media.AtRuleMedia {
    static final String[] mediaCSS21 = new String[]{"all", "braille", "embossed", "handheld", "print", "projection", "screen", "speech", "tty", "tv"};
    static final String[] deprecatedMedia = new String[]{"aural"};

    @Override
    public org.w3c.css.media.AtRuleMedia addMedia(String restrictor, String medium, ApplContext ac) throws InvalidParamException {
        Media media = new Media();
        if (restrictor != null) {
            if ("not".equalsIgnoreCase(restrictor)) {
                media.setNot(true);
            } else if ("only".equalsIgnoreCase(restrictor)) {
                media.setOnly(true);
            }
        }
        if (medium == null) {
            this.allMedia.add(media);
            return this;
        }
        medium = medium.toLowerCase();
        for (String s : mediaCSS21) {
            if (!medium.equals(s)) continue;
            media.setMedia(s);
            this.allMedia.add(media);
            return this;
        }
        for (String s : deprecatedMedia) {
            if (!medium.equals(s)) continue;
            ac.getFrame().addWarning("deprecatedmedia", medium);
            this.allMedia.add(new Media(s));
            return this;
        }
        throw new InvalidParamException("media", medium, ac);
    }

    @Override
    public void addMediaFeature(MediaFeature feature, ApplContext ac) throws InvalidParamException {
        Media latest = (Media)this.allMedia.get(this.allMedia.size() - 1);
        latest.addFeature(feature);
    }

    @Override
    public boolean canApply(AtRule atRule) {
        try {
            org.w3c.css.media.AtRuleMedia second = (org.w3c.css.media.AtRuleMedia)atRule;
            return this.canMatch(second) && second.canMatch(this);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    @Override
    public boolean canMatch(AtRule atRule) {
        try {
            org.w3c.css.media.AtRuleMedia second = (org.w3c.css.media.AtRuleMedia)atRule;
            ArrayList<Media> otherMediaList = second.getMediaList();
            for (Media m : otherMediaList) {
                if (this.allMedia.contains(m)) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    @Override
    public String getValueString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Media m : this.allMedia) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(m.toString());
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('@').append(this.keyword()).append(' ');
        sb.append(this.getValueString());
        return sb.toString();
    }
}

